
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.BinaryObjectType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for SupplyChainEventType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SupplyChainEventType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="OccurrenceDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="DescriptionBinaryObject" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}BinaryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="UnitQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="LatestOccurrenceDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="EarliestOccurrenceDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="OccurrenceSpecifiedPeriod" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedPeriodType" minOccurs="0"/>
 *         <element name="OccurrenceLogisticsLocation" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}LogisticsLocationType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SupplyChainEventType", propOrder = {
    "id",
    "occurrenceDateTime",
    "typeCode",
    "description",
    "descriptionBinaryObject",
    "unitQuantity",
    "latestOccurrenceDateTime",
    "earliestOccurrenceDateTime",
    "occurrenceSpecifiedPeriod",
    "occurrenceLogisticsLocation"
})
@CodingStyleguideUnaware
public class SupplyChainEventType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID")
    private IDType id;
    @XmlElement(name = "OccurrenceDateTime")
    private DateTimeType occurrenceDateTime;
    @XmlElement(name = "TypeCode")
    private CodeType typeCode;
    @XmlElement(name = "Description")
    private List<TextType> description;
    @XmlElement(name = "DescriptionBinaryObject")
    private List<BinaryObjectType> descriptionBinaryObject;
    @XmlElement(name = "UnitQuantity")
    private QuantityType unitQuantity;
    @XmlElement(name = "LatestOccurrenceDateTime")
    private DateTimeType latestOccurrenceDateTime;
    @XmlElement(name = "EarliestOccurrenceDateTime")
    private DateTimeType earliestOccurrenceDateTime;
    @XmlElement(name = "OccurrenceSpecifiedPeriod")
    private SpecifiedPeriodType occurrenceSpecifiedPeriod;
    @XmlElement(name = "OccurrenceLogisticsLocation")
    private LogisticsLocationType occurrenceLogisticsLocation;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SupplyChainEventType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the occurrenceDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getOccurrenceDateTime() {
        return occurrenceDateTime;
    }

    /**
     * Sets the value of the occurrenceDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setOccurrenceDateTime(
        @Nullable
        DateTimeType value) {
        this.occurrenceDateTime = value;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        CodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the descriptionBinaryObject property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the descriptionBinaryObject property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescriptionBinaryObject().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BinaryObjectType }
     * 
     * 
     * @return
     *     The value of the descriptionBinaryObject property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BinaryObjectType> getDescriptionBinaryObject() {
        if (descriptionBinaryObject == null) {
            descriptionBinaryObject = new ArrayList<>();
        }
        return this.descriptionBinaryObject;
    }

    /**
     * Gets the value of the unitQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getUnitQuantity() {
        return unitQuantity;
    }

    /**
     * Sets the value of the unitQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setUnitQuantity(
        @Nullable
        QuantityType value) {
        this.unitQuantity = value;
    }

    /**
     * Gets the value of the latestOccurrenceDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getLatestOccurrenceDateTime() {
        return latestOccurrenceDateTime;
    }

    /**
     * Sets the value of the latestOccurrenceDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setLatestOccurrenceDateTime(
        @Nullable
        DateTimeType value) {
        this.latestOccurrenceDateTime = value;
    }

    /**
     * Gets the value of the earliestOccurrenceDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getEarliestOccurrenceDateTime() {
        return earliestOccurrenceDateTime;
    }

    /**
     * Sets the value of the earliestOccurrenceDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setEarliestOccurrenceDateTime(
        @Nullable
        DateTimeType value) {
        this.earliestOccurrenceDateTime = value;
    }

    /**
     * Gets the value of the occurrenceSpecifiedPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    @Nullable
    public SpecifiedPeriodType getOccurrenceSpecifiedPeriod() {
        return occurrenceSpecifiedPeriod;
    }

    /**
     * Sets the value of the occurrenceSpecifiedPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    public void setOccurrenceSpecifiedPeriod(
        @Nullable
        SpecifiedPeriodType value) {
        this.occurrenceSpecifiedPeriod = value;
    }

    /**
     * Gets the value of the occurrenceLogisticsLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LogisticsLocationType }
     *     
     */
    @Nullable
    public LogisticsLocationType getOccurrenceLogisticsLocation() {
        return occurrenceLogisticsLocation;
    }

    /**
     * Sets the value of the occurrenceLogisticsLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LogisticsLocationType }
     *     
     */
    public void setOccurrenceLogisticsLocation(
        @Nullable
        LogisticsLocationType value) {
        this.occurrenceLogisticsLocation = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SupplyChainEventType rhs = ((SupplyChainEventType) o);
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(descriptionBinaryObject, rhs.descriptionBinaryObject)) {
            return false;
        }
        if (!EqualsHelper.equals(earliestOccurrenceDateTime, rhs.earliestOccurrenceDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(latestOccurrenceDateTime, rhs.latestOccurrenceDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(occurrenceDateTime, rhs.occurrenceDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(occurrenceLogisticsLocation, rhs.occurrenceLogisticsLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(occurrenceSpecifiedPeriod, rhs.occurrenceSpecifiedPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(unitQuantity, rhs.unitQuantity)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(description).append(descriptionBinaryObject).append(earliestOccurrenceDateTime).append(id).append(latestOccurrenceDateTime).append(occurrenceDateTime).append(occurrenceLogisticsLocation).append(occurrenceSpecifiedPeriod).append(typeCode).append(unitQuantity).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("description", description).append("descriptionBinaryObject", descriptionBinaryObject).append("earliestOccurrenceDateTime", earliestOccurrenceDateTime).append("id", id).append("latestOccurrenceDateTime", latestOccurrenceDateTime).append("occurrenceDateTime", occurrenceDateTime).append("occurrenceLogisticsLocation", occurrenceLogisticsLocation).append("occurrenceSpecifiedPeriod", occurrenceSpecifiedPeriod).append("typeCode", typeCode).append("unitQuantity", unitQuantity).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<TextType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescriptionBinaryObject(
        @Nullable
        final List<BinaryObjectType> aList) {
        descriptionBinaryObject = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final TextType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionBinaryObjectEntries() {
        return (!getDescriptionBinaryObject().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionBinaryObjectEntries() {
        return getDescriptionBinaryObject().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionBinaryObjectCount() {
        return getDescriptionBinaryObject().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BinaryObjectType getDescriptionBinaryObjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescriptionBinaryObject().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescriptionBinaryObject(
        @Nonnull
        final BinaryObjectType elem) {
        getDescriptionBinaryObject().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SupplyChainEventType ret) {
        if (description == null) {
            ret.description = null;
        } else {
            List<TextType> retDescription = new ArrayList<>();
            for (TextType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (descriptionBinaryObject == null) {
            ret.descriptionBinaryObject = null;
        } else {
            List<BinaryObjectType> retDescriptionBinaryObject = new ArrayList<>();
            for (BinaryObjectType aItem: getDescriptionBinaryObject()) {
                retDescriptionBinaryObject.add(((aItem == null)?null:aItem.clone()));
            }
            ret.descriptionBinaryObject = retDescriptionBinaryObject;
        }
        ret.earliestOccurrenceDateTime = ((earliestOccurrenceDateTime == null)?null:earliestOccurrenceDateTime.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.latestOccurrenceDateTime = ((latestOccurrenceDateTime == null)?null:latestOccurrenceDateTime.clone());
        ret.occurrenceDateTime = ((occurrenceDateTime == null)?null:occurrenceDateTime.clone());
        ret.occurrenceLogisticsLocation = ((occurrenceLogisticsLocation == null)?null:occurrenceLogisticsLocation.clone());
        ret.occurrenceSpecifiedPeriod = ((occurrenceSpecifiedPeriod == null)?null:occurrenceSpecifiedPeriod.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        ret.unitQuantity = ((unitQuantity == null)?null:unitQuantity.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SupplyChainEventType clone() {
        SupplyChainEventType ret = new SupplyChainEventType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setTypeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setUnitQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getUnitQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setUnitQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        CodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getUnitQuantityValue() {
        QuantityType aObj = getUnitQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
