
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.PackageTypeCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.MeasureType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for SupplyChainPackagingType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SupplyChainPackagingType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}PackageTypeCodeType" minOccurs="0"/>
 *         <element name="Type" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ConditionCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="DisposalMethodCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="WeightMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="MaximumStackabilityQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="MaximumStackabilityWeightMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" minOccurs="0"/>
 *         <element name="CustomerFacingTotalUnitQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="LayerTotalUnitQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="ContentLayerQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="LinearSpatialDimension" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpatialDimensionType" minOccurs="0"/>
 *         <element name="MinimumLinearSpatialDimension" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpatialDimensionType" minOccurs="0"/>
 *         <element name="MaximumLinearSpatialDimension" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpatialDimensionType" minOccurs="0"/>
 *         <element name="SpecifiedPackagingMarking" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}PackagingMarkingType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ApplicableMaterialGoodsCharacteristic" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}MaterialGoodsCharacteristicType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ApplicableDisposalInstructions" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}DisposalInstructionsType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ApplicableReturnableAssetInstructions" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReturnableAssetInstructionsType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SupplyChainPackagingType", propOrder = {
    "typeCode",
    "type",
    "description",
    "conditionCode",
    "disposalMethodCode",
    "weightMeasure",
    "maximumStackabilityQuantity",
    "maximumStackabilityWeightMeasure",
    "customerFacingTotalUnitQuantity",
    "layerTotalUnitQuantity",
    "contentLayerQuantity",
    "linearSpatialDimension",
    "minimumLinearSpatialDimension",
    "maximumLinearSpatialDimension",
    "specifiedPackagingMarking",
    "applicableMaterialGoodsCharacteristic",
    "applicableDisposalInstructions",
    "applicableReturnableAssetInstructions"
})
@CodingStyleguideUnaware
public class SupplyChainPackagingType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "TypeCode")
    private PackageTypeCodeType typeCode;
    @XmlElement(name = "Type")
    private TextType type;
    @XmlElement(name = "Description")
    private List<TextType> description;
    @XmlElement(name = "ConditionCode")
    private CodeType conditionCode;
    @XmlElement(name = "DisposalMethodCode")
    private List<CodeType> disposalMethodCode;
    @XmlElement(name = "WeightMeasure")
    private List<MeasureType> weightMeasure;
    @XmlElement(name = "MaximumStackabilityQuantity")
    private QuantityType maximumStackabilityQuantity;
    @XmlElement(name = "MaximumStackabilityWeightMeasure")
    private MeasureType maximumStackabilityWeightMeasure;
    @XmlElement(name = "CustomerFacingTotalUnitQuantity")
    private QuantityType customerFacingTotalUnitQuantity;
    @XmlElement(name = "LayerTotalUnitQuantity")
    private QuantityType layerTotalUnitQuantity;
    @XmlElement(name = "ContentLayerQuantity")
    private QuantityType contentLayerQuantity;
    @XmlElement(name = "LinearSpatialDimension")
    private SpatialDimensionType linearSpatialDimension;
    @XmlElement(name = "MinimumLinearSpatialDimension")
    private SpatialDimensionType minimumLinearSpatialDimension;
    @XmlElement(name = "MaximumLinearSpatialDimension")
    private SpatialDimensionType maximumLinearSpatialDimension;
    @XmlElement(name = "SpecifiedPackagingMarking")
    private List<PackagingMarkingType> specifiedPackagingMarking;
    @XmlElement(name = "ApplicableMaterialGoodsCharacteristic")
    private List<MaterialGoodsCharacteristicType> applicableMaterialGoodsCharacteristic;
    @XmlElement(name = "ApplicableDisposalInstructions")
    private List<DisposalInstructionsType> applicableDisposalInstructions;
    @XmlElement(name = "ApplicableReturnableAssetInstructions")
    private List<ReturnableAssetInstructionsType> applicableReturnableAssetInstructions;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SupplyChainPackagingType() {
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link PackageTypeCodeType }
     *     
     */
    @Nullable
    public PackageTypeCodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PackageTypeCodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        PackageTypeCodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setType(
        @Nullable
        TextType value) {
        this.type = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the conditionCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getConditionCode() {
        return conditionCode;
    }

    /**
     * Sets the value of the conditionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setConditionCode(
        @Nullable
        CodeType value) {
        this.conditionCode = value;
    }

    /**
     * Gets the value of the disposalMethodCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the disposalMethodCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDisposalMethodCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the disposalMethodCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getDisposalMethodCode() {
        if (disposalMethodCode == null) {
            disposalMethodCode = new ArrayList<>();
        }
        return this.disposalMethodCode;
    }

    /**
     * Gets the value of the weightMeasure property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the weightMeasure property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWeightMeasure().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MeasureType }
     * 
     * 
     * @return
     *     The value of the weightMeasure property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<MeasureType> getWeightMeasure() {
        if (weightMeasure == null) {
            weightMeasure = new ArrayList<>();
        }
        return this.weightMeasure;
    }

    /**
     * Gets the value of the maximumStackabilityQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getMaximumStackabilityQuantity() {
        return maximumStackabilityQuantity;
    }

    /**
     * Sets the value of the maximumStackabilityQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setMaximumStackabilityQuantity(
        @Nullable
        QuantityType value) {
        this.maximumStackabilityQuantity = value;
    }

    /**
     * Gets the value of the maximumStackabilityWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MeasureType }
     *     
     */
    @Nullable
    public MeasureType getMaximumStackabilityWeightMeasure() {
        return maximumStackabilityWeightMeasure;
    }

    /**
     * Sets the value of the maximumStackabilityWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeasureType }
     *     
     */
    public void setMaximumStackabilityWeightMeasure(
        @Nullable
        MeasureType value) {
        this.maximumStackabilityWeightMeasure = value;
    }

    /**
     * Gets the value of the customerFacingTotalUnitQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getCustomerFacingTotalUnitQuantity() {
        return customerFacingTotalUnitQuantity;
    }

    /**
     * Sets the value of the customerFacingTotalUnitQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setCustomerFacingTotalUnitQuantity(
        @Nullable
        QuantityType value) {
        this.customerFacingTotalUnitQuantity = value;
    }

    /**
     * Gets the value of the layerTotalUnitQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getLayerTotalUnitQuantity() {
        return layerTotalUnitQuantity;
    }

    /**
     * Sets the value of the layerTotalUnitQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setLayerTotalUnitQuantity(
        @Nullable
        QuantityType value) {
        this.layerTotalUnitQuantity = value;
    }

    /**
     * Gets the value of the contentLayerQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getContentLayerQuantity() {
        return contentLayerQuantity;
    }

    /**
     * Sets the value of the contentLayerQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setContentLayerQuantity(
        @Nullable
        QuantityType value) {
        this.contentLayerQuantity = value;
    }

    /**
     * Gets the value of the linearSpatialDimension property.
     * 
     * @return
     *     possible object is
     *     {@link SpatialDimensionType }
     *     
     */
    @Nullable
    public SpatialDimensionType getLinearSpatialDimension() {
        return linearSpatialDimension;
    }

    /**
     * Sets the value of the linearSpatialDimension property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpatialDimensionType }
     *     
     */
    public void setLinearSpatialDimension(
        @Nullable
        SpatialDimensionType value) {
        this.linearSpatialDimension = value;
    }

    /**
     * Gets the value of the minimumLinearSpatialDimension property.
     * 
     * @return
     *     possible object is
     *     {@link SpatialDimensionType }
     *     
     */
    @Nullable
    public SpatialDimensionType getMinimumLinearSpatialDimension() {
        return minimumLinearSpatialDimension;
    }

    /**
     * Sets the value of the minimumLinearSpatialDimension property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpatialDimensionType }
     *     
     */
    public void setMinimumLinearSpatialDimension(
        @Nullable
        SpatialDimensionType value) {
        this.minimumLinearSpatialDimension = value;
    }

    /**
     * Gets the value of the maximumLinearSpatialDimension property.
     * 
     * @return
     *     possible object is
     *     {@link SpatialDimensionType }
     *     
     */
    @Nullable
    public SpatialDimensionType getMaximumLinearSpatialDimension() {
        return maximumLinearSpatialDimension;
    }

    /**
     * Sets the value of the maximumLinearSpatialDimension property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpatialDimensionType }
     *     
     */
    public void setMaximumLinearSpatialDimension(
        @Nullable
        SpatialDimensionType value) {
        this.maximumLinearSpatialDimension = value;
    }

    /**
     * Gets the value of the specifiedPackagingMarking property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the specifiedPackagingMarking property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedPackagingMarking().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PackagingMarkingType }
     * 
     * 
     * @return
     *     The value of the specifiedPackagingMarking property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PackagingMarkingType> getSpecifiedPackagingMarking() {
        if (specifiedPackagingMarking == null) {
            specifiedPackagingMarking = new ArrayList<>();
        }
        return this.specifiedPackagingMarking;
    }

    /**
     * Gets the value of the applicableMaterialGoodsCharacteristic property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the applicableMaterialGoodsCharacteristic property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getApplicableMaterialGoodsCharacteristic().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MaterialGoodsCharacteristicType }
     * 
     * 
     * @return
     *     The value of the applicableMaterialGoodsCharacteristic property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<MaterialGoodsCharacteristicType> getApplicableMaterialGoodsCharacteristic() {
        if (applicableMaterialGoodsCharacteristic == null) {
            applicableMaterialGoodsCharacteristic = new ArrayList<>();
        }
        return this.applicableMaterialGoodsCharacteristic;
    }

    /**
     * Gets the value of the applicableDisposalInstructions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the applicableDisposalInstructions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getApplicableDisposalInstructions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DisposalInstructionsType }
     * 
     * 
     * @return
     *     The value of the applicableDisposalInstructions property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DisposalInstructionsType> getApplicableDisposalInstructions() {
        if (applicableDisposalInstructions == null) {
            applicableDisposalInstructions = new ArrayList<>();
        }
        return this.applicableDisposalInstructions;
    }

    /**
     * Gets the value of the applicableReturnableAssetInstructions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the applicableReturnableAssetInstructions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getApplicableReturnableAssetInstructions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReturnableAssetInstructionsType }
     * 
     * 
     * @return
     *     The value of the applicableReturnableAssetInstructions property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReturnableAssetInstructionsType> getApplicableReturnableAssetInstructions() {
        if (applicableReturnableAssetInstructions == null) {
            applicableReturnableAssetInstructions = new ArrayList<>();
        }
        return this.applicableReturnableAssetInstructions;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SupplyChainPackagingType rhs = ((SupplyChainPackagingType) o);
        if (!EqualsHelper.equalsCollection(applicableDisposalInstructions, rhs.applicableDisposalInstructions)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(applicableMaterialGoodsCharacteristic, rhs.applicableMaterialGoodsCharacteristic)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(applicableReturnableAssetInstructions, rhs.applicableReturnableAssetInstructions)) {
            return false;
        }
        if (!EqualsHelper.equals(conditionCode, rhs.conditionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(contentLayerQuantity, rhs.contentLayerQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(customerFacingTotalUnitQuantity, rhs.customerFacingTotalUnitQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(disposalMethodCode, rhs.disposalMethodCode)) {
            return false;
        }
        if (!EqualsHelper.equals(layerTotalUnitQuantity, rhs.layerTotalUnitQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(linearSpatialDimension, rhs.linearSpatialDimension)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumLinearSpatialDimension, rhs.maximumLinearSpatialDimension)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumStackabilityQuantity, rhs.maximumStackabilityQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumStackabilityWeightMeasure, rhs.maximumStackabilityWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumLinearSpatialDimension, rhs.minimumLinearSpatialDimension)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedPackagingMarking, rhs.specifiedPackagingMarking)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(weightMeasure, rhs.weightMeasure)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(applicableDisposalInstructions).append(applicableMaterialGoodsCharacteristic).append(applicableReturnableAssetInstructions).append(conditionCode).append(contentLayerQuantity).append(customerFacingTotalUnitQuantity).append(description).append(disposalMethodCode).append(layerTotalUnitQuantity).append(linearSpatialDimension).append(maximumLinearSpatialDimension).append(maximumStackabilityQuantity).append(maximumStackabilityWeightMeasure).append(minimumLinearSpatialDimension).append(specifiedPackagingMarking).append(type).append(typeCode).append(weightMeasure).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("applicableDisposalInstructions", applicableDisposalInstructions).append("applicableMaterialGoodsCharacteristic", applicableMaterialGoodsCharacteristic).append("applicableReturnableAssetInstructions", applicableReturnableAssetInstructions).append("conditionCode", conditionCode).append("contentLayerQuantity", contentLayerQuantity).append("customerFacingTotalUnitQuantity", customerFacingTotalUnitQuantity).append("description", description).append("disposalMethodCode", disposalMethodCode).append("layerTotalUnitQuantity", layerTotalUnitQuantity).append("linearSpatialDimension", linearSpatialDimension).append("maximumLinearSpatialDimension", maximumLinearSpatialDimension).append("maximumStackabilityQuantity", maximumStackabilityQuantity).append("maximumStackabilityWeightMeasure", maximumStackabilityWeightMeasure).append("minimumLinearSpatialDimension", minimumLinearSpatialDimension).append("specifiedPackagingMarking", specifiedPackagingMarking).append("type", type).append("typeCode", typeCode).append("weightMeasure", weightMeasure).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<TextType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDisposalMethodCode(
        @Nullable
        final List<CodeType> aList) {
        disposalMethodCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setWeightMeasure(
        @Nullable
        final List<MeasureType> aList) {
        weightMeasure = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedPackagingMarking(
        @Nullable
        final List<PackagingMarkingType> aList) {
        specifiedPackagingMarking = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setApplicableMaterialGoodsCharacteristic(
        @Nullable
        final List<MaterialGoodsCharacteristicType> aList) {
        applicableMaterialGoodsCharacteristic = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setApplicableDisposalInstructions(
        @Nullable
        final List<DisposalInstructionsType> aList) {
        applicableDisposalInstructions = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setApplicableReturnableAssetInstructions(
        @Nullable
        final List<ReturnableAssetInstructionsType> aList) {
        applicableReturnableAssetInstructions = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final TextType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDisposalMethodCodeEntries() {
        return (!getDisposalMethodCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDisposalMethodCodeEntries() {
        return getDisposalMethodCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDisposalMethodCodeCount() {
        return getDisposalMethodCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getDisposalMethodCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDisposalMethodCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDisposalMethodCode(
        @Nonnull
        final CodeType elem) {
        getDisposalMethodCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasWeightMeasureEntries() {
        return (!getWeightMeasure().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoWeightMeasureEntries() {
        return getWeightMeasure().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getWeightMeasureCount() {
        return getWeightMeasure().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public MeasureType getWeightMeasureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getWeightMeasure().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addWeightMeasure(
        @Nonnull
        final MeasureType elem) {
        getWeightMeasure().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedPackagingMarkingEntries() {
        return (!getSpecifiedPackagingMarking().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedPackagingMarkingEntries() {
        return getSpecifiedPackagingMarking().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedPackagingMarkingCount() {
        return getSpecifiedPackagingMarking().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PackagingMarkingType getSpecifiedPackagingMarkingAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedPackagingMarking().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedPackagingMarking(
        @Nonnull
        final PackagingMarkingType elem) {
        getSpecifiedPackagingMarking().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasApplicableMaterialGoodsCharacteristicEntries() {
        return (!getApplicableMaterialGoodsCharacteristic().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoApplicableMaterialGoodsCharacteristicEntries() {
        return getApplicableMaterialGoodsCharacteristic().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getApplicableMaterialGoodsCharacteristicCount() {
        return getApplicableMaterialGoodsCharacteristic().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public MaterialGoodsCharacteristicType getApplicableMaterialGoodsCharacteristicAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getApplicableMaterialGoodsCharacteristic().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addApplicableMaterialGoodsCharacteristic(
        @Nonnull
        final MaterialGoodsCharacteristicType elem) {
        getApplicableMaterialGoodsCharacteristic().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasApplicableDisposalInstructionsEntries() {
        return (!getApplicableDisposalInstructions().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoApplicableDisposalInstructionsEntries() {
        return getApplicableDisposalInstructions().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getApplicableDisposalInstructionsCount() {
        return getApplicableDisposalInstructions().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DisposalInstructionsType getApplicableDisposalInstructionsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getApplicableDisposalInstructions().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addApplicableDisposalInstructions(
        @Nonnull
        final DisposalInstructionsType elem) {
        getApplicableDisposalInstructions().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasApplicableReturnableAssetInstructionsEntries() {
        return (!getApplicableReturnableAssetInstructions().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoApplicableReturnableAssetInstructionsEntries() {
        return getApplicableReturnableAssetInstructions().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getApplicableReturnableAssetInstructionsCount() {
        return getApplicableReturnableAssetInstructions().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReturnableAssetInstructionsType getApplicableReturnableAssetInstructionsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getApplicableReturnableAssetInstructions().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addApplicableReturnableAssetInstructions(
        @Nonnull
        final ReturnableAssetInstructionsType elem) {
        getApplicableReturnableAssetInstructions().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SupplyChainPackagingType ret) {
        if (applicableDisposalInstructions == null) {
            ret.applicableDisposalInstructions = null;
        } else {
            List<DisposalInstructionsType> retApplicableDisposalInstructions = new ArrayList<>();
            for (DisposalInstructionsType aItem: getApplicableDisposalInstructions()) {
                retApplicableDisposalInstructions.add(((aItem == null)?null:aItem.clone()));
            }
            ret.applicableDisposalInstructions = retApplicableDisposalInstructions;
        }
        if (applicableMaterialGoodsCharacteristic == null) {
            ret.applicableMaterialGoodsCharacteristic = null;
        } else {
            List<MaterialGoodsCharacteristicType> retApplicableMaterialGoodsCharacteristic = new ArrayList<>();
            for (MaterialGoodsCharacteristicType aItem: getApplicableMaterialGoodsCharacteristic()) {
                retApplicableMaterialGoodsCharacteristic.add(((aItem == null)?null:aItem.clone()));
            }
            ret.applicableMaterialGoodsCharacteristic = retApplicableMaterialGoodsCharacteristic;
        }
        if (applicableReturnableAssetInstructions == null) {
            ret.applicableReturnableAssetInstructions = null;
        } else {
            List<ReturnableAssetInstructionsType> retApplicableReturnableAssetInstructions = new ArrayList<>();
            for (ReturnableAssetInstructionsType aItem: getApplicableReturnableAssetInstructions()) {
                retApplicableReturnableAssetInstructions.add(((aItem == null)?null:aItem.clone()));
            }
            ret.applicableReturnableAssetInstructions = retApplicableReturnableAssetInstructions;
        }
        ret.conditionCode = ((conditionCode == null)?null:conditionCode.clone());
        ret.contentLayerQuantity = ((contentLayerQuantity == null)?null:contentLayerQuantity.clone());
        ret.customerFacingTotalUnitQuantity = ((customerFacingTotalUnitQuantity == null)?null:customerFacingTotalUnitQuantity.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<TextType> retDescription = new ArrayList<>();
            for (TextType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (disposalMethodCode == null) {
            ret.disposalMethodCode = null;
        } else {
            List<CodeType> retDisposalMethodCode = new ArrayList<>();
            for (CodeType aItem: getDisposalMethodCode()) {
                retDisposalMethodCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.disposalMethodCode = retDisposalMethodCode;
        }
        ret.layerTotalUnitQuantity = ((layerTotalUnitQuantity == null)?null:layerTotalUnitQuantity.clone());
        ret.linearSpatialDimension = ((linearSpatialDimension == null)?null:linearSpatialDimension.clone());
        ret.maximumLinearSpatialDimension = ((maximumLinearSpatialDimension == null)?null:maximumLinearSpatialDimension.clone());
        ret.maximumStackabilityQuantity = ((maximumStackabilityQuantity == null)?null:maximumStackabilityQuantity.clone());
        ret.maximumStackabilityWeightMeasure = ((maximumStackabilityWeightMeasure == null)?null:maximumStackabilityWeightMeasure.clone());
        ret.minimumLinearSpatialDimension = ((minimumLinearSpatialDimension == null)?null:minimumLinearSpatialDimension.clone());
        if (specifiedPackagingMarking == null) {
            ret.specifiedPackagingMarking = null;
        } else {
            List<PackagingMarkingType> retSpecifiedPackagingMarking = new ArrayList<>();
            for (PackagingMarkingType aItem: getSpecifiedPackagingMarking()) {
                retSpecifiedPackagingMarking.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedPackagingMarking = retSpecifiedPackagingMarking;
        }
        ret.type = ((type == null)?null:type.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        if (weightMeasure == null) {
            ret.weightMeasure = null;
        } else {
            List<MeasureType> retWeightMeasure = new ArrayList<>();
            for (MeasureType aItem: getWeightMeasure()) {
                retWeightMeasure.add(((aItem == null)?null:aItem.clone()));
            }
            ret.weightMeasure = retWeightMeasure;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SupplyChainPackagingType clone() {
        SupplyChainPackagingType ret = new SupplyChainPackagingType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PackageTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public PackageTypeCodeType setTypeCode(
        @Nullable
        final String valueParam) {
        PackageTypeCodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new PackageTypeCodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setType(
        @Nullable
        final String valueParam) {
        TextType aObj = getType();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setConditionCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getConditionCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setConditionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setMaximumStackabilityQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getMaximumStackabilityQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setMaximumStackabilityQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeasureType and never <code>null</code>
     */
    @Nonnull
    public MeasureType setMaximumStackabilityWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MeasureType aObj = getMaximumStackabilityWeightMeasure();
        if (aObj == null) {
            aObj = new MeasureType(valueParam);
            setMaximumStackabilityWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setCustomerFacingTotalUnitQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getCustomerFacingTotalUnitQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setCustomerFacingTotalUnitQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setLayerTotalUnitQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getLayerTotalUnitQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setLayerTotalUnitQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setContentLayerQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getContentLayerQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setContentLayerQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained PackageTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PackageTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        PackageTypeCodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getTypeValue() {
        TextType aObj = getType();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getConditionCodeValue() {
        CodeType aObj = getConditionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumStackabilityQuantityValue() {
        QuantityType aObj = getMaximumStackabilityQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumStackabilityWeightMeasureValue() {
        MeasureType aObj = getMaximumStackabilityWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCustomerFacingTotalUnitQuantityValue() {
        QuantityType aObj = getCustomerFacingTotalUnitQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getLayerTotalUnitQuantityValue() {
        QuantityType aObj = getLayerTotalUnitQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getContentLayerQuantityValue() {
        QuantityType aObj = getContentLayerQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
