
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.CountryIDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for TradeAddressType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradeAddressType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="PostcodeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="PostOfficeBox" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="BuildingName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="LineOne" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="LineTwo" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="LineThree" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="LineFour" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="LineFive" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="StreetName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="CityName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="CitySubDivisionName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="CountryID" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}CountryIDType" minOccurs="0"/>
 *         <element name="CountryName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CountrySubDivisionID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="CountrySubDivisionName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AttentionOf" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="CareOf" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="BuildingNumber" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="DepartmentName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="AdditionalStreetName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradeAddressType", propOrder = {
    "id",
    "postcodeCode",
    "postOfficeBox",
    "buildingName",
    "lineOne",
    "lineTwo",
    "lineThree",
    "lineFour",
    "lineFive",
    "streetName",
    "cityName",
    "citySubDivisionName",
    "countryID",
    "countryName",
    "countrySubDivisionID",
    "countrySubDivisionName",
    "attentionOf",
    "careOf",
    "buildingNumber",
    "departmentName",
    "additionalStreetName"
})
@CodingStyleguideUnaware
public class TradeAddressType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID")
    private IDType id;
    @XmlElement(name = "PostcodeCode")
    private CodeType postcodeCode;
    @XmlElement(name = "PostOfficeBox")
    private TextType postOfficeBox;
    @XmlElement(name = "BuildingName")
    private TextType buildingName;
    @XmlElement(name = "LineOne")
    private TextType lineOne;
    @XmlElement(name = "LineTwo")
    private TextType lineTwo;
    @XmlElement(name = "LineThree")
    private TextType lineThree;
    @XmlElement(name = "LineFour")
    private TextType lineFour;
    @XmlElement(name = "LineFive")
    private TextType lineFive;
    @XmlElement(name = "StreetName")
    private TextType streetName;
    @XmlElement(name = "CityName")
    private TextType cityName;
    @XmlElement(name = "CitySubDivisionName")
    private TextType citySubDivisionName;
    @XmlElement(name = "CountryID")
    private CountryIDType countryID;
    @XmlElement(name = "CountryName")
    private List<TextType> countryName;
    @XmlElement(name = "CountrySubDivisionID")
    private IDType countrySubDivisionID;
    @XmlElement(name = "CountrySubDivisionName")
    private List<TextType> countrySubDivisionName;
    @XmlElement(name = "AttentionOf")
    private TextType attentionOf;
    @XmlElement(name = "CareOf")
    private TextType careOf;
    @XmlElement(name = "BuildingNumber")
    private TextType buildingNumber;
    @XmlElement(name = "DepartmentName")
    private TextType departmentName;
    @XmlElement(name = "AdditionalStreetName")
    private TextType additionalStreetName;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradeAddressType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the postcodeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getPostcodeCode() {
        return postcodeCode;
    }

    /**
     * Sets the value of the postcodeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setPostcodeCode(
        @Nullable
        CodeType value) {
        this.postcodeCode = value;
    }

    /**
     * Gets the value of the postOfficeBox property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getPostOfficeBox() {
        return postOfficeBox;
    }

    /**
     * Sets the value of the postOfficeBox property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setPostOfficeBox(
        @Nullable
        TextType value) {
        this.postOfficeBox = value;
    }

    /**
     * Gets the value of the buildingName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getBuildingName() {
        return buildingName;
    }

    /**
     * Sets the value of the buildingName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setBuildingName(
        @Nullable
        TextType value) {
        this.buildingName = value;
    }

    /**
     * Gets the value of the lineOne property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineOne() {
        return lineOne;
    }

    /**
     * Sets the value of the lineOne property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineOne(
        @Nullable
        TextType value) {
        this.lineOne = value;
    }

    /**
     * Gets the value of the lineTwo property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineTwo() {
        return lineTwo;
    }

    /**
     * Sets the value of the lineTwo property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineTwo(
        @Nullable
        TextType value) {
        this.lineTwo = value;
    }

    /**
     * Gets the value of the lineThree property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineThree() {
        return lineThree;
    }

    /**
     * Sets the value of the lineThree property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineThree(
        @Nullable
        TextType value) {
        this.lineThree = value;
    }

    /**
     * Gets the value of the lineFour property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineFour() {
        return lineFour;
    }

    /**
     * Sets the value of the lineFour property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineFour(
        @Nullable
        TextType value) {
        this.lineFour = value;
    }

    /**
     * Gets the value of the lineFive property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineFive() {
        return lineFive;
    }

    /**
     * Sets the value of the lineFive property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineFive(
        @Nullable
        TextType value) {
        this.lineFive = value;
    }

    /**
     * Gets the value of the streetName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getStreetName() {
        return streetName;
    }

    /**
     * Sets the value of the streetName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setStreetName(
        @Nullable
        TextType value) {
        this.streetName = value;
    }

    /**
     * Gets the value of the cityName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getCityName() {
        return cityName;
    }

    /**
     * Sets the value of the cityName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setCityName(
        @Nullable
        TextType value) {
        this.cityName = value;
    }

    /**
     * Gets the value of the citySubDivisionName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getCitySubDivisionName() {
        return citySubDivisionName;
    }

    /**
     * Sets the value of the citySubDivisionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setCitySubDivisionName(
        @Nullable
        TextType value) {
        this.citySubDivisionName = value;
    }

    /**
     * Gets the value of the countryID property.
     * 
     * @return
     *     possible object is
     *     {@link CountryIDType }
     *     
     */
    @Nullable
    public CountryIDType getCountryID() {
        return countryID;
    }

    /**
     * Sets the value of the countryID property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryIDType }
     *     
     */
    public void setCountryID(
        @Nullable
        CountryIDType value) {
        this.countryID = value;
    }

    /**
     * Gets the value of the countryName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the countryName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCountryName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the countryName property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getCountryName() {
        if (countryName == null) {
            countryName = new ArrayList<>();
        }
        return this.countryName;
    }

    /**
     * Gets the value of the countrySubDivisionID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getCountrySubDivisionID() {
        return countrySubDivisionID;
    }

    /**
     * Sets the value of the countrySubDivisionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setCountrySubDivisionID(
        @Nullable
        IDType value) {
        this.countrySubDivisionID = value;
    }

    /**
     * Gets the value of the countrySubDivisionName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the countrySubDivisionName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCountrySubDivisionName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the countrySubDivisionName property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getCountrySubDivisionName() {
        if (countrySubDivisionName == null) {
            countrySubDivisionName = new ArrayList<>();
        }
        return this.countrySubDivisionName;
    }

    /**
     * Gets the value of the attentionOf property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getAttentionOf() {
        return attentionOf;
    }

    /**
     * Sets the value of the attentionOf property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setAttentionOf(
        @Nullable
        TextType value) {
        this.attentionOf = value;
    }

    /**
     * Gets the value of the careOf property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getCareOf() {
        return careOf;
    }

    /**
     * Sets the value of the careOf property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setCareOf(
        @Nullable
        TextType value) {
        this.careOf = value;
    }

    /**
     * Gets the value of the buildingNumber property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getBuildingNumber() {
        return buildingNumber;
    }

    /**
     * Sets the value of the buildingNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setBuildingNumber(
        @Nullable
        TextType value) {
        this.buildingNumber = value;
    }

    /**
     * Gets the value of the departmentName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getDepartmentName() {
        return departmentName;
    }

    /**
     * Sets the value of the departmentName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setDepartmentName(
        @Nullable
        TextType value) {
        this.departmentName = value;
    }

    /**
     * Gets the value of the additionalStreetName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getAdditionalStreetName() {
        return additionalStreetName;
    }

    /**
     * Sets the value of the additionalStreetName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setAdditionalStreetName(
        @Nullable
        TextType value) {
        this.additionalStreetName = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradeAddressType rhs = ((TradeAddressType) o);
        if (!EqualsHelper.equals(additionalStreetName, rhs.additionalStreetName)) {
            return false;
        }
        if (!EqualsHelper.equals(attentionOf, rhs.attentionOf)) {
            return false;
        }
        if (!EqualsHelper.equals(buildingName, rhs.buildingName)) {
            return false;
        }
        if (!EqualsHelper.equals(buildingNumber, rhs.buildingNumber)) {
            return false;
        }
        if (!EqualsHelper.equals(careOf, rhs.careOf)) {
            return false;
        }
        if (!EqualsHelper.equals(cityName, rhs.cityName)) {
            return false;
        }
        if (!EqualsHelper.equals(citySubDivisionName, rhs.citySubDivisionName)) {
            return false;
        }
        if (!EqualsHelper.equals(countryID, rhs.countryID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(countryName, rhs.countryName)) {
            return false;
        }
        if (!EqualsHelper.equals(countrySubDivisionID, rhs.countrySubDivisionID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(countrySubDivisionName, rhs.countrySubDivisionName)) {
            return false;
        }
        if (!EqualsHelper.equals(departmentName, rhs.departmentName)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(lineFive, rhs.lineFive)) {
            return false;
        }
        if (!EqualsHelper.equals(lineFour, rhs.lineFour)) {
            return false;
        }
        if (!EqualsHelper.equals(lineOne, rhs.lineOne)) {
            return false;
        }
        if (!EqualsHelper.equals(lineThree, rhs.lineThree)) {
            return false;
        }
        if (!EqualsHelper.equals(lineTwo, rhs.lineTwo)) {
            return false;
        }
        if (!EqualsHelper.equals(postOfficeBox, rhs.postOfficeBox)) {
            return false;
        }
        if (!EqualsHelper.equals(postcodeCode, rhs.postcodeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(streetName, rhs.streetName)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalStreetName).append(attentionOf).append(buildingName).append(buildingNumber).append(careOf).append(cityName).append(citySubDivisionName).append(countryID).append(countryName).append(countrySubDivisionID).append(countrySubDivisionName).append(departmentName).append(id).append(lineFive).append(lineFour).append(lineOne).append(lineThree).append(lineTwo).append(postOfficeBox).append(postcodeCode).append(streetName).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalStreetName", additionalStreetName).append("attentionOf", attentionOf).append("buildingName", buildingName).append("buildingNumber", buildingNumber).append("careOf", careOf).append("cityName", cityName).append("citySubDivisionName", citySubDivisionName).append("countryID", countryID).append("countryName", countryName).append("countrySubDivisionID", countrySubDivisionID).append("countrySubDivisionName", countrySubDivisionName).append("departmentName", departmentName).append("id", id).append("lineFive", lineFive).append("lineFour", lineFour).append("lineOne", lineOne).append("lineThree", lineThree).append("lineTwo", lineTwo).append("postOfficeBox", postOfficeBox).append("postcodeCode", postcodeCode).append("streetName", streetName).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCountryName(
        @Nullable
        final List<TextType> aList) {
        countryName = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCountrySubDivisionName(
        @Nullable
        final List<TextType> aList) {
        countrySubDivisionName = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCountryNameEntries() {
        return (!getCountryName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCountryNameEntries() {
        return getCountryName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCountryNameCount() {
        return getCountryName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getCountryNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCountryName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCountryName(
        @Nonnull
        final TextType elem) {
        getCountryName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCountrySubDivisionNameEntries() {
        return (!getCountrySubDivisionName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCountrySubDivisionNameEntries() {
        return getCountrySubDivisionName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCountrySubDivisionNameCount() {
        return getCountrySubDivisionName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getCountrySubDivisionNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCountrySubDivisionName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCountrySubDivisionName(
        @Nonnull
        final TextType elem) {
        getCountrySubDivisionName().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradeAddressType ret) {
        ret.additionalStreetName = ((additionalStreetName == null)?null:additionalStreetName.clone());
        ret.attentionOf = ((attentionOf == null)?null:attentionOf.clone());
        ret.buildingName = ((buildingName == null)?null:buildingName.clone());
        ret.buildingNumber = ((buildingNumber == null)?null:buildingNumber.clone());
        ret.careOf = ((careOf == null)?null:careOf.clone());
        ret.cityName = ((cityName == null)?null:cityName.clone());
        ret.citySubDivisionName = ((citySubDivisionName == null)?null:citySubDivisionName.clone());
        ret.countryID = ((countryID == null)?null:countryID.clone());
        if (countryName == null) {
            ret.countryName = null;
        } else {
            List<TextType> retCountryName = new ArrayList<>();
            for (TextType aItem: getCountryName()) {
                retCountryName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.countryName = retCountryName;
        }
        ret.countrySubDivisionID = ((countrySubDivisionID == null)?null:countrySubDivisionID.clone());
        if (countrySubDivisionName == null) {
            ret.countrySubDivisionName = null;
        } else {
            List<TextType> retCountrySubDivisionName = new ArrayList<>();
            for (TextType aItem: getCountrySubDivisionName()) {
                retCountrySubDivisionName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.countrySubDivisionName = retCountrySubDivisionName;
        }
        ret.departmentName = ((departmentName == null)?null:departmentName.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.lineFive = ((lineFive == null)?null:lineFive.clone());
        ret.lineFour = ((lineFour == null)?null:lineFour.clone());
        ret.lineOne = ((lineOne == null)?null:lineOne.clone());
        ret.lineThree = ((lineThree == null)?null:lineThree.clone());
        ret.lineTwo = ((lineTwo == null)?null:lineTwo.clone());
        ret.postOfficeBox = ((postOfficeBox == null)?null:postOfficeBox.clone());
        ret.postcodeCode = ((postcodeCode == null)?null:postcodeCode.clone());
        ret.streetName = ((streetName == null)?null:streetName.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradeAddressType clone() {
        TradeAddressType ret = new TradeAddressType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setPostcodeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getPostcodeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setPostcodeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setPostOfficeBox(
        @Nullable
        final String valueParam) {
        TextType aObj = getPostOfficeBox();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setPostOfficeBox(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setBuildingName(
        @Nullable
        final String valueParam) {
        TextType aObj = getBuildingName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setBuildingName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineOne(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineOne();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineOne(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineTwo(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineTwo();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineTwo(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineThree(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineThree();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineThree(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineFour(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineFour();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineFour(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineFive(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineFive();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineFive(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setStreetName(
        @Nullable
        final String valueParam) {
        TextType aObj = getStreetName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setStreetName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setCityName(
        @Nullable
        final String valueParam) {
        TextType aObj = getCityName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setCityName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setCitySubDivisionName(
        @Nullable
        final String valueParam) {
        TextType aObj = getCitySubDivisionName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setCitySubDivisionName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CountryIDType and never <code>null</code>
     */
    @Nonnull
    public CountryIDType setCountryID(
        @Nullable
        final String valueParam) {
        CountryIDType aObj = getCountryID();
        if (aObj == null) {
            aObj = new CountryIDType(valueParam);
            setCountryID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setCountrySubDivisionID(
        @Nullable
        final String valueParam) {
        IDType aObj = getCountrySubDivisionID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setCountrySubDivisionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setAttentionOf(
        @Nullable
        final String valueParam) {
        TextType aObj = getAttentionOf();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setAttentionOf(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setCareOf(
        @Nullable
        final String valueParam) {
        TextType aObj = getCareOf();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setCareOf(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setBuildingNumber(
        @Nullable
        final String valueParam) {
        TextType aObj = getBuildingNumber();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setBuildingNumber(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setDepartmentName(
        @Nullable
        final String valueParam) {
        TextType aObj = getDepartmentName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setDepartmentName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setAdditionalStreetName(
        @Nullable
        final String valueParam) {
        TextType aObj = getAdditionalStreetName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setAdditionalStreetName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getPostcodeCodeValue() {
        CodeType aObj = getPostcodeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getPostOfficeBoxValue() {
        TextType aObj = getPostOfficeBox();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getBuildingNameValue() {
        TextType aObj = getBuildingName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineOneValue() {
        TextType aObj = getLineOne();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineTwoValue() {
        TextType aObj = getLineTwo();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineThreeValue() {
        TextType aObj = getLineThree();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineFourValue() {
        TextType aObj = getLineFour();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineFiveValue() {
        TextType aObj = getLineFive();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getStreetNameValue() {
        TextType aObj = getStreetName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getCityNameValue() {
        TextType aObj = getCityName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getCitySubDivisionNameValue() {
        TextType aObj = getCitySubDivisionName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CountryIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CountryIDType object or <code>null</code>
     */
    @Nullable
    public String getCountryIDValue() {
        CountryIDType aObj = getCountryID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getCountrySubDivisionIDValue() {
        IDType aObj = getCountrySubDivisionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getAttentionOfValue() {
        TextType aObj = getAttentionOf();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getCareOfValue() {
        TextType aObj = getCareOf();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getBuildingNumberValue() {
        TextType aObj = getBuildingNumber();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getDepartmentNameValue() {
        TextType aObj = getDepartmentName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getAdditionalStreetNameValue() {
        TextType aObj = getAdditionalStreetName();
        return (aObj == null)?null:aObj.getValue();
    }

}
