
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.AllowanceChargeIdentificationCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.AllowanceChargeReasonCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.NumericType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.PercentType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for TradeAllowanceChargeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradeAllowanceChargeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ChargeIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="SequenceNumeric" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}NumericType" minOccurs="0"/>
 *         <element name="CalculationPercent" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}PercentType" minOccurs="0"/>
 *         <element name="BasisAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="BasisQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="PrepaidIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *         <element name="ActualAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="UnitBasisAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="ReasonCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}AllowanceChargeReasonCodeType" minOccurs="0"/>
 *         <element name="Reason" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}AllowanceChargeIdentificationCodeType" minOccurs="0"/>
 *         <element name="CategoryTradeTax" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeTaxType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ActualTradeCurrencyExchange" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeCurrencyExchangeType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradeAllowanceChargeType", propOrder = {
    "chargeIndicator",
    "id",
    "sequenceNumeric",
    "calculationPercent",
    "basisAmount",
    "basisQuantity",
    "prepaidIndicator",
    "actualAmount",
    "unitBasisAmount",
    "reasonCode",
    "reason",
    "typeCode",
    "categoryTradeTax",
    "actualTradeCurrencyExchange"
})
@CodingStyleguideUnaware
public class TradeAllowanceChargeType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ChargeIndicator")
    private IndicatorType chargeIndicator;
    @XmlElement(name = "ID")
    private IDType id;
    @XmlElement(name = "SequenceNumeric")
    private NumericType sequenceNumeric;
    @XmlElement(name = "CalculationPercent")
    private PercentType calculationPercent;
    @XmlElement(name = "BasisAmount")
    private AmountType basisAmount;
    @XmlElement(name = "BasisQuantity")
    private QuantityType basisQuantity;
    @XmlElement(name = "PrepaidIndicator")
    private IndicatorType prepaidIndicator;
    @XmlElement(name = "ActualAmount")
    private List<AmountType> actualAmount;
    @XmlElement(name = "UnitBasisAmount")
    private AmountType unitBasisAmount;
    @XmlElement(name = "ReasonCode")
    private AllowanceChargeReasonCodeType reasonCode;
    @XmlElement(name = "Reason")
    private TextType reason;
    @XmlElement(name = "TypeCode")
    private AllowanceChargeIdentificationCodeType typeCode;
    @XmlElement(name = "CategoryTradeTax")
    private List<TradeTaxType> categoryTradeTax;
    @XmlElement(name = "ActualTradeCurrencyExchange")
    private TradeCurrencyExchangeType actualTradeCurrencyExchange;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradeAllowanceChargeType() {
    }

    /**
     * Gets the value of the chargeIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getChargeIndicator() {
        return chargeIndicator;
    }

    /**
     * Sets the value of the chargeIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setChargeIndicator(
        @Nullable
        IndicatorType value) {
        this.chargeIndicator = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the sequenceNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link NumericType }
     *     
     */
    @Nullable
    public NumericType getSequenceNumeric() {
        return sequenceNumeric;
    }

    /**
     * Sets the value of the sequenceNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link NumericType }
     *     
     */
    public void setSequenceNumeric(
        @Nullable
        NumericType value) {
        this.sequenceNumeric = value;
    }

    /**
     * Gets the value of the calculationPercent property.
     * 
     * @return
     *     possible object is
     *     {@link PercentType }
     *     
     */
    @Nullable
    public PercentType getCalculationPercent() {
        return calculationPercent;
    }

    /**
     * Sets the value of the calculationPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link PercentType }
     *     
     */
    public void setCalculationPercent(
        @Nullable
        PercentType value) {
        this.calculationPercent = value;
    }

    /**
     * Gets the value of the basisAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getBasisAmount() {
        return basisAmount;
    }

    /**
     * Sets the value of the basisAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setBasisAmount(
        @Nullable
        AmountType value) {
        this.basisAmount = value;
    }

    /**
     * Gets the value of the basisQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getBasisQuantity() {
        return basisQuantity;
    }

    /**
     * Sets the value of the basisQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setBasisQuantity(
        @Nullable
        QuantityType value) {
        this.basisQuantity = value;
    }

    /**
     * Gets the value of the prepaidIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getPrepaidIndicator() {
        return prepaidIndicator;
    }

    /**
     * Sets the value of the prepaidIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setPrepaidIndicator(
        @Nullable
        IndicatorType value) {
        this.prepaidIndicator = value;
    }

    /**
     * Gets the value of the actualAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the actualAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getActualAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the actualAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getActualAmount() {
        if (actualAmount == null) {
            actualAmount = new ArrayList<>();
        }
        return this.actualAmount;
    }

    /**
     * Gets the value of the unitBasisAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getUnitBasisAmount() {
        return unitBasisAmount;
    }

    /**
     * Sets the value of the unitBasisAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setUnitBasisAmount(
        @Nullable
        AmountType value) {
        this.unitBasisAmount = value;
    }

    /**
     * Gets the value of the reasonCode property.
     * 
     * @return
     *     possible object is
     *     {@link AllowanceChargeReasonCodeType }
     *     
     */
    @Nullable
    public AllowanceChargeReasonCodeType getReasonCode() {
        return reasonCode;
    }

    /**
     * Sets the value of the reasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link AllowanceChargeReasonCodeType }
     *     
     */
    public void setReasonCode(
        @Nullable
        AllowanceChargeReasonCodeType value) {
        this.reasonCode = value;
    }

    /**
     * Gets the value of the reason property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getReason() {
        return reason;
    }

    /**
     * Sets the value of the reason property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setReason(
        @Nullable
        TextType value) {
        this.reason = value;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link AllowanceChargeIdentificationCodeType }
     *     
     */
    @Nullable
    public AllowanceChargeIdentificationCodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link AllowanceChargeIdentificationCodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        AllowanceChargeIdentificationCodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the categoryTradeTax property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the categoryTradeTax property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCategoryTradeTax().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeTaxType }
     * 
     * 
     * @return
     *     The value of the categoryTradeTax property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeTaxType> getCategoryTradeTax() {
        if (categoryTradeTax == null) {
            categoryTradeTax = new ArrayList<>();
        }
        return this.categoryTradeTax;
    }

    /**
     * Gets the value of the actualTradeCurrencyExchange property.
     * 
     * @return
     *     possible object is
     *     {@link TradeCurrencyExchangeType }
     *     
     */
    @Nullable
    public TradeCurrencyExchangeType getActualTradeCurrencyExchange() {
        return actualTradeCurrencyExchange;
    }

    /**
     * Sets the value of the actualTradeCurrencyExchange property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeCurrencyExchangeType }
     *     
     */
    public void setActualTradeCurrencyExchange(
        @Nullable
        TradeCurrencyExchangeType value) {
        this.actualTradeCurrencyExchange = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradeAllowanceChargeType rhs = ((TradeAllowanceChargeType) o);
        if (!EqualsHelper.equalsCollection(actualAmount, rhs.actualAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(actualTradeCurrencyExchange, rhs.actualTradeCurrencyExchange)) {
            return false;
        }
        if (!EqualsHelper.equals(basisAmount, rhs.basisAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(basisQuantity, rhs.basisQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(calculationPercent, rhs.calculationPercent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(categoryTradeTax, rhs.categoryTradeTax)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeIndicator, rhs.chargeIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(prepaidIndicator, rhs.prepaidIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(reason, rhs.reason)) {
            return false;
        }
        if (!EqualsHelper.equals(reasonCode, rhs.reasonCode)) {
            return false;
        }
        if (!EqualsHelper.equals(sequenceNumeric, rhs.sequenceNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(unitBasisAmount, rhs.unitBasisAmount)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualAmount).append(actualTradeCurrencyExchange).append(basisAmount).append(basisQuantity).append(calculationPercent).append(categoryTradeTax).append(chargeIndicator).append(id).append(prepaidIndicator).append(reason).append(reasonCode).append(sequenceNumeric).append(typeCode).append(unitBasisAmount).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualAmount", actualAmount).append("actualTradeCurrencyExchange", actualTradeCurrencyExchange).append("basisAmount", basisAmount).append("basisQuantity", basisQuantity).append("calculationPercent", calculationPercent).append("categoryTradeTax", categoryTradeTax).append("chargeIndicator", chargeIndicator).append("id", id).append("prepaidIndicator", prepaidIndicator).append("reason", reason).append("reasonCode", reasonCode).append("sequenceNumeric", sequenceNumeric).append("typeCode", typeCode).append("unitBasisAmount", unitBasisAmount).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setActualAmount(
        @Nullable
        final List<AmountType> aList) {
        actualAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCategoryTradeTax(
        @Nullable
        final List<TradeTaxType> aList) {
        categoryTradeTax = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasActualAmountEntries() {
        return (!getActualAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoActualAmountEntries() {
        return getActualAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getActualAmountCount() {
        return getActualAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getActualAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getActualAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addActualAmount(
        @Nonnull
        final AmountType elem) {
        getActualAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCategoryTradeTaxEntries() {
        return (!getCategoryTradeTax().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCategoryTradeTaxEntries() {
        return getCategoryTradeTax().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCategoryTradeTaxCount() {
        return getCategoryTradeTax().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeTaxType getCategoryTradeTaxAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCategoryTradeTax().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCategoryTradeTax(
        @Nonnull
        final TradeTaxType elem) {
        getCategoryTradeTax().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradeAllowanceChargeType ret) {
        if (actualAmount == null) {
            ret.actualAmount = null;
        } else {
            List<AmountType> retActualAmount = new ArrayList<>();
            for (AmountType aItem: getActualAmount()) {
                retActualAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.actualAmount = retActualAmount;
        }
        ret.actualTradeCurrencyExchange = ((actualTradeCurrencyExchange == null)?null:actualTradeCurrencyExchange.clone());
        ret.basisAmount = ((basisAmount == null)?null:basisAmount.clone());
        ret.basisQuantity = ((basisQuantity == null)?null:basisQuantity.clone());
        ret.calculationPercent = ((calculationPercent == null)?null:calculationPercent.clone());
        if (categoryTradeTax == null) {
            ret.categoryTradeTax = null;
        } else {
            List<TradeTaxType> retCategoryTradeTax = new ArrayList<>();
            for (TradeTaxType aItem: getCategoryTradeTax()) {
                retCategoryTradeTax.add(((aItem == null)?null:aItem.clone()));
            }
            ret.categoryTradeTax = retCategoryTradeTax;
        }
        ret.chargeIndicator = ((chargeIndicator == null)?null:chargeIndicator.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.prepaidIndicator = ((prepaidIndicator == null)?null:prepaidIndicator.clone());
        ret.reason = ((reason == null)?null:reason.clone());
        ret.reasonCode = ((reasonCode == null)?null:reasonCode.clone());
        ret.sequenceNumeric = ((sequenceNumeric == null)?null:sequenceNumeric.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        ret.unitBasisAmount = ((unitBasisAmount == null)?null:unitBasisAmount.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradeAllowanceChargeType clone() {
        TradeAllowanceChargeType ret = new TradeAllowanceChargeType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NumericType and never <code>null</code>
     */
    @Nonnull
    public NumericType setSequenceNumeric(
        @Nullable
        final BigDecimal valueParam) {
        NumericType aObj = getSequenceNumeric();
        if (aObj == null) {
            aObj = new NumericType(valueParam);
            setSequenceNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PercentType and never <code>null</code>
     */
    @Nonnull
    public PercentType setCalculationPercent(
        @Nullable
        final BigDecimal valueParam) {
        PercentType aObj = getCalculationPercent();
        if (aObj == null) {
            aObj = new PercentType(valueParam);
            setCalculationPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setBasisAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getBasisAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setBasisAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setBasisQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getBasisQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setBasisQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setUnitBasisAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getUnitBasisAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setUnitBasisAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AllowanceChargeReasonCodeType and never <code>null</code>
     */
    @Nonnull
    public AllowanceChargeReasonCodeType setReasonCode(
        @Nullable
        final String valueParam) {
        AllowanceChargeReasonCodeType aObj = getReasonCode();
        if (aObj == null) {
            aObj = new AllowanceChargeReasonCodeType(valueParam);
            setReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setReason(
        @Nullable
        final String valueParam) {
        TextType aObj = getReason();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setReason(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AllowanceChargeIdentificationCodeType and never <code>null</code>
     */
    @Nonnull
    public AllowanceChargeIdentificationCodeType setTypeCode(
        @Nullable
        final String valueParam) {
        AllowanceChargeIdentificationCodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new AllowanceChargeIdentificationCodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSequenceNumericValue() {
        NumericType aObj = getSequenceNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCalculationPercentValue() {
        PercentType aObj = getCalculationPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getBasisAmountValue() {
        AmountType aObj = getBasisAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getBasisQuantityValue() {
        QuantityType aObj = getBasisQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getUnitBasisAmountValue() {
        AmountType aObj = getUnitBasisAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AllowanceChargeReasonCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AllowanceChargeReasonCodeType object or <code>null</code>
     */
    @Nullable
    public String getReasonCodeValue() {
        AllowanceChargeReasonCodeType aObj = getReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getReasonValue() {
        TextType aObj = getReason();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AllowanceChargeIdentificationCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AllowanceChargeIdentificationCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        AllowanceChargeIdentificationCodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
