
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.CurrencyCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.NumericType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.RateType;


/**
 * <p>Java class for TradeCurrencyExchangeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradeCurrencyExchangeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="SourceCurrencyCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}CurrencyCodeType"/>
 *         <element name="SourceUnitBasisNumeric" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}NumericType" minOccurs="0"/>
 *         <element name="TargetCurrencyCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}CurrencyCodeType"/>
 *         <element name="TargetUnitBaseNumeric" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}NumericType" minOccurs="0"/>
 *         <element name="MarketID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="ConversionRate" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}RateType"/>
 *         <element name="ConversionRateDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="AssociatedReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradeCurrencyExchangeType", propOrder = {
    "sourceCurrencyCode",
    "sourceUnitBasisNumeric",
    "targetCurrencyCode",
    "targetUnitBaseNumeric",
    "marketID",
    "conversionRate",
    "conversionRateDateTime",
    "associatedReferencedDocument"
})
@CodingStyleguideUnaware
public class TradeCurrencyExchangeType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SourceCurrencyCode", required = true)
    private CurrencyCodeType sourceCurrencyCode;
    @XmlElement(name = "SourceUnitBasisNumeric")
    private NumericType sourceUnitBasisNumeric;
    @XmlElement(name = "TargetCurrencyCode", required = true)
    private CurrencyCodeType targetCurrencyCode;
    @XmlElement(name = "TargetUnitBaseNumeric")
    private NumericType targetUnitBaseNumeric;
    @XmlElement(name = "MarketID")
    private IDType marketID;
    @XmlElement(name = "ConversionRate", required = true)
    private RateType conversionRate;
    @XmlElement(name = "ConversionRateDateTime")
    private DateTimeType conversionRateDateTime;
    @XmlElement(name = "AssociatedReferencedDocument")
    private List<ReferencedDocumentType> associatedReferencedDocument;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradeCurrencyExchangeType() {
    }

    /**
     * Gets the value of the sourceCurrencyCode property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyCodeType }
     *     
     */
    @Nullable
    public CurrencyCodeType getSourceCurrencyCode() {
        return sourceCurrencyCode;
    }

    /**
     * Sets the value of the sourceCurrencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyCodeType }
     *     
     */
    public void setSourceCurrencyCode(
        @Nullable
        CurrencyCodeType value) {
        this.sourceCurrencyCode = value;
    }

    /**
     * Gets the value of the sourceUnitBasisNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link NumericType }
     *     
     */
    @Nullable
    public NumericType getSourceUnitBasisNumeric() {
        return sourceUnitBasisNumeric;
    }

    /**
     * Sets the value of the sourceUnitBasisNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link NumericType }
     *     
     */
    public void setSourceUnitBasisNumeric(
        @Nullable
        NumericType value) {
        this.sourceUnitBasisNumeric = value;
    }

    /**
     * Gets the value of the targetCurrencyCode property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyCodeType }
     *     
     */
    @Nullable
    public CurrencyCodeType getTargetCurrencyCode() {
        return targetCurrencyCode;
    }

    /**
     * Sets the value of the targetCurrencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyCodeType }
     *     
     */
    public void setTargetCurrencyCode(
        @Nullable
        CurrencyCodeType value) {
        this.targetCurrencyCode = value;
    }

    /**
     * Gets the value of the targetUnitBaseNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link NumericType }
     *     
     */
    @Nullable
    public NumericType getTargetUnitBaseNumeric() {
        return targetUnitBaseNumeric;
    }

    /**
     * Sets the value of the targetUnitBaseNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link NumericType }
     *     
     */
    public void setTargetUnitBaseNumeric(
        @Nullable
        NumericType value) {
        this.targetUnitBaseNumeric = value;
    }

    /**
     * Gets the value of the marketID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getMarketID() {
        return marketID;
    }

    /**
     * Sets the value of the marketID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setMarketID(
        @Nullable
        IDType value) {
        this.marketID = value;
    }

    /**
     * Gets the value of the conversionRate property.
     * 
     * @return
     *     possible object is
     *     {@link RateType }
     *     
     */
    @Nullable
    public RateType getConversionRate() {
        return conversionRate;
    }

    /**
     * Sets the value of the conversionRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link RateType }
     *     
     */
    public void setConversionRate(
        @Nullable
        RateType value) {
        this.conversionRate = value;
    }

    /**
     * Gets the value of the conversionRateDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getConversionRateDateTime() {
        return conversionRateDateTime;
    }

    /**
     * Sets the value of the conversionRateDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setConversionRateDateTime(
        @Nullable
        DateTimeType value) {
        this.conversionRateDateTime = value;
    }

    /**
     * Gets the value of the associatedReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the associatedReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssociatedReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the associatedReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getAssociatedReferencedDocument() {
        if (associatedReferencedDocument == null) {
            associatedReferencedDocument = new ArrayList<>();
        }
        return this.associatedReferencedDocument;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradeCurrencyExchangeType rhs = ((TradeCurrencyExchangeType) o);
        if (!EqualsHelper.equalsCollection(associatedReferencedDocument, rhs.associatedReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(conversionRate, rhs.conversionRate)) {
            return false;
        }
        if (!EqualsHelper.equals(conversionRateDateTime, rhs.conversionRateDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(marketID, rhs.marketID)) {
            return false;
        }
        if (!EqualsHelper.equals(sourceCurrencyCode, rhs.sourceCurrencyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(sourceUnitBasisNumeric, rhs.sourceUnitBasisNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(targetCurrencyCode, rhs.targetCurrencyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(targetUnitBaseNumeric, rhs.targetUnitBaseNumeric)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(associatedReferencedDocument).append(conversionRate).append(conversionRateDateTime).append(marketID).append(sourceCurrencyCode).append(sourceUnitBasisNumeric).append(targetCurrencyCode).append(targetUnitBaseNumeric).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("associatedReferencedDocument", associatedReferencedDocument).append("conversionRate", conversionRate).append("conversionRateDateTime", conversionRateDateTime).append("marketID", marketID).append("sourceCurrencyCode", sourceCurrencyCode).append("sourceUnitBasisNumeric", sourceUnitBasisNumeric).append("targetCurrencyCode", targetCurrencyCode).append("targetUnitBaseNumeric", targetUnitBaseNumeric).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAssociatedReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        associatedReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAssociatedReferencedDocumentEntries() {
        return (!getAssociatedReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAssociatedReferencedDocumentEntries() {
        return getAssociatedReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAssociatedReferencedDocumentCount() {
        return getAssociatedReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getAssociatedReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAssociatedReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAssociatedReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getAssociatedReferencedDocument().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradeCurrencyExchangeType ret) {
        if (associatedReferencedDocument == null) {
            ret.associatedReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retAssociatedReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getAssociatedReferencedDocument()) {
                retAssociatedReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.associatedReferencedDocument = retAssociatedReferencedDocument;
        }
        ret.conversionRate = ((conversionRate == null)?null:conversionRate.clone());
        ret.conversionRateDateTime = ((conversionRateDateTime == null)?null:conversionRateDateTime.clone());
        ret.marketID = ((marketID == null)?null:marketID.clone());
        ret.sourceCurrencyCode = ((sourceCurrencyCode == null)?null:sourceCurrencyCode.clone());
        ret.sourceUnitBasisNumeric = ((sourceUnitBasisNumeric == null)?null:sourceUnitBasisNumeric.clone());
        ret.targetCurrencyCode = ((targetCurrencyCode == null)?null:targetCurrencyCode.clone());
        ret.targetUnitBaseNumeric = ((targetUnitBaseNumeric == null)?null:targetUnitBaseNumeric.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradeCurrencyExchangeType clone() {
        TradeCurrencyExchangeType ret = new TradeCurrencyExchangeType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CurrencyCodeType and never <code>null</code>
     */
    @Nonnull
    public CurrencyCodeType setSourceCurrencyCode(
        @Nullable
        final String valueParam) {
        CurrencyCodeType aObj = getSourceCurrencyCode();
        if (aObj == null) {
            aObj = new CurrencyCodeType(valueParam);
            setSourceCurrencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NumericType and never <code>null</code>
     */
    @Nonnull
    public NumericType setSourceUnitBasisNumeric(
        @Nullable
        final BigDecimal valueParam) {
        NumericType aObj = getSourceUnitBasisNumeric();
        if (aObj == null) {
            aObj = new NumericType(valueParam);
            setSourceUnitBasisNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CurrencyCodeType and never <code>null</code>
     */
    @Nonnull
    public CurrencyCodeType setTargetCurrencyCode(
        @Nullable
        final String valueParam) {
        CurrencyCodeType aObj = getTargetCurrencyCode();
        if (aObj == null) {
            aObj = new CurrencyCodeType(valueParam);
            setTargetCurrencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NumericType and never <code>null</code>
     */
    @Nonnull
    public NumericType setTargetUnitBaseNumeric(
        @Nullable
        final BigDecimal valueParam) {
        NumericType aObj = getTargetUnitBaseNumeric();
        if (aObj == null) {
            aObj = new NumericType(valueParam);
            setTargetUnitBaseNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setMarketID(
        @Nullable
        final String valueParam) {
        IDType aObj = getMarketID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setMarketID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RateType and never <code>null</code>
     */
    @Nonnull
    public RateType setConversionRate(
        @Nullable
        final BigDecimal valueParam) {
        RateType aObj = getConversionRate();
        if (aObj == null) {
            aObj = new RateType(valueParam);
            setConversionRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CurrencyCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CurrencyCodeType object or <code>null</code>
     */
    @Nullable
    public String getSourceCurrencyCodeValue() {
        CurrencyCodeType aObj = getSourceCurrencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSourceUnitBasisNumericValue() {
        NumericType aObj = getSourceUnitBasisNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CurrencyCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CurrencyCodeType object or <code>null</code>
     */
    @Nullable
    public String getTargetCurrencyCodeValue() {
        CurrencyCodeType aObj = getTargetCurrencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTargetUnitBaseNumericValue() {
        NumericType aObj = getTargetUnitBaseNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getMarketIDValue() {
        IDType aObj = getMarketID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RateType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getConversionRateValue() {
        RateType aObj = getConversionRate();
        return (aObj == null)?null:aObj.getValue();
    }

}
