
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.MeasureType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.PercentType;


/**
 * <p>Java class for TradePaymentDiscountTermsType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradePaymentDiscountTermsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="BasisDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="BasisPeriodMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" minOccurs="0"/>
 *         <element name="BasisAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="CalculationPercent" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}PercentType" minOccurs="0"/>
 *         <element name="ActualDiscountAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradePaymentDiscountTermsType", propOrder = {
    "basisDateTime",
    "basisPeriodMeasure",
    "basisAmount",
    "calculationPercent",
    "actualDiscountAmount"
})
@CodingStyleguideUnaware
public class TradePaymentDiscountTermsType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "BasisDateTime")
    private DateTimeType basisDateTime;
    @XmlElement(name = "BasisPeriodMeasure")
    private MeasureType basisPeriodMeasure;
    @XmlElement(name = "BasisAmount")
    private AmountType basisAmount;
    @XmlElement(name = "CalculationPercent")
    private PercentType calculationPercent;
    @XmlElement(name = "ActualDiscountAmount")
    private AmountType actualDiscountAmount;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradePaymentDiscountTermsType() {
    }

    /**
     * Gets the value of the basisDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getBasisDateTime() {
        return basisDateTime;
    }

    /**
     * Sets the value of the basisDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setBasisDateTime(
        @Nullable
        DateTimeType value) {
        this.basisDateTime = value;
    }

    /**
     * Gets the value of the basisPeriodMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MeasureType }
     *     
     */
    @Nullable
    public MeasureType getBasisPeriodMeasure() {
        return basisPeriodMeasure;
    }

    /**
     * Sets the value of the basisPeriodMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeasureType }
     *     
     */
    public void setBasisPeriodMeasure(
        @Nullable
        MeasureType value) {
        this.basisPeriodMeasure = value;
    }

    /**
     * Gets the value of the basisAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getBasisAmount() {
        return basisAmount;
    }

    /**
     * Sets the value of the basisAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setBasisAmount(
        @Nullable
        AmountType value) {
        this.basisAmount = value;
    }

    /**
     * Gets the value of the calculationPercent property.
     * 
     * @return
     *     possible object is
     *     {@link PercentType }
     *     
     */
    @Nullable
    public PercentType getCalculationPercent() {
        return calculationPercent;
    }

    /**
     * Sets the value of the calculationPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link PercentType }
     *     
     */
    public void setCalculationPercent(
        @Nullable
        PercentType value) {
        this.calculationPercent = value;
    }

    /**
     * Gets the value of the actualDiscountAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getActualDiscountAmount() {
        return actualDiscountAmount;
    }

    /**
     * Sets the value of the actualDiscountAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setActualDiscountAmount(
        @Nullable
        AmountType value) {
        this.actualDiscountAmount = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradePaymentDiscountTermsType rhs = ((TradePaymentDiscountTermsType) o);
        if (!EqualsHelper.equals(actualDiscountAmount, rhs.actualDiscountAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(basisAmount, rhs.basisAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(basisDateTime, rhs.basisDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(basisPeriodMeasure, rhs.basisPeriodMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(calculationPercent, rhs.calculationPercent)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualDiscountAmount).append(basisAmount).append(basisDateTime).append(basisPeriodMeasure).append(calculationPercent).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualDiscountAmount", actualDiscountAmount).append("basisAmount", basisAmount).append("basisDateTime", basisDateTime).append("basisPeriodMeasure", basisPeriodMeasure).append("calculationPercent", calculationPercent).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradePaymentDiscountTermsType ret) {
        ret.actualDiscountAmount = ((actualDiscountAmount == null)?null:actualDiscountAmount.clone());
        ret.basisAmount = ((basisAmount == null)?null:basisAmount.clone());
        ret.basisDateTime = ((basisDateTime == null)?null:basisDateTime.clone());
        ret.basisPeriodMeasure = ((basisPeriodMeasure == null)?null:basisPeriodMeasure.clone());
        ret.calculationPercent = ((calculationPercent == null)?null:calculationPercent.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradePaymentDiscountTermsType clone() {
        TradePaymentDiscountTermsType ret = new TradePaymentDiscountTermsType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeasureType and never <code>null</code>
     */
    @Nonnull
    public MeasureType setBasisPeriodMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MeasureType aObj = getBasisPeriodMeasure();
        if (aObj == null) {
            aObj = new MeasureType(valueParam);
            setBasisPeriodMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setBasisAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getBasisAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setBasisAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PercentType and never <code>null</code>
     */
    @Nonnull
    public PercentType setCalculationPercent(
        @Nullable
        final BigDecimal valueParam) {
        PercentType aObj = getCalculationPercent();
        if (aObj == null) {
            aObj = new PercentType(valueParam);
            setCalculationPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setActualDiscountAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getActualDiscountAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setActualDiscountAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained MeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getBasisPeriodMeasureValue() {
        MeasureType aObj = getBasisPeriodMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getBasisAmountValue() {
        AmountType aObj = getBasisAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCalculationPercentValue() {
        PercentType aObj = getCalculationPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getActualDiscountAmountValue() {
        AmountType aObj = getActualDiscountAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
