
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.PaymentTermsEventTimeReferenceCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.PaymentTermsIDType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.PaymentTermsTypeCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.MeasureType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.PercentType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for TradePaymentTermsType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradePaymentTermsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}PaymentTermsIDType" minOccurs="0"/>
 *         <element name="FromEventCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}PaymentTermsEventTimeReferenceCodeType" minOccurs="0"/>
 *         <element name="SettlementPeriodMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" minOccurs="0"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="DueDateDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}PaymentTermsTypeCodeType" minOccurs="0"/>
 *         <element name="InstructionTypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="DirectDebitMandateID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PartialPaymentPercent" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}PercentType" minOccurs="0"/>
 *         <element name="PaymentMeansID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PartialPaymentAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ApplicableTradePaymentPenaltyTerms" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePaymentPenaltyTermsType" minOccurs="0"/>
 *         <element name="ApplicableTradePaymentDiscountTerms" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePaymentDiscountTermsType" minOccurs="0"/>
 *         <element name="PayeeTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradePaymentTermsType", propOrder = {
    "id",
    "fromEventCode",
    "settlementPeriodMeasure",
    "description",
    "dueDateDateTime",
    "typeCode",
    "instructionTypeCode",
    "directDebitMandateID",
    "partialPaymentPercent",
    "paymentMeansID",
    "partialPaymentAmount",
    "applicableTradePaymentPenaltyTerms",
    "applicableTradePaymentDiscountTerms",
    "payeeTradeParty"
})
@CodingStyleguideUnaware
public class TradePaymentTermsType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID")
    private PaymentTermsIDType id;
    @XmlElement(name = "FromEventCode")
    private PaymentTermsEventTimeReferenceCodeType fromEventCode;
    @XmlElement(name = "SettlementPeriodMeasure")
    private MeasureType settlementPeriodMeasure;
    @XmlElement(name = "Description")
    private List<TextType> description;
    @XmlElement(name = "DueDateDateTime")
    private DateTimeType dueDateDateTime;
    @XmlElement(name = "TypeCode")
    private PaymentTermsTypeCodeType typeCode;
    @XmlElement(name = "InstructionTypeCode")
    private CodeType instructionTypeCode;
    @XmlElement(name = "DirectDebitMandateID")
    private List<IDType> directDebitMandateID;
    @XmlElement(name = "PartialPaymentPercent")
    private PercentType partialPaymentPercent;
    @XmlElement(name = "PaymentMeansID")
    private List<IDType> paymentMeansID;
    @XmlElement(name = "PartialPaymentAmount")
    private List<AmountType> partialPaymentAmount;
    @XmlElement(name = "ApplicableTradePaymentPenaltyTerms")
    private TradePaymentPenaltyTermsType applicableTradePaymentPenaltyTerms;
    @XmlElement(name = "ApplicableTradePaymentDiscountTerms")
    private TradePaymentDiscountTermsType applicableTradePaymentDiscountTerms;
    @XmlElement(name = "PayeeTradeParty")
    private List<TradePartyType> payeeTradeParty;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradePaymentTermsType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTermsIDType }
     *     
     */
    @Nullable
    public PaymentTermsIDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTermsIDType }
     *     
     */
    public void setID(
        @Nullable
        PaymentTermsIDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the fromEventCode property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTermsEventTimeReferenceCodeType }
     *     
     */
    @Nullable
    public PaymentTermsEventTimeReferenceCodeType getFromEventCode() {
        return fromEventCode;
    }

    /**
     * Sets the value of the fromEventCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTermsEventTimeReferenceCodeType }
     *     
     */
    public void setFromEventCode(
        @Nullable
        PaymentTermsEventTimeReferenceCodeType value) {
        this.fromEventCode = value;
    }

    /**
     * Gets the value of the settlementPeriodMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MeasureType }
     *     
     */
    @Nullable
    public MeasureType getSettlementPeriodMeasure() {
        return settlementPeriodMeasure;
    }

    /**
     * Sets the value of the settlementPeriodMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeasureType }
     *     
     */
    public void setSettlementPeriodMeasure(
        @Nullable
        MeasureType value) {
        this.settlementPeriodMeasure = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the dueDateDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getDueDateDateTime() {
        return dueDateDateTime;
    }

    /**
     * Sets the value of the dueDateDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setDueDateDateTime(
        @Nullable
        DateTimeType value) {
        this.dueDateDateTime = value;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTermsTypeCodeType }
     *     
     */
    @Nullable
    public PaymentTermsTypeCodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTermsTypeCodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        PaymentTermsTypeCodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the instructionTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getInstructionTypeCode() {
        return instructionTypeCode;
    }

    /**
     * Sets the value of the instructionTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setInstructionTypeCode(
        @Nullable
        CodeType value) {
        this.instructionTypeCode = value;
    }

    /**
     * Gets the value of the directDebitMandateID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the directDebitMandateID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDirectDebitMandateID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     * @return
     *     The value of the directDebitMandateID property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getDirectDebitMandateID() {
        if (directDebitMandateID == null) {
            directDebitMandateID = new ArrayList<>();
        }
        return this.directDebitMandateID;
    }

    /**
     * Gets the value of the partialPaymentPercent property.
     * 
     * @return
     *     possible object is
     *     {@link PercentType }
     *     
     */
    @Nullable
    public PercentType getPartialPaymentPercent() {
        return partialPaymentPercent;
    }

    /**
     * Sets the value of the partialPaymentPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link PercentType }
     *     
     */
    public void setPartialPaymentPercent(
        @Nullable
        PercentType value) {
        this.partialPaymentPercent = value;
    }

    /**
     * Gets the value of the paymentMeansID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the paymentMeansID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPaymentMeansID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     * @return
     *     The value of the paymentMeansID property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getPaymentMeansID() {
        if (paymentMeansID == null) {
            paymentMeansID = new ArrayList<>();
        }
        return this.paymentMeansID;
    }

    /**
     * Gets the value of the partialPaymentAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the partialPaymentAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPartialPaymentAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the partialPaymentAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getPartialPaymentAmount() {
        if (partialPaymentAmount == null) {
            partialPaymentAmount = new ArrayList<>();
        }
        return this.partialPaymentAmount;
    }

    /**
     * Gets the value of the applicableTradePaymentPenaltyTerms property.
     * 
     * @return
     *     possible object is
     *     {@link TradePaymentPenaltyTermsType }
     *     
     */
    @Nullable
    public TradePaymentPenaltyTermsType getApplicableTradePaymentPenaltyTerms() {
        return applicableTradePaymentPenaltyTerms;
    }

    /**
     * Sets the value of the applicableTradePaymentPenaltyTerms property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePaymentPenaltyTermsType }
     *     
     */
    public void setApplicableTradePaymentPenaltyTerms(
        @Nullable
        TradePaymentPenaltyTermsType value) {
        this.applicableTradePaymentPenaltyTerms = value;
    }

    /**
     * Gets the value of the applicableTradePaymentDiscountTerms property.
     * 
     * @return
     *     possible object is
     *     {@link TradePaymentDiscountTermsType }
     *     
     */
    @Nullable
    public TradePaymentDiscountTermsType getApplicableTradePaymentDiscountTerms() {
        return applicableTradePaymentDiscountTerms;
    }

    /**
     * Sets the value of the applicableTradePaymentDiscountTerms property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePaymentDiscountTermsType }
     *     
     */
    public void setApplicableTradePaymentDiscountTerms(
        @Nullable
        TradePaymentDiscountTermsType value) {
        this.applicableTradePaymentDiscountTerms = value;
    }

    /**
     * Gets the value of the payeeTradeParty property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the payeeTradeParty property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayeeTradeParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradePartyType }
     * 
     * 
     * @return
     *     The value of the payeeTradeParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradePartyType> getPayeeTradeParty() {
        if (payeeTradeParty == null) {
            payeeTradeParty = new ArrayList<>();
        }
        return this.payeeTradeParty;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradePaymentTermsType rhs = ((TradePaymentTermsType) o);
        if (!EqualsHelper.equals(applicableTradePaymentDiscountTerms, rhs.applicableTradePaymentDiscountTerms)) {
            return false;
        }
        if (!EqualsHelper.equals(applicableTradePaymentPenaltyTerms, rhs.applicableTradePaymentPenaltyTerms)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(directDebitMandateID, rhs.directDebitMandateID)) {
            return false;
        }
        if (!EqualsHelper.equals(dueDateDateTime, rhs.dueDateDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(fromEventCode, rhs.fromEventCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(instructionTypeCode, rhs.instructionTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partialPaymentAmount, rhs.partialPaymentAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(partialPaymentPercent, rhs.partialPaymentPercent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(payeeTradeParty, rhs.payeeTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(paymentMeansID, rhs.paymentMeansID)) {
            return false;
        }
        if (!EqualsHelper.equals(settlementPeriodMeasure, rhs.settlementPeriodMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(applicableTradePaymentDiscountTerms).append(applicableTradePaymentPenaltyTerms).append(description).append(directDebitMandateID).append(dueDateDateTime).append(fromEventCode).append(id).append(instructionTypeCode).append(partialPaymentAmount).append(partialPaymentPercent).append(payeeTradeParty).append(paymentMeansID).append(settlementPeriodMeasure).append(typeCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("applicableTradePaymentDiscountTerms", applicableTradePaymentDiscountTerms).append("applicableTradePaymentPenaltyTerms", applicableTradePaymentPenaltyTerms).append("description", description).append("directDebitMandateID", directDebitMandateID).append("dueDateDateTime", dueDateDateTime).append("fromEventCode", fromEventCode).append("id", id).append("instructionTypeCode", instructionTypeCode).append("partialPaymentAmount", partialPaymentAmount).append("partialPaymentPercent", partialPaymentPercent).append("payeeTradeParty", payeeTradeParty).append("paymentMeansID", paymentMeansID).append("settlementPeriodMeasure", settlementPeriodMeasure).append("typeCode", typeCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<TextType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDirectDebitMandateID(
        @Nullable
        final List<IDType> aList) {
        directDebitMandateID = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPaymentMeansID(
        @Nullable
        final List<IDType> aList) {
        paymentMeansID = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartialPaymentAmount(
        @Nullable
        final List<AmountType> aList) {
        partialPaymentAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPayeeTradeParty(
        @Nullable
        final List<TradePartyType> aList) {
        payeeTradeParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final TextType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDirectDebitMandateIDEntries() {
        return (!getDirectDebitMandateID().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDirectDebitMandateIDEntries() {
        return getDirectDebitMandateID().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDirectDebitMandateIDCount() {
        return getDirectDebitMandateID().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getDirectDebitMandateIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDirectDebitMandateID().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDirectDebitMandateID(
        @Nonnull
        final IDType elem) {
        getDirectDebitMandateID().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPaymentMeansIDEntries() {
        return (!getPaymentMeansID().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPaymentMeansIDEntries() {
        return getPaymentMeansID().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPaymentMeansIDCount() {
        return getPaymentMeansID().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getPaymentMeansIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPaymentMeansID().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPaymentMeansID(
        @Nonnull
        final IDType elem) {
        getPaymentMeansID().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartialPaymentAmountEntries() {
        return (!getPartialPaymentAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartialPaymentAmountEntries() {
        return getPartialPaymentAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartialPaymentAmountCount() {
        return getPartialPaymentAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getPartialPaymentAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartialPaymentAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartialPaymentAmount(
        @Nonnull
        final AmountType elem) {
        getPartialPaymentAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPayeeTradePartyEntries() {
        return (!getPayeeTradeParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPayeeTradePartyEntries() {
        return getPayeeTradeParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPayeeTradePartyCount() {
        return getPayeeTradeParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradePartyType getPayeeTradePartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPayeeTradeParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPayeeTradeParty(
        @Nonnull
        final TradePartyType elem) {
        getPayeeTradeParty().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradePaymentTermsType ret) {
        ret.applicableTradePaymentDiscountTerms = ((applicableTradePaymentDiscountTerms == null)?null:applicableTradePaymentDiscountTerms.clone());
        ret.applicableTradePaymentPenaltyTerms = ((applicableTradePaymentPenaltyTerms == null)?null:applicableTradePaymentPenaltyTerms.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<TextType> retDescription = new ArrayList<>();
            for (TextType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (directDebitMandateID == null) {
            ret.directDebitMandateID = null;
        } else {
            List<IDType> retDirectDebitMandateID = new ArrayList<>();
            for (IDType aItem: getDirectDebitMandateID()) {
                retDirectDebitMandateID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.directDebitMandateID = retDirectDebitMandateID;
        }
        ret.dueDateDateTime = ((dueDateDateTime == null)?null:dueDateDateTime.clone());
        ret.fromEventCode = ((fromEventCode == null)?null:fromEventCode.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.instructionTypeCode = ((instructionTypeCode == null)?null:instructionTypeCode.clone());
        if (partialPaymentAmount == null) {
            ret.partialPaymentAmount = null;
        } else {
            List<AmountType> retPartialPaymentAmount = new ArrayList<>();
            for (AmountType aItem: getPartialPaymentAmount()) {
                retPartialPaymentAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partialPaymentAmount = retPartialPaymentAmount;
        }
        ret.partialPaymentPercent = ((partialPaymentPercent == null)?null:partialPaymentPercent.clone());
        if (payeeTradeParty == null) {
            ret.payeeTradeParty = null;
        } else {
            List<TradePartyType> retPayeeTradeParty = new ArrayList<>();
            for (TradePartyType aItem: getPayeeTradeParty()) {
                retPayeeTradeParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.payeeTradeParty = retPayeeTradeParty;
        }
        if (paymentMeansID == null) {
            ret.paymentMeansID = null;
        } else {
            List<IDType> retPaymentMeansID = new ArrayList<>();
            for (IDType aItem: getPaymentMeansID()) {
                retPaymentMeansID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.paymentMeansID = retPaymentMeansID;
        }
        ret.settlementPeriodMeasure = ((settlementPeriodMeasure == null)?null:settlementPeriodMeasure.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradePaymentTermsType clone() {
        TradePaymentTermsType ret = new TradePaymentTermsType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaymentTermsIDType and never <code>null</code>
     */
    @Nonnull
    public PaymentTermsIDType setID(
        @Nullable
        final String valueParam) {
        PaymentTermsIDType aObj = getID();
        if (aObj == null) {
            aObj = new PaymentTermsIDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaymentTermsEventTimeReferenceCodeType and never <code>null</code>
     */
    @Nonnull
    public PaymentTermsEventTimeReferenceCodeType setFromEventCode(
        @Nullable
        final String valueParam) {
        PaymentTermsEventTimeReferenceCodeType aObj = getFromEventCode();
        if (aObj == null) {
            aObj = new PaymentTermsEventTimeReferenceCodeType(valueParam);
            setFromEventCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeasureType and never <code>null</code>
     */
    @Nonnull
    public MeasureType setSettlementPeriodMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MeasureType aObj = getSettlementPeriodMeasure();
        if (aObj == null) {
            aObj = new MeasureType(valueParam);
            setSettlementPeriodMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaymentTermsTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public PaymentTermsTypeCodeType setTypeCode(
        @Nullable
        final String valueParam) {
        PaymentTermsTypeCodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new PaymentTermsTypeCodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setInstructionTypeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getInstructionTypeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setInstructionTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PercentType and never <code>null</code>
     */
    @Nonnull
    public PercentType setPartialPaymentPercent(
        @Nullable
        final BigDecimal valueParam) {
        PercentType aObj = getPartialPaymentPercent();
        if (aObj == null) {
            aObj = new PercentType(valueParam);
            setPartialPaymentPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained PaymentTermsIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaymentTermsIDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        PaymentTermsIDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaymentTermsEventTimeReferenceCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaymentTermsEventTimeReferenceCodeType object or <code>null</code>
     */
    @Nullable
    public String getFromEventCodeValue() {
        PaymentTermsEventTimeReferenceCodeType aObj = getFromEventCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSettlementPeriodMeasureValue() {
        MeasureType aObj = getSettlementPeriodMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaymentTermsTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaymentTermsTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        PaymentTermsTypeCodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getInstructionTypeCodeValue() {
        CodeType aObj = getInstructionTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPartialPaymentPercentValue() {
        PercentType aObj = getPartialPaymentPercent();
        return (aObj == null)?null:aObj.getValue();
    }

}
