
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.PriceTypeCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.NumericType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for TradePriceType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradePriceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}PriceTypeCodeType" minOccurs="0"/>
 *         <element name="ChargeAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded"/>
 *         <element name="BasisQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="MinimumQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="MaximumQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="ChangeReason" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="OrderUnitConversionFactorNumeric" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}NumericType" minOccurs="0"/>
 *         <element name="AppliedTradeAllowanceCharge" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAllowanceChargeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ValiditySpecifiedPeriod" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedPeriodType" minOccurs="0"/>
 *         <element name="IncludedTradeTax" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeTaxType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="DeliveryTradeLocation" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeLocationType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TradeComparisonReferencePrice" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencePriceType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AssociatedReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradePriceType", propOrder = {
    "typeCode",
    "chargeAmount",
    "basisQuantity",
    "minimumQuantity",
    "maximumQuantity",
    "changeReason",
    "orderUnitConversionFactorNumeric",
    "appliedTradeAllowanceCharge",
    "validitySpecifiedPeriod",
    "includedTradeTax",
    "deliveryTradeLocation",
    "tradeComparisonReferencePrice",
    "associatedReferencedDocument"
})
@CodingStyleguideUnaware
public class TradePriceType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "TypeCode")
    private PriceTypeCodeType typeCode;
    @XmlElement(name = "ChargeAmount", required = true)
    private List<AmountType> chargeAmount;
    @XmlElement(name = "BasisQuantity")
    private QuantityType basisQuantity;
    @XmlElement(name = "MinimumQuantity")
    private QuantityType minimumQuantity;
    @XmlElement(name = "MaximumQuantity")
    private QuantityType maximumQuantity;
    @XmlElement(name = "ChangeReason")
    private List<TextType> changeReason;
    @XmlElement(name = "OrderUnitConversionFactorNumeric")
    private NumericType orderUnitConversionFactorNumeric;
    @XmlElement(name = "AppliedTradeAllowanceCharge")
    private List<TradeAllowanceChargeType> appliedTradeAllowanceCharge;
    @XmlElement(name = "ValiditySpecifiedPeriod")
    private SpecifiedPeriodType validitySpecifiedPeriod;
    @XmlElement(name = "IncludedTradeTax")
    private List<TradeTaxType> includedTradeTax;
    @XmlElement(name = "DeliveryTradeLocation")
    private List<TradeLocationType> deliveryTradeLocation;
    @XmlElement(name = "TradeComparisonReferencePrice")
    private List<ReferencePriceType> tradeComparisonReferencePrice;
    @XmlElement(name = "AssociatedReferencedDocument")
    private List<ReferencedDocumentType> associatedReferencedDocument;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradePriceType() {
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link PriceTypeCodeType }
     *     
     */
    @Nullable
    public PriceTypeCodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceTypeCodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        PriceTypeCodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the chargeAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the chargeAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getChargeAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the chargeAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getChargeAmount() {
        if (chargeAmount == null) {
            chargeAmount = new ArrayList<>();
        }
        return this.chargeAmount;
    }

    /**
     * Gets the value of the basisQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getBasisQuantity() {
        return basisQuantity;
    }

    /**
     * Sets the value of the basisQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setBasisQuantity(
        @Nullable
        QuantityType value) {
        this.basisQuantity = value;
    }

    /**
     * Gets the value of the minimumQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getMinimumQuantity() {
        return minimumQuantity;
    }

    /**
     * Sets the value of the minimumQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setMinimumQuantity(
        @Nullable
        QuantityType value) {
        this.minimumQuantity = value;
    }

    /**
     * Gets the value of the maximumQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getMaximumQuantity() {
        return maximumQuantity;
    }

    /**
     * Sets the value of the maximumQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setMaximumQuantity(
        @Nullable
        QuantityType value) {
        this.maximumQuantity = value;
    }

    /**
     * Gets the value of the changeReason property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the changeReason property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getChangeReason().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the changeReason property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getChangeReason() {
        if (changeReason == null) {
            changeReason = new ArrayList<>();
        }
        return this.changeReason;
    }

    /**
     * Gets the value of the orderUnitConversionFactorNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link NumericType }
     *     
     */
    @Nullable
    public NumericType getOrderUnitConversionFactorNumeric() {
        return orderUnitConversionFactorNumeric;
    }

    /**
     * Sets the value of the orderUnitConversionFactorNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link NumericType }
     *     
     */
    public void setOrderUnitConversionFactorNumeric(
        @Nullable
        NumericType value) {
        this.orderUnitConversionFactorNumeric = value;
    }

    /**
     * Gets the value of the appliedTradeAllowanceCharge property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the appliedTradeAllowanceCharge property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAppliedTradeAllowanceCharge().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeAllowanceChargeType }
     * 
     * 
     * @return
     *     The value of the appliedTradeAllowanceCharge property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeAllowanceChargeType> getAppliedTradeAllowanceCharge() {
        if (appliedTradeAllowanceCharge == null) {
            appliedTradeAllowanceCharge = new ArrayList<>();
        }
        return this.appliedTradeAllowanceCharge;
    }

    /**
     * Gets the value of the validitySpecifiedPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    @Nullable
    public SpecifiedPeriodType getValiditySpecifiedPeriod() {
        return validitySpecifiedPeriod;
    }

    /**
     * Sets the value of the validitySpecifiedPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    public void setValiditySpecifiedPeriod(
        @Nullable
        SpecifiedPeriodType value) {
        this.validitySpecifiedPeriod = value;
    }

    /**
     * Gets the value of the includedTradeTax property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the includedTradeTax property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedTradeTax().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeTaxType }
     * 
     * 
     * @return
     *     The value of the includedTradeTax property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeTaxType> getIncludedTradeTax() {
        if (includedTradeTax == null) {
            includedTradeTax = new ArrayList<>();
        }
        return this.includedTradeTax;
    }

    /**
     * Gets the value of the deliveryTradeLocation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the deliveryTradeLocation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDeliveryTradeLocation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeLocationType }
     * 
     * 
     * @return
     *     The value of the deliveryTradeLocation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeLocationType> getDeliveryTradeLocation() {
        if (deliveryTradeLocation == null) {
            deliveryTradeLocation = new ArrayList<>();
        }
        return this.deliveryTradeLocation;
    }

    /**
     * Gets the value of the tradeComparisonReferencePrice property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the tradeComparisonReferencePrice property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTradeComparisonReferencePrice().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencePriceType }
     * 
     * 
     * @return
     *     The value of the tradeComparisonReferencePrice property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencePriceType> getTradeComparisonReferencePrice() {
        if (tradeComparisonReferencePrice == null) {
            tradeComparisonReferencePrice = new ArrayList<>();
        }
        return this.tradeComparisonReferencePrice;
    }

    /**
     * Gets the value of the associatedReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the associatedReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssociatedReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the associatedReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getAssociatedReferencedDocument() {
        if (associatedReferencedDocument == null) {
            associatedReferencedDocument = new ArrayList<>();
        }
        return this.associatedReferencedDocument;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradePriceType rhs = ((TradePriceType) o);
        if (!EqualsHelper.equalsCollection(appliedTradeAllowanceCharge, rhs.appliedTradeAllowanceCharge)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(associatedReferencedDocument, rhs.associatedReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(basisQuantity, rhs.basisQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(changeReason, rhs.changeReason)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(chargeAmount, rhs.chargeAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(deliveryTradeLocation, rhs.deliveryTradeLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(includedTradeTax, rhs.includedTradeTax)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumQuantity, rhs.maximumQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumQuantity, rhs.minimumQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(orderUnitConversionFactorNumeric, rhs.orderUnitConversionFactorNumeric)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(tradeComparisonReferencePrice, rhs.tradeComparisonReferencePrice)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(validitySpecifiedPeriod, rhs.validitySpecifiedPeriod)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(appliedTradeAllowanceCharge).append(associatedReferencedDocument).append(basisQuantity).append(changeReason).append(chargeAmount).append(deliveryTradeLocation).append(includedTradeTax).append(maximumQuantity).append(minimumQuantity).append(orderUnitConversionFactorNumeric).append(tradeComparisonReferencePrice).append(typeCode).append(validitySpecifiedPeriod).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("appliedTradeAllowanceCharge", appliedTradeAllowanceCharge).append("associatedReferencedDocument", associatedReferencedDocument).append("basisQuantity", basisQuantity).append("changeReason", changeReason).append("chargeAmount", chargeAmount).append("deliveryTradeLocation", deliveryTradeLocation).append("includedTradeTax", includedTradeTax).append("maximumQuantity", maximumQuantity).append("minimumQuantity", minimumQuantity).append("orderUnitConversionFactorNumeric", orderUnitConversionFactorNumeric).append("tradeComparisonReferencePrice", tradeComparisonReferencePrice).append("typeCode", typeCode).append("validitySpecifiedPeriod", validitySpecifiedPeriod).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setChargeAmount(
        @Nullable
        final List<AmountType> aList) {
        chargeAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setChangeReason(
        @Nullable
        final List<TextType> aList) {
        changeReason = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAppliedTradeAllowanceCharge(
        @Nullable
        final List<TradeAllowanceChargeType> aList) {
        appliedTradeAllowanceCharge = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIncludedTradeTax(
        @Nullable
        final List<TradeTaxType> aList) {
        includedTradeTax = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDeliveryTradeLocation(
        @Nullable
        final List<TradeLocationType> aList) {
        deliveryTradeLocation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTradeComparisonReferencePrice(
        @Nullable
        final List<ReferencePriceType> aList) {
        tradeComparisonReferencePrice = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAssociatedReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        associatedReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasChargeAmountEntries() {
        return (!getChargeAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoChargeAmountEntries() {
        return getChargeAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getChargeAmountCount() {
        return getChargeAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getChargeAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getChargeAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addChargeAmount(
        @Nonnull
        final AmountType elem) {
        getChargeAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasChangeReasonEntries() {
        return (!getChangeReason().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoChangeReasonEntries() {
        return getChangeReason().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getChangeReasonCount() {
        return getChangeReason().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getChangeReasonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getChangeReason().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addChangeReason(
        @Nonnull
        final TextType elem) {
        getChangeReason().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAppliedTradeAllowanceChargeEntries() {
        return (!getAppliedTradeAllowanceCharge().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAppliedTradeAllowanceChargeEntries() {
        return getAppliedTradeAllowanceCharge().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAppliedTradeAllowanceChargeCount() {
        return getAppliedTradeAllowanceCharge().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeAllowanceChargeType getAppliedTradeAllowanceChargeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAppliedTradeAllowanceCharge().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAppliedTradeAllowanceCharge(
        @Nonnull
        final TradeAllowanceChargeType elem) {
        getAppliedTradeAllowanceCharge().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIncludedTradeTaxEntries() {
        return (!getIncludedTradeTax().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIncludedTradeTaxEntries() {
        return getIncludedTradeTax().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIncludedTradeTaxCount() {
        return getIncludedTradeTax().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeTaxType getIncludedTradeTaxAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIncludedTradeTax().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIncludedTradeTax(
        @Nonnull
        final TradeTaxType elem) {
        getIncludedTradeTax().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDeliveryTradeLocationEntries() {
        return (!getDeliveryTradeLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDeliveryTradeLocationEntries() {
        return getDeliveryTradeLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDeliveryTradeLocationCount() {
        return getDeliveryTradeLocation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeLocationType getDeliveryTradeLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDeliveryTradeLocation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDeliveryTradeLocation(
        @Nonnull
        final TradeLocationType elem) {
        getDeliveryTradeLocation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTradeComparisonReferencePriceEntries() {
        return (!getTradeComparisonReferencePrice().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTradeComparisonReferencePriceEntries() {
        return getTradeComparisonReferencePrice().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTradeComparisonReferencePriceCount() {
        return getTradeComparisonReferencePrice().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencePriceType getTradeComparisonReferencePriceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTradeComparisonReferencePrice().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTradeComparisonReferencePrice(
        @Nonnull
        final ReferencePriceType elem) {
        getTradeComparisonReferencePrice().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAssociatedReferencedDocumentEntries() {
        return (!getAssociatedReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAssociatedReferencedDocumentEntries() {
        return getAssociatedReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAssociatedReferencedDocumentCount() {
        return getAssociatedReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getAssociatedReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAssociatedReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAssociatedReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getAssociatedReferencedDocument().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradePriceType ret) {
        if (appliedTradeAllowanceCharge == null) {
            ret.appliedTradeAllowanceCharge = null;
        } else {
            List<TradeAllowanceChargeType> retAppliedTradeAllowanceCharge = new ArrayList<>();
            for (TradeAllowanceChargeType aItem: getAppliedTradeAllowanceCharge()) {
                retAppliedTradeAllowanceCharge.add(((aItem == null)?null:aItem.clone()));
            }
            ret.appliedTradeAllowanceCharge = retAppliedTradeAllowanceCharge;
        }
        if (associatedReferencedDocument == null) {
            ret.associatedReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retAssociatedReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getAssociatedReferencedDocument()) {
                retAssociatedReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.associatedReferencedDocument = retAssociatedReferencedDocument;
        }
        ret.basisQuantity = ((basisQuantity == null)?null:basisQuantity.clone());
        if (changeReason == null) {
            ret.changeReason = null;
        } else {
            List<TextType> retChangeReason = new ArrayList<>();
            for (TextType aItem: getChangeReason()) {
                retChangeReason.add(((aItem == null)?null:aItem.clone()));
            }
            ret.changeReason = retChangeReason;
        }
        if (chargeAmount == null) {
            ret.chargeAmount = null;
        } else {
            List<AmountType> retChargeAmount = new ArrayList<>();
            for (AmountType aItem: getChargeAmount()) {
                retChargeAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.chargeAmount = retChargeAmount;
        }
        if (deliveryTradeLocation == null) {
            ret.deliveryTradeLocation = null;
        } else {
            List<TradeLocationType> retDeliveryTradeLocation = new ArrayList<>();
            for (TradeLocationType aItem: getDeliveryTradeLocation()) {
                retDeliveryTradeLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.deliveryTradeLocation = retDeliveryTradeLocation;
        }
        if (includedTradeTax == null) {
            ret.includedTradeTax = null;
        } else {
            List<TradeTaxType> retIncludedTradeTax = new ArrayList<>();
            for (TradeTaxType aItem: getIncludedTradeTax()) {
                retIncludedTradeTax.add(((aItem == null)?null:aItem.clone()));
            }
            ret.includedTradeTax = retIncludedTradeTax;
        }
        ret.maximumQuantity = ((maximumQuantity == null)?null:maximumQuantity.clone());
        ret.minimumQuantity = ((minimumQuantity == null)?null:minimumQuantity.clone());
        ret.orderUnitConversionFactorNumeric = ((orderUnitConversionFactorNumeric == null)?null:orderUnitConversionFactorNumeric.clone());
        if (tradeComparisonReferencePrice == null) {
            ret.tradeComparisonReferencePrice = null;
        } else {
            List<ReferencePriceType> retTradeComparisonReferencePrice = new ArrayList<>();
            for (ReferencePriceType aItem: getTradeComparisonReferencePrice()) {
                retTradeComparisonReferencePrice.add(((aItem == null)?null:aItem.clone()));
            }
            ret.tradeComparisonReferencePrice = retTradeComparisonReferencePrice;
        }
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        ret.validitySpecifiedPeriod = ((validitySpecifiedPeriod == null)?null:validitySpecifiedPeriod.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradePriceType clone() {
        TradePriceType ret = new TradePriceType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PriceTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public PriceTypeCodeType setTypeCode(
        @Nullable
        final String valueParam) {
        PriceTypeCodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new PriceTypeCodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setBasisQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getBasisQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setBasisQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setMinimumQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getMinimumQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setMinimumQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setMaximumQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getMaximumQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setMaximumQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NumericType and never <code>null</code>
     */
    @Nonnull
    public NumericType setOrderUnitConversionFactorNumeric(
        @Nullable
        final BigDecimal valueParam) {
        NumericType aObj = getOrderUnitConversionFactorNumeric();
        if (aObj == null) {
            aObj = new NumericType(valueParam);
            setOrderUnitConversionFactorNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained PriceTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PriceTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        PriceTypeCodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getBasisQuantityValue() {
        QuantityType aObj = getBasisQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMinimumQuantityValue() {
        QuantityType aObj = getMinimumQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumQuantityValue() {
        QuantityType aObj = getMaximumQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getOrderUnitConversionFactorNumericValue() {
        NumericType aObj = getOrderUnitConversionFactorNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

}
