
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FormattedDateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.MeasureType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for TradeProductType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradeProductType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="GlobalID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="SellerAssignedID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="BuyerAssignedID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="ManufacturerAssignedID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="Name" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TradeName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="NetWeightMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" minOccurs="0"/>
 *         <element name="GrossWeightMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" minOccurs="0"/>
 *         <element name="ProductGroupID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="EndItemTypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="EndItemName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AreaDensityMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" minOccurs="0"/>
 *         <element name="UseDescription" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="BrandName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="SubBrandName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="DrainedNetWeightMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" minOccurs="0"/>
 *         <element name="VariableMeasureIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *         <element name="ColourCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="ColourDescription" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Designation" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="FormattedCancellationAnnouncedLaunchDateTime" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}FormattedDateTimeType" minOccurs="0"/>
 *         <element name="FormattedLatestProductDataChangeDateTime" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}FormattedDateTimeType" minOccurs="0"/>
 *         <element name="ApplicableProductCharacteristic" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ProductCharacteristicType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ApplicableMaterialGoodsCharacteristic" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}MaterialGoodsCharacteristicType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="DesignatedProductClassification" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ProductClassificationType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="IndividualTradeProductInstance" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeProductInstanceType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CertificationEvidenceReferenceReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="InspectionReferenceReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="OriginTradeCountry" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeCountryType" minOccurs="0"/>
 *         <element name="LinearSpatialDimension" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpatialDimensionType" minOccurs="0"/>
 *         <element name="MinimumLinearSpatialDimension" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpatialDimensionType" minOccurs="0"/>
 *         <element name="MaximumLinearSpatialDimension" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpatialDimensionType" minOccurs="0"/>
 *         <element name="ManufacturerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="PresentationSpecifiedBinaryFile" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedBinaryFileType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="MSDSReferenceReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="AdditionalReferenceReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="LegalRightsOwnerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="BrandOwnerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="IncludedReferencedProduct" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedProductType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="InformationNote" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}NoteType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradeProductType", propOrder = {
    "id",
    "globalID",
    "sellerAssignedID",
    "buyerAssignedID",
    "manufacturerAssignedID",
    "name",
    "tradeName",
    "description",
    "typeCode",
    "netWeightMeasure",
    "grossWeightMeasure",
    "productGroupID",
    "endItemTypeCode",
    "endItemName",
    "areaDensityMeasure",
    "useDescription",
    "brandName",
    "subBrandName",
    "drainedNetWeightMeasure",
    "variableMeasureIndicator",
    "colourCode",
    "colourDescription",
    "designation",
    "formattedCancellationAnnouncedLaunchDateTime",
    "formattedLatestProductDataChangeDateTime",
    "applicableProductCharacteristic",
    "applicableMaterialGoodsCharacteristic",
    "designatedProductClassification",
    "individualTradeProductInstance",
    "certificationEvidenceReferenceReferencedDocument",
    "inspectionReferenceReferencedDocument",
    "originTradeCountry",
    "linearSpatialDimension",
    "minimumLinearSpatialDimension",
    "maximumLinearSpatialDimension",
    "manufacturerTradeParty",
    "presentationSpecifiedBinaryFile",
    "msdsReferenceReferencedDocument",
    "additionalReferenceReferencedDocument",
    "legalRightsOwnerTradeParty",
    "brandOwnerTradeParty",
    "includedReferencedProduct",
    "informationNote"
})
@CodingStyleguideUnaware
public class TradeProductType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID")
    private IDType id;
    @XmlElement(name = "GlobalID")
    private IDType globalID;
    @XmlElement(name = "SellerAssignedID")
    private IDType sellerAssignedID;
    @XmlElement(name = "BuyerAssignedID")
    private IDType buyerAssignedID;
    @XmlElement(name = "ManufacturerAssignedID")
    private IDType manufacturerAssignedID;
    @XmlElement(name = "Name")
    private List<TextType> name;
    @XmlElement(name = "TradeName")
    private TextType tradeName;
    @XmlElement(name = "Description")
    private TextType description;
    @XmlElement(name = "TypeCode")
    private CodeType typeCode;
    @XmlElement(name = "NetWeightMeasure")
    private MeasureType netWeightMeasure;
    @XmlElement(name = "GrossWeightMeasure")
    private MeasureType grossWeightMeasure;
    @XmlElement(name = "ProductGroupID")
    private List<IDType> productGroupID;
    @XmlElement(name = "EndItemTypeCode")
    private List<CodeType> endItemTypeCode;
    @XmlElement(name = "EndItemName")
    private List<TextType> endItemName;
    @XmlElement(name = "AreaDensityMeasure")
    private MeasureType areaDensityMeasure;
    @XmlElement(name = "UseDescription")
    private List<TextType> useDescription;
    @XmlElement(name = "BrandName")
    private TextType brandName;
    @XmlElement(name = "SubBrandName")
    private TextType subBrandName;
    @XmlElement(name = "DrainedNetWeightMeasure")
    private MeasureType drainedNetWeightMeasure;
    @XmlElement(name = "VariableMeasureIndicator")
    private IndicatorType variableMeasureIndicator;
    @XmlElement(name = "ColourCode")
    private CodeType colourCode;
    @XmlElement(name = "ColourDescription")
    private List<TextType> colourDescription;
    @XmlElement(name = "Designation")
    private List<TextType> designation;
    @XmlElement(name = "FormattedCancellationAnnouncedLaunchDateTime")
    private FormattedDateTimeType formattedCancellationAnnouncedLaunchDateTime;
    @XmlElement(name = "FormattedLatestProductDataChangeDateTime")
    private FormattedDateTimeType formattedLatestProductDataChangeDateTime;
    @XmlElement(name = "ApplicableProductCharacteristic")
    private List<ProductCharacteristicType> applicableProductCharacteristic;
    @XmlElement(name = "ApplicableMaterialGoodsCharacteristic")
    private List<MaterialGoodsCharacteristicType> applicableMaterialGoodsCharacteristic;
    @XmlElement(name = "DesignatedProductClassification")
    private List<ProductClassificationType> designatedProductClassification;
    @XmlElement(name = "IndividualTradeProductInstance")
    private List<TradeProductInstanceType> individualTradeProductInstance;
    @XmlElement(name = "CertificationEvidenceReferenceReferencedDocument")
    private List<ReferencedDocumentType> certificationEvidenceReferenceReferencedDocument;
    @XmlElement(name = "InspectionReferenceReferencedDocument")
    private List<ReferencedDocumentType> inspectionReferenceReferencedDocument;
    @XmlElement(name = "OriginTradeCountry")
    private TradeCountryType originTradeCountry;
    @XmlElement(name = "LinearSpatialDimension")
    private SpatialDimensionType linearSpatialDimension;
    @XmlElement(name = "MinimumLinearSpatialDimension")
    private SpatialDimensionType minimumLinearSpatialDimension;
    @XmlElement(name = "MaximumLinearSpatialDimension")
    private SpatialDimensionType maximumLinearSpatialDimension;
    @XmlElement(name = "ManufacturerTradeParty")
    private TradePartyType manufacturerTradeParty;
    @XmlElement(name = "PresentationSpecifiedBinaryFile")
    private List<SpecifiedBinaryFileType> presentationSpecifiedBinaryFile;
    @XmlElement(name = "MSDSReferenceReferencedDocument")
    private ReferencedDocumentType msdsReferenceReferencedDocument;
    @XmlElement(name = "AdditionalReferenceReferencedDocument")
    private List<ReferencedDocumentType> additionalReferenceReferencedDocument;
    @XmlElement(name = "LegalRightsOwnerTradeParty")
    private TradePartyType legalRightsOwnerTradeParty;
    @XmlElement(name = "BrandOwnerTradeParty")
    private TradePartyType brandOwnerTradeParty;
    @XmlElement(name = "IncludedReferencedProduct")
    private List<ReferencedProductType> includedReferencedProduct;
    @XmlElement(name = "InformationNote")
    private List<NoteType> informationNote;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradeProductType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the globalID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getGlobalID() {
        return globalID;
    }

    /**
     * Sets the value of the globalID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setGlobalID(
        @Nullable
        IDType value) {
        this.globalID = value;
    }

    /**
     * Gets the value of the sellerAssignedID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getSellerAssignedID() {
        return sellerAssignedID;
    }

    /**
     * Sets the value of the sellerAssignedID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setSellerAssignedID(
        @Nullable
        IDType value) {
        this.sellerAssignedID = value;
    }

    /**
     * Gets the value of the buyerAssignedID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getBuyerAssignedID() {
        return buyerAssignedID;
    }

    /**
     * Sets the value of the buyerAssignedID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setBuyerAssignedID(
        @Nullable
        IDType value) {
        this.buyerAssignedID = value;
    }

    /**
     * Gets the value of the manufacturerAssignedID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getManufacturerAssignedID() {
        return manufacturerAssignedID;
    }

    /**
     * Sets the value of the manufacturerAssignedID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setManufacturerAssignedID(
        @Nullable
        IDType value) {
        this.manufacturerAssignedID = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the name property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the name property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getName() {
        if (name == null) {
            name = new ArrayList<>();
        }
        return this.name;
    }

    /**
     * Gets the value of the tradeName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getTradeName() {
        return tradeName;
    }

    /**
     * Sets the value of the tradeName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setTradeName(
        @Nullable
        TextType value) {
        this.tradeName = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setDescription(
        @Nullable
        TextType value) {
        this.description = value;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        CodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the netWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MeasureType }
     *     
     */
    @Nullable
    public MeasureType getNetWeightMeasure() {
        return netWeightMeasure;
    }

    /**
     * Sets the value of the netWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeasureType }
     *     
     */
    public void setNetWeightMeasure(
        @Nullable
        MeasureType value) {
        this.netWeightMeasure = value;
    }

    /**
     * Gets the value of the grossWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MeasureType }
     *     
     */
    @Nullable
    public MeasureType getGrossWeightMeasure() {
        return grossWeightMeasure;
    }

    /**
     * Sets the value of the grossWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeasureType }
     *     
     */
    public void setGrossWeightMeasure(
        @Nullable
        MeasureType value) {
        this.grossWeightMeasure = value;
    }

    /**
     * Gets the value of the productGroupID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the productGroupID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProductGroupID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     * @return
     *     The value of the productGroupID property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getProductGroupID() {
        if (productGroupID == null) {
            productGroupID = new ArrayList<>();
        }
        return this.productGroupID;
    }

    /**
     * Gets the value of the endItemTypeCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the endItemTypeCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEndItemTypeCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the endItemTypeCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getEndItemTypeCode() {
        if (endItemTypeCode == null) {
            endItemTypeCode = new ArrayList<>();
        }
        return this.endItemTypeCode;
    }

    /**
     * Gets the value of the endItemName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the endItemName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEndItemName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the endItemName property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getEndItemName() {
        if (endItemName == null) {
            endItemName = new ArrayList<>();
        }
        return this.endItemName;
    }

    /**
     * Gets the value of the areaDensityMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MeasureType }
     *     
     */
    @Nullable
    public MeasureType getAreaDensityMeasure() {
        return areaDensityMeasure;
    }

    /**
     * Sets the value of the areaDensityMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeasureType }
     *     
     */
    public void setAreaDensityMeasure(
        @Nullable
        MeasureType value) {
        this.areaDensityMeasure = value;
    }

    /**
     * Gets the value of the useDescription property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the useDescription property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUseDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the useDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getUseDescription() {
        if (useDescription == null) {
            useDescription = new ArrayList<>();
        }
        return this.useDescription;
    }

    /**
     * Gets the value of the brandName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getBrandName() {
        return brandName;
    }

    /**
     * Sets the value of the brandName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setBrandName(
        @Nullable
        TextType value) {
        this.brandName = value;
    }

    /**
     * Gets the value of the subBrandName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getSubBrandName() {
        return subBrandName;
    }

    /**
     * Sets the value of the subBrandName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setSubBrandName(
        @Nullable
        TextType value) {
        this.subBrandName = value;
    }

    /**
     * Gets the value of the drainedNetWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MeasureType }
     *     
     */
    @Nullable
    public MeasureType getDrainedNetWeightMeasure() {
        return drainedNetWeightMeasure;
    }

    /**
     * Sets the value of the drainedNetWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeasureType }
     *     
     */
    public void setDrainedNetWeightMeasure(
        @Nullable
        MeasureType value) {
        this.drainedNetWeightMeasure = value;
    }

    /**
     * Gets the value of the variableMeasureIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getVariableMeasureIndicator() {
        return variableMeasureIndicator;
    }

    /**
     * Sets the value of the variableMeasureIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setVariableMeasureIndicator(
        @Nullable
        IndicatorType value) {
        this.variableMeasureIndicator = value;
    }

    /**
     * Gets the value of the colourCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getColourCode() {
        return colourCode;
    }

    /**
     * Sets the value of the colourCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setColourCode(
        @Nullable
        CodeType value) {
        this.colourCode = value;
    }

    /**
     * Gets the value of the colourDescription property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the colourDescription property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getColourDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the colourDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getColourDescription() {
        if (colourDescription == null) {
            colourDescription = new ArrayList<>();
        }
        return this.colourDescription;
    }

    /**
     * Gets the value of the designation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the designation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDesignation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the designation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getDesignation() {
        if (designation == null) {
            designation = new ArrayList<>();
        }
        return this.designation;
    }

    /**
     * Gets the value of the formattedCancellationAnnouncedLaunchDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link FormattedDateTimeType }
     *     
     */
    @Nullable
    public FormattedDateTimeType getFormattedCancellationAnnouncedLaunchDateTime() {
        return formattedCancellationAnnouncedLaunchDateTime;
    }

    /**
     * Sets the value of the formattedCancellationAnnouncedLaunchDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormattedDateTimeType }
     *     
     */
    public void setFormattedCancellationAnnouncedLaunchDateTime(
        @Nullable
        FormattedDateTimeType value) {
        this.formattedCancellationAnnouncedLaunchDateTime = value;
    }

    /**
     * Gets the value of the formattedLatestProductDataChangeDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link FormattedDateTimeType }
     *     
     */
    @Nullable
    public FormattedDateTimeType getFormattedLatestProductDataChangeDateTime() {
        return formattedLatestProductDataChangeDateTime;
    }

    /**
     * Sets the value of the formattedLatestProductDataChangeDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormattedDateTimeType }
     *     
     */
    public void setFormattedLatestProductDataChangeDateTime(
        @Nullable
        FormattedDateTimeType value) {
        this.formattedLatestProductDataChangeDateTime = value;
    }

    /**
     * Gets the value of the applicableProductCharacteristic property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the applicableProductCharacteristic property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getApplicableProductCharacteristic().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProductCharacteristicType }
     * 
     * 
     * @return
     *     The value of the applicableProductCharacteristic property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ProductCharacteristicType> getApplicableProductCharacteristic() {
        if (applicableProductCharacteristic == null) {
            applicableProductCharacteristic = new ArrayList<>();
        }
        return this.applicableProductCharacteristic;
    }

    /**
     * Gets the value of the applicableMaterialGoodsCharacteristic property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the applicableMaterialGoodsCharacteristic property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getApplicableMaterialGoodsCharacteristic().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MaterialGoodsCharacteristicType }
     * 
     * 
     * @return
     *     The value of the applicableMaterialGoodsCharacteristic property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<MaterialGoodsCharacteristicType> getApplicableMaterialGoodsCharacteristic() {
        if (applicableMaterialGoodsCharacteristic == null) {
            applicableMaterialGoodsCharacteristic = new ArrayList<>();
        }
        return this.applicableMaterialGoodsCharacteristic;
    }

    /**
     * Gets the value of the designatedProductClassification property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the designatedProductClassification property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDesignatedProductClassification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProductClassificationType }
     * 
     * 
     * @return
     *     The value of the designatedProductClassification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ProductClassificationType> getDesignatedProductClassification() {
        if (designatedProductClassification == null) {
            designatedProductClassification = new ArrayList<>();
        }
        return this.designatedProductClassification;
    }

    /**
     * Gets the value of the individualTradeProductInstance property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the individualTradeProductInstance property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIndividualTradeProductInstance().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeProductInstanceType }
     * 
     * 
     * @return
     *     The value of the individualTradeProductInstance property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeProductInstanceType> getIndividualTradeProductInstance() {
        if (individualTradeProductInstance == null) {
            individualTradeProductInstance = new ArrayList<>();
        }
        return this.individualTradeProductInstance;
    }

    /**
     * Gets the value of the certificationEvidenceReferenceReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the certificationEvidenceReferenceReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCertificationEvidenceReferenceReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the certificationEvidenceReferenceReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getCertificationEvidenceReferenceReferencedDocument() {
        if (certificationEvidenceReferenceReferencedDocument == null) {
            certificationEvidenceReferenceReferencedDocument = new ArrayList<>();
        }
        return this.certificationEvidenceReferenceReferencedDocument;
    }

    /**
     * Gets the value of the inspectionReferenceReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the inspectionReferenceReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInspectionReferenceReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the inspectionReferenceReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getInspectionReferenceReferencedDocument() {
        if (inspectionReferenceReferencedDocument == null) {
            inspectionReferenceReferencedDocument = new ArrayList<>();
        }
        return this.inspectionReferenceReferencedDocument;
    }

    /**
     * Gets the value of the originTradeCountry property.
     * 
     * @return
     *     possible object is
     *     {@link TradeCountryType }
     *     
     */
    @Nullable
    public TradeCountryType getOriginTradeCountry() {
        return originTradeCountry;
    }

    /**
     * Sets the value of the originTradeCountry property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeCountryType }
     *     
     */
    public void setOriginTradeCountry(
        @Nullable
        TradeCountryType value) {
        this.originTradeCountry = value;
    }

    /**
     * Gets the value of the linearSpatialDimension property.
     * 
     * @return
     *     possible object is
     *     {@link SpatialDimensionType }
     *     
     */
    @Nullable
    public SpatialDimensionType getLinearSpatialDimension() {
        return linearSpatialDimension;
    }

    /**
     * Sets the value of the linearSpatialDimension property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpatialDimensionType }
     *     
     */
    public void setLinearSpatialDimension(
        @Nullable
        SpatialDimensionType value) {
        this.linearSpatialDimension = value;
    }

    /**
     * Gets the value of the minimumLinearSpatialDimension property.
     * 
     * @return
     *     possible object is
     *     {@link SpatialDimensionType }
     *     
     */
    @Nullable
    public SpatialDimensionType getMinimumLinearSpatialDimension() {
        return minimumLinearSpatialDimension;
    }

    /**
     * Sets the value of the minimumLinearSpatialDimension property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpatialDimensionType }
     *     
     */
    public void setMinimumLinearSpatialDimension(
        @Nullable
        SpatialDimensionType value) {
        this.minimumLinearSpatialDimension = value;
    }

    /**
     * Gets the value of the maximumLinearSpatialDimension property.
     * 
     * @return
     *     possible object is
     *     {@link SpatialDimensionType }
     *     
     */
    @Nullable
    public SpatialDimensionType getMaximumLinearSpatialDimension() {
        return maximumLinearSpatialDimension;
    }

    /**
     * Sets the value of the maximumLinearSpatialDimension property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpatialDimensionType }
     *     
     */
    public void setMaximumLinearSpatialDimension(
        @Nullable
        SpatialDimensionType value) {
        this.maximumLinearSpatialDimension = value;
    }

    /**
     * Gets the value of the manufacturerTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getManufacturerTradeParty() {
        return manufacturerTradeParty;
    }

    /**
     * Sets the value of the manufacturerTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setManufacturerTradeParty(
        @Nullable
        TradePartyType value) {
        this.manufacturerTradeParty = value;
    }

    /**
     * Gets the value of the presentationSpecifiedBinaryFile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the presentationSpecifiedBinaryFile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPresentationSpecifiedBinaryFile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpecifiedBinaryFileType }
     * 
     * 
     * @return
     *     The value of the presentationSpecifiedBinaryFile property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SpecifiedBinaryFileType> getPresentationSpecifiedBinaryFile() {
        if (presentationSpecifiedBinaryFile == null) {
            presentationSpecifiedBinaryFile = new ArrayList<>();
        }
        return this.presentationSpecifiedBinaryFile;
    }

    /**
     * Gets the value of the msdsReferenceReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getMSDSReferenceReferencedDocument() {
        return msdsReferenceReferencedDocument;
    }

    /**
     * Sets the value of the msdsReferenceReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setMSDSReferenceReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.msdsReferenceReferencedDocument = value;
    }

    /**
     * Gets the value of the additionalReferenceReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the additionalReferenceReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAdditionalReferenceReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the additionalReferenceReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getAdditionalReferenceReferencedDocument() {
        if (additionalReferenceReferencedDocument == null) {
            additionalReferenceReferencedDocument = new ArrayList<>();
        }
        return this.additionalReferenceReferencedDocument;
    }

    /**
     * Gets the value of the legalRightsOwnerTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getLegalRightsOwnerTradeParty() {
        return legalRightsOwnerTradeParty;
    }

    /**
     * Sets the value of the legalRightsOwnerTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setLegalRightsOwnerTradeParty(
        @Nullable
        TradePartyType value) {
        this.legalRightsOwnerTradeParty = value;
    }

    /**
     * Gets the value of the brandOwnerTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getBrandOwnerTradeParty() {
        return brandOwnerTradeParty;
    }

    /**
     * Sets the value of the brandOwnerTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setBrandOwnerTradeParty(
        @Nullable
        TradePartyType value) {
        this.brandOwnerTradeParty = value;
    }

    /**
     * Gets the value of the includedReferencedProduct property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the includedReferencedProduct property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedReferencedProduct().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedProductType }
     * 
     * 
     * @return
     *     The value of the includedReferencedProduct property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedProductType> getIncludedReferencedProduct() {
        if (includedReferencedProduct == null) {
            includedReferencedProduct = new ArrayList<>();
        }
        return this.includedReferencedProduct;
    }

    /**
     * Gets the value of the informationNote property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the informationNote property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInformationNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     * @return
     *     The value of the informationNote property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getInformationNote() {
        if (informationNote == null) {
            informationNote = new ArrayList<>();
        }
        return this.informationNote;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradeProductType rhs = ((TradeProductType) o);
        if (!EqualsHelper.equalsCollection(additionalReferenceReferencedDocument, rhs.additionalReferenceReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(applicableMaterialGoodsCharacteristic, rhs.applicableMaterialGoodsCharacteristic)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(applicableProductCharacteristic, rhs.applicableProductCharacteristic)) {
            return false;
        }
        if (!EqualsHelper.equals(areaDensityMeasure, rhs.areaDensityMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(brandName, rhs.brandName)) {
            return false;
        }
        if (!EqualsHelper.equals(brandOwnerTradeParty, rhs.brandOwnerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerAssignedID, rhs.buyerAssignedID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(certificationEvidenceReferenceReferencedDocument, rhs.certificationEvidenceReferenceReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(colourCode, rhs.colourCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(colourDescription, rhs.colourDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(designatedProductClassification, rhs.designatedProductClassification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(designation, rhs.designation)) {
            return false;
        }
        if (!EqualsHelper.equals(drainedNetWeightMeasure, rhs.drainedNetWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(endItemName, rhs.endItemName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(endItemTypeCode, rhs.endItemTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(formattedCancellationAnnouncedLaunchDateTime, rhs.formattedCancellationAnnouncedLaunchDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(formattedLatestProductDataChangeDateTime, rhs.formattedLatestProductDataChangeDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(globalID, rhs.globalID)) {
            return false;
        }
        if (!EqualsHelper.equals(grossWeightMeasure, rhs.grossWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(includedReferencedProduct, rhs.includedReferencedProduct)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(individualTradeProductInstance, rhs.individualTradeProductInstance)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(informationNote, rhs.informationNote)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(inspectionReferenceReferencedDocument, rhs.inspectionReferenceReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(legalRightsOwnerTradeParty, rhs.legalRightsOwnerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(linearSpatialDimension, rhs.linearSpatialDimension)) {
            return false;
        }
        if (!EqualsHelper.equals(manufacturerAssignedID, rhs.manufacturerAssignedID)) {
            return false;
        }
        if (!EqualsHelper.equals(manufacturerTradeParty, rhs.manufacturerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumLinearSpatialDimension, rhs.maximumLinearSpatialDimension)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumLinearSpatialDimension, rhs.minimumLinearSpatialDimension)) {
            return false;
        }
        if (!EqualsHelper.equals(msdsReferenceReferencedDocument, rhs.msdsReferenceReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equals(netWeightMeasure, rhs.netWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(originTradeCountry, rhs.originTradeCountry)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(presentationSpecifiedBinaryFile, rhs.presentationSpecifiedBinaryFile)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(productGroupID, rhs.productGroupID)) {
            return false;
        }
        if (!EqualsHelper.equals(sellerAssignedID, rhs.sellerAssignedID)) {
            return false;
        }
        if (!EqualsHelper.equals(subBrandName, rhs.subBrandName)) {
            return false;
        }
        if (!EqualsHelper.equals(tradeName, rhs.tradeName)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(useDescription, rhs.useDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(variableMeasureIndicator, rhs.variableMeasureIndicator)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalReferenceReferencedDocument).append(applicableMaterialGoodsCharacteristic).append(applicableProductCharacteristic).append(areaDensityMeasure).append(brandName).append(brandOwnerTradeParty).append(buyerAssignedID).append(certificationEvidenceReferenceReferencedDocument).append(colourCode).append(colourDescription).append(description).append(designatedProductClassification).append(designation).append(drainedNetWeightMeasure).append(endItemName).append(endItemTypeCode).append(formattedCancellationAnnouncedLaunchDateTime).append(formattedLatestProductDataChangeDateTime).append(globalID).append(grossWeightMeasure).append(id).append(includedReferencedProduct).append(individualTradeProductInstance).append(informationNote).append(inspectionReferenceReferencedDocument).append(legalRightsOwnerTradeParty).append(linearSpatialDimension).append(manufacturerAssignedID).append(manufacturerTradeParty).append(maximumLinearSpatialDimension).append(minimumLinearSpatialDimension).append(msdsReferenceReferencedDocument).append(name).append(netWeightMeasure).append(originTradeCountry).append(presentationSpecifiedBinaryFile).append(productGroupID).append(sellerAssignedID).append(subBrandName).append(tradeName).append(typeCode).append(useDescription).append(variableMeasureIndicator).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalReferenceReferencedDocument", additionalReferenceReferencedDocument).append("applicableMaterialGoodsCharacteristic", applicableMaterialGoodsCharacteristic).append("applicableProductCharacteristic", applicableProductCharacteristic).append("areaDensityMeasure", areaDensityMeasure).append("brandName", brandName).append("brandOwnerTradeParty", brandOwnerTradeParty).append("buyerAssignedID", buyerAssignedID).append("certificationEvidenceReferenceReferencedDocument", certificationEvidenceReferenceReferencedDocument).append("colourCode", colourCode).append("colourDescription", colourDescription).append("description", description).append("designatedProductClassification", designatedProductClassification).append("designation", designation).append("drainedNetWeightMeasure", drainedNetWeightMeasure).append("endItemName", endItemName).append("endItemTypeCode", endItemTypeCode).append("formattedCancellationAnnouncedLaunchDateTime", formattedCancellationAnnouncedLaunchDateTime).append("formattedLatestProductDataChangeDateTime", formattedLatestProductDataChangeDateTime).append("globalID", globalID).append("grossWeightMeasure", grossWeightMeasure).append("id", id).append("includedReferencedProduct", includedReferencedProduct).append("individualTradeProductInstance", individualTradeProductInstance).append("informationNote", informationNote).append("inspectionReferenceReferencedDocument", inspectionReferenceReferencedDocument).append("legalRightsOwnerTradeParty", legalRightsOwnerTradeParty).append("linearSpatialDimension", linearSpatialDimension).append("manufacturerAssignedID", manufacturerAssignedID).append("manufacturerTradeParty", manufacturerTradeParty).append("maximumLinearSpatialDimension", maximumLinearSpatialDimension).append("minimumLinearSpatialDimension", minimumLinearSpatialDimension).append("msdsReferenceReferencedDocument", msdsReferenceReferencedDocument).append("name", name).append("netWeightMeasure", netWeightMeasure).append("originTradeCountry", originTradeCountry).append("presentationSpecifiedBinaryFile", presentationSpecifiedBinaryFile).append("productGroupID", productGroupID).append("sellerAssignedID", sellerAssignedID).append("subBrandName", subBrandName).append("tradeName", tradeName).append("typeCode", typeCode).append("useDescription", useDescription).append("variableMeasureIndicator", variableMeasureIndicator).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setName(
        @Nullable
        final List<TextType> aList) {
        name = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProductGroupID(
        @Nullable
        final List<IDType> aList) {
        productGroupID = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEndItemTypeCode(
        @Nullable
        final List<CodeType> aList) {
        endItemTypeCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEndItemName(
        @Nullable
        final List<TextType> aList) {
        endItemName = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUseDescription(
        @Nullable
        final List<TextType> aList) {
        useDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setColourDescription(
        @Nullable
        final List<TextType> aList) {
        colourDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDesignation(
        @Nullable
        final List<TextType> aList) {
        designation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setApplicableProductCharacteristic(
        @Nullable
        final List<ProductCharacteristicType> aList) {
        applicableProductCharacteristic = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setApplicableMaterialGoodsCharacteristic(
        @Nullable
        final List<MaterialGoodsCharacteristicType> aList) {
        applicableMaterialGoodsCharacteristic = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDesignatedProductClassification(
        @Nullable
        final List<ProductClassificationType> aList) {
        designatedProductClassification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIndividualTradeProductInstance(
        @Nullable
        final List<TradeProductInstanceType> aList) {
        individualTradeProductInstance = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCertificationEvidenceReferenceReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        certificationEvidenceReferenceReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInspectionReferenceReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        inspectionReferenceReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPresentationSpecifiedBinaryFile(
        @Nullable
        final List<SpecifiedBinaryFileType> aList) {
        presentationSpecifiedBinaryFile = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalReferenceReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        additionalReferenceReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIncludedReferencedProduct(
        @Nullable
        final List<ReferencedProductType> aList) {
        includedReferencedProduct = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInformationNote(
        @Nullable
        final List<NoteType> aList) {
        informationNote = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNameEntries() {
        return (!getName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNameEntries() {
        return getName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNameCount() {
        return getName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addName(
        @Nonnull
        final TextType elem) {
        getName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProductGroupIDEntries() {
        return (!getProductGroupID().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProductGroupIDEntries() {
        return getProductGroupID().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProductGroupIDCount() {
        return getProductGroupID().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getProductGroupIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProductGroupID().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProductGroupID(
        @Nonnull
        final IDType elem) {
        getProductGroupID().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEndItemTypeCodeEntries() {
        return (!getEndItemTypeCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEndItemTypeCodeEntries() {
        return getEndItemTypeCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEndItemTypeCodeCount() {
        return getEndItemTypeCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getEndItemTypeCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEndItemTypeCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEndItemTypeCode(
        @Nonnull
        final CodeType elem) {
        getEndItemTypeCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEndItemNameEntries() {
        return (!getEndItemName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEndItemNameEntries() {
        return getEndItemName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEndItemNameCount() {
        return getEndItemName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getEndItemNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEndItemName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEndItemName(
        @Nonnull
        final TextType elem) {
        getEndItemName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUseDescriptionEntries() {
        return (!getUseDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUseDescriptionEntries() {
        return getUseDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUseDescriptionCount() {
        return getUseDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getUseDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUseDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUseDescription(
        @Nonnull
        final TextType elem) {
        getUseDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasColourDescriptionEntries() {
        return (!getColourDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoColourDescriptionEntries() {
        return getColourDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getColourDescriptionCount() {
        return getColourDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getColourDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getColourDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addColourDescription(
        @Nonnull
        final TextType elem) {
        getColourDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDesignationEntries() {
        return (!getDesignation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDesignationEntries() {
        return getDesignation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDesignationCount() {
        return getDesignation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getDesignationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDesignation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDesignation(
        @Nonnull
        final TextType elem) {
        getDesignation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasApplicableProductCharacteristicEntries() {
        return (!getApplicableProductCharacteristic().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoApplicableProductCharacteristicEntries() {
        return getApplicableProductCharacteristic().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getApplicableProductCharacteristicCount() {
        return getApplicableProductCharacteristic().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ProductCharacteristicType getApplicableProductCharacteristicAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getApplicableProductCharacteristic().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addApplicableProductCharacteristic(
        @Nonnull
        final ProductCharacteristicType elem) {
        getApplicableProductCharacteristic().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasApplicableMaterialGoodsCharacteristicEntries() {
        return (!getApplicableMaterialGoodsCharacteristic().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoApplicableMaterialGoodsCharacteristicEntries() {
        return getApplicableMaterialGoodsCharacteristic().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getApplicableMaterialGoodsCharacteristicCount() {
        return getApplicableMaterialGoodsCharacteristic().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public MaterialGoodsCharacteristicType getApplicableMaterialGoodsCharacteristicAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getApplicableMaterialGoodsCharacteristic().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addApplicableMaterialGoodsCharacteristic(
        @Nonnull
        final MaterialGoodsCharacteristicType elem) {
        getApplicableMaterialGoodsCharacteristic().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDesignatedProductClassificationEntries() {
        return (!getDesignatedProductClassification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDesignatedProductClassificationEntries() {
        return getDesignatedProductClassification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDesignatedProductClassificationCount() {
        return getDesignatedProductClassification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ProductClassificationType getDesignatedProductClassificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDesignatedProductClassification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDesignatedProductClassification(
        @Nonnull
        final ProductClassificationType elem) {
        getDesignatedProductClassification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIndividualTradeProductInstanceEntries() {
        return (!getIndividualTradeProductInstance().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIndividualTradeProductInstanceEntries() {
        return getIndividualTradeProductInstance().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIndividualTradeProductInstanceCount() {
        return getIndividualTradeProductInstance().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeProductInstanceType getIndividualTradeProductInstanceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIndividualTradeProductInstance().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIndividualTradeProductInstance(
        @Nonnull
        final TradeProductInstanceType elem) {
        getIndividualTradeProductInstance().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCertificationEvidenceReferenceReferencedDocumentEntries() {
        return (!getCertificationEvidenceReferenceReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCertificationEvidenceReferenceReferencedDocumentEntries() {
        return getCertificationEvidenceReferenceReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCertificationEvidenceReferenceReferencedDocumentCount() {
        return getCertificationEvidenceReferenceReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getCertificationEvidenceReferenceReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCertificationEvidenceReferenceReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCertificationEvidenceReferenceReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getCertificationEvidenceReferenceReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInspectionReferenceReferencedDocumentEntries() {
        return (!getInspectionReferenceReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInspectionReferenceReferencedDocumentEntries() {
        return getInspectionReferenceReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInspectionReferenceReferencedDocumentCount() {
        return getInspectionReferenceReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getInspectionReferenceReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInspectionReferenceReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInspectionReferenceReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getInspectionReferenceReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPresentationSpecifiedBinaryFileEntries() {
        return (!getPresentationSpecifiedBinaryFile().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPresentationSpecifiedBinaryFileEntries() {
        return getPresentationSpecifiedBinaryFile().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPresentationSpecifiedBinaryFileCount() {
        return getPresentationSpecifiedBinaryFile().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SpecifiedBinaryFileType getPresentationSpecifiedBinaryFileAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPresentationSpecifiedBinaryFile().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPresentationSpecifiedBinaryFile(
        @Nonnull
        final SpecifiedBinaryFileType elem) {
        getPresentationSpecifiedBinaryFile().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalReferenceReferencedDocumentEntries() {
        return (!getAdditionalReferenceReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalReferenceReferencedDocumentEntries() {
        return getAdditionalReferenceReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalReferenceReferencedDocumentCount() {
        return getAdditionalReferenceReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getAdditionalReferenceReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalReferenceReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalReferenceReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getAdditionalReferenceReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIncludedReferencedProductEntries() {
        return (!getIncludedReferencedProduct().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIncludedReferencedProductEntries() {
        return getIncludedReferencedProduct().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIncludedReferencedProductCount() {
        return getIncludedReferencedProduct().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedProductType getIncludedReferencedProductAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIncludedReferencedProduct().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIncludedReferencedProduct(
        @Nonnull
        final ReferencedProductType elem) {
        getIncludedReferencedProduct().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInformationNoteEntries() {
        return (!getInformationNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInformationNoteEntries() {
        return getInformationNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInformationNoteCount() {
        return getInformationNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getInformationNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInformationNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInformationNote(
        @Nonnull
        final NoteType elem) {
        getInformationNote().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradeProductType ret) {
        if (additionalReferenceReferencedDocument == null) {
            ret.additionalReferenceReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retAdditionalReferenceReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getAdditionalReferenceReferencedDocument()) {
                retAdditionalReferenceReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalReferenceReferencedDocument = retAdditionalReferenceReferencedDocument;
        }
        if (applicableMaterialGoodsCharacteristic == null) {
            ret.applicableMaterialGoodsCharacteristic = null;
        } else {
            List<MaterialGoodsCharacteristicType> retApplicableMaterialGoodsCharacteristic = new ArrayList<>();
            for (MaterialGoodsCharacteristicType aItem: getApplicableMaterialGoodsCharacteristic()) {
                retApplicableMaterialGoodsCharacteristic.add(((aItem == null)?null:aItem.clone()));
            }
            ret.applicableMaterialGoodsCharacteristic = retApplicableMaterialGoodsCharacteristic;
        }
        if (applicableProductCharacteristic == null) {
            ret.applicableProductCharacteristic = null;
        } else {
            List<ProductCharacteristicType> retApplicableProductCharacteristic = new ArrayList<>();
            for (ProductCharacteristicType aItem: getApplicableProductCharacteristic()) {
                retApplicableProductCharacteristic.add(((aItem == null)?null:aItem.clone()));
            }
            ret.applicableProductCharacteristic = retApplicableProductCharacteristic;
        }
        ret.areaDensityMeasure = ((areaDensityMeasure == null)?null:areaDensityMeasure.clone());
        ret.brandName = ((brandName == null)?null:brandName.clone());
        ret.brandOwnerTradeParty = ((brandOwnerTradeParty == null)?null:brandOwnerTradeParty.clone());
        ret.buyerAssignedID = ((buyerAssignedID == null)?null:buyerAssignedID.clone());
        if (certificationEvidenceReferenceReferencedDocument == null) {
            ret.certificationEvidenceReferenceReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retCertificationEvidenceReferenceReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getCertificationEvidenceReferenceReferencedDocument()) {
                retCertificationEvidenceReferenceReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.certificationEvidenceReferenceReferencedDocument = retCertificationEvidenceReferenceReferencedDocument;
        }
        ret.colourCode = ((colourCode == null)?null:colourCode.clone());
        if (colourDescription == null) {
            ret.colourDescription = null;
        } else {
            List<TextType> retColourDescription = new ArrayList<>();
            for (TextType aItem: getColourDescription()) {
                retColourDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.colourDescription = retColourDescription;
        }
        ret.description = ((description == null)?null:description.clone());
        if (designatedProductClassification == null) {
            ret.designatedProductClassification = null;
        } else {
            List<ProductClassificationType> retDesignatedProductClassification = new ArrayList<>();
            for (ProductClassificationType aItem: getDesignatedProductClassification()) {
                retDesignatedProductClassification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.designatedProductClassification = retDesignatedProductClassification;
        }
        if (designation == null) {
            ret.designation = null;
        } else {
            List<TextType> retDesignation = new ArrayList<>();
            for (TextType aItem: getDesignation()) {
                retDesignation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.designation = retDesignation;
        }
        ret.drainedNetWeightMeasure = ((drainedNetWeightMeasure == null)?null:drainedNetWeightMeasure.clone());
        if (endItemName == null) {
            ret.endItemName = null;
        } else {
            List<TextType> retEndItemName = new ArrayList<>();
            for (TextType aItem: getEndItemName()) {
                retEndItemName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.endItemName = retEndItemName;
        }
        if (endItemTypeCode == null) {
            ret.endItemTypeCode = null;
        } else {
            List<CodeType> retEndItemTypeCode = new ArrayList<>();
            for (CodeType aItem: getEndItemTypeCode()) {
                retEndItemTypeCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.endItemTypeCode = retEndItemTypeCode;
        }
        ret.formattedCancellationAnnouncedLaunchDateTime = ((formattedCancellationAnnouncedLaunchDateTime == null)?null:formattedCancellationAnnouncedLaunchDateTime.clone());
        ret.formattedLatestProductDataChangeDateTime = ((formattedLatestProductDataChangeDateTime == null)?null:formattedLatestProductDataChangeDateTime.clone());
        ret.globalID = ((globalID == null)?null:globalID.clone());
        ret.grossWeightMeasure = ((grossWeightMeasure == null)?null:grossWeightMeasure.clone());
        ret.id = ((id == null)?null:id.clone());
        if (includedReferencedProduct == null) {
            ret.includedReferencedProduct = null;
        } else {
            List<ReferencedProductType> retIncludedReferencedProduct = new ArrayList<>();
            for (ReferencedProductType aItem: getIncludedReferencedProduct()) {
                retIncludedReferencedProduct.add(((aItem == null)?null:aItem.clone()));
            }
            ret.includedReferencedProduct = retIncludedReferencedProduct;
        }
        if (individualTradeProductInstance == null) {
            ret.individualTradeProductInstance = null;
        } else {
            List<TradeProductInstanceType> retIndividualTradeProductInstance = new ArrayList<>();
            for (TradeProductInstanceType aItem: getIndividualTradeProductInstance()) {
                retIndividualTradeProductInstance.add(((aItem == null)?null:aItem.clone()));
            }
            ret.individualTradeProductInstance = retIndividualTradeProductInstance;
        }
        if (informationNote == null) {
            ret.informationNote = null;
        } else {
            List<NoteType> retInformationNote = new ArrayList<>();
            for (NoteType aItem: getInformationNote()) {
                retInformationNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.informationNote = retInformationNote;
        }
        if (inspectionReferenceReferencedDocument == null) {
            ret.inspectionReferenceReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retInspectionReferenceReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getInspectionReferenceReferencedDocument()) {
                retInspectionReferenceReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.inspectionReferenceReferencedDocument = retInspectionReferenceReferencedDocument;
        }
        ret.legalRightsOwnerTradeParty = ((legalRightsOwnerTradeParty == null)?null:legalRightsOwnerTradeParty.clone());
        ret.linearSpatialDimension = ((linearSpatialDimension == null)?null:linearSpatialDimension.clone());
        ret.manufacturerAssignedID = ((manufacturerAssignedID == null)?null:manufacturerAssignedID.clone());
        ret.manufacturerTradeParty = ((manufacturerTradeParty == null)?null:manufacturerTradeParty.clone());
        ret.maximumLinearSpatialDimension = ((maximumLinearSpatialDimension == null)?null:maximumLinearSpatialDimension.clone());
        ret.minimumLinearSpatialDimension = ((minimumLinearSpatialDimension == null)?null:minimumLinearSpatialDimension.clone());
        ret.msdsReferenceReferencedDocument = ((msdsReferenceReferencedDocument == null)?null:msdsReferenceReferencedDocument.clone());
        if (name == null) {
            ret.name = null;
        } else {
            List<TextType> retName = new ArrayList<>();
            for (TextType aItem: getName()) {
                retName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.name = retName;
        }
        ret.netWeightMeasure = ((netWeightMeasure == null)?null:netWeightMeasure.clone());
        ret.originTradeCountry = ((originTradeCountry == null)?null:originTradeCountry.clone());
        if (presentationSpecifiedBinaryFile == null) {
            ret.presentationSpecifiedBinaryFile = null;
        } else {
            List<SpecifiedBinaryFileType> retPresentationSpecifiedBinaryFile = new ArrayList<>();
            for (SpecifiedBinaryFileType aItem: getPresentationSpecifiedBinaryFile()) {
                retPresentationSpecifiedBinaryFile.add(((aItem == null)?null:aItem.clone()));
            }
            ret.presentationSpecifiedBinaryFile = retPresentationSpecifiedBinaryFile;
        }
        if (productGroupID == null) {
            ret.productGroupID = null;
        } else {
            List<IDType> retProductGroupID = new ArrayList<>();
            for (IDType aItem: getProductGroupID()) {
                retProductGroupID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.productGroupID = retProductGroupID;
        }
        ret.sellerAssignedID = ((sellerAssignedID == null)?null:sellerAssignedID.clone());
        ret.subBrandName = ((subBrandName == null)?null:subBrandName.clone());
        ret.tradeName = ((tradeName == null)?null:tradeName.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        if (useDescription == null) {
            ret.useDescription = null;
        } else {
            List<TextType> retUseDescription = new ArrayList<>();
            for (TextType aItem: getUseDescription()) {
                retUseDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.useDescription = retUseDescription;
        }
        ret.variableMeasureIndicator = ((variableMeasureIndicator == null)?null:variableMeasureIndicator.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradeProductType clone() {
        TradeProductType ret = new TradeProductType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setGlobalID(
        @Nullable
        final String valueParam) {
        IDType aObj = getGlobalID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setGlobalID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setSellerAssignedID(
        @Nullable
        final String valueParam) {
        IDType aObj = getSellerAssignedID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setSellerAssignedID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setBuyerAssignedID(
        @Nullable
        final String valueParam) {
        IDType aObj = getBuyerAssignedID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setBuyerAssignedID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setManufacturerAssignedID(
        @Nullable
        final String valueParam) {
        IDType aObj = getManufacturerAssignedID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setManufacturerAssignedID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setTradeName(
        @Nullable
        final String valueParam) {
        TextType aObj = getTradeName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setTradeName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setDescription(
        @Nullable
        final String valueParam) {
        TextType aObj = getDescription();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setDescription(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setTypeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeasureType and never <code>null</code>
     */
    @Nonnull
    public MeasureType setNetWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MeasureType aObj = getNetWeightMeasure();
        if (aObj == null) {
            aObj = new MeasureType(valueParam);
            setNetWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeasureType and never <code>null</code>
     */
    @Nonnull
    public MeasureType setGrossWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MeasureType aObj = getGrossWeightMeasure();
        if (aObj == null) {
            aObj = new MeasureType(valueParam);
            setGrossWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeasureType and never <code>null</code>
     */
    @Nonnull
    public MeasureType setAreaDensityMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MeasureType aObj = getAreaDensityMeasure();
        if (aObj == null) {
            aObj = new MeasureType(valueParam);
            setAreaDensityMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setBrandName(
        @Nullable
        final String valueParam) {
        TextType aObj = getBrandName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setBrandName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setSubBrandName(
        @Nullable
        final String valueParam) {
        TextType aObj = getSubBrandName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setSubBrandName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeasureType and never <code>null</code>
     */
    @Nonnull
    public MeasureType setDrainedNetWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MeasureType aObj = getDrainedNetWeightMeasure();
        if (aObj == null) {
            aObj = new MeasureType(valueParam);
            setDrainedNetWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setColourCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getColourCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setColourCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getGlobalIDValue() {
        IDType aObj = getGlobalID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getSellerAssignedIDValue() {
        IDType aObj = getSellerAssignedID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getBuyerAssignedIDValue() {
        IDType aObj = getBuyerAssignedID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getManufacturerAssignedIDValue() {
        IDType aObj = getManufacturerAssignedID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getTradeNameValue() {
        TextType aObj = getTradeName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getDescriptionValue() {
        TextType aObj = getDescription();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        CodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNetWeightMeasureValue() {
        MeasureType aObj = getNetWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGrossWeightMeasureValue() {
        MeasureType aObj = getGrossWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAreaDensityMeasureValue() {
        MeasureType aObj = getAreaDensityMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getBrandNameValue() {
        TextType aObj = getBrandName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getSubBrandNameValue() {
        TextType aObj = getSubBrandName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDrainedNetWeightMeasureValue() {
        MeasureType aObj = getDrainedNetWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getColourCodeValue() {
        CodeType aObj = getColourCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
