
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.NumericType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.PercentType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for TradeSettlementFinancialCardType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradeSettlementFinancialCardType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="MicrochipIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="CardholderName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="ExpiryDate" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateType" minOccurs="0"/>
 *         <element name="VerificationNumeric" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}NumericType" minOccurs="0"/>
 *         <element name="ValidFromDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="CreditLimitAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CreditAvailableAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="InterestRatePercent" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}PercentType" minOccurs="0"/>
 *         <element name="IssuingCompanyName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradeSettlementFinancialCardType", propOrder = {
    "microchipIndicator",
    "id",
    "typeCode",
    "cardholderName",
    "expiryDate",
    "verificationNumeric",
    "validFromDateTime",
    "creditLimitAmount",
    "creditAvailableAmount",
    "interestRatePercent",
    "issuingCompanyName",
    "description"
})
@CodingStyleguideUnaware
public class TradeSettlementFinancialCardType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "MicrochipIndicator")
    private IndicatorType microchipIndicator;
    @XmlElement(name = "ID")
    private IDType id;
    @XmlElement(name = "TypeCode")
    private CodeType typeCode;
    @XmlElement(name = "CardholderName")
    private TextType cardholderName;
    @XmlElement(name = "ExpiryDate")
    private DateType expiryDate;
    @XmlElement(name = "VerificationNumeric")
    private NumericType verificationNumeric;
    @XmlElement(name = "ValidFromDateTime")
    private DateTimeType validFromDateTime;
    @XmlElement(name = "CreditLimitAmount")
    private List<AmountType> creditLimitAmount;
    @XmlElement(name = "CreditAvailableAmount")
    private List<AmountType> creditAvailableAmount;
    @XmlElement(name = "InterestRatePercent")
    private PercentType interestRatePercent;
    @XmlElement(name = "IssuingCompanyName")
    private TextType issuingCompanyName;
    @XmlElement(name = "Description")
    private TextType description;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradeSettlementFinancialCardType() {
    }

    /**
     * Gets the value of the microchipIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getMicrochipIndicator() {
        return microchipIndicator;
    }

    /**
     * Sets the value of the microchipIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setMicrochipIndicator(
        @Nullable
        IndicatorType value) {
        this.microchipIndicator = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        CodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the cardholderName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getCardholderName() {
        return cardholderName;
    }

    /**
     * Sets the value of the cardholderName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setCardholderName(
        @Nullable
        TextType value) {
        this.cardholderName = value;
    }

    /**
     * Gets the value of the expiryDate property.
     * 
     * @return
     *     possible object is
     *     {@link DateType }
     *     
     */
    @Nullable
    public DateType getExpiryDate() {
        return expiryDate;
    }

    /**
     * Sets the value of the expiryDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateType }
     *     
     */
    public void setExpiryDate(
        @Nullable
        DateType value) {
        this.expiryDate = value;
    }

    /**
     * Gets the value of the verificationNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link NumericType }
     *     
     */
    @Nullable
    public NumericType getVerificationNumeric() {
        return verificationNumeric;
    }

    /**
     * Sets the value of the verificationNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link NumericType }
     *     
     */
    public void setVerificationNumeric(
        @Nullable
        NumericType value) {
        this.verificationNumeric = value;
    }

    /**
     * Gets the value of the validFromDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getValidFromDateTime() {
        return validFromDateTime;
    }

    /**
     * Sets the value of the validFromDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setValidFromDateTime(
        @Nullable
        DateTimeType value) {
        this.validFromDateTime = value;
    }

    /**
     * Gets the value of the creditLimitAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the creditLimitAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCreditLimitAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the creditLimitAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getCreditLimitAmount() {
        if (creditLimitAmount == null) {
            creditLimitAmount = new ArrayList<>();
        }
        return this.creditLimitAmount;
    }

    /**
     * Gets the value of the creditAvailableAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the creditAvailableAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCreditAvailableAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the creditAvailableAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getCreditAvailableAmount() {
        if (creditAvailableAmount == null) {
            creditAvailableAmount = new ArrayList<>();
        }
        return this.creditAvailableAmount;
    }

    /**
     * Gets the value of the interestRatePercent property.
     * 
     * @return
     *     possible object is
     *     {@link PercentType }
     *     
     */
    @Nullable
    public PercentType getInterestRatePercent() {
        return interestRatePercent;
    }

    /**
     * Sets the value of the interestRatePercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link PercentType }
     *     
     */
    public void setInterestRatePercent(
        @Nullable
        PercentType value) {
        this.interestRatePercent = value;
    }

    /**
     * Gets the value of the issuingCompanyName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getIssuingCompanyName() {
        return issuingCompanyName;
    }

    /**
     * Sets the value of the issuingCompanyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setIssuingCompanyName(
        @Nullable
        TextType value) {
        this.issuingCompanyName = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setDescription(
        @Nullable
        TextType value) {
        this.description = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradeSettlementFinancialCardType rhs = ((TradeSettlementFinancialCardType) o);
        if (!EqualsHelper.equals(cardholderName, rhs.cardholderName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(creditAvailableAmount, rhs.creditAvailableAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(creditLimitAmount, rhs.creditLimitAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(expiryDate, rhs.expiryDate)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(interestRatePercent, rhs.interestRatePercent)) {
            return false;
        }
        if (!EqualsHelper.equals(issuingCompanyName, rhs.issuingCompanyName)) {
            return false;
        }
        if (!EqualsHelper.equals(microchipIndicator, rhs.microchipIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(validFromDateTime, rhs.validFromDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(verificationNumeric, rhs.verificationNumeric)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(cardholderName).append(creditAvailableAmount).append(creditLimitAmount).append(description).append(expiryDate).append(id).append(interestRatePercent).append(issuingCompanyName).append(microchipIndicator).append(typeCode).append(validFromDateTime).append(verificationNumeric).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("cardholderName", cardholderName).append("creditAvailableAmount", creditAvailableAmount).append("creditLimitAmount", creditLimitAmount).append("description", description).append("expiryDate", expiryDate).append("id", id).append("interestRatePercent", interestRatePercent).append("issuingCompanyName", issuingCompanyName).append("microchipIndicator", microchipIndicator).append("typeCode", typeCode).append("validFromDateTime", validFromDateTime).append("verificationNumeric", verificationNumeric).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCreditLimitAmount(
        @Nullable
        final List<AmountType> aList) {
        creditLimitAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCreditAvailableAmount(
        @Nullable
        final List<AmountType> aList) {
        creditAvailableAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCreditLimitAmountEntries() {
        return (!getCreditLimitAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCreditLimitAmountEntries() {
        return getCreditLimitAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCreditLimitAmountCount() {
        return getCreditLimitAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getCreditLimitAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCreditLimitAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCreditLimitAmount(
        @Nonnull
        final AmountType elem) {
        getCreditLimitAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCreditAvailableAmountEntries() {
        return (!getCreditAvailableAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCreditAvailableAmountEntries() {
        return getCreditAvailableAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCreditAvailableAmountCount() {
        return getCreditAvailableAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getCreditAvailableAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCreditAvailableAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCreditAvailableAmount(
        @Nonnull
        final AmountType elem) {
        getCreditAvailableAmount().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradeSettlementFinancialCardType ret) {
        ret.cardholderName = ((cardholderName == null)?null:cardholderName.clone());
        if (creditAvailableAmount == null) {
            ret.creditAvailableAmount = null;
        } else {
            List<AmountType> retCreditAvailableAmount = new ArrayList<>();
            for (AmountType aItem: getCreditAvailableAmount()) {
                retCreditAvailableAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.creditAvailableAmount = retCreditAvailableAmount;
        }
        if (creditLimitAmount == null) {
            ret.creditLimitAmount = null;
        } else {
            List<AmountType> retCreditLimitAmount = new ArrayList<>();
            for (AmountType aItem: getCreditLimitAmount()) {
                retCreditLimitAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.creditLimitAmount = retCreditLimitAmount;
        }
        ret.description = ((description == null)?null:description.clone());
        ret.expiryDate = ((expiryDate == null)?null:expiryDate.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.interestRatePercent = ((interestRatePercent == null)?null:interestRatePercent.clone());
        ret.issuingCompanyName = ((issuingCompanyName == null)?null:issuingCompanyName.clone());
        ret.microchipIndicator = ((microchipIndicator == null)?null:microchipIndicator.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        ret.validFromDateTime = ((validFromDateTime == null)?null:validFromDateTime.clone());
        ret.verificationNumeric = ((verificationNumeric == null)?null:verificationNumeric.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradeSettlementFinancialCardType clone() {
        TradeSettlementFinancialCardType ret = new TradeSettlementFinancialCardType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setTypeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setCardholderName(
        @Nullable
        final String valueParam) {
        TextType aObj = getCardholderName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setCardholderName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NumericType and never <code>null</code>
     */
    @Nonnull
    public NumericType setVerificationNumeric(
        @Nullable
        final BigDecimal valueParam) {
        NumericType aObj = getVerificationNumeric();
        if (aObj == null) {
            aObj = new NumericType(valueParam);
            setVerificationNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PercentType and never <code>null</code>
     */
    @Nonnull
    public PercentType setInterestRatePercent(
        @Nullable
        final BigDecimal valueParam) {
        PercentType aObj = getInterestRatePercent();
        if (aObj == null) {
            aObj = new PercentType(valueParam);
            setInterestRatePercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setIssuingCompanyName(
        @Nullable
        final String valueParam) {
        TextType aObj = getIssuingCompanyName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setIssuingCompanyName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setDescription(
        @Nullable
        final String valueParam) {
        TextType aObj = getDescription();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setDescription(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        CodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getCardholderNameValue() {
        TextType aObj = getCardholderName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getVerificationNumericValue() {
        NumericType aObj = getVerificationNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getInterestRatePercentValue() {
        PercentType aObj = getInterestRatePercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getIssuingCompanyNameValue() {
        TextType aObj = getIssuingCompanyName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getDescriptionValue() {
        TextType aObj = getDescription();
        return (aObj == null)?null:aObj.getValue();
    }

}
