
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;


/**
 * <p>Java class for TradeSettlementHeaderMonetarySummationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradeSettlementHeaderMonetarySummationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="LineTotalAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ChargeTotalAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AllowanceTotalAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TaxBasisTotalAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TaxTotalAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="RoundingAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="GrandTotalAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="InformationAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalPrepaidAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalDiscountAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalAllowanceChargeAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="DuePayableAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="RetailValueExcludingTaxInformationAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalDepositFeeInformationAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ProductValueExcludingTobaccoTaxInformationAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalRetailValueInformationAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="GrossLineTotalAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="NetLineTotalAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="NetIncludingTaxesLineTotalAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradeSettlementHeaderMonetarySummationType", propOrder = {
    "lineTotalAmount",
    "chargeTotalAmount",
    "allowanceTotalAmount",
    "taxBasisTotalAmount",
    "taxTotalAmount",
    "roundingAmount",
    "grandTotalAmount",
    "informationAmount",
    "totalPrepaidAmount",
    "totalDiscountAmount",
    "totalAllowanceChargeAmount",
    "duePayableAmount",
    "retailValueExcludingTaxInformationAmount",
    "totalDepositFeeInformationAmount",
    "productValueExcludingTobaccoTaxInformationAmount",
    "totalRetailValueInformationAmount",
    "grossLineTotalAmount",
    "netLineTotalAmount",
    "netIncludingTaxesLineTotalAmount"
})
@CodingStyleguideUnaware
public class TradeSettlementHeaderMonetarySummationType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "LineTotalAmount")
    private List<AmountType> lineTotalAmount;
    @XmlElement(name = "ChargeTotalAmount")
    private List<AmountType> chargeTotalAmount;
    @XmlElement(name = "AllowanceTotalAmount")
    private List<AmountType> allowanceTotalAmount;
    @XmlElement(name = "TaxBasisTotalAmount")
    private List<AmountType> taxBasisTotalAmount;
    @XmlElement(name = "TaxTotalAmount")
    private List<AmountType> taxTotalAmount;
    @XmlElement(name = "RoundingAmount")
    private List<AmountType> roundingAmount;
    @XmlElement(name = "GrandTotalAmount")
    private List<AmountType> grandTotalAmount;
    @XmlElement(name = "InformationAmount")
    private List<AmountType> informationAmount;
    @XmlElement(name = "TotalPrepaidAmount")
    private List<AmountType> totalPrepaidAmount;
    @XmlElement(name = "TotalDiscountAmount")
    private List<AmountType> totalDiscountAmount;
    @XmlElement(name = "TotalAllowanceChargeAmount")
    private List<AmountType> totalAllowanceChargeAmount;
    @XmlElement(name = "DuePayableAmount")
    private List<AmountType> duePayableAmount;
    @XmlElement(name = "RetailValueExcludingTaxInformationAmount")
    private List<AmountType> retailValueExcludingTaxInformationAmount;
    @XmlElement(name = "TotalDepositFeeInformationAmount")
    private List<AmountType> totalDepositFeeInformationAmount;
    @XmlElement(name = "ProductValueExcludingTobaccoTaxInformationAmount")
    private List<AmountType> productValueExcludingTobaccoTaxInformationAmount;
    @XmlElement(name = "TotalRetailValueInformationAmount")
    private List<AmountType> totalRetailValueInformationAmount;
    @XmlElement(name = "GrossLineTotalAmount")
    private List<AmountType> grossLineTotalAmount;
    @XmlElement(name = "NetLineTotalAmount")
    private List<AmountType> netLineTotalAmount;
    @XmlElement(name = "NetIncludingTaxesLineTotalAmount")
    private List<AmountType> netIncludingTaxesLineTotalAmount;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradeSettlementHeaderMonetarySummationType() {
    }

    /**
     * Gets the value of the lineTotalAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the lineTotalAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLineTotalAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the lineTotalAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getLineTotalAmount() {
        if (lineTotalAmount == null) {
            lineTotalAmount = new ArrayList<>();
        }
        return this.lineTotalAmount;
    }

    /**
     * Gets the value of the chargeTotalAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the chargeTotalAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getChargeTotalAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the chargeTotalAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getChargeTotalAmount() {
        if (chargeTotalAmount == null) {
            chargeTotalAmount = new ArrayList<>();
        }
        return this.chargeTotalAmount;
    }

    /**
     * Gets the value of the allowanceTotalAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the allowanceTotalAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAllowanceTotalAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the allowanceTotalAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getAllowanceTotalAmount() {
        if (allowanceTotalAmount == null) {
            allowanceTotalAmount = new ArrayList<>();
        }
        return this.allowanceTotalAmount;
    }

    /**
     * Gets the value of the taxBasisTotalAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the taxBasisTotalAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTaxBasisTotalAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the taxBasisTotalAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getTaxBasisTotalAmount() {
        if (taxBasisTotalAmount == null) {
            taxBasisTotalAmount = new ArrayList<>();
        }
        return this.taxBasisTotalAmount;
    }

    /**
     * Gets the value of the taxTotalAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the taxTotalAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTaxTotalAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the taxTotalAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getTaxTotalAmount() {
        if (taxTotalAmount == null) {
            taxTotalAmount = new ArrayList<>();
        }
        return this.taxTotalAmount;
    }

    /**
     * Gets the value of the roundingAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the roundingAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRoundingAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the roundingAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getRoundingAmount() {
        if (roundingAmount == null) {
            roundingAmount = new ArrayList<>();
        }
        return this.roundingAmount;
    }

    /**
     * Gets the value of the grandTotalAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the grandTotalAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGrandTotalAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the grandTotalAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getGrandTotalAmount() {
        if (grandTotalAmount == null) {
            grandTotalAmount = new ArrayList<>();
        }
        return this.grandTotalAmount;
    }

    /**
     * Gets the value of the informationAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the informationAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInformationAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the informationAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getInformationAmount() {
        if (informationAmount == null) {
            informationAmount = new ArrayList<>();
        }
        return this.informationAmount;
    }

    /**
     * Gets the value of the totalPrepaidAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the totalPrepaidAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalPrepaidAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the totalPrepaidAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getTotalPrepaidAmount() {
        if (totalPrepaidAmount == null) {
            totalPrepaidAmount = new ArrayList<>();
        }
        return this.totalPrepaidAmount;
    }

    /**
     * Gets the value of the totalDiscountAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the totalDiscountAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalDiscountAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the totalDiscountAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getTotalDiscountAmount() {
        if (totalDiscountAmount == null) {
            totalDiscountAmount = new ArrayList<>();
        }
        return this.totalDiscountAmount;
    }

    /**
     * Gets the value of the totalAllowanceChargeAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the totalAllowanceChargeAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalAllowanceChargeAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the totalAllowanceChargeAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getTotalAllowanceChargeAmount() {
        if (totalAllowanceChargeAmount == null) {
            totalAllowanceChargeAmount = new ArrayList<>();
        }
        return this.totalAllowanceChargeAmount;
    }

    /**
     * Gets the value of the duePayableAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the duePayableAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDuePayableAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the duePayableAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getDuePayableAmount() {
        if (duePayableAmount == null) {
            duePayableAmount = new ArrayList<>();
        }
        return this.duePayableAmount;
    }

    /**
     * Gets the value of the retailValueExcludingTaxInformationAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the retailValueExcludingTaxInformationAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRetailValueExcludingTaxInformationAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the retailValueExcludingTaxInformationAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getRetailValueExcludingTaxInformationAmount() {
        if (retailValueExcludingTaxInformationAmount == null) {
            retailValueExcludingTaxInformationAmount = new ArrayList<>();
        }
        return this.retailValueExcludingTaxInformationAmount;
    }

    /**
     * Gets the value of the totalDepositFeeInformationAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the totalDepositFeeInformationAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalDepositFeeInformationAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the totalDepositFeeInformationAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getTotalDepositFeeInformationAmount() {
        if (totalDepositFeeInformationAmount == null) {
            totalDepositFeeInformationAmount = new ArrayList<>();
        }
        return this.totalDepositFeeInformationAmount;
    }

    /**
     * Gets the value of the productValueExcludingTobaccoTaxInformationAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the productValueExcludingTobaccoTaxInformationAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProductValueExcludingTobaccoTaxInformationAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the productValueExcludingTobaccoTaxInformationAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getProductValueExcludingTobaccoTaxInformationAmount() {
        if (productValueExcludingTobaccoTaxInformationAmount == null) {
            productValueExcludingTobaccoTaxInformationAmount = new ArrayList<>();
        }
        return this.productValueExcludingTobaccoTaxInformationAmount;
    }

    /**
     * Gets the value of the totalRetailValueInformationAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the totalRetailValueInformationAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalRetailValueInformationAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the totalRetailValueInformationAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getTotalRetailValueInformationAmount() {
        if (totalRetailValueInformationAmount == null) {
            totalRetailValueInformationAmount = new ArrayList<>();
        }
        return this.totalRetailValueInformationAmount;
    }

    /**
     * Gets the value of the grossLineTotalAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the grossLineTotalAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGrossLineTotalAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the grossLineTotalAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getGrossLineTotalAmount() {
        if (grossLineTotalAmount == null) {
            grossLineTotalAmount = new ArrayList<>();
        }
        return this.grossLineTotalAmount;
    }

    /**
     * Gets the value of the netLineTotalAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the netLineTotalAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNetLineTotalAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the netLineTotalAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getNetLineTotalAmount() {
        if (netLineTotalAmount == null) {
            netLineTotalAmount = new ArrayList<>();
        }
        return this.netLineTotalAmount;
    }

    /**
     * Gets the value of the netIncludingTaxesLineTotalAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the netIncludingTaxesLineTotalAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNetIncludingTaxesLineTotalAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the netIncludingTaxesLineTotalAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getNetIncludingTaxesLineTotalAmount() {
        if (netIncludingTaxesLineTotalAmount == null) {
            netIncludingTaxesLineTotalAmount = new ArrayList<>();
        }
        return this.netIncludingTaxesLineTotalAmount;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradeSettlementHeaderMonetarySummationType rhs = ((TradeSettlementHeaderMonetarySummationType) o);
        if (!EqualsHelper.equalsCollection(allowanceTotalAmount, rhs.allowanceTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(chargeTotalAmount, rhs.chargeTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(duePayableAmount, rhs.duePayableAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(grandTotalAmount, rhs.grandTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(grossLineTotalAmount, rhs.grossLineTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(informationAmount, rhs.informationAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(lineTotalAmount, rhs.lineTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(netIncludingTaxesLineTotalAmount, rhs.netIncludingTaxesLineTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(netLineTotalAmount, rhs.netLineTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(productValueExcludingTobaccoTaxInformationAmount, rhs.productValueExcludingTobaccoTaxInformationAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(retailValueExcludingTaxInformationAmount, rhs.retailValueExcludingTaxInformationAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(roundingAmount, rhs.roundingAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(taxBasisTotalAmount, rhs.taxBasisTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(taxTotalAmount, rhs.taxTotalAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(totalAllowanceChargeAmount, rhs.totalAllowanceChargeAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(totalDepositFeeInformationAmount, rhs.totalDepositFeeInformationAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(totalDiscountAmount, rhs.totalDiscountAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(totalPrepaidAmount, rhs.totalPrepaidAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(totalRetailValueInformationAmount, rhs.totalRetailValueInformationAmount)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(allowanceTotalAmount).append(chargeTotalAmount).append(duePayableAmount).append(grandTotalAmount).append(grossLineTotalAmount).append(informationAmount).append(lineTotalAmount).append(netIncludingTaxesLineTotalAmount).append(netLineTotalAmount).append(productValueExcludingTobaccoTaxInformationAmount).append(retailValueExcludingTaxInformationAmount).append(roundingAmount).append(taxBasisTotalAmount).append(taxTotalAmount).append(totalAllowanceChargeAmount).append(totalDepositFeeInformationAmount).append(totalDiscountAmount).append(totalPrepaidAmount).append(totalRetailValueInformationAmount).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("allowanceTotalAmount", allowanceTotalAmount).append("chargeTotalAmount", chargeTotalAmount).append("duePayableAmount", duePayableAmount).append("grandTotalAmount", grandTotalAmount).append("grossLineTotalAmount", grossLineTotalAmount).append("informationAmount", informationAmount).append("lineTotalAmount", lineTotalAmount).append("netIncludingTaxesLineTotalAmount", netIncludingTaxesLineTotalAmount).append("netLineTotalAmount", netLineTotalAmount).append("productValueExcludingTobaccoTaxInformationAmount", productValueExcludingTobaccoTaxInformationAmount).append("retailValueExcludingTaxInformationAmount", retailValueExcludingTaxInformationAmount).append("roundingAmount", roundingAmount).append("taxBasisTotalAmount", taxBasisTotalAmount).append("taxTotalAmount", taxTotalAmount).append("totalAllowanceChargeAmount", totalAllowanceChargeAmount).append("totalDepositFeeInformationAmount", totalDepositFeeInformationAmount).append("totalDiscountAmount", totalDiscountAmount).append("totalPrepaidAmount", totalPrepaidAmount).append("totalRetailValueInformationAmount", totalRetailValueInformationAmount).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLineTotalAmount(
        @Nullable
        final List<AmountType> aList) {
        lineTotalAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setChargeTotalAmount(
        @Nullable
        final List<AmountType> aList) {
        chargeTotalAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAllowanceTotalAmount(
        @Nullable
        final List<AmountType> aList) {
        allowanceTotalAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTaxBasisTotalAmount(
        @Nullable
        final List<AmountType> aList) {
        taxBasisTotalAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTaxTotalAmount(
        @Nullable
        final List<AmountType> aList) {
        taxTotalAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRoundingAmount(
        @Nullable
        final List<AmountType> aList) {
        roundingAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGrandTotalAmount(
        @Nullable
        final List<AmountType> aList) {
        grandTotalAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInformationAmount(
        @Nullable
        final List<AmountType> aList) {
        informationAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTotalPrepaidAmount(
        @Nullable
        final List<AmountType> aList) {
        totalPrepaidAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTotalDiscountAmount(
        @Nullable
        final List<AmountType> aList) {
        totalDiscountAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTotalAllowanceChargeAmount(
        @Nullable
        final List<AmountType> aList) {
        totalAllowanceChargeAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDuePayableAmount(
        @Nullable
        final List<AmountType> aList) {
        duePayableAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRetailValueExcludingTaxInformationAmount(
        @Nullable
        final List<AmountType> aList) {
        retailValueExcludingTaxInformationAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTotalDepositFeeInformationAmount(
        @Nullable
        final List<AmountType> aList) {
        totalDepositFeeInformationAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProductValueExcludingTobaccoTaxInformationAmount(
        @Nullable
        final List<AmountType> aList) {
        productValueExcludingTobaccoTaxInformationAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTotalRetailValueInformationAmount(
        @Nullable
        final List<AmountType> aList) {
        totalRetailValueInformationAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGrossLineTotalAmount(
        @Nullable
        final List<AmountType> aList) {
        grossLineTotalAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNetLineTotalAmount(
        @Nullable
        final List<AmountType> aList) {
        netLineTotalAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNetIncludingTaxesLineTotalAmount(
        @Nullable
        final List<AmountType> aList) {
        netIncludingTaxesLineTotalAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLineTotalAmountEntries() {
        return (!getLineTotalAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLineTotalAmountEntries() {
        return getLineTotalAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLineTotalAmountCount() {
        return getLineTotalAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getLineTotalAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLineTotalAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLineTotalAmount(
        @Nonnull
        final AmountType elem) {
        getLineTotalAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasChargeTotalAmountEntries() {
        return (!getChargeTotalAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoChargeTotalAmountEntries() {
        return getChargeTotalAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getChargeTotalAmountCount() {
        return getChargeTotalAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getChargeTotalAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getChargeTotalAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addChargeTotalAmount(
        @Nonnull
        final AmountType elem) {
        getChargeTotalAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAllowanceTotalAmountEntries() {
        return (!getAllowanceTotalAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAllowanceTotalAmountEntries() {
        return getAllowanceTotalAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAllowanceTotalAmountCount() {
        return getAllowanceTotalAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getAllowanceTotalAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAllowanceTotalAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAllowanceTotalAmount(
        @Nonnull
        final AmountType elem) {
        getAllowanceTotalAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTaxBasisTotalAmountEntries() {
        return (!getTaxBasisTotalAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTaxBasisTotalAmountEntries() {
        return getTaxBasisTotalAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTaxBasisTotalAmountCount() {
        return getTaxBasisTotalAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getTaxBasisTotalAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTaxBasisTotalAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTaxBasisTotalAmount(
        @Nonnull
        final AmountType elem) {
        getTaxBasisTotalAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTaxTotalAmountEntries() {
        return (!getTaxTotalAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTaxTotalAmountEntries() {
        return getTaxTotalAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTaxTotalAmountCount() {
        return getTaxTotalAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getTaxTotalAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTaxTotalAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTaxTotalAmount(
        @Nonnull
        final AmountType elem) {
        getTaxTotalAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRoundingAmountEntries() {
        return (!getRoundingAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRoundingAmountEntries() {
        return getRoundingAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRoundingAmountCount() {
        return getRoundingAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getRoundingAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRoundingAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRoundingAmount(
        @Nonnull
        final AmountType elem) {
        getRoundingAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGrandTotalAmountEntries() {
        return (!getGrandTotalAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGrandTotalAmountEntries() {
        return getGrandTotalAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGrandTotalAmountCount() {
        return getGrandTotalAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getGrandTotalAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGrandTotalAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGrandTotalAmount(
        @Nonnull
        final AmountType elem) {
        getGrandTotalAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInformationAmountEntries() {
        return (!getInformationAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInformationAmountEntries() {
        return getInformationAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInformationAmountCount() {
        return getInformationAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getInformationAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInformationAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInformationAmount(
        @Nonnull
        final AmountType elem) {
        getInformationAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTotalPrepaidAmountEntries() {
        return (!getTotalPrepaidAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTotalPrepaidAmountEntries() {
        return getTotalPrepaidAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTotalPrepaidAmountCount() {
        return getTotalPrepaidAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getTotalPrepaidAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTotalPrepaidAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTotalPrepaidAmount(
        @Nonnull
        final AmountType elem) {
        getTotalPrepaidAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTotalDiscountAmountEntries() {
        return (!getTotalDiscountAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTotalDiscountAmountEntries() {
        return getTotalDiscountAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTotalDiscountAmountCount() {
        return getTotalDiscountAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getTotalDiscountAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTotalDiscountAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTotalDiscountAmount(
        @Nonnull
        final AmountType elem) {
        getTotalDiscountAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTotalAllowanceChargeAmountEntries() {
        return (!getTotalAllowanceChargeAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTotalAllowanceChargeAmountEntries() {
        return getTotalAllowanceChargeAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTotalAllowanceChargeAmountCount() {
        return getTotalAllowanceChargeAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getTotalAllowanceChargeAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTotalAllowanceChargeAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTotalAllowanceChargeAmount(
        @Nonnull
        final AmountType elem) {
        getTotalAllowanceChargeAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDuePayableAmountEntries() {
        return (!getDuePayableAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDuePayableAmountEntries() {
        return getDuePayableAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDuePayableAmountCount() {
        return getDuePayableAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getDuePayableAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDuePayableAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDuePayableAmount(
        @Nonnull
        final AmountType elem) {
        getDuePayableAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRetailValueExcludingTaxInformationAmountEntries() {
        return (!getRetailValueExcludingTaxInformationAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRetailValueExcludingTaxInformationAmountEntries() {
        return getRetailValueExcludingTaxInformationAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRetailValueExcludingTaxInformationAmountCount() {
        return getRetailValueExcludingTaxInformationAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getRetailValueExcludingTaxInformationAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRetailValueExcludingTaxInformationAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRetailValueExcludingTaxInformationAmount(
        @Nonnull
        final AmountType elem) {
        getRetailValueExcludingTaxInformationAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTotalDepositFeeInformationAmountEntries() {
        return (!getTotalDepositFeeInformationAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTotalDepositFeeInformationAmountEntries() {
        return getTotalDepositFeeInformationAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTotalDepositFeeInformationAmountCount() {
        return getTotalDepositFeeInformationAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getTotalDepositFeeInformationAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTotalDepositFeeInformationAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTotalDepositFeeInformationAmount(
        @Nonnull
        final AmountType elem) {
        getTotalDepositFeeInformationAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProductValueExcludingTobaccoTaxInformationAmountEntries() {
        return (!getProductValueExcludingTobaccoTaxInformationAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProductValueExcludingTobaccoTaxInformationAmountEntries() {
        return getProductValueExcludingTobaccoTaxInformationAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProductValueExcludingTobaccoTaxInformationAmountCount() {
        return getProductValueExcludingTobaccoTaxInformationAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getProductValueExcludingTobaccoTaxInformationAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProductValueExcludingTobaccoTaxInformationAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProductValueExcludingTobaccoTaxInformationAmount(
        @Nonnull
        final AmountType elem) {
        getProductValueExcludingTobaccoTaxInformationAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTotalRetailValueInformationAmountEntries() {
        return (!getTotalRetailValueInformationAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTotalRetailValueInformationAmountEntries() {
        return getTotalRetailValueInformationAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTotalRetailValueInformationAmountCount() {
        return getTotalRetailValueInformationAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getTotalRetailValueInformationAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTotalRetailValueInformationAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTotalRetailValueInformationAmount(
        @Nonnull
        final AmountType elem) {
        getTotalRetailValueInformationAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGrossLineTotalAmountEntries() {
        return (!getGrossLineTotalAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGrossLineTotalAmountEntries() {
        return getGrossLineTotalAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGrossLineTotalAmountCount() {
        return getGrossLineTotalAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getGrossLineTotalAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGrossLineTotalAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGrossLineTotalAmount(
        @Nonnull
        final AmountType elem) {
        getGrossLineTotalAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNetLineTotalAmountEntries() {
        return (!getNetLineTotalAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNetLineTotalAmountEntries() {
        return getNetLineTotalAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNetLineTotalAmountCount() {
        return getNetLineTotalAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getNetLineTotalAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNetLineTotalAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNetLineTotalAmount(
        @Nonnull
        final AmountType elem) {
        getNetLineTotalAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNetIncludingTaxesLineTotalAmountEntries() {
        return (!getNetIncludingTaxesLineTotalAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNetIncludingTaxesLineTotalAmountEntries() {
        return getNetIncludingTaxesLineTotalAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNetIncludingTaxesLineTotalAmountCount() {
        return getNetIncludingTaxesLineTotalAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getNetIncludingTaxesLineTotalAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNetIncludingTaxesLineTotalAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNetIncludingTaxesLineTotalAmount(
        @Nonnull
        final AmountType elem) {
        getNetIncludingTaxesLineTotalAmount().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradeSettlementHeaderMonetarySummationType ret) {
        if (allowanceTotalAmount == null) {
            ret.allowanceTotalAmount = null;
        } else {
            List<AmountType> retAllowanceTotalAmount = new ArrayList<>();
            for (AmountType aItem: getAllowanceTotalAmount()) {
                retAllowanceTotalAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.allowanceTotalAmount = retAllowanceTotalAmount;
        }
        if (chargeTotalAmount == null) {
            ret.chargeTotalAmount = null;
        } else {
            List<AmountType> retChargeTotalAmount = new ArrayList<>();
            for (AmountType aItem: getChargeTotalAmount()) {
                retChargeTotalAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.chargeTotalAmount = retChargeTotalAmount;
        }
        if (duePayableAmount == null) {
            ret.duePayableAmount = null;
        } else {
            List<AmountType> retDuePayableAmount = new ArrayList<>();
            for (AmountType aItem: getDuePayableAmount()) {
                retDuePayableAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.duePayableAmount = retDuePayableAmount;
        }
        if (grandTotalAmount == null) {
            ret.grandTotalAmount = null;
        } else {
            List<AmountType> retGrandTotalAmount = new ArrayList<>();
            for (AmountType aItem: getGrandTotalAmount()) {
                retGrandTotalAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.grandTotalAmount = retGrandTotalAmount;
        }
        if (grossLineTotalAmount == null) {
            ret.grossLineTotalAmount = null;
        } else {
            List<AmountType> retGrossLineTotalAmount = new ArrayList<>();
            for (AmountType aItem: getGrossLineTotalAmount()) {
                retGrossLineTotalAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.grossLineTotalAmount = retGrossLineTotalAmount;
        }
        if (informationAmount == null) {
            ret.informationAmount = null;
        } else {
            List<AmountType> retInformationAmount = new ArrayList<>();
            for (AmountType aItem: getInformationAmount()) {
                retInformationAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.informationAmount = retInformationAmount;
        }
        if (lineTotalAmount == null) {
            ret.lineTotalAmount = null;
        } else {
            List<AmountType> retLineTotalAmount = new ArrayList<>();
            for (AmountType aItem: getLineTotalAmount()) {
                retLineTotalAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.lineTotalAmount = retLineTotalAmount;
        }
        if (netIncludingTaxesLineTotalAmount == null) {
            ret.netIncludingTaxesLineTotalAmount = null;
        } else {
            List<AmountType> retNetIncludingTaxesLineTotalAmount = new ArrayList<>();
            for (AmountType aItem: getNetIncludingTaxesLineTotalAmount()) {
                retNetIncludingTaxesLineTotalAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.netIncludingTaxesLineTotalAmount = retNetIncludingTaxesLineTotalAmount;
        }
        if (netLineTotalAmount == null) {
            ret.netLineTotalAmount = null;
        } else {
            List<AmountType> retNetLineTotalAmount = new ArrayList<>();
            for (AmountType aItem: getNetLineTotalAmount()) {
                retNetLineTotalAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.netLineTotalAmount = retNetLineTotalAmount;
        }
        if (productValueExcludingTobaccoTaxInformationAmount == null) {
            ret.productValueExcludingTobaccoTaxInformationAmount = null;
        } else {
            List<AmountType> retProductValueExcludingTobaccoTaxInformationAmount = new ArrayList<>();
            for (AmountType aItem: getProductValueExcludingTobaccoTaxInformationAmount()) {
                retProductValueExcludingTobaccoTaxInformationAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.productValueExcludingTobaccoTaxInformationAmount = retProductValueExcludingTobaccoTaxInformationAmount;
        }
        if (retailValueExcludingTaxInformationAmount == null) {
            ret.retailValueExcludingTaxInformationAmount = null;
        } else {
            List<AmountType> retRetailValueExcludingTaxInformationAmount = new ArrayList<>();
            for (AmountType aItem: getRetailValueExcludingTaxInformationAmount()) {
                retRetailValueExcludingTaxInformationAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.retailValueExcludingTaxInformationAmount = retRetailValueExcludingTaxInformationAmount;
        }
        if (roundingAmount == null) {
            ret.roundingAmount = null;
        } else {
            List<AmountType> retRoundingAmount = new ArrayList<>();
            for (AmountType aItem: getRoundingAmount()) {
                retRoundingAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.roundingAmount = retRoundingAmount;
        }
        if (taxBasisTotalAmount == null) {
            ret.taxBasisTotalAmount = null;
        } else {
            List<AmountType> retTaxBasisTotalAmount = new ArrayList<>();
            for (AmountType aItem: getTaxBasisTotalAmount()) {
                retTaxBasisTotalAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.taxBasisTotalAmount = retTaxBasisTotalAmount;
        }
        if (taxTotalAmount == null) {
            ret.taxTotalAmount = null;
        } else {
            List<AmountType> retTaxTotalAmount = new ArrayList<>();
            for (AmountType aItem: getTaxTotalAmount()) {
                retTaxTotalAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.taxTotalAmount = retTaxTotalAmount;
        }
        if (totalAllowanceChargeAmount == null) {
            ret.totalAllowanceChargeAmount = null;
        } else {
            List<AmountType> retTotalAllowanceChargeAmount = new ArrayList<>();
            for (AmountType aItem: getTotalAllowanceChargeAmount()) {
                retTotalAllowanceChargeAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.totalAllowanceChargeAmount = retTotalAllowanceChargeAmount;
        }
        if (totalDepositFeeInformationAmount == null) {
            ret.totalDepositFeeInformationAmount = null;
        } else {
            List<AmountType> retTotalDepositFeeInformationAmount = new ArrayList<>();
            for (AmountType aItem: getTotalDepositFeeInformationAmount()) {
                retTotalDepositFeeInformationAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.totalDepositFeeInformationAmount = retTotalDepositFeeInformationAmount;
        }
        if (totalDiscountAmount == null) {
            ret.totalDiscountAmount = null;
        } else {
            List<AmountType> retTotalDiscountAmount = new ArrayList<>();
            for (AmountType aItem: getTotalDiscountAmount()) {
                retTotalDiscountAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.totalDiscountAmount = retTotalDiscountAmount;
        }
        if (totalPrepaidAmount == null) {
            ret.totalPrepaidAmount = null;
        } else {
            List<AmountType> retTotalPrepaidAmount = new ArrayList<>();
            for (AmountType aItem: getTotalPrepaidAmount()) {
                retTotalPrepaidAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.totalPrepaidAmount = retTotalPrepaidAmount;
        }
        if (totalRetailValueInformationAmount == null) {
            ret.totalRetailValueInformationAmount = null;
        } else {
            List<AmountType> retTotalRetailValueInformationAmount = new ArrayList<>();
            for (AmountType aItem: getTotalRetailValueInformationAmount()) {
                retTotalRetailValueInformationAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.totalRetailValueInformationAmount = retTotalRetailValueInformationAmount;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradeSettlementHeaderMonetarySummationType clone() {
        TradeSettlementHeaderMonetarySummationType ret = new TradeSettlementHeaderMonetarySummationType();
        cloneTo(ret);
        return ret;
    }

}
