
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.CurrencyCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.TaxCategoryCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.TaxTypeCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.TimeReferenceCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.NumericType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.PercentType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.RateType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for TradeTaxType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TradeTaxType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="CalculatedAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}TaxTypeCodeType" minOccurs="0"/>
 *         <element name="ExemptionReason" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="CalculatedRate" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}RateType" minOccurs="0"/>
 *         <element name="CalculationSequenceNumeric" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}NumericType" minOccurs="0"/>
 *         <element name="BasisQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="BasisAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="UnitBasisAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="LineTotalBasisAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AllowanceChargeBasisAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CategoryCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}TaxCategoryCodeType" minOccurs="0"/>
 *         <element name="CurrencyCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}CurrencyCodeType" minOccurs="0"/>
 *         <element name="Jurisdiction" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CustomsDutyIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *         <element name="ExemptionReasonCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="TaxBasisAllowanceRate" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}RateType" minOccurs="0"/>
 *         <element name="TaxPointDate" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateType" minOccurs="0"/>
 *         <element name="Type" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="InformationAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CategoryName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="DueDateTypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}TimeReferenceCodeType" minOccurs="0"/>
 *         <element name="RateApplicablePercent" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}PercentType" minOccurs="0"/>
 *         <element name="SpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ServiceSupplyTradeCountry" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeCountryType" minOccurs="0"/>
 *         <element name="BuyerRepayableTaxSpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" minOccurs="0"/>
 *         <element name="SellerPayableTaxSpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" minOccurs="0"/>
 *         <element name="SellerRefundableTaxSpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" minOccurs="0"/>
 *         <element name="BuyerDeductibleTaxSpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" minOccurs="0"/>
 *         <element name="BuyerNonDeductibleTaxSpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" minOccurs="0"/>
 *         <element name="PlaceApplicableTradeLocation" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeLocationType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradeTaxType", propOrder = {
    "calculatedAmount",
    "typeCode",
    "exemptionReason",
    "calculatedRate",
    "calculationSequenceNumeric",
    "basisQuantity",
    "basisAmount",
    "unitBasisAmount",
    "lineTotalBasisAmount",
    "allowanceChargeBasisAmount",
    "categoryCode",
    "currencyCode",
    "jurisdiction",
    "customsDutyIndicator",
    "exemptionReasonCode",
    "taxBasisAllowanceRate",
    "taxPointDate",
    "type",
    "informationAmount",
    "categoryName",
    "dueDateTypeCode",
    "rateApplicablePercent",
    "specifiedTradeAccountingAccount",
    "serviceSupplyTradeCountry",
    "buyerRepayableTaxSpecifiedTradeAccountingAccount",
    "sellerPayableTaxSpecifiedTradeAccountingAccount",
    "sellerRefundableTaxSpecifiedTradeAccountingAccount",
    "buyerDeductibleTaxSpecifiedTradeAccountingAccount",
    "buyerNonDeductibleTaxSpecifiedTradeAccountingAccount",
    "placeApplicableTradeLocation"
})
@CodingStyleguideUnaware
public class TradeTaxType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "CalculatedAmount")
    private List<AmountType> calculatedAmount;
    @XmlElement(name = "TypeCode")
    private TaxTypeCodeType typeCode;
    @XmlElement(name = "ExemptionReason")
    private TextType exemptionReason;
    @XmlElement(name = "CalculatedRate")
    private RateType calculatedRate;
    @XmlElement(name = "CalculationSequenceNumeric")
    private NumericType calculationSequenceNumeric;
    @XmlElement(name = "BasisQuantity")
    private QuantityType basisQuantity;
    @XmlElement(name = "BasisAmount")
    private List<AmountType> basisAmount;
    @XmlElement(name = "UnitBasisAmount")
    private List<AmountType> unitBasisAmount;
    @XmlElement(name = "LineTotalBasisAmount")
    private List<AmountType> lineTotalBasisAmount;
    @XmlElement(name = "AllowanceChargeBasisAmount")
    private List<AmountType> allowanceChargeBasisAmount;
    @XmlElement(name = "CategoryCode")
    private TaxCategoryCodeType categoryCode;
    @XmlElement(name = "CurrencyCode")
    private CurrencyCodeType currencyCode;
    @XmlElement(name = "Jurisdiction")
    private List<TextType> jurisdiction;
    @XmlElement(name = "CustomsDutyIndicator")
    private IndicatorType customsDutyIndicator;
    @XmlElement(name = "ExemptionReasonCode")
    private CodeType exemptionReasonCode;
    @XmlElement(name = "TaxBasisAllowanceRate")
    private RateType taxBasisAllowanceRate;
    @XmlElement(name = "TaxPointDate")
    private DateType taxPointDate;
    @XmlElement(name = "Type")
    private TextType type;
    @XmlElement(name = "InformationAmount")
    private List<AmountType> informationAmount;
    @XmlElement(name = "CategoryName")
    private List<TextType> categoryName;
    @XmlElement(name = "DueDateTypeCode")
    private TimeReferenceCodeType dueDateTypeCode;
    @XmlElement(name = "RateApplicablePercent")
    private PercentType rateApplicablePercent;
    @XmlElement(name = "SpecifiedTradeAccountingAccount")
    private List<TradeAccountingAccountType> specifiedTradeAccountingAccount;
    @XmlElement(name = "ServiceSupplyTradeCountry")
    private TradeCountryType serviceSupplyTradeCountry;
    @XmlElement(name = "BuyerRepayableTaxSpecifiedTradeAccountingAccount")
    private TradeAccountingAccountType buyerRepayableTaxSpecifiedTradeAccountingAccount;
    @XmlElement(name = "SellerPayableTaxSpecifiedTradeAccountingAccount")
    private TradeAccountingAccountType sellerPayableTaxSpecifiedTradeAccountingAccount;
    @XmlElement(name = "SellerRefundableTaxSpecifiedTradeAccountingAccount")
    private TradeAccountingAccountType sellerRefundableTaxSpecifiedTradeAccountingAccount;
    @XmlElement(name = "BuyerDeductibleTaxSpecifiedTradeAccountingAccount")
    private TradeAccountingAccountType buyerDeductibleTaxSpecifiedTradeAccountingAccount;
    @XmlElement(name = "BuyerNonDeductibleTaxSpecifiedTradeAccountingAccount")
    private TradeAccountingAccountType buyerNonDeductibleTaxSpecifiedTradeAccountingAccount;
    @XmlElement(name = "PlaceApplicableTradeLocation")
    private List<TradeLocationType> placeApplicableTradeLocation;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TradeTaxType() {
    }

    /**
     * Gets the value of the calculatedAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the calculatedAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCalculatedAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the calculatedAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getCalculatedAmount() {
        if (calculatedAmount == null) {
            calculatedAmount = new ArrayList<>();
        }
        return this.calculatedAmount;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TaxTypeCodeType }
     *     
     */
    @Nullable
    public TaxTypeCodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxTypeCodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        TaxTypeCodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the exemptionReason property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getExemptionReason() {
        return exemptionReason;
    }

    /**
     * Sets the value of the exemptionReason property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setExemptionReason(
        @Nullable
        TextType value) {
        this.exemptionReason = value;
    }

    /**
     * Gets the value of the calculatedRate property.
     * 
     * @return
     *     possible object is
     *     {@link RateType }
     *     
     */
    @Nullable
    public RateType getCalculatedRate() {
        return calculatedRate;
    }

    /**
     * Sets the value of the calculatedRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link RateType }
     *     
     */
    public void setCalculatedRate(
        @Nullable
        RateType value) {
        this.calculatedRate = value;
    }

    /**
     * Gets the value of the calculationSequenceNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link NumericType }
     *     
     */
    @Nullable
    public NumericType getCalculationSequenceNumeric() {
        return calculationSequenceNumeric;
    }

    /**
     * Sets the value of the calculationSequenceNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link NumericType }
     *     
     */
    public void setCalculationSequenceNumeric(
        @Nullable
        NumericType value) {
        this.calculationSequenceNumeric = value;
    }

    /**
     * Gets the value of the basisQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getBasisQuantity() {
        return basisQuantity;
    }

    /**
     * Sets the value of the basisQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setBasisQuantity(
        @Nullable
        QuantityType value) {
        this.basisQuantity = value;
    }

    /**
     * Gets the value of the basisAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the basisAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBasisAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the basisAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getBasisAmount() {
        if (basisAmount == null) {
            basisAmount = new ArrayList<>();
        }
        return this.basisAmount;
    }

    /**
     * Gets the value of the unitBasisAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the unitBasisAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUnitBasisAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the unitBasisAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getUnitBasisAmount() {
        if (unitBasisAmount == null) {
            unitBasisAmount = new ArrayList<>();
        }
        return this.unitBasisAmount;
    }

    /**
     * Gets the value of the lineTotalBasisAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the lineTotalBasisAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLineTotalBasisAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the lineTotalBasisAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getLineTotalBasisAmount() {
        if (lineTotalBasisAmount == null) {
            lineTotalBasisAmount = new ArrayList<>();
        }
        return this.lineTotalBasisAmount;
    }

    /**
     * Gets the value of the allowanceChargeBasisAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the allowanceChargeBasisAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAllowanceChargeBasisAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the allowanceChargeBasisAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getAllowanceChargeBasisAmount() {
        if (allowanceChargeBasisAmount == null) {
            allowanceChargeBasisAmount = new ArrayList<>();
        }
        return this.allowanceChargeBasisAmount;
    }

    /**
     * Gets the value of the categoryCode property.
     * 
     * @return
     *     possible object is
     *     {@link TaxCategoryCodeType }
     *     
     */
    @Nullable
    public TaxCategoryCodeType getCategoryCode() {
        return categoryCode;
    }

    /**
     * Sets the value of the categoryCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxCategoryCodeType }
     *     
     */
    public void setCategoryCode(
        @Nullable
        TaxCategoryCodeType value) {
        this.categoryCode = value;
    }

    /**
     * Gets the value of the currencyCode property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyCodeType }
     *     
     */
    @Nullable
    public CurrencyCodeType getCurrencyCode() {
        return currencyCode;
    }

    /**
     * Sets the value of the currencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyCodeType }
     *     
     */
    public void setCurrencyCode(
        @Nullable
        CurrencyCodeType value) {
        this.currencyCode = value;
    }

    /**
     * Gets the value of the jurisdiction property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the jurisdiction property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJurisdiction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the jurisdiction property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getJurisdiction() {
        if (jurisdiction == null) {
            jurisdiction = new ArrayList<>();
        }
        return this.jurisdiction;
    }

    /**
     * Gets the value of the customsDutyIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getCustomsDutyIndicator() {
        return customsDutyIndicator;
    }

    /**
     * Sets the value of the customsDutyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setCustomsDutyIndicator(
        @Nullable
        IndicatorType value) {
        this.customsDutyIndicator = value;
    }

    /**
     * Gets the value of the exemptionReasonCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getExemptionReasonCode() {
        return exemptionReasonCode;
    }

    /**
     * Sets the value of the exemptionReasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setExemptionReasonCode(
        @Nullable
        CodeType value) {
        this.exemptionReasonCode = value;
    }

    /**
     * Gets the value of the taxBasisAllowanceRate property.
     * 
     * @return
     *     possible object is
     *     {@link RateType }
     *     
     */
    @Nullable
    public RateType getTaxBasisAllowanceRate() {
        return taxBasisAllowanceRate;
    }

    /**
     * Sets the value of the taxBasisAllowanceRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link RateType }
     *     
     */
    public void setTaxBasisAllowanceRate(
        @Nullable
        RateType value) {
        this.taxBasisAllowanceRate = value;
    }

    /**
     * Gets the value of the taxPointDate property.
     * 
     * @return
     *     possible object is
     *     {@link DateType }
     *     
     */
    @Nullable
    public DateType getTaxPointDate() {
        return taxPointDate;
    }

    /**
     * Sets the value of the taxPointDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateType }
     *     
     */
    public void setTaxPointDate(
        @Nullable
        DateType value) {
        this.taxPointDate = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setType(
        @Nullable
        TextType value) {
        this.type = value;
    }

    /**
     * Gets the value of the informationAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the informationAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInformationAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the informationAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getInformationAmount() {
        if (informationAmount == null) {
            informationAmount = new ArrayList<>();
        }
        return this.informationAmount;
    }

    /**
     * Gets the value of the categoryName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the categoryName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCategoryName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the categoryName property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getCategoryName() {
        if (categoryName == null) {
            categoryName = new ArrayList<>();
        }
        return this.categoryName;
    }

    /**
     * Gets the value of the dueDateTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TimeReferenceCodeType }
     *     
     */
    @Nullable
    public TimeReferenceCodeType getDueDateTypeCode() {
        return dueDateTypeCode;
    }

    /**
     * Sets the value of the dueDateTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeReferenceCodeType }
     *     
     */
    public void setDueDateTypeCode(
        @Nullable
        TimeReferenceCodeType value) {
        this.dueDateTypeCode = value;
    }

    /**
     * Gets the value of the rateApplicablePercent property.
     * 
     * @return
     *     possible object is
     *     {@link PercentType }
     *     
     */
    @Nullable
    public PercentType getRateApplicablePercent() {
        return rateApplicablePercent;
    }

    /**
     * Sets the value of the rateApplicablePercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link PercentType }
     *     
     */
    public void setRateApplicablePercent(
        @Nullable
        PercentType value) {
        this.rateApplicablePercent = value;
    }

    /**
     * Gets the value of the specifiedTradeAccountingAccount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the specifiedTradeAccountingAccount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedTradeAccountingAccount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeAccountingAccountType }
     * 
     * 
     * @return
     *     The value of the specifiedTradeAccountingAccount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeAccountingAccountType> getSpecifiedTradeAccountingAccount() {
        if (specifiedTradeAccountingAccount == null) {
            specifiedTradeAccountingAccount = new ArrayList<>();
        }
        return this.specifiedTradeAccountingAccount;
    }

    /**
     * Gets the value of the serviceSupplyTradeCountry property.
     * 
     * @return
     *     possible object is
     *     {@link TradeCountryType }
     *     
     */
    @Nullable
    public TradeCountryType getServiceSupplyTradeCountry() {
        return serviceSupplyTradeCountry;
    }

    /**
     * Sets the value of the serviceSupplyTradeCountry property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeCountryType }
     *     
     */
    public void setServiceSupplyTradeCountry(
        @Nullable
        TradeCountryType value) {
        this.serviceSupplyTradeCountry = value;
    }

    /**
     * Gets the value of the buyerRepayableTaxSpecifiedTradeAccountingAccount property.
     * 
     * @return
     *     possible object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    @Nullable
    public TradeAccountingAccountType getBuyerRepayableTaxSpecifiedTradeAccountingAccount() {
        return buyerRepayableTaxSpecifiedTradeAccountingAccount;
    }

    /**
     * Sets the value of the buyerRepayableTaxSpecifiedTradeAccountingAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    public void setBuyerRepayableTaxSpecifiedTradeAccountingAccount(
        @Nullable
        TradeAccountingAccountType value) {
        this.buyerRepayableTaxSpecifiedTradeAccountingAccount = value;
    }

    /**
     * Gets the value of the sellerPayableTaxSpecifiedTradeAccountingAccount property.
     * 
     * @return
     *     possible object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    @Nullable
    public TradeAccountingAccountType getSellerPayableTaxSpecifiedTradeAccountingAccount() {
        return sellerPayableTaxSpecifiedTradeAccountingAccount;
    }

    /**
     * Sets the value of the sellerPayableTaxSpecifiedTradeAccountingAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    public void setSellerPayableTaxSpecifiedTradeAccountingAccount(
        @Nullable
        TradeAccountingAccountType value) {
        this.sellerPayableTaxSpecifiedTradeAccountingAccount = value;
    }

    /**
     * Gets the value of the sellerRefundableTaxSpecifiedTradeAccountingAccount property.
     * 
     * @return
     *     possible object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    @Nullable
    public TradeAccountingAccountType getSellerRefundableTaxSpecifiedTradeAccountingAccount() {
        return sellerRefundableTaxSpecifiedTradeAccountingAccount;
    }

    /**
     * Sets the value of the sellerRefundableTaxSpecifiedTradeAccountingAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    public void setSellerRefundableTaxSpecifiedTradeAccountingAccount(
        @Nullable
        TradeAccountingAccountType value) {
        this.sellerRefundableTaxSpecifiedTradeAccountingAccount = value;
    }

    /**
     * Gets the value of the buyerDeductibleTaxSpecifiedTradeAccountingAccount property.
     * 
     * @return
     *     possible object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    @Nullable
    public TradeAccountingAccountType getBuyerDeductibleTaxSpecifiedTradeAccountingAccount() {
        return buyerDeductibleTaxSpecifiedTradeAccountingAccount;
    }

    /**
     * Sets the value of the buyerDeductibleTaxSpecifiedTradeAccountingAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    public void setBuyerDeductibleTaxSpecifiedTradeAccountingAccount(
        @Nullable
        TradeAccountingAccountType value) {
        this.buyerDeductibleTaxSpecifiedTradeAccountingAccount = value;
    }

    /**
     * Gets the value of the buyerNonDeductibleTaxSpecifiedTradeAccountingAccount property.
     * 
     * @return
     *     possible object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    @Nullable
    public TradeAccountingAccountType getBuyerNonDeductibleTaxSpecifiedTradeAccountingAccount() {
        return buyerNonDeductibleTaxSpecifiedTradeAccountingAccount;
    }

    /**
     * Sets the value of the buyerNonDeductibleTaxSpecifiedTradeAccountingAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeAccountingAccountType }
     *     
     */
    public void setBuyerNonDeductibleTaxSpecifiedTradeAccountingAccount(
        @Nullable
        TradeAccountingAccountType value) {
        this.buyerNonDeductibleTaxSpecifiedTradeAccountingAccount = value;
    }

    /**
     * Gets the value of the placeApplicableTradeLocation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the placeApplicableTradeLocation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPlaceApplicableTradeLocation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeLocationType }
     * 
     * 
     * @return
     *     The value of the placeApplicableTradeLocation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeLocationType> getPlaceApplicableTradeLocation() {
        if (placeApplicableTradeLocation == null) {
            placeApplicableTradeLocation = new ArrayList<>();
        }
        return this.placeApplicableTradeLocation;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TradeTaxType rhs = ((TradeTaxType) o);
        if (!EqualsHelper.equalsCollection(allowanceChargeBasisAmount, rhs.allowanceChargeBasisAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(basisAmount, rhs.basisAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(basisQuantity, rhs.basisQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerDeductibleTaxSpecifiedTradeAccountingAccount, rhs.buyerDeductibleTaxSpecifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerNonDeductibleTaxSpecifiedTradeAccountingAccount, rhs.buyerNonDeductibleTaxSpecifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerRepayableTaxSpecifiedTradeAccountingAccount, rhs.buyerRepayableTaxSpecifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(calculatedAmount, rhs.calculatedAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(calculatedRate, rhs.calculatedRate)) {
            return false;
        }
        if (!EqualsHelper.equals(calculationSequenceNumeric, rhs.calculationSequenceNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(categoryCode, rhs.categoryCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(categoryName, rhs.categoryName)) {
            return false;
        }
        if (!EqualsHelper.equals(currencyCode, rhs.currencyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(customsDutyIndicator, rhs.customsDutyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(dueDateTypeCode, rhs.dueDateTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(exemptionReason, rhs.exemptionReason)) {
            return false;
        }
        if (!EqualsHelper.equals(exemptionReasonCode, rhs.exemptionReasonCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(informationAmount, rhs.informationAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(jurisdiction, rhs.jurisdiction)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(lineTotalBasisAmount, rhs.lineTotalBasisAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(placeApplicableTradeLocation, rhs.placeApplicableTradeLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(rateApplicablePercent, rhs.rateApplicablePercent)) {
            return false;
        }
        if (!EqualsHelper.equals(sellerPayableTaxSpecifiedTradeAccountingAccount, rhs.sellerPayableTaxSpecifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(sellerRefundableTaxSpecifiedTradeAccountingAccount, rhs.sellerRefundableTaxSpecifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(serviceSupplyTradeCountry, rhs.serviceSupplyTradeCountry)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedTradeAccountingAccount, rhs.specifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(taxBasisAllowanceRate, rhs.taxBasisAllowanceRate)) {
            return false;
        }
        if (!EqualsHelper.equals(taxPointDate, rhs.taxPointDate)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(unitBasisAmount, rhs.unitBasisAmount)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(allowanceChargeBasisAmount).append(basisAmount).append(basisQuantity).append(buyerDeductibleTaxSpecifiedTradeAccountingAccount).append(buyerNonDeductibleTaxSpecifiedTradeAccountingAccount).append(buyerRepayableTaxSpecifiedTradeAccountingAccount).append(calculatedAmount).append(calculatedRate).append(calculationSequenceNumeric).append(categoryCode).append(categoryName).append(currencyCode).append(customsDutyIndicator).append(dueDateTypeCode).append(exemptionReason).append(exemptionReasonCode).append(informationAmount).append(jurisdiction).append(lineTotalBasisAmount).append(placeApplicableTradeLocation).append(rateApplicablePercent).append(sellerPayableTaxSpecifiedTradeAccountingAccount).append(sellerRefundableTaxSpecifiedTradeAccountingAccount).append(serviceSupplyTradeCountry).append(specifiedTradeAccountingAccount).append(taxBasisAllowanceRate).append(taxPointDate).append(type).append(typeCode).append(unitBasisAmount).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("allowanceChargeBasisAmount", allowanceChargeBasisAmount).append("basisAmount", basisAmount).append("basisQuantity", basisQuantity).append("buyerDeductibleTaxSpecifiedTradeAccountingAccount", buyerDeductibleTaxSpecifiedTradeAccountingAccount).append("buyerNonDeductibleTaxSpecifiedTradeAccountingAccount", buyerNonDeductibleTaxSpecifiedTradeAccountingAccount).append("buyerRepayableTaxSpecifiedTradeAccountingAccount", buyerRepayableTaxSpecifiedTradeAccountingAccount).append("calculatedAmount", calculatedAmount).append("calculatedRate", calculatedRate).append("calculationSequenceNumeric", calculationSequenceNumeric).append("categoryCode", categoryCode).append("categoryName", categoryName).append("currencyCode", currencyCode).append("customsDutyIndicator", customsDutyIndicator).append("dueDateTypeCode", dueDateTypeCode).append("exemptionReason", exemptionReason).append("exemptionReasonCode", exemptionReasonCode).append("informationAmount", informationAmount).append("jurisdiction", jurisdiction).append("lineTotalBasisAmount", lineTotalBasisAmount).append("placeApplicableTradeLocation", placeApplicableTradeLocation).append("rateApplicablePercent", rateApplicablePercent).append("sellerPayableTaxSpecifiedTradeAccountingAccount", sellerPayableTaxSpecifiedTradeAccountingAccount).append("sellerRefundableTaxSpecifiedTradeAccountingAccount", sellerRefundableTaxSpecifiedTradeAccountingAccount).append("serviceSupplyTradeCountry", serviceSupplyTradeCountry).append("specifiedTradeAccountingAccount", specifiedTradeAccountingAccount).append("taxBasisAllowanceRate", taxBasisAllowanceRate).append("taxPointDate", taxPointDate).append("type", type).append("typeCode", typeCode).append("unitBasisAmount", unitBasisAmount).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCalculatedAmount(
        @Nullable
        final List<AmountType> aList) {
        calculatedAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBasisAmount(
        @Nullable
        final List<AmountType> aList) {
        basisAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUnitBasisAmount(
        @Nullable
        final List<AmountType> aList) {
        unitBasisAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLineTotalBasisAmount(
        @Nullable
        final List<AmountType> aList) {
        lineTotalBasisAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAllowanceChargeBasisAmount(
        @Nullable
        final List<AmountType> aList) {
        allowanceChargeBasisAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setJurisdiction(
        @Nullable
        final List<TextType> aList) {
        jurisdiction = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInformationAmount(
        @Nullable
        final List<AmountType> aList) {
        informationAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCategoryName(
        @Nullable
        final List<TextType> aList) {
        categoryName = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedTradeAccountingAccount(
        @Nullable
        final List<TradeAccountingAccountType> aList) {
        specifiedTradeAccountingAccount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPlaceApplicableTradeLocation(
        @Nullable
        final List<TradeLocationType> aList) {
        placeApplicableTradeLocation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCalculatedAmountEntries() {
        return (!getCalculatedAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCalculatedAmountEntries() {
        return getCalculatedAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCalculatedAmountCount() {
        return getCalculatedAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getCalculatedAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCalculatedAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCalculatedAmount(
        @Nonnull
        final AmountType elem) {
        getCalculatedAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBasisAmountEntries() {
        return (!getBasisAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBasisAmountEntries() {
        return getBasisAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBasisAmountCount() {
        return getBasisAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getBasisAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBasisAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBasisAmount(
        @Nonnull
        final AmountType elem) {
        getBasisAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUnitBasisAmountEntries() {
        return (!getUnitBasisAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUnitBasisAmountEntries() {
        return getUnitBasisAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUnitBasisAmountCount() {
        return getUnitBasisAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getUnitBasisAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUnitBasisAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUnitBasisAmount(
        @Nonnull
        final AmountType elem) {
        getUnitBasisAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLineTotalBasisAmountEntries() {
        return (!getLineTotalBasisAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLineTotalBasisAmountEntries() {
        return getLineTotalBasisAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLineTotalBasisAmountCount() {
        return getLineTotalBasisAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getLineTotalBasisAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLineTotalBasisAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLineTotalBasisAmount(
        @Nonnull
        final AmountType elem) {
        getLineTotalBasisAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAllowanceChargeBasisAmountEntries() {
        return (!getAllowanceChargeBasisAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAllowanceChargeBasisAmountEntries() {
        return getAllowanceChargeBasisAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAllowanceChargeBasisAmountCount() {
        return getAllowanceChargeBasisAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getAllowanceChargeBasisAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAllowanceChargeBasisAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAllowanceChargeBasisAmount(
        @Nonnull
        final AmountType elem) {
        getAllowanceChargeBasisAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasJurisdictionEntries() {
        return (!getJurisdiction().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoJurisdictionEntries() {
        return getJurisdiction().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getJurisdictionCount() {
        return getJurisdiction().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getJurisdictionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getJurisdiction().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addJurisdiction(
        @Nonnull
        final TextType elem) {
        getJurisdiction().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInformationAmountEntries() {
        return (!getInformationAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInformationAmountEntries() {
        return getInformationAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInformationAmountCount() {
        return getInformationAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getInformationAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInformationAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInformationAmount(
        @Nonnull
        final AmountType elem) {
        getInformationAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCategoryNameEntries() {
        return (!getCategoryName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCategoryNameEntries() {
        return getCategoryName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCategoryNameCount() {
        return getCategoryName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getCategoryNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCategoryName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCategoryName(
        @Nonnull
        final TextType elem) {
        getCategoryName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedTradeAccountingAccountEntries() {
        return (!getSpecifiedTradeAccountingAccount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedTradeAccountingAccountEntries() {
        return getSpecifiedTradeAccountingAccount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedTradeAccountingAccountCount() {
        return getSpecifiedTradeAccountingAccount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeAccountingAccountType getSpecifiedTradeAccountingAccountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedTradeAccountingAccount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedTradeAccountingAccount(
        @Nonnull
        final TradeAccountingAccountType elem) {
        getSpecifiedTradeAccountingAccount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPlaceApplicableTradeLocationEntries() {
        return (!getPlaceApplicableTradeLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPlaceApplicableTradeLocationEntries() {
        return getPlaceApplicableTradeLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPlaceApplicableTradeLocationCount() {
        return getPlaceApplicableTradeLocation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeLocationType getPlaceApplicableTradeLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPlaceApplicableTradeLocation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPlaceApplicableTradeLocation(
        @Nonnull
        final TradeLocationType elem) {
        getPlaceApplicableTradeLocation().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TradeTaxType ret) {
        if (allowanceChargeBasisAmount == null) {
            ret.allowanceChargeBasisAmount = null;
        } else {
            List<AmountType> retAllowanceChargeBasisAmount = new ArrayList<>();
            for (AmountType aItem: getAllowanceChargeBasisAmount()) {
                retAllowanceChargeBasisAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.allowanceChargeBasisAmount = retAllowanceChargeBasisAmount;
        }
        if (basisAmount == null) {
            ret.basisAmount = null;
        } else {
            List<AmountType> retBasisAmount = new ArrayList<>();
            for (AmountType aItem: getBasisAmount()) {
                retBasisAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.basisAmount = retBasisAmount;
        }
        ret.basisQuantity = ((basisQuantity == null)?null:basisQuantity.clone());
        ret.buyerDeductibleTaxSpecifiedTradeAccountingAccount = ((buyerDeductibleTaxSpecifiedTradeAccountingAccount == null)?null:buyerDeductibleTaxSpecifiedTradeAccountingAccount.clone());
        ret.buyerNonDeductibleTaxSpecifiedTradeAccountingAccount = ((buyerNonDeductibleTaxSpecifiedTradeAccountingAccount == null)?null:buyerNonDeductibleTaxSpecifiedTradeAccountingAccount.clone());
        ret.buyerRepayableTaxSpecifiedTradeAccountingAccount = ((buyerRepayableTaxSpecifiedTradeAccountingAccount == null)?null:buyerRepayableTaxSpecifiedTradeAccountingAccount.clone());
        if (calculatedAmount == null) {
            ret.calculatedAmount = null;
        } else {
            List<AmountType> retCalculatedAmount = new ArrayList<>();
            for (AmountType aItem: getCalculatedAmount()) {
                retCalculatedAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.calculatedAmount = retCalculatedAmount;
        }
        ret.calculatedRate = ((calculatedRate == null)?null:calculatedRate.clone());
        ret.calculationSequenceNumeric = ((calculationSequenceNumeric == null)?null:calculationSequenceNumeric.clone());
        ret.categoryCode = ((categoryCode == null)?null:categoryCode.clone());
        if (categoryName == null) {
            ret.categoryName = null;
        } else {
            List<TextType> retCategoryName = new ArrayList<>();
            for (TextType aItem: getCategoryName()) {
                retCategoryName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.categoryName = retCategoryName;
        }
        ret.currencyCode = ((currencyCode == null)?null:currencyCode.clone());
        ret.customsDutyIndicator = ((customsDutyIndicator == null)?null:customsDutyIndicator.clone());
        ret.dueDateTypeCode = ((dueDateTypeCode == null)?null:dueDateTypeCode.clone());
        ret.exemptionReason = ((exemptionReason == null)?null:exemptionReason.clone());
        ret.exemptionReasonCode = ((exemptionReasonCode == null)?null:exemptionReasonCode.clone());
        if (informationAmount == null) {
            ret.informationAmount = null;
        } else {
            List<AmountType> retInformationAmount = new ArrayList<>();
            for (AmountType aItem: getInformationAmount()) {
                retInformationAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.informationAmount = retInformationAmount;
        }
        if (jurisdiction == null) {
            ret.jurisdiction = null;
        } else {
            List<TextType> retJurisdiction = new ArrayList<>();
            for (TextType aItem: getJurisdiction()) {
                retJurisdiction.add(((aItem == null)?null:aItem.clone()));
            }
            ret.jurisdiction = retJurisdiction;
        }
        if (lineTotalBasisAmount == null) {
            ret.lineTotalBasisAmount = null;
        } else {
            List<AmountType> retLineTotalBasisAmount = new ArrayList<>();
            for (AmountType aItem: getLineTotalBasisAmount()) {
                retLineTotalBasisAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.lineTotalBasisAmount = retLineTotalBasisAmount;
        }
        if (placeApplicableTradeLocation == null) {
            ret.placeApplicableTradeLocation = null;
        } else {
            List<TradeLocationType> retPlaceApplicableTradeLocation = new ArrayList<>();
            for (TradeLocationType aItem: getPlaceApplicableTradeLocation()) {
                retPlaceApplicableTradeLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.placeApplicableTradeLocation = retPlaceApplicableTradeLocation;
        }
        ret.rateApplicablePercent = ((rateApplicablePercent == null)?null:rateApplicablePercent.clone());
        ret.sellerPayableTaxSpecifiedTradeAccountingAccount = ((sellerPayableTaxSpecifiedTradeAccountingAccount == null)?null:sellerPayableTaxSpecifiedTradeAccountingAccount.clone());
        ret.sellerRefundableTaxSpecifiedTradeAccountingAccount = ((sellerRefundableTaxSpecifiedTradeAccountingAccount == null)?null:sellerRefundableTaxSpecifiedTradeAccountingAccount.clone());
        ret.serviceSupplyTradeCountry = ((serviceSupplyTradeCountry == null)?null:serviceSupplyTradeCountry.clone());
        if (specifiedTradeAccountingAccount == null) {
            ret.specifiedTradeAccountingAccount = null;
        } else {
            List<TradeAccountingAccountType> retSpecifiedTradeAccountingAccount = new ArrayList<>();
            for (TradeAccountingAccountType aItem: getSpecifiedTradeAccountingAccount()) {
                retSpecifiedTradeAccountingAccount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedTradeAccountingAccount = retSpecifiedTradeAccountingAccount;
        }
        ret.taxBasisAllowanceRate = ((taxBasisAllowanceRate == null)?null:taxBasisAllowanceRate.clone());
        ret.taxPointDate = ((taxPointDate == null)?null:taxPointDate.clone());
        ret.type = ((type == null)?null:type.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        if (unitBasisAmount == null) {
            ret.unitBasisAmount = null;
        } else {
            List<AmountType> retUnitBasisAmount = new ArrayList<>();
            for (AmountType aItem: getUnitBasisAmount()) {
                retUnitBasisAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.unitBasisAmount = retUnitBasisAmount;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TradeTaxType clone() {
        TradeTaxType ret = new TradeTaxType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TaxTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public TaxTypeCodeType setTypeCode(
        @Nullable
        final String valueParam) {
        TaxTypeCodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new TaxTypeCodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setExemptionReason(
        @Nullable
        final String valueParam) {
        TextType aObj = getExemptionReason();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setExemptionReason(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RateType and never <code>null</code>
     */
    @Nonnull
    public RateType setCalculatedRate(
        @Nullable
        final BigDecimal valueParam) {
        RateType aObj = getCalculatedRate();
        if (aObj == null) {
            aObj = new RateType(valueParam);
            setCalculatedRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NumericType and never <code>null</code>
     */
    @Nonnull
    public NumericType setCalculationSequenceNumeric(
        @Nullable
        final BigDecimal valueParam) {
        NumericType aObj = getCalculationSequenceNumeric();
        if (aObj == null) {
            aObj = new NumericType(valueParam);
            setCalculationSequenceNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setBasisQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getBasisQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setBasisQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TaxCategoryCodeType and never <code>null</code>
     */
    @Nonnull
    public TaxCategoryCodeType setCategoryCode(
        @Nullable
        final String valueParam) {
        TaxCategoryCodeType aObj = getCategoryCode();
        if (aObj == null) {
            aObj = new TaxCategoryCodeType(valueParam);
            setCategoryCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CurrencyCodeType and never <code>null</code>
     */
    @Nonnull
    public CurrencyCodeType setCurrencyCode(
        @Nullable
        final String valueParam) {
        CurrencyCodeType aObj = getCurrencyCode();
        if (aObj == null) {
            aObj = new CurrencyCodeType(valueParam);
            setCurrencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setExemptionReasonCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getExemptionReasonCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setExemptionReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RateType and never <code>null</code>
     */
    @Nonnull
    public RateType setTaxBasisAllowanceRate(
        @Nullable
        final BigDecimal valueParam) {
        RateType aObj = getTaxBasisAllowanceRate();
        if (aObj == null) {
            aObj = new RateType(valueParam);
            setTaxBasisAllowanceRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setType(
        @Nullable
        final String valueParam) {
        TextType aObj = getType();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TimeReferenceCodeType and never <code>null</code>
     */
    @Nonnull
    public TimeReferenceCodeType setDueDateTypeCode(
        @Nullable
        final String valueParam) {
        TimeReferenceCodeType aObj = getDueDateTypeCode();
        if (aObj == null) {
            aObj = new TimeReferenceCodeType(valueParam);
            setDueDateTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PercentType and never <code>null</code>
     */
    @Nonnull
    public PercentType setRateApplicablePercent(
        @Nullable
        final BigDecimal valueParam) {
        PercentType aObj = getRateApplicablePercent();
        if (aObj == null) {
            aObj = new PercentType(valueParam);
            setRateApplicablePercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TaxTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TaxTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        TaxTypeCodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getExemptionReasonValue() {
        TextType aObj = getExemptionReason();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RateType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCalculatedRateValue() {
        RateType aObj = getCalculatedRate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCalculationSequenceNumericValue() {
        NumericType aObj = getCalculationSequenceNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getBasisQuantityValue() {
        QuantityType aObj = getBasisQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TaxCategoryCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TaxCategoryCodeType object or <code>null</code>
     */
    @Nullable
    public String getCategoryCodeValue() {
        TaxCategoryCodeType aObj = getCategoryCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CurrencyCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CurrencyCodeType object or <code>null</code>
     */
    @Nullable
    public String getCurrencyCodeValue() {
        CurrencyCodeType aObj = getCurrencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getExemptionReasonCodeValue() {
        CodeType aObj = getExemptionReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RateType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTaxBasisAllowanceRateValue() {
        RateType aObj = getTaxBasisAllowanceRate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getTypeValue() {
        TextType aObj = getType();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TimeReferenceCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TimeReferenceCodeType object or <code>null</code>
     */
    @Nullable
    public String getDueDateTypeCodeValue() {
        TimeReferenceCodeType aObj = getDueDateTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getRateApplicablePercentValue() {
        PercentType aObj = getRateApplicablePercent();
        return (aObj == null)?null:aObj.getValue();
    }

}
