
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.CurrencyCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for ValuationBreakdownStatementType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ValuationBreakdownStatementType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType"/>
 *         <element name="Name" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="MeasurementMethodID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CreationDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType"/>
 *         <element name="DefaultCurrencyCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}CurrencyCodeType"/>
 *         <element name="DefaultLanguageCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType"/>
 *         <element name="Comment" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="RequestedActionCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PriceListID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="ContractualLanguageCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="ItemGroupedWorkItem" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}GroupedWorkItemType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ItemBasicWorkItem" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}BasicWorkItemType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalCalculatedPrice" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}CalculatedPriceType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ChangedRecordedStatus" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}RecordedStatusType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CreationSpecifiedBinaryFile" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedBinaryFileType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ReaderSpecifiedBinaryFile" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedBinaryFileType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ReferencedSpecifiedBinaryFile" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedBinaryFileType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ValuationBreakdownStatementType", propOrder = {
    "id",
    "name",
    "description",
    "measurementMethodID",
    "creationDateTime",
    "defaultCurrencyCode",
    "defaultLanguageCode",
    "comment",
    "typeCode",
    "requestedActionCode",
    "priceListID",
    "contractualLanguageCode",
    "itemGroupedWorkItem",
    "itemBasicWorkItem",
    "totalCalculatedPrice",
    "changedRecordedStatus",
    "creationSpecifiedBinaryFile",
    "readerSpecifiedBinaryFile",
    "referencedSpecifiedBinaryFile"
})
@CodingStyleguideUnaware
public class ValuationBreakdownStatementType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", required = true)
    private IDType id;
    @XmlElement(name = "Name", required = true)
    private TextType name;
    @XmlElement(name = "Description")
    private List<TextType> description;
    @XmlElement(name = "MeasurementMethodID")
    private List<IDType> measurementMethodID;
    @XmlElement(name = "CreationDateTime", required = true)
    private DateTimeType creationDateTime;
    @XmlElement(name = "DefaultCurrencyCode", required = true)
    private CurrencyCodeType defaultCurrencyCode;
    @XmlElement(name = "DefaultLanguageCode", required = true)
    private CodeType defaultLanguageCode;
    @XmlElement(name = "Comment")
    private List<TextType> comment;
    @XmlElement(name = "TypeCode")
    private List<CodeType> typeCode;
    @XmlElement(name = "RequestedActionCode")
    private List<CodeType> requestedActionCode;
    @XmlElement(name = "PriceListID")
    private IDType priceListID;
    @XmlElement(name = "ContractualLanguageCode")
    private CodeType contractualLanguageCode;
    @XmlElement(name = "ItemGroupedWorkItem")
    private List<GroupedWorkItemType> itemGroupedWorkItem;
    @XmlElement(name = "ItemBasicWorkItem")
    private List<BasicWorkItemType> itemBasicWorkItem;
    @XmlElement(name = "TotalCalculatedPrice")
    private List<CalculatedPriceType> totalCalculatedPrice;
    @XmlElement(name = "ChangedRecordedStatus")
    private List<RecordedStatusType> changedRecordedStatus;
    @XmlElement(name = "CreationSpecifiedBinaryFile")
    private List<SpecifiedBinaryFileType> creationSpecifiedBinaryFile;
    @XmlElement(name = "ReaderSpecifiedBinaryFile")
    private List<SpecifiedBinaryFileType> readerSpecifiedBinaryFile;
    @XmlElement(name = "ReferencedSpecifiedBinaryFile")
    private List<SpecifiedBinaryFileType> referencedSpecifiedBinaryFile;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ValuationBreakdownStatementType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setName(
        @Nullable
        TextType value) {
        this.name = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the measurementMethodID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the measurementMethodID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMeasurementMethodID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     * @return
     *     The value of the measurementMethodID property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getMeasurementMethodID() {
        if (measurementMethodID == null) {
            measurementMethodID = new ArrayList<>();
        }
        return this.measurementMethodID;
    }

    /**
     * Gets the value of the creationDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getCreationDateTime() {
        return creationDateTime;
    }

    /**
     * Sets the value of the creationDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setCreationDateTime(
        @Nullable
        DateTimeType value) {
        this.creationDateTime = value;
    }

    /**
     * Gets the value of the defaultCurrencyCode property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyCodeType }
     *     
     */
    @Nullable
    public CurrencyCodeType getDefaultCurrencyCode() {
        return defaultCurrencyCode;
    }

    /**
     * Sets the value of the defaultCurrencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyCodeType }
     *     
     */
    public void setDefaultCurrencyCode(
        @Nullable
        CurrencyCodeType value) {
        this.defaultCurrencyCode = value;
    }

    /**
     * Gets the value of the defaultLanguageCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getDefaultLanguageCode() {
        return defaultLanguageCode;
    }

    /**
     * Sets the value of the defaultLanguageCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setDefaultLanguageCode(
        @Nullable
        CodeType value) {
        this.defaultLanguageCode = value;
    }

    /**
     * Gets the value of the comment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the comment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getComment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the comment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getComment() {
        if (comment == null) {
            comment = new ArrayList<>();
        }
        return this.comment;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the typeCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTypeCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the typeCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getTypeCode() {
        if (typeCode == null) {
            typeCode = new ArrayList<>();
        }
        return this.typeCode;
    }

    /**
     * Gets the value of the requestedActionCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the requestedActionCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRequestedActionCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the requestedActionCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getRequestedActionCode() {
        if (requestedActionCode == null) {
            requestedActionCode = new ArrayList<>();
        }
        return this.requestedActionCode;
    }

    /**
     * Gets the value of the priceListID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getPriceListID() {
        return priceListID;
    }

    /**
     * Sets the value of the priceListID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setPriceListID(
        @Nullable
        IDType value) {
        this.priceListID = value;
    }

    /**
     * Gets the value of the contractualLanguageCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getContractualLanguageCode() {
        return contractualLanguageCode;
    }

    /**
     * Sets the value of the contractualLanguageCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setContractualLanguageCode(
        @Nullable
        CodeType value) {
        this.contractualLanguageCode = value;
    }

    /**
     * Gets the value of the itemGroupedWorkItem property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the itemGroupedWorkItem property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemGroupedWorkItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GroupedWorkItemType }
     * 
     * 
     * @return
     *     The value of the itemGroupedWorkItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GroupedWorkItemType> getItemGroupedWorkItem() {
        if (itemGroupedWorkItem == null) {
            itemGroupedWorkItem = new ArrayList<>();
        }
        return this.itemGroupedWorkItem;
    }

    /**
     * Gets the value of the itemBasicWorkItem property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the itemBasicWorkItem property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemBasicWorkItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BasicWorkItemType }
     * 
     * 
     * @return
     *     The value of the itemBasicWorkItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BasicWorkItemType> getItemBasicWorkItem() {
        if (itemBasicWorkItem == null) {
            itemBasicWorkItem = new ArrayList<>();
        }
        return this.itemBasicWorkItem;
    }

    /**
     * Gets the value of the totalCalculatedPrice property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the totalCalculatedPrice property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalCalculatedPrice().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CalculatedPriceType }
     * 
     * 
     * @return
     *     The value of the totalCalculatedPrice property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CalculatedPriceType> getTotalCalculatedPrice() {
        if (totalCalculatedPrice == null) {
            totalCalculatedPrice = new ArrayList<>();
        }
        return this.totalCalculatedPrice;
    }

    /**
     * Gets the value of the changedRecordedStatus property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the changedRecordedStatus property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getChangedRecordedStatus().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RecordedStatusType }
     * 
     * 
     * @return
     *     The value of the changedRecordedStatus property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RecordedStatusType> getChangedRecordedStatus() {
        if (changedRecordedStatus == null) {
            changedRecordedStatus = new ArrayList<>();
        }
        return this.changedRecordedStatus;
    }

    /**
     * Gets the value of the creationSpecifiedBinaryFile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the creationSpecifiedBinaryFile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCreationSpecifiedBinaryFile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpecifiedBinaryFileType }
     * 
     * 
     * @return
     *     The value of the creationSpecifiedBinaryFile property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SpecifiedBinaryFileType> getCreationSpecifiedBinaryFile() {
        if (creationSpecifiedBinaryFile == null) {
            creationSpecifiedBinaryFile = new ArrayList<>();
        }
        return this.creationSpecifiedBinaryFile;
    }

    /**
     * Gets the value of the readerSpecifiedBinaryFile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the readerSpecifiedBinaryFile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReaderSpecifiedBinaryFile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpecifiedBinaryFileType }
     * 
     * 
     * @return
     *     The value of the readerSpecifiedBinaryFile property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SpecifiedBinaryFileType> getReaderSpecifiedBinaryFile() {
        if (readerSpecifiedBinaryFile == null) {
            readerSpecifiedBinaryFile = new ArrayList<>();
        }
        return this.readerSpecifiedBinaryFile;
    }

    /**
     * Gets the value of the referencedSpecifiedBinaryFile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the referencedSpecifiedBinaryFile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReferencedSpecifiedBinaryFile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpecifiedBinaryFileType }
     * 
     * 
     * @return
     *     The value of the referencedSpecifiedBinaryFile property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SpecifiedBinaryFileType> getReferencedSpecifiedBinaryFile() {
        if (referencedSpecifiedBinaryFile == null) {
            referencedSpecifiedBinaryFile = new ArrayList<>();
        }
        return this.referencedSpecifiedBinaryFile;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ValuationBreakdownStatementType rhs = ((ValuationBreakdownStatementType) o);
        if (!EqualsHelper.equalsCollection(changedRecordedStatus, rhs.changedRecordedStatus)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(comment, rhs.comment)) {
            return false;
        }
        if (!EqualsHelper.equals(contractualLanguageCode, rhs.contractualLanguageCode)) {
            return false;
        }
        if (!EqualsHelper.equals(creationDateTime, rhs.creationDateTime)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(creationSpecifiedBinaryFile, rhs.creationSpecifiedBinaryFile)) {
            return false;
        }
        if (!EqualsHelper.equals(defaultCurrencyCode, rhs.defaultCurrencyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(defaultLanguageCode, rhs.defaultLanguageCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(itemBasicWorkItem, rhs.itemBasicWorkItem)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(itemGroupedWorkItem, rhs.itemGroupedWorkItem)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(measurementMethodID, rhs.measurementMethodID)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equals(priceListID, rhs.priceListID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(readerSpecifiedBinaryFile, rhs.readerSpecifiedBinaryFile)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(referencedSpecifiedBinaryFile, rhs.referencedSpecifiedBinaryFile)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requestedActionCode, rhs.requestedActionCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(totalCalculatedPrice, rhs.totalCalculatedPrice)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(typeCode, rhs.typeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(changedRecordedStatus).append(comment).append(contractualLanguageCode).append(creationDateTime).append(creationSpecifiedBinaryFile).append(defaultCurrencyCode).append(defaultLanguageCode).append(description).append(id).append(itemBasicWorkItem).append(itemGroupedWorkItem).append(measurementMethodID).append(name).append(priceListID).append(readerSpecifiedBinaryFile).append(referencedSpecifiedBinaryFile).append(requestedActionCode).append(totalCalculatedPrice).append(typeCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("changedRecordedStatus", changedRecordedStatus).append("comment", comment).append("contractualLanguageCode", contractualLanguageCode).append("creationDateTime", creationDateTime).append("creationSpecifiedBinaryFile", creationSpecifiedBinaryFile).append("defaultCurrencyCode", defaultCurrencyCode).append("defaultLanguageCode", defaultLanguageCode).append("description", description).append("id", id).append("itemBasicWorkItem", itemBasicWorkItem).append("itemGroupedWorkItem", itemGroupedWorkItem).append("measurementMethodID", measurementMethodID).append("name", name).append("priceListID", priceListID).append("readerSpecifiedBinaryFile", readerSpecifiedBinaryFile).append("referencedSpecifiedBinaryFile", referencedSpecifiedBinaryFile).append("requestedActionCode", requestedActionCode).append("totalCalculatedPrice", totalCalculatedPrice).append("typeCode", typeCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<TextType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMeasurementMethodID(
        @Nullable
        final List<IDType> aList) {
        measurementMethodID = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setComment(
        @Nullable
        final List<TextType> aList) {
        comment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTypeCode(
        @Nullable
        final List<CodeType> aList) {
        typeCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequestedActionCode(
        @Nullable
        final List<CodeType> aList) {
        requestedActionCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItemGroupedWorkItem(
        @Nullable
        final List<GroupedWorkItemType> aList) {
        itemGroupedWorkItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItemBasicWorkItem(
        @Nullable
        final List<BasicWorkItemType> aList) {
        itemBasicWorkItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTotalCalculatedPrice(
        @Nullable
        final List<CalculatedPriceType> aList) {
        totalCalculatedPrice = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setChangedRecordedStatus(
        @Nullable
        final List<RecordedStatusType> aList) {
        changedRecordedStatus = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCreationSpecifiedBinaryFile(
        @Nullable
        final List<SpecifiedBinaryFileType> aList) {
        creationSpecifiedBinaryFile = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReaderSpecifiedBinaryFile(
        @Nullable
        final List<SpecifiedBinaryFileType> aList) {
        readerSpecifiedBinaryFile = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReferencedSpecifiedBinaryFile(
        @Nullable
        final List<SpecifiedBinaryFileType> aList) {
        referencedSpecifiedBinaryFile = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final TextType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMeasurementMethodIDEntries() {
        return (!getMeasurementMethodID().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMeasurementMethodIDEntries() {
        return getMeasurementMethodID().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMeasurementMethodIDCount() {
        return getMeasurementMethodID().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getMeasurementMethodIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMeasurementMethodID().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMeasurementMethodID(
        @Nonnull
        final IDType elem) {
        getMeasurementMethodID().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommentEntries() {
        return (!getComment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommentEntries() {
        return getComment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommentCount() {
        return getComment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getCommentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getComment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addComment(
        @Nonnull
        final TextType elem) {
        getComment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTypeCodeEntries() {
        return (!getTypeCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTypeCodeEntries() {
        return getTypeCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTypeCodeCount() {
        return getTypeCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getTypeCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTypeCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTypeCode(
        @Nonnull
        final CodeType elem) {
        getTypeCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequestedActionCodeEntries() {
        return (!getRequestedActionCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequestedActionCodeEntries() {
        return getRequestedActionCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequestedActionCodeCount() {
        return getRequestedActionCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getRequestedActionCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequestedActionCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequestedActionCode(
        @Nonnull
        final CodeType elem) {
        getRequestedActionCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemGroupedWorkItemEntries() {
        return (!getItemGroupedWorkItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemGroupedWorkItemEntries() {
        return getItemGroupedWorkItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemGroupedWorkItemCount() {
        return getItemGroupedWorkItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GroupedWorkItemType getItemGroupedWorkItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItemGroupedWorkItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItemGroupedWorkItem(
        @Nonnull
        final GroupedWorkItemType elem) {
        getItemGroupedWorkItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemBasicWorkItemEntries() {
        return (!getItemBasicWorkItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemBasicWorkItemEntries() {
        return getItemBasicWorkItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemBasicWorkItemCount() {
        return getItemBasicWorkItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BasicWorkItemType getItemBasicWorkItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItemBasicWorkItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItemBasicWorkItem(
        @Nonnull
        final BasicWorkItemType elem) {
        getItemBasicWorkItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTotalCalculatedPriceEntries() {
        return (!getTotalCalculatedPrice().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTotalCalculatedPriceEntries() {
        return getTotalCalculatedPrice().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTotalCalculatedPriceCount() {
        return getTotalCalculatedPrice().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CalculatedPriceType getTotalCalculatedPriceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTotalCalculatedPrice().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTotalCalculatedPrice(
        @Nonnull
        final CalculatedPriceType elem) {
        getTotalCalculatedPrice().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasChangedRecordedStatusEntries() {
        return (!getChangedRecordedStatus().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoChangedRecordedStatusEntries() {
        return getChangedRecordedStatus().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getChangedRecordedStatusCount() {
        return getChangedRecordedStatus().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RecordedStatusType getChangedRecordedStatusAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getChangedRecordedStatus().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addChangedRecordedStatus(
        @Nonnull
        final RecordedStatusType elem) {
        getChangedRecordedStatus().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCreationSpecifiedBinaryFileEntries() {
        return (!getCreationSpecifiedBinaryFile().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCreationSpecifiedBinaryFileEntries() {
        return getCreationSpecifiedBinaryFile().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCreationSpecifiedBinaryFileCount() {
        return getCreationSpecifiedBinaryFile().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SpecifiedBinaryFileType getCreationSpecifiedBinaryFileAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCreationSpecifiedBinaryFile().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCreationSpecifiedBinaryFile(
        @Nonnull
        final SpecifiedBinaryFileType elem) {
        getCreationSpecifiedBinaryFile().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReaderSpecifiedBinaryFileEntries() {
        return (!getReaderSpecifiedBinaryFile().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReaderSpecifiedBinaryFileEntries() {
        return getReaderSpecifiedBinaryFile().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReaderSpecifiedBinaryFileCount() {
        return getReaderSpecifiedBinaryFile().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SpecifiedBinaryFileType getReaderSpecifiedBinaryFileAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReaderSpecifiedBinaryFile().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReaderSpecifiedBinaryFile(
        @Nonnull
        final SpecifiedBinaryFileType elem) {
        getReaderSpecifiedBinaryFile().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReferencedSpecifiedBinaryFileEntries() {
        return (!getReferencedSpecifiedBinaryFile().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReferencedSpecifiedBinaryFileEntries() {
        return getReferencedSpecifiedBinaryFile().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReferencedSpecifiedBinaryFileCount() {
        return getReferencedSpecifiedBinaryFile().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SpecifiedBinaryFileType getReferencedSpecifiedBinaryFileAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReferencedSpecifiedBinaryFile().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReferencedSpecifiedBinaryFile(
        @Nonnull
        final SpecifiedBinaryFileType elem) {
        getReferencedSpecifiedBinaryFile().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ValuationBreakdownStatementType ret) {
        if (changedRecordedStatus == null) {
            ret.changedRecordedStatus = null;
        } else {
            List<RecordedStatusType> retChangedRecordedStatus = new ArrayList<>();
            for (RecordedStatusType aItem: getChangedRecordedStatus()) {
                retChangedRecordedStatus.add(((aItem == null)?null:aItem.clone()));
            }
            ret.changedRecordedStatus = retChangedRecordedStatus;
        }
        if (comment == null) {
            ret.comment = null;
        } else {
            List<TextType> retComment = new ArrayList<>();
            for (TextType aItem: getComment()) {
                retComment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.comment = retComment;
        }
        ret.contractualLanguageCode = ((contractualLanguageCode == null)?null:contractualLanguageCode.clone());
        ret.creationDateTime = ((creationDateTime == null)?null:creationDateTime.clone());
        if (creationSpecifiedBinaryFile == null) {
            ret.creationSpecifiedBinaryFile = null;
        } else {
            List<SpecifiedBinaryFileType> retCreationSpecifiedBinaryFile = new ArrayList<>();
            for (SpecifiedBinaryFileType aItem: getCreationSpecifiedBinaryFile()) {
                retCreationSpecifiedBinaryFile.add(((aItem == null)?null:aItem.clone()));
            }
            ret.creationSpecifiedBinaryFile = retCreationSpecifiedBinaryFile;
        }
        ret.defaultCurrencyCode = ((defaultCurrencyCode == null)?null:defaultCurrencyCode.clone());
        ret.defaultLanguageCode = ((defaultLanguageCode == null)?null:defaultLanguageCode.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<TextType> retDescription = new ArrayList<>();
            for (TextType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.id = ((id == null)?null:id.clone());
        if (itemBasicWorkItem == null) {
            ret.itemBasicWorkItem = null;
        } else {
            List<BasicWorkItemType> retItemBasicWorkItem = new ArrayList<>();
            for (BasicWorkItemType aItem: getItemBasicWorkItem()) {
                retItemBasicWorkItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.itemBasicWorkItem = retItemBasicWorkItem;
        }
        if (itemGroupedWorkItem == null) {
            ret.itemGroupedWorkItem = null;
        } else {
            List<GroupedWorkItemType> retItemGroupedWorkItem = new ArrayList<>();
            for (GroupedWorkItemType aItem: getItemGroupedWorkItem()) {
                retItemGroupedWorkItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.itemGroupedWorkItem = retItemGroupedWorkItem;
        }
        if (measurementMethodID == null) {
            ret.measurementMethodID = null;
        } else {
            List<IDType> retMeasurementMethodID = new ArrayList<>();
            for (IDType aItem: getMeasurementMethodID()) {
                retMeasurementMethodID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.measurementMethodID = retMeasurementMethodID;
        }
        ret.name = ((name == null)?null:name.clone());
        ret.priceListID = ((priceListID == null)?null:priceListID.clone());
        if (readerSpecifiedBinaryFile == null) {
            ret.readerSpecifiedBinaryFile = null;
        } else {
            List<SpecifiedBinaryFileType> retReaderSpecifiedBinaryFile = new ArrayList<>();
            for (SpecifiedBinaryFileType aItem: getReaderSpecifiedBinaryFile()) {
                retReaderSpecifiedBinaryFile.add(((aItem == null)?null:aItem.clone()));
            }
            ret.readerSpecifiedBinaryFile = retReaderSpecifiedBinaryFile;
        }
        if (referencedSpecifiedBinaryFile == null) {
            ret.referencedSpecifiedBinaryFile = null;
        } else {
            List<SpecifiedBinaryFileType> retReferencedSpecifiedBinaryFile = new ArrayList<>();
            for (SpecifiedBinaryFileType aItem: getReferencedSpecifiedBinaryFile()) {
                retReferencedSpecifiedBinaryFile.add(((aItem == null)?null:aItem.clone()));
            }
            ret.referencedSpecifiedBinaryFile = retReferencedSpecifiedBinaryFile;
        }
        if (requestedActionCode == null) {
            ret.requestedActionCode = null;
        } else {
            List<CodeType> retRequestedActionCode = new ArrayList<>();
            for (CodeType aItem: getRequestedActionCode()) {
                retRequestedActionCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requestedActionCode = retRequestedActionCode;
        }
        if (totalCalculatedPrice == null) {
            ret.totalCalculatedPrice = null;
        } else {
            List<CalculatedPriceType> retTotalCalculatedPrice = new ArrayList<>();
            for (CalculatedPriceType aItem: getTotalCalculatedPrice()) {
                retTotalCalculatedPrice.add(((aItem == null)?null:aItem.clone()));
            }
            ret.totalCalculatedPrice = retTotalCalculatedPrice;
        }
        if (typeCode == null) {
            ret.typeCode = null;
        } else {
            List<CodeType> retTypeCode = new ArrayList<>();
            for (CodeType aItem: getTypeCode()) {
                retTypeCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.typeCode = retTypeCode;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ValuationBreakdownStatementType clone() {
        ValuationBreakdownStatementType ret = new ValuationBreakdownStatementType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setName(
        @Nullable
        final String valueParam) {
        TextType aObj = getName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CurrencyCodeType and never <code>null</code>
     */
    @Nonnull
    public CurrencyCodeType setDefaultCurrencyCode(
        @Nullable
        final String valueParam) {
        CurrencyCodeType aObj = getDefaultCurrencyCode();
        if (aObj == null) {
            aObj = new CurrencyCodeType(valueParam);
            setDefaultCurrencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setDefaultLanguageCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getDefaultLanguageCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setDefaultLanguageCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setPriceListID(
        @Nullable
        final String valueParam) {
        IDType aObj = getPriceListID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setPriceListID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setContractualLanguageCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getContractualLanguageCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setContractualLanguageCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getNameValue() {
        TextType aObj = getName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CurrencyCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CurrencyCodeType object or <code>null</code>
     */
    @Nullable
    public String getDefaultCurrencyCodeValue() {
        CurrencyCodeType aObj = getDefaultCurrencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getDefaultLanguageCodeValue() {
        CodeType aObj = getDefaultLanguageCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getPriceListIDValue() {
        IDType aObj = getPriceListID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getContractualLanguageCodeValue() {
        CodeType aObj = getContractualLanguageCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
