
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.PercentType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for WorkItemQuantityAnalysisType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="WorkItemQuantityAnalysisType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType"/>
 *         <element name="ActualQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="ActualQuantityPercent" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}PercentType" minOccurs="0"/>
 *         <element name="StatusCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="PrimaryClassificationCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AlternativeClassificationCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ContractualLanguageCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="ActualQuantityWorkItemDimension" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}WorkItemDimensionType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="BreakdownWorkItemQuantityAnalysis" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}WorkItemQuantityAnalysisType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ChangedRecordedStatus" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}RecordedStatusType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "WorkItemQuantityAnalysisType", propOrder = {
    "id",
    "actualQuantity",
    "description",
    "actualQuantityPercent",
    "statusCode",
    "typeCode",
    "primaryClassificationCode",
    "alternativeClassificationCode",
    "contractualLanguageCode",
    "actualQuantityWorkItemDimension",
    "breakdownWorkItemQuantityAnalysis",
    "changedRecordedStatus"
})
@CodingStyleguideUnaware
public class WorkItemQuantityAnalysisType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", required = true)
    private IDType id;
    @XmlElement(name = "ActualQuantity")
    private QuantityType actualQuantity;
    @XmlElement(name = "Description")
    private TextType description;
    @XmlElement(name = "ActualQuantityPercent")
    private PercentType actualQuantityPercent;
    @XmlElement(name = "StatusCode")
    private CodeType statusCode;
    @XmlElement(name = "TypeCode")
    private CodeType typeCode;
    @XmlElement(name = "PrimaryClassificationCode")
    private List<CodeType> primaryClassificationCode;
    @XmlElement(name = "AlternativeClassificationCode")
    private List<CodeType> alternativeClassificationCode;
    @XmlElement(name = "ContractualLanguageCode")
    private CodeType contractualLanguageCode;
    @XmlElement(name = "ActualQuantityWorkItemDimension")
    private List<WorkItemDimensionType> actualQuantityWorkItemDimension;
    @XmlElement(name = "BreakdownWorkItemQuantityAnalysis")
    private List<WorkItemQuantityAnalysisType> breakdownWorkItemQuantityAnalysis;
    @XmlElement(name = "ChangedRecordedStatus")
    private List<RecordedStatusType> changedRecordedStatus;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public WorkItemQuantityAnalysisType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the actualQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getActualQuantity() {
        return actualQuantity;
    }

    /**
     * Sets the value of the actualQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setActualQuantity(
        @Nullable
        QuantityType value) {
        this.actualQuantity = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setDescription(
        @Nullable
        TextType value) {
        this.description = value;
    }

    /**
     * Gets the value of the actualQuantityPercent property.
     * 
     * @return
     *     possible object is
     *     {@link PercentType }
     *     
     */
    @Nullable
    public PercentType getActualQuantityPercent() {
        return actualQuantityPercent;
    }

    /**
     * Sets the value of the actualQuantityPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link PercentType }
     *     
     */
    public void setActualQuantityPercent(
        @Nullable
        PercentType value) {
        this.actualQuantityPercent = value;
    }

    /**
     * Gets the value of the statusCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getStatusCode() {
        return statusCode;
    }

    /**
     * Sets the value of the statusCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setStatusCode(
        @Nullable
        CodeType value) {
        this.statusCode = value;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        CodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the primaryClassificationCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the primaryClassificationCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPrimaryClassificationCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the primaryClassificationCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getPrimaryClassificationCode() {
        if (primaryClassificationCode == null) {
            primaryClassificationCode = new ArrayList<>();
        }
        return this.primaryClassificationCode;
    }

    /**
     * Gets the value of the alternativeClassificationCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the alternativeClassificationCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAlternativeClassificationCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the alternativeClassificationCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getAlternativeClassificationCode() {
        if (alternativeClassificationCode == null) {
            alternativeClassificationCode = new ArrayList<>();
        }
        return this.alternativeClassificationCode;
    }

    /**
     * Gets the value of the contractualLanguageCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getContractualLanguageCode() {
        return contractualLanguageCode;
    }

    /**
     * Sets the value of the contractualLanguageCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setContractualLanguageCode(
        @Nullable
        CodeType value) {
        this.contractualLanguageCode = value;
    }

    /**
     * Gets the value of the actualQuantityWorkItemDimension property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the actualQuantityWorkItemDimension property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getActualQuantityWorkItemDimension().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkItemDimensionType }
     * 
     * 
     * @return
     *     The value of the actualQuantityWorkItemDimension property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WorkItemDimensionType> getActualQuantityWorkItemDimension() {
        if (actualQuantityWorkItemDimension == null) {
            actualQuantityWorkItemDimension = new ArrayList<>();
        }
        return this.actualQuantityWorkItemDimension;
    }

    /**
     * Gets the value of the breakdownWorkItemQuantityAnalysis property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the breakdownWorkItemQuantityAnalysis property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBreakdownWorkItemQuantityAnalysis().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkItemQuantityAnalysisType }
     * 
     * 
     * @return
     *     The value of the breakdownWorkItemQuantityAnalysis property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WorkItemQuantityAnalysisType> getBreakdownWorkItemQuantityAnalysis() {
        if (breakdownWorkItemQuantityAnalysis == null) {
            breakdownWorkItemQuantityAnalysis = new ArrayList<>();
        }
        return this.breakdownWorkItemQuantityAnalysis;
    }

    /**
     * Gets the value of the changedRecordedStatus property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the changedRecordedStatus property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getChangedRecordedStatus().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RecordedStatusType }
     * 
     * 
     * @return
     *     The value of the changedRecordedStatus property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RecordedStatusType> getChangedRecordedStatus() {
        if (changedRecordedStatus == null) {
            changedRecordedStatus = new ArrayList<>();
        }
        return this.changedRecordedStatus;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final WorkItemQuantityAnalysisType rhs = ((WorkItemQuantityAnalysisType) o);
        if (!EqualsHelper.equals(actualQuantity, rhs.actualQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(actualQuantityPercent, rhs.actualQuantityPercent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(actualQuantityWorkItemDimension, rhs.actualQuantityWorkItemDimension)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(alternativeClassificationCode, rhs.alternativeClassificationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(breakdownWorkItemQuantityAnalysis, rhs.breakdownWorkItemQuantityAnalysis)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(changedRecordedStatus, rhs.changedRecordedStatus)) {
            return false;
        }
        if (!EqualsHelper.equals(contractualLanguageCode, rhs.contractualLanguageCode)) {
            return false;
        }
        if (!EqualsHelper.equals(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(primaryClassificationCode, rhs.primaryClassificationCode)) {
            return false;
        }
        if (!EqualsHelper.equals(statusCode, rhs.statusCode)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualQuantity).append(actualQuantityPercent).append(actualQuantityWorkItemDimension).append(alternativeClassificationCode).append(breakdownWorkItemQuantityAnalysis).append(changedRecordedStatus).append(contractualLanguageCode).append(description).append(id).append(primaryClassificationCode).append(statusCode).append(typeCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualQuantity", actualQuantity).append("actualQuantityPercent", actualQuantityPercent).append("actualQuantityWorkItemDimension", actualQuantityWorkItemDimension).append("alternativeClassificationCode", alternativeClassificationCode).append("breakdownWorkItemQuantityAnalysis", breakdownWorkItemQuantityAnalysis).append("changedRecordedStatus", changedRecordedStatus).append("contractualLanguageCode", contractualLanguageCode).append("description", description).append("id", id).append("primaryClassificationCode", primaryClassificationCode).append("statusCode", statusCode).append("typeCode", typeCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPrimaryClassificationCode(
        @Nullable
        final List<CodeType> aList) {
        primaryClassificationCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAlternativeClassificationCode(
        @Nullable
        final List<CodeType> aList) {
        alternativeClassificationCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setActualQuantityWorkItemDimension(
        @Nullable
        final List<WorkItemDimensionType> aList) {
        actualQuantityWorkItemDimension = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBreakdownWorkItemQuantityAnalysis(
        @Nullable
        final List<WorkItemQuantityAnalysisType> aList) {
        breakdownWorkItemQuantityAnalysis = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setChangedRecordedStatus(
        @Nullable
        final List<RecordedStatusType> aList) {
        changedRecordedStatus = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPrimaryClassificationCodeEntries() {
        return (!getPrimaryClassificationCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPrimaryClassificationCodeEntries() {
        return getPrimaryClassificationCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPrimaryClassificationCodeCount() {
        return getPrimaryClassificationCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getPrimaryClassificationCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPrimaryClassificationCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPrimaryClassificationCode(
        @Nonnull
        final CodeType elem) {
        getPrimaryClassificationCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAlternativeClassificationCodeEntries() {
        return (!getAlternativeClassificationCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAlternativeClassificationCodeEntries() {
        return getAlternativeClassificationCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAlternativeClassificationCodeCount() {
        return getAlternativeClassificationCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getAlternativeClassificationCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAlternativeClassificationCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAlternativeClassificationCode(
        @Nonnull
        final CodeType elem) {
        getAlternativeClassificationCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasActualQuantityWorkItemDimensionEntries() {
        return (!getActualQuantityWorkItemDimension().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoActualQuantityWorkItemDimensionEntries() {
        return getActualQuantityWorkItemDimension().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getActualQuantityWorkItemDimensionCount() {
        return getActualQuantityWorkItemDimension().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WorkItemDimensionType getActualQuantityWorkItemDimensionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getActualQuantityWorkItemDimension().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addActualQuantityWorkItemDimension(
        @Nonnull
        final WorkItemDimensionType elem) {
        getActualQuantityWorkItemDimension().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBreakdownWorkItemQuantityAnalysisEntries() {
        return (!getBreakdownWorkItemQuantityAnalysis().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBreakdownWorkItemQuantityAnalysisEntries() {
        return getBreakdownWorkItemQuantityAnalysis().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBreakdownWorkItemQuantityAnalysisCount() {
        return getBreakdownWorkItemQuantityAnalysis().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WorkItemQuantityAnalysisType getBreakdownWorkItemQuantityAnalysisAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBreakdownWorkItemQuantityAnalysis().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBreakdownWorkItemQuantityAnalysis(
        @Nonnull
        final WorkItemQuantityAnalysisType elem) {
        getBreakdownWorkItemQuantityAnalysis().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasChangedRecordedStatusEntries() {
        return (!getChangedRecordedStatus().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoChangedRecordedStatusEntries() {
        return getChangedRecordedStatus().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getChangedRecordedStatusCount() {
        return getChangedRecordedStatus().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RecordedStatusType getChangedRecordedStatusAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getChangedRecordedStatus().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addChangedRecordedStatus(
        @Nonnull
        final RecordedStatusType elem) {
        getChangedRecordedStatus().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        WorkItemQuantityAnalysisType ret) {
        ret.actualQuantity = ((actualQuantity == null)?null:actualQuantity.clone());
        ret.actualQuantityPercent = ((actualQuantityPercent == null)?null:actualQuantityPercent.clone());
        if (actualQuantityWorkItemDimension == null) {
            ret.actualQuantityWorkItemDimension = null;
        } else {
            List<WorkItemDimensionType> retActualQuantityWorkItemDimension = new ArrayList<>();
            for (WorkItemDimensionType aItem: getActualQuantityWorkItemDimension()) {
                retActualQuantityWorkItemDimension.add(((aItem == null)?null:aItem.clone()));
            }
            ret.actualQuantityWorkItemDimension = retActualQuantityWorkItemDimension;
        }
        if (alternativeClassificationCode == null) {
            ret.alternativeClassificationCode = null;
        } else {
            List<CodeType> retAlternativeClassificationCode = new ArrayList<>();
            for (CodeType aItem: getAlternativeClassificationCode()) {
                retAlternativeClassificationCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.alternativeClassificationCode = retAlternativeClassificationCode;
        }
        if (breakdownWorkItemQuantityAnalysis == null) {
            ret.breakdownWorkItemQuantityAnalysis = null;
        } else {
            List<WorkItemQuantityAnalysisType> retBreakdownWorkItemQuantityAnalysis = new ArrayList<>();
            for (WorkItemQuantityAnalysisType aItem: getBreakdownWorkItemQuantityAnalysis()) {
                retBreakdownWorkItemQuantityAnalysis.add(((aItem == null)?null:aItem.clone()));
            }
            ret.breakdownWorkItemQuantityAnalysis = retBreakdownWorkItemQuantityAnalysis;
        }
        if (changedRecordedStatus == null) {
            ret.changedRecordedStatus = null;
        } else {
            List<RecordedStatusType> retChangedRecordedStatus = new ArrayList<>();
            for (RecordedStatusType aItem: getChangedRecordedStatus()) {
                retChangedRecordedStatus.add(((aItem == null)?null:aItem.clone()));
            }
            ret.changedRecordedStatus = retChangedRecordedStatus;
        }
        ret.contractualLanguageCode = ((contractualLanguageCode == null)?null:contractualLanguageCode.clone());
        ret.description = ((description == null)?null:description.clone());
        ret.id = ((id == null)?null:id.clone());
        if (primaryClassificationCode == null) {
            ret.primaryClassificationCode = null;
        } else {
            List<CodeType> retPrimaryClassificationCode = new ArrayList<>();
            for (CodeType aItem: getPrimaryClassificationCode()) {
                retPrimaryClassificationCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.primaryClassificationCode = retPrimaryClassificationCode;
        }
        ret.statusCode = ((statusCode == null)?null:statusCode.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public WorkItemQuantityAnalysisType clone() {
        WorkItemQuantityAnalysisType ret = new WorkItemQuantityAnalysisType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setActualQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getActualQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setActualQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setDescription(
        @Nullable
        final String valueParam) {
        TextType aObj = getDescription();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setDescription(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PercentType and never <code>null</code>
     */
    @Nonnull
    public PercentType setActualQuantityPercent(
        @Nullable
        final BigDecimal valueParam) {
        PercentType aObj = getActualQuantityPercent();
        if (aObj == null) {
            aObj = new PercentType(valueParam);
            setActualQuantityPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setStatusCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getStatusCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setStatusCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setTypeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setContractualLanguageCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getContractualLanguageCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setContractualLanguageCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getActualQuantityValue() {
        QuantityType aObj = getActualQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getDescriptionValue() {
        TextType aObj = getDescription();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getActualQuantityPercentValue() {
        PercentType aObj = getActualQuantityPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getStatusCodeValue() {
        CodeType aObj = getStatusCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        CodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getContractualLanguageCodeValue() {
        CodeType aObj = getContractualLanguageCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
