
package un.unece.uncefact.data.standard.unqualifieddatatype._100;

import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDate;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for DateType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="DateType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice>
 *         <element name="DateString">
 *           <complexType>
 *             <simpleContent>
 *               <extension base="<http://www.w3.org/2001/XMLSchema>string">
 *                 <attribute name="format" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               </extension>
 *             </simpleContent>
 *           </complexType>
 *         </element>
 *         <element name="Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *       </choice>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-offset-dt-extension</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DateType", propOrder = {
    "dateString",
    "date"
})
@CodingStyleguideUnaware
public class DateType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "DateString")
    private DateType.DateString dateString;
    @XmlElement(name = "Date", type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDate.class)
    @XmlSchemaType(name = "date")
    private XMLOffsetDate date;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public DateType() {
    }

    /**
     * Gets the value of the dateString property.
     * 
     * @return
     *     possible object is
     *     {@link DateType.DateString }
     *     
     */
    @Nullable
    public DateType.DateString getDateString() {
        return dateString;
    }

    /**
     * Sets the value of the dateString property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateType.DateString }
     *     
     */
    public void setDateString(
        @Nullable
        DateType.DateString value) {
        this.dateString = value;
    }

    /**
     * Gets the value of the date property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDate getDate() {
        return date;
    }

    /**
     * Sets the value of the date property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDate(
        @Nullable
        XMLOffsetDate value) {
        this.date = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DateType rhs = ((DateType) o);
        if (!EqualsHelper.equals(date, rhs.date)) {
            return false;
        }
        if (!EqualsHelper.equals(dateString, rhs.dateString)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(date).append(dateString).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("date", date).append("dateString", dateString).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DateType ret) {
        ret.date = date;
        ret.dateString = ((dateString == null)?null:dateString.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DateType clone() {
        DateType ret = new DateType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DateString and never <code>null</code>
     */
    @Nonnull
    public DateType.DateString setDateString(
        @Nullable
        final String valueParam) {
        DateType.DateString aObj = getDateString();
        if (aObj == null) {
            aObj = new DateType.DateString(valueParam);
            setDateString(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained DateString object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DateString object or <code>null</code>
     */
    @Nullable
    public String getDateStringValue() {
        DateType.DateString aObj = getDateString();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDate representation of date. May be <code>null</code>.
     */
    @Nullable
    public LocalDate getDateLocal() {
        return (date == null)?null:date.toLocalDate();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDate to set. May be <code>null</code>.
     */
    public void setDate(
        @Nullable
        final LocalDate aValue) {
        date = (aValue == null)?null:XMLOffsetDate.of(aValue, null);
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <simpleContent>
     *     <extension base="<http://www.w3.org/2001/XMLSchema>string">
     *       <attribute name="format" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     </extension>
     *   </simpleContent>
     * </complexType>
     * }</pre>
     * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
     * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
     * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
     * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
     * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    @CodingStyleguideUnaware
    public static class DateString implements Serializable, IExplicitlyCloneable
    {

        @XmlValue
        private String value;
        @XmlAttribute(name = "format")
        private String format;

        /**
         * Default constructor<br>
         * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
         * 
         */
        public DateString() {
        }

        /**
         * Constructor for value of type String<br>
         * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
         * 
         * @param valueParam
         *     The value to be set. May be <code>null</code>.
         */
        public DateString(
            @Nullable
            final String valueParam) {
            setValue(valueParam);
        }

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(
            @Nullable
            String value) {
            this.value = value;
        }

        /**
         * Gets the value of the format property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getFormat() {
            return format;
        }

        /**
         * Sets the value of the format property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setFormat(
            @Nullable
            String value) {
            this.format = value;
        }

        /**
         * Created by ph-jaxb-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final DateType.DateString rhs = ((DateType.DateString) o);
            if (!EqualsHelper.equals(format, rhs.format)) {
                return false;
            }
            if (!EqualsHelper.equals(value, rhs.value)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(format).append(value).getHashCode();
        }

        /**
         * Created by ph-jaxb-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("format", format).append("value", value).getToString();
        }

        /**
         * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be <code>null</code>.
         */
        public void cloneTo(
            @Nonnull
            DateType.DateString ret) {
            ret.format = format;
            ret.value = value;
        }

        /**
         * Created by ph-jaxb-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never <code>null</code>.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public DateType.DateString clone() {
            DateType.DateString ret = new DateType.DateString();
            cloneTo(ret);
            return ret;
        }

    }

}
