/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.OffsetDate;
import com.helger.commons.datetime.PDTConfig;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class XMLOffsetDateTime
implements Temporal,
TemporalAdjuster,
Comparable<XMLOffsetDateTime>,
Serializable {
    public static final XMLOffsetDateTime MIN = XMLOffsetDateTime.of(LocalDateTime.MIN, ZoneOffset.MAX);
    public static final XMLOffsetDateTime MAX = XMLOffsetDateTime.of(LocalDateTime.MAX, ZoneOffset.MIN);
    private final LocalDateTime m_aDateTime;
    private final ZoneOffset m_aOffset;

    public static Comparator<XMLOffsetDateTime> timeLineOrder() {
        return XMLOffsetDateTime::compareInstant;
    }

    protected static int compareInstant(@Nonnull XMLOffsetDateTime xMLOffsetDateTime, @Nonnull XMLOffsetDateTime xMLOffsetDateTime2) {
        if (EqualsHelper.equals(xMLOffsetDateTime.m_aOffset, xMLOffsetDateTime2.m_aOffset)) {
            return xMLOffsetDateTime.toLocalDateTime().compareTo(xMLOffsetDateTime2.toLocalDateTime());
        }
        int n = Long.compare(xMLOffsetDateTime.toEpochSecond(), xMLOffsetDateTime2.toEpochSecond());
        if (n == 0) {
            n = xMLOffsetDateTime.toLocalTime().getNano() - xMLOffsetDateTime2.toLocalTime().getNano();
        }
        return n;
    }

    @Nonnull
    public static XMLOffsetDateTime now() {
        return XMLOffsetDateTime.now(Clock.systemDefaultZone());
    }

    @Nonnull
    public static XMLOffsetDateTime now(@Nonnull ZoneId zoneId) {
        return XMLOffsetDateTime.now(Clock.system(zoneId));
    }

    @Nonnull
    public static XMLOffsetDateTime now(@Nonnull Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        return XMLOffsetDateTime.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    @Nonnull
    public static XMLOffsetDateTime of(@Nonnull LocalDate localDate, @Nonnull LocalTime localTime) {
        return new XMLOffsetDateTime(LocalDateTime.of(localDate, localTime), null);
    }

    @Nonnull
    public static XMLOffsetDateTime of(@Nonnull LocalDate localDate, @Nonnull LocalTime localTime, @Nullable ZoneOffset zoneOffset) {
        return new XMLOffsetDateTime(LocalDateTime.of(localDate, localTime), zoneOffset);
    }

    @Nonnull
    public static XMLOffsetDateTime of(@Nonnull LocalDateTime localDateTime) {
        return new XMLOffsetDateTime(localDateTime, null);
    }

    @Nonnull
    public static XMLOffsetDateTime of(@Nonnull LocalDateTime localDateTime, @Nullable ZoneOffset zoneOffset) {
        return new XMLOffsetDateTime(localDateTime, zoneOffset);
    }

    @Nonnull
    public static XMLOffsetDateTime of(@Nonnull OffsetDateTime offsetDateTime) {
        return new XMLOffsetDateTime(offsetDateTime.toLocalDateTime(), offsetDateTime.getOffset());
    }

    @Nonnull
    public static XMLOffsetDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7, @Nullable ZoneOffset zoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.of(n, n2, n3, n4, n5, n6, n7);
        return new XMLOffsetDateTime(localDateTime, zoneOffset);
    }

    @Nonnull
    public static XMLOffsetDateTime ofInstant(@Nonnull Instant instant, @Nonnull ZoneId zoneId) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zoneId, "zone");
        ZoneOffset zoneOffset = zoneId.getRules().getOffset(instant);
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), zoneOffset);
        return new XMLOffsetDateTime(localDateTime, zoneOffset);
    }

    @Nonnull
    public static XMLOffsetDateTime from(@Nonnull TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof XMLOffsetDateTime) {
            return (XMLOffsetDateTime)temporalAccessor;
        }
        try {
            ZoneOffset zoneOffset;
            LocalDate localDate = temporalAccessor.query(TemporalQueries.localDate());
            LocalTime localTime = temporalAccessor.query(TemporalQueries.localTime());
            try {
                zoneOffset = ZoneOffset.from(temporalAccessor);
            }
            catch (DateTimeException dateTimeException) {
                zoneOffset = null;
            }
            if (localDate != null && localTime != null) {
                return XMLOffsetDateTime.of(localDate, localTime, zoneOffset);
            }
            Instant instant = Instant.from(temporalAccessor);
            return XMLOffsetDateTime.ofInstant(instant, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain XMLOffsetDateTime from TemporalAccessor: " + String.valueOf(temporalAccessor) + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    @Nonnull
    public static XMLOffsetDateTime parse(@Nonnull CharSequence charSequence) {
        return XMLOffsetDateTime.parse(charSequence, DateTimeFormatter.ISO_DATE_TIME);
    }

    @Nonnull
    public static XMLOffsetDateTime parse(@Nonnull CharSequence charSequence, @Nonnull DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, XMLOffsetDateTime::from);
    }

    protected XMLOffsetDateTime(@Nonnull LocalDateTime localDateTime, @Nullable ZoneOffset zoneOffset) {
        this.m_aDateTime = Objects.requireNonNull(localDateTime, "dateTime");
        this.m_aOffset = zoneOffset;
    }

    @Nonnull
    protected XMLOffsetDateTime with(@Nonnull LocalDateTime localDateTime, @Nullable ZoneOffset zoneOffset) {
        if (this.m_aDateTime == localDateTime && EqualsHelper.equals(this.m_aOffset, zoneOffset)) {
            return this;
        }
        return new XMLOffsetDateTime(localDateTime, zoneOffset);
    }

    @Override
    public boolean isSupported(@Nullable TemporalField temporalField) {
        return temporalField instanceof ChronoField || temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(@Nullable TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit != ChronoUnit.FOREVER;
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    @Nonnull
    public ValueRange range(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.m_aDateTime.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    throw new UnsupportedTemporalTypeException("Invalid field 'InstantSeconds' for get() method, use getLong() instead");
                }
                case OFFSET_SECONDS: {
                    return this.m_aOffset == null ? 0 : this.m_aOffset.getTotalSeconds();
                }
            }
            return this.m_aDateTime.get(temporalField);
        }
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.m_aOffset != null ? (long)this.m_aOffset.getTotalSeconds() : 0L;
                }
            }
            return this.m_aDateTime.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Nullable
    public ZoneOffset getOffset() {
        return this.m_aOffset;
    }

    public boolean hasOffset() {
        return this.m_aOffset != null;
    }

    @Nonnull
    public XMLOffsetDateTime withOffsetSameLocal(@Nullable ZoneOffset zoneOffset) {
        return this.with(this.m_aDateTime, zoneOffset);
    }

    @Nonnull
    public XMLOffsetDateTime withOffsetSameInstant(@Nullable ZoneOffset zoneOffset) {
        if (EqualsHelper.equals(zoneOffset, this.m_aOffset)) {
            return this;
        }
        int n = (zoneOffset != null ? zoneOffset.getTotalSeconds() : 0) - (this.m_aOffset != null ? this.m_aOffset.getTotalSeconds() : 0);
        LocalDateTime localDateTime = this.m_aDateTime.plusSeconds(n);
        return new XMLOffsetDateTime(localDateTime, zoneOffset);
    }

    @Nonnull
    public LocalDateTime toLocalDateTime() {
        return this.m_aDateTime;
    }

    @Nonnull
    public LocalDate toLocalDate() {
        return this.m_aDateTime.toLocalDate();
    }

    public int getYear() {
        return this.m_aDateTime.getYear();
    }

    public int getMonthValue() {
        return this.m_aDateTime.getMonthValue();
    }

    @Nonnull
    public Month getMonth() {
        return this.m_aDateTime.getMonth();
    }

    public int getDayOfMonth() {
        return this.m_aDateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.m_aDateTime.getDayOfYear();
    }

    @Nonnull
    public DayOfWeek getDayOfWeek() {
        return this.m_aDateTime.getDayOfWeek();
    }

    @Nonnull
    public LocalTime toLocalTime() {
        return this.m_aDateTime.toLocalTime();
    }

    public int getHour() {
        return this.m_aDateTime.getHour();
    }

    public int getMinute() {
        return this.m_aDateTime.getMinute();
    }

    public int getSecond() {
        return this.m_aDateTime.getSecond();
    }

    public int getNano() {
        return this.m_aDateTime.getNano();
    }

    @Override
    @Nonnull
    public XMLOffsetDateTime with(@Nonnull TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate || temporalAdjuster instanceof LocalTime || temporalAdjuster instanceof LocalDateTime) {
            return this.with(this.m_aDateTime.with(temporalAdjuster), this.m_aOffset);
        }
        if (temporalAdjuster instanceof Instant) {
            return XMLOffsetDateTime.ofInstant((Instant)temporalAdjuster, this.m_aOffset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            return this.with(this.m_aDateTime, (ZoneOffset)temporalAdjuster);
        }
        if (temporalAdjuster instanceof XMLOffsetDateTime) {
            return (XMLOffsetDateTime)temporalAdjuster;
        }
        return (XMLOffsetDateTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    @Nonnull
    public XMLOffsetDateTime with(@Nonnull TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            switch (chronoField) {
                case INSTANT_SECONDS: {
                    return XMLOffsetDateTime.ofInstant(Instant.ofEpochSecond(l, this.getNano()), this.m_aOffset);
                }
                case OFFSET_SECONDS: {
                    return this.with(this.m_aDateTime, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
                }
            }
            return this.with(this.m_aDateTime.with(temporalField, l), this.m_aOffset);
        }
        return temporalField.adjustInto(this, l);
    }

    @Nonnull
    public XMLOffsetDateTime withYear(int n) {
        return this.with(this.m_aDateTime.withYear(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime withMonth(int n) {
        return this.with(this.m_aDateTime.withMonth(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime withDayOfMonth(int n) {
        return this.with(this.m_aDateTime.withDayOfMonth(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime withDayOfYear(int n) {
        return this.with(this.m_aDateTime.withDayOfYear(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime withHour(int n) {
        return this.with(this.m_aDateTime.withHour(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime withMinute(int n) {
        return this.with(this.m_aDateTime.withMinute(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime withSecond(int n) {
        return this.with(this.m_aDateTime.withSecond(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime withNano(int n) {
        return this.with(this.m_aDateTime.withNano(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime truncatedTo(@Nonnull TemporalUnit temporalUnit) {
        return this.with(this.m_aDateTime.truncatedTo(temporalUnit), this.m_aOffset);
    }

    @Override
    public XMLOffsetDateTime plus(@Nonnull TemporalAmount temporalAmount) {
        return (XMLOffsetDateTime)temporalAmount.addTo(this);
    }

    @Override
    public XMLOffsetDateTime plus(long l, @Nonnull TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.m_aDateTime.plus(l, temporalUnit), this.m_aOffset);
        }
        return temporalUnit.addTo(this, l);
    }

    @Nonnull
    public XMLOffsetDateTime plusYears(long l) {
        return this.with(this.m_aDateTime.plusYears(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime plusMonths(long l) {
        return this.with(this.m_aDateTime.plusMonths(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime plusWeeks(long l) {
        return this.with(this.m_aDateTime.plusWeeks(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime plusDays(long l) {
        return this.with(this.m_aDateTime.plusDays(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime plusHours(long l) {
        return this.with(this.m_aDateTime.plusHours(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime plusMinutes(long l) {
        return this.with(this.m_aDateTime.plusMinutes(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime plusSeconds(long l) {
        return this.with(this.m_aDateTime.plusSeconds(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDateTime plusNanos(long l) {
        return this.with(this.m_aDateTime.plusNanos(l), this.m_aOffset);
    }

    @Override
    @Nonnull
    public XMLOffsetDateTime minus(@Nonnull TemporalAmount temporalAmount) {
        return (XMLOffsetDateTime)temporalAmount.subtractFrom(this);
    }

    @Override
    @Nonnull
    public XMLOffsetDateTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    @Nonnull
    public XMLOffsetDateTime minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    @Nonnull
    public XMLOffsetDateTime minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    @Nonnull
    public XMLOffsetDateTime minusWeeks(long l) {
        return l == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-l);
    }

    @Nonnull
    public XMLOffsetDateTime minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    @Nonnull
    public XMLOffsetDateTime minusHours(long l) {
        return l == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-l);
    }

    @Nonnull
    public XMLOffsetDateTime minusMinutes(long l) {
        return l == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-l);
    }

    @Nonnull
    public XMLOffsetDateTime minusSeconds(long l) {
        return l == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-l);
    }

    @Nonnull
    public XMLOffsetDateTime minusNanos(long l) {
        return l == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-l);
    }

    @Override
    public <R> R query(@Nonnull TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return (R)this.getOffsetOrDefault();
        }
        if (temporalQuery == TemporalQueries.zoneId()) {
            return null;
        }
        if (temporalQuery == TemporalQueries.localDate()) {
            return (R)this.toLocalDate();
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return (R)this.toLocalTime();
        }
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return Temporal.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(@Nonnull Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField.NANO_OF_DAY, this.toLocalTime().toNanoOfDay()).with(ChronoField.OFFSET_SECONDS, this.m_aOffset != null ? (long)this.m_aOffset.getTotalSeconds() : 0L);
    }

    @Override
    public long until(@Nonnull Temporal temporal, @Nonnull TemporalUnit temporalUnit) {
        XMLOffsetDateTime xMLOffsetDateTime = XMLOffsetDateTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            xMLOffsetDateTime = xMLOffsetDateTime.withOffsetSameInstant(this.m_aOffset);
            return this.m_aDateTime.until(xMLOffsetDateTime.m_aDateTime, temporalUnit);
        }
        return temporalUnit.between(this, xMLOffsetDateTime);
    }

    @Nonnull
    public String format(@Nonnull DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    @Nonnull
    protected ZoneOffset getOffsetOr(@Nonnull Supplier<ZoneOffset> supplier) {
        ZoneOffset zoneOffset = this.m_aOffset;
        if (zoneOffset == null) {
            zoneOffset = supplier.get();
        }
        return zoneOffset;
    }

    @Nonnull
    protected ZoneOffset getOffsetOrDefault() {
        return this.getOffsetOr(() -> PDTConfig.getDefaultZoneId().getRules().getOffset(this.m_aDateTime));
    }

    @Nonnull
    protected ZoneOffset getOffsetOrUTC() {
        return this.getOffsetOr(() -> ZoneOffset.UTC);
    }

    @Nonnull
    public ZonedDateTime atZoneSameInstant(@Nonnull ZoneId zoneId) {
        return ZonedDateTime.ofInstant(this.m_aDateTime, this.getOffsetOrDefault(), zoneId);
    }

    @Nonnull
    public ZonedDateTime atZoneSimilarLocal(@Nonnull ZoneId zoneId) {
        return ZonedDateTime.ofLocal(this.m_aDateTime, zoneId, this.getOffsetOrDefault());
    }

    @Nonnull
    public OffsetTime toOffsetTime() {
        return OffsetTime.of(this.m_aDateTime.toLocalTime(), this.getOffsetOrDefault());
    }

    @Nonnull
    public XMLOffsetTime toXMLOffsetTime() {
        return XMLOffsetTime.of(this.m_aDateTime.toLocalTime(), this.m_aOffset);
    }

    @Nullable
    public OffsetDate toOffsetDate() {
        return OffsetDate.of(this.m_aDateTime.toLocalDate(), this.getOffsetOrDefault());
    }

    @Nullable
    public XMLOffsetDate toXMLOffsetDate() {
        return XMLOffsetDate.of(this.m_aDateTime.toLocalDate(), this.m_aOffset);
    }

    @Nullable
    public OffsetDateTime toOffsetDateTime() {
        return OffsetDateTime.of(this.m_aDateTime, this.getOffsetOrDefault());
    }

    @Nonnull
    public ZonedDateTime toZonedDateTime() {
        return ZonedDateTime.of(this.m_aDateTime, this.getOffsetOrDefault());
    }

    @Nonnull
    public Instant toInstant() {
        return this.m_aDateTime.toInstant(this.getOffsetOrDefault());
    }

    public long toEpochSecond() {
        return this.m_aDateTime.toEpochSecond(this.getOffsetOrUTC());
    }

    @Override
    public int compareTo(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        int n = XMLOffsetDateTime.compareInstant(this, xMLOffsetDateTime);
        if (n == 0) {
            n = this.toLocalDateTime().compareTo(xMLOffsetDateTime.toLocalDateTime());
        }
        return n;
    }

    public boolean isAfter(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 > (l = xMLOffsetDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() > xMLOffsetDateTime.toLocalTime().getNano();
    }

    public boolean isBefore(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        long l;
        long l2 = this.toEpochSecond();
        return l2 < (l = xMLOffsetDateTime.toEpochSecond()) || l2 == l && this.toLocalTime().getNano() < xMLOffsetDateTime.toLocalTime().getNano();
    }

    public boolean isEqual(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        return this.toEpochSecond() == xMLOffsetDateTime.toEpochSecond() && this.toLocalTime().getNano() == xMLOffsetDateTime.toLocalTime().getNano();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XMLOffsetDateTime xMLOffsetDateTime = (XMLOffsetDateTime)object;
        return this.m_aDateTime.equals(xMLOffsetDateTime.m_aDateTime) && EqualsHelper.equals(this.m_aOffset, xMLOffsetDateTime.m_aOffset);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aDateTime).append(this.m_aOffset).getHashCode();
    }

    @Nonnull
    @Deprecated(forRemoval=false)
    @Nonempty
    public String getAsString() {
        return this.toString();
    }

    public String toString() {
        return this.m_aDateTime.toString() + (this.m_aOffset != null ? this.m_aOffset.toString() : "");
    }
}

