/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.base64;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.base64.Base64InputStream;
import com.helger.commons.base64.Base64OutputStream;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int GZIP = 2;
    public static final int DONT_GUNZIP = 4;
    public static final int DO_BREAK_LINES = 8;
    public static final int URL_SAFE = 16;
    public static final int ORDERED = 32;
    public static final int MAX_LINE_LENGTH = 76;
    public static final byte EQUALS_SIGN = 61;
    public static final byte NEW_LINE = 10;
    public static final Charset PREFERRED_ENCODING = StandardCharsets.US_ASCII;
    static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] _STANDARD_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final byte[] _URL_SAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] _URL_SAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final byte[] _ORDERED_ALPHABET = new byte[]{45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] _ORDERED_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, -9, -9, -9, -1, -9, -9, -9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, -9, -9, -9, -9, 37, -9, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final Base64 s_aInstance = new Base64();

    @Nonnull
    @ReturnsMutableObject(value="design")
    private static byte[] _getAlphabet(int n) {
        if ((n & 0x10) == 16) {
            return _URL_SAFE_ALPHABET;
        }
        if ((n & 0x20) == 32) {
            return _ORDERED_ALPHABET;
        }
        return _STANDARD_ALPHABET;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    static byte[] _getDecodabet(int n) {
        if ((n & 0x10) == 16) {
            return _URL_SAFE_DECODABET;
        }
        if ((n & 0x20) == 32) {
            return _ORDERED_DECODABET;
        }
        return _STANDARD_DECODABET;
    }

    private Base64() {
    }

    @Nonnull
    @ReturnsMutableObject(value="passed parameter")
    static byte[] _encode3to4(@Nonnull byte[] byArray, @Nonnull byte[] byArray2, @Nonnegative int n, int n2) {
        Base64._encode3to4(byArray2, 0, n, byArray, 0, n2);
        return byArray;
    }

    @Nonnull
    @ReturnsMutableObject(value="passed parameter")
    static byte[] _encode3to4(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull byte[] byArray2, @Nonnegative int n3, int n4) {
        byte[] byArray3 = Base64._getAlphabet(n4);
        int n5 = (n2 > 0 ? byArray[n] << 24 >>> 8 : 0) | (n2 > 1 ? byArray[n + 1] << 24 >>> 16 : 0) | (n2 > 2 ? byArray[n + 2] << 24 >>> 24 : 0);
        switch (n2) {
            case 3: {
                byArray2[n3] = byArray3[n5 >>> 18];
                byArray2[n3 + 1] = byArray3[n5 >>> 12 & 0x3F];
                byArray2[n3 + 2] = byArray3[n5 >>> 6 & 0x3F];
                byArray2[n3 + 3] = byArray3[n5 & 0x3F];
                return byArray2;
            }
            case 2: {
                byArray2[n3] = byArray3[n5 >>> 18];
                byArray2[n3 + 1] = byArray3[n5 >>> 12 & 0x3F];
                byArray2[n3 + 2] = byArray3[n5 >>> 6 & 0x3F];
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
            case 1: {
                byArray2[n3] = byArray3[n5 >>> 18];
                byArray2[n3 + 1] = byArray3[n5 >>> 12 & 0x3F];
                byArray2[n3 + 2] = 61;
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
        }
        return byArray2;
    }

    public static void encode(@Nonnull ByteBuffer byteBuffer, @Nonnull ByteBuffer byteBuffer2) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[4];
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(3, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
            Base64._encode3to4(byArray2, byArray, n, 0);
            byteBuffer2.put(byArray2);
        }
    }

    public static void encode(@Nonnull ByteBuffer byteBuffer, @Nonnull CharBuffer charBuffer) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[4];
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(3, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
            Base64._encode3to4(byArray2, byArray, n, 0);
            for (int i = 0; i < 4; ++i) {
                charBuffer.put((char)(byArray2[i] & 0xFF));
            }
        }
    }

    public static String encodeObject(@Nonnull Serializable serializable) throws IOException {
        return Base64.encodeObject(serializable, 0);
    }

    @Nonnull
    public static String encodeObject(@Nonnull Serializable serializable, int n) throws IOException {
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream;
        block49: {
            ValueEnforcer.notNull(serializable, "Object");
            nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
            try (Base64OutputStream base64OutputStream = new Base64OutputStream(nonBlockingByteArrayOutputStream, 1 | n);){
                OutputStream outputStream;
                if ((n & 2) != 0) {
                    outputStream = new GZIPOutputStream(base64OutputStream);
                    Throwable throwable = null;
                    try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);){
                        objectOutputStream.writeObject(serializable);
                        break block49;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outputStream != null) {
                            if (throwable != null) {
                                try {
                                    ((DeflaterOutputStream)outputStream).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((DeflaterOutputStream)outputStream).close();
                            }
                        }
                    }
                }
                outputStream = new ObjectOutputStream(base64OutputStream);
                Throwable throwable = null;
                try {
                    ((ObjectOutputStream)outputStream).writeObject(serializable);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (outputStream != null) {
                        if (throwable != null) {
                            try {
                                ((ObjectOutputStream)outputStream).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((ObjectOutputStream)outputStream).close();
                        }
                    }
                }
            }
        }
        return nonBlockingByteArrayOutputStream.getAsString(PREFERRED_ENCODING);
    }

    @Nonnull
    public static String encodeBytes(@Nonnull byte[] byArray) {
        String string;
        block3: {
            string = null;
            try {
                string = Base64.encodeBytes(byArray, 0, byArray.length, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException.getMessage());
            }
        }
        assert (string != null);
        return string;
    }

    @Nonnull
    public static String encodeBytes(@Nonnull byte[] byArray, int n) throws IOException {
        return Base64.encodeBytes(byArray, 0, byArray.length, n);
    }

    @Nonnull
    public static String encodeBytes(@Nonnull byte[] byArray, int n, int n2) {
        String string;
        block3: {
            string = null;
            try {
                string = Base64.encodeBytes(byArray, n, n2, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException.getMessage());
            }
        }
        assert (string != null);
        return string;
    }

    @Nonnull
    public static String encodeBytes(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, int n3) throws IOException {
        byte[] byArray2 = Base64.encodeBytesToBytes(byArray, n, n2, n3);
        return new String(byArray2, PREFERRED_ENCODING);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] encodeBytesToBytes(@Nonnull byte[] byArray) {
        byte[] byArray2;
        try {
            byArray2 = Base64.encodeBytesToBytes(byArray, 0, byArray.length, 0);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("IOExceptions only come from GZipping, which is turned off", iOException);
        }
        return byArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] encodeBytesToBytes(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, int n3) throws IOException {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        if ((n3 & 2) != 0) {
            try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
                try (Object object = new Base64OutputStream(nonBlockingByteArrayOutputStream, 1 | n3);
                     GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object);){
                    gZIPOutputStream.write(byArray, n, n2);
                }
                object = nonBlockingByteArrayOutputStream.toByteArray();
                return object;
            }
        }
        boolean bl = (n3 & 8) != 0;
        int n4 = n2 / 3 * 4 + (n2 % 3 > 0 ? 4 : 0);
        if (bl) {
            n4 += n4 / 76;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 - 2;
        int n8 = 0;
        while (n5 < n7) {
            Base64._encode3to4(byArray, n5 + n, 3, byArray2, n6, n3);
            if (bl && (n8 += 4) >= 76) {
                byArray2[n6 + 4] = 10;
                ++n6;
                n8 = 0;
            }
            n5 += 3;
            n6 += 4;
        }
        if (n5 < n2) {
            Base64._encode3to4(byArray, n5 + n, n2 - n5, byArray2, n6, n3);
            n6 += 4;
        }
        if (n6 <= byArray2.length - 1) {
            byte[] byArray3 = new byte[n6];
            System.arraycopy(byArray2, 0, byArray3, 0, n6);
            return byArray3;
        }
        return byArray2;
    }

    @Nonnegative
    static int _decode4to3(@Nonnull byte[] byArray, int n, @Nonnull byte[] byArray2, int n2, int n3) {
        ValueEnforcer.notNull(byArray, "Source");
        ValueEnforcer.notNull(byArray2, "Destination");
        if (n < 0 || n + 3 >= byArray.length) {
            throw new IllegalArgumentException("Source array with length " + byArray.length + " cannot have offset of " + n + " and still process four bytes.");
        }
        if (n2 < 0 || n2 + 2 >= byArray2.length) {
            throw new IllegalArgumentException("Destination array with length " + byArray2.length + " cannot have offset of " + n2 + " and still store three bytes.");
        }
        byte[] byArray3 = Base64._getDecodabet(n3);
        if (byArray[n + 2] == 61) {
            int n4 = (byArray3[byArray[n]] & 0xFF) << 18 | (byArray3[byArray[n + 1]] & 0xFF) << 12;
            byArray2[n2] = (byte)(n4 >>> 16);
            return 1;
        }
        if (byArray[n + 3] == 61) {
            int n5 = (byArray3[byArray[n]] & 0xFF) << 18 | (byArray3[byArray[n + 1]] & 0xFF) << 12 | (byArray3[byArray[n + 2]] & 0xFF) << 6;
            byArray2[n2] = (byte)(n5 >>> 16);
            byArray2[n2 + 1] = (byte)(n5 >>> 8);
            return 2;
        }
        int n6 = (byArray3[byArray[n]] & 0xFF) << 18 | (byArray3[byArray[n + 1]] & 0xFF) << 12 | (byArray3[byArray[n + 2]] & 0xFF) << 6 | byArray3[byArray[n + 3]] & 0xFF;
        byArray2[n2] = (byte)(n6 >> 16);
        byArray2[n2 + 1] = (byte)(n6 >> 8);
        byArray2[n2 + 2] = (byte)n6;
        return 3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] decode(@Nonnull byte[] byArray) throws IOException {
        return Base64.decode(byArray, 0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] decode(@Nonnull byte[] byArray, int n) throws IOException {
        byte[] byArray2 = Base64.decode(byArray, 0, byArray.length, n);
        return byArray2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] decode(@Nonnull byte[] byArray, int n, int n2, int n3) throws IOException {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        if (n2 == 0) {
            return ArrayHelper.EMPTY_BYTE_ARRAY;
        }
        ValueEnforcer.isTrue(n2 >= 4, () -> "Base64-encoded string must have at least four characters, but length specified was " + n2);
        byte[] byArray2 = Base64._getDecodabet(n3);
        int n4 = n2 * 3 / 4;
        byte[] byArray3 = new byte[n4];
        int n5 = 0;
        byte[] byArray4 = new byte[4];
        int n6 = 0;
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray2[byArray[i] & 0xFF];
            if (by >= -5) {
                if (by < -1) continue;
                byArray4[n6++] = byArray[i];
                if (n6 <= 3) continue;
                n5 += Base64._decode4to3(byArray4, 0, byArray3, n5, n3);
                n6 = 0;
                if (byArray[i] != 61) continue;
                break;
            }
            throw new IOException("Bad Base64 input character decimal " + (byArray[i] & 0xFF) + " in array position " + i);
        }
        byte[] byArray5 = new byte[n5];
        System.arraycopy(byArray3, 0, byArray5, 0, n5);
        return byArray5;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] decode(@Nonnull String string) throws IOException {
        return Base64.decode(string, 0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] decode(@Nonnull String string, int n) throws IOException {
        int n2;
        boolean bl;
        ValueEnforcer.notNull(string, "InputString");
        byte[] byArray = string.getBytes(PREFERRED_ENCODING);
        byArray = Base64.decode(byArray, 0, byArray.length, n);
        boolean bl2 = bl = (n & 4) != 0;
        if (byArray.length >= 4 && !bl && 35615 == (n2 = byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00)) {
            try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
                 NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);
                 GZIPInputStream gZIPInputStream = new GZIPInputStream(nonBlockingByteArrayInputStream);){
                int n3;
                byte[] byArray2 = new byte[2048];
                while ((n3 = gZIPInputStream.read(byArray2)) >= 0) {
                    nonBlockingByteArrayOutputStream.write(byArray2, 0, n3);
                }
                byArray = nonBlockingByteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public static Object decodeToObject(@Nonnull String string) throws IOException, ClassNotFoundException {
        return Base64.decodeToObject(string, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeToObject(@Nonnull String string, int n, final @Nullable ClassLoader classLoader) throws IOException, ClassNotFoundException {
        byte[] byArray = Base64.decode(string, n);
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);){
            objectInputStream = classLoader == null ? new ObjectInputStream(nonBlockingByteArrayInputStream) : new ObjectInputStream(nonBlockingByteArrayInputStream){

                @Override
                public Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                    Class<?> clazz = Class.forName(objectStreamClass.getName(), false, classLoader);
                    if (clazz != null) {
                        return clazz;
                    }
                    return super.resolveClass(objectStreamClass);
                }
            };
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            StreamHelper.close(objectInputStream);
            throw throwable;
        }
        StreamHelper.close(objectInputStream);
        return object;
    }

    public static void encodeToFile(@Nonnull byte[] byArray, File file) throws IOException {
        ValueEnforcer.notNull(byArray, "DataToEncode");
        try (Base64OutputStream base64OutputStream = new Base64OutputStream(FileHelper.getBufferedOutputStream(file), 1);){
            base64OutputStream.write(byArray);
        }
    }

    public static void decodeToFile(@Nonnull String string, @Nonnull File file) throws IOException {
        try (Base64OutputStream base64OutputStream = new Base64OutputStream(FileHelper.getBufferedOutputStream(file), 0);){
            base64OutputStream.write(string.getBytes(PREFERRED_ENCODING));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] decodeFromFile(@Nonnull String string) throws IOException {
        File file = new File(string);
        if (file.length() > Integer.MAX_VALUE) {
            throw new IOException("File is too big for this convenience method (" + file.length() + " bytes).");
        }
        byte[] byArray = new byte[(int)file.length()];
        try (Base64InputStream base64InputStream = new Base64InputStream(FileHelper.getBufferedInputStream(file), 0);){
            int n;
            int n2 = 0;
            while ((n = base64InputStream.read(byArray, n2, 4096)) >= 0) {
                n2 += n;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byte[] byArray3 = byArray2;
            return byArray3;
        }
    }

    @Nonnull
    public static String encodeFromFile(@Nonnull String string) throws IOException {
        File file = new File(string);
        try (Base64InputStream base64InputStream = new Base64InputStream(FileHelper.getBufferedInputStream(file), 1);){
            String string2;
            int n;
            byte[] byArray = new byte[Math.max((int)((double)file.length() * 1.4 + 1.0), 40)];
            int n2 = 0;
            while ((n = base64InputStream.read(byArray, n2, 4096)) >= 0) {
                n2 += n;
            }
            String string3 = string2 = new String(byArray, 0, n2, PREFERRED_ENCODING);
            return string3;
        }
    }

    public static void encodeFileToFile(@Nonnull String string, @Nonnull File file) throws IOException {
        String string2 = Base64.encodeFromFile(string);
        try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream(file);){
            ((OutputStream)nonBlockingBufferedOutputStream).write(string2.getBytes(PREFERRED_ENCODING));
        }
    }

    public static void decodeFileToFile(@Nonnull String string, @Nonnull File file) throws IOException {
        byte[] byArray = Base64.decodeFromFile(string);
        try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream(file);){
            ((OutputStream)nonBlockingBufferedOutputStream).write(byArray);
        }
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeDecode(@Nullable String string) {
        return Base64.safeDecode(string, 4);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeDecode(@Nullable String string, int n) {
        if (string != null) {
            try {
                return Base64.decode(string, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeDecode(@Nullable byte[] byArray) {
        return Base64.safeDecode(byArray, 4);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeDecode(@Nullable byte[] byArray, int n) {
        if (byArray != null) {
            return Base64.safeDecode(byArray, 0, byArray.length, n);
        }
        return null;
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeDecode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return Base64.safeDecode(byArray, n, n2, 4);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeDecode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, int n3) {
        if (byArray != null) {
            try {
                return Base64.decode(byArray, n, n2, n3);
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String safeDecodeAsString(@Nullable String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        if (string != null) {
            try {
                byte[] byArray = Base64.decode(string, 4);
                return new String(byArray, charset);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String safeDecodeAsString(@Nullable byte[] byArray, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return byArray == null ? null : Base64.safeDecodeAsString(byArray, 0, byArray.length, charset);
    }

    @Nullable
    public static String safeDecodeAsString(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        if (byArray != null) {
            try {
                byte[] byArray2 = Base64.decode(byArray, n, n2, 4);
                return new String(byArray2, charset);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeEncodeBytesToBytes(@Nullable byte[] byArray) {
        return Base64.safeEncodeBytesToBytes(byArray, 0);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeEncodeBytesToBytes(@Nullable byte[] byArray, int n) {
        if (byArray != null) {
            return Base64.safeEncodeBytesToBytes(byArray, 0, byArray.length, n);
        }
        return null;
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeEncodeBytesToBytes(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return Base64.safeEncodeBytesToBytes(byArray, n, n2, 0);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] safeEncodeBytesToBytes(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, int n3) {
        if (byArray != null) {
            try {
                return Base64.encodeBytesToBytes(byArray, n, n2, n3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    @ReturnsMutableCopy
    public static String safeEncodeBytes(@Nullable byte[] byArray) {
        return Base64.safeEncodeBytes(byArray, 0);
    }

    @Nullable
    @ReturnsMutableCopy
    public static String safeEncodeBytes(@Nullable byte[] byArray, int n) {
        if (byArray != null) {
            return Base64.safeEncodeBytes(byArray, 0, byArray.length, n);
        }
        return null;
    }

    @Nullable
    @ReturnsMutableCopy
    public static String safeEncodeBytes(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return Base64.safeEncodeBytes(byArray, n, n2, 0);
    }

    @Nullable
    @ReturnsMutableCopy
    public static String safeEncodeBytes(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, int n3) {
        if (byArray != null) {
            try {
                return Base64.encodeBytes(byArray, n, n2, n3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String safeEncode(@Nonnull String string, @Nonnull Charset charset) {
        byte[] byArray = string.getBytes(charset);
        return Base64.encodeBytes(byArray);
    }
}

