/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.state.EContinue;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsIterable<ELEMENTTYPE>
extends Iterable<ELEMENTTYPE> {
    default public void forEachByIndex(@Nonnull ObjIntConsumer<? super ELEMENTTYPE> objIntConsumer) {
        int n = 0;
        for (Object t : this) {
            objIntConsumer.accept(t, n);
            ++n;
        }
    }

    @Nonnull
    default public EContinue forEachBreakable(@Nonnull Function<? super ELEMENTTYPE, EContinue> function) {
        Objects.requireNonNull(function);
        for (Object t : this) {
            if (!function.apply(t).isBreak()) continue;
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    default public void forEach(@Nonnull Consumer<? super ELEMENTTYPE> consumer, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            this.forEach(consumer);
        } else {
            for (Object t : this) {
                if (!predicate.test(t)) continue;
                consumer.accept(t);
            }
        }
    }

    default public void findAll(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Consumer<? super ELEMENTTYPE> consumer) {
        CollectionHelper.findAll(this, predicate, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionHelper.findAllMapped(this, function, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionHelper.findAllMapped(this, predicate, function, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable Predicate<? super DSTTYPE> predicate, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionHelper.findAllMapped(this, function, predicate, consumer);
    }

    default public <DSTTYPE extends ELEMENTTYPE> void findAllInstanceOf(@Nonnull Class<DSTTYPE> clazz, @Nonnull Consumer<? super DSTTYPE> consumer) {
        this.findAllMapped(clazz::isInstance, clazz::cast, consumer);
    }

    @Nullable
    default public ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return this.findFirst(predicate, null);
    }

    @Nullable
    default public ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return CollectionHelper.findFirst(this, predicate, ELEMENTTYPE);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        return this.findFirstMapped(predicate, function, null);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionHelper.findFirstMapped(this, predicate, function, DSTTYPE);
    }

    default public boolean containsAny(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.containsAny(this, predicate);
    }

    default public boolean containsNone(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.containsNone(this, predicate);
    }

    default public boolean containsOnly(@Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.containsOnly(this, predicate);
    }

    @Nonnegative
    default public int getCount() {
        return IteratorHelper.getSize(this.iterator());
    }

    @Nonnegative
    default public int getCount(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.getCount();
        }
        int n = 0;
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            ++n;
        }
        return n;
    }

    @Nonnegative
    default public int findFirstIndex(@Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        int n = 0;
        for (Object t : this) {
            if (predicate.test(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Nonnegative
    default public int findLastIndex(@Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        int n = -1;
        int n2 = 0;
        for (Object t : this) {
            if (predicate.test(t)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }
}

