/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.beetl.core.AntlrProgramBuilder;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.TemplateEngine;
import org.beetl.core.engine.GrammarCreator;
import org.beetl.core.engine.IGrammarConstants;
import org.beetl.core.parser.BeetlAntlrErrorStrategy;
import org.beetl.core.parser.BeetlLexer;
import org.beetl.core.parser.BeetlParser;
import org.beetl.core.parser.SyntaxErrorListener;
import org.beetl.core.statement.AjaxStatement;
import org.beetl.core.statement.Program;
import org.beetl.core.statement.ProgramMetaData;

public class DefaultTemplateEngine
implements TemplateEngine,
IGrammarConstants {
    protected BeetlAntlrErrorStrategy antlrErrorStrategy = new BeetlAntlrErrorStrategy();
    protected SyntaxErrorListener syntaxError = new SyntaxErrorListener();
    protected static final String[] STRICT_DISABLE_GRAMMARS = new String[]{"Arth", "ClassNativeCall", "Compare", "Function", "IncDec", "InstanceNativeCall", "VarAssign", "VarRefAssign", "VarRefAssignExp"};

    @Override
    public Program createProgram(Resource resource, Reader reader, Map<Integer, String> textMap, String cr, GroupTemplate gt) {
        BeetlLexer lexer;
        try {
            lexer = new BeetlLexer((CharStream)CharStreams.fromReader((Reader)reader));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)this.syntaxError);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        BeetlParser parser = new BeetlParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)this.antlrErrorStrategy);
        BeetlParser.ProgContext tree = parser.prog();
        Program program = new Program();
        program.res = resource;
        program.gt = gt;
        program.metaData = this.getAntlrBuilder(gt).build((ParseTree)tree, resource);
        program.metaData.lineSeparator = cr;
        program.metaData.staticTextArray = new Object[textMap.size()];
        int index = 0;
        Configuration conf = gt.getConf();
        boolean directByteOutput = conf.isDirectByteOutput();
        String charset = conf.getCharset();
        try {
            for (String v : textMap.values()) {
                program.metaData.staticTextArray[index++] = directByteOutput ? (Object[])v.getBytes(charset) : v.toCharArray();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (program.metaData.ajaxs != null) {
            for (AjaxStatement ajax : program.metaData.ajaxs.values()) {
                ProgramMetaData metaData = ajax.getLocalProgramMetaData();
                metaData.staticTextArray = program.metaData.staticTextArray;
                metaData.lineSeparator = cr;
            }
        }
        return program;
    }

    protected void checkProgram(Program program) {
    }

    protected AntlrProgramBuilder getAntlrBuilder(GroupTemplate groupTemplate) {
        GrammarCreator grammarCreator = this.getGrammarCreator(groupTemplate);
        return new AntlrProgramBuilder(groupTemplate, grammarCreator);
    }

    protected GrammarCreator getGrammarCreator(GroupTemplate groupTemplate) {
        GrammarCreator result = new GrammarCreator();
        this.setStrictDisableGrammars(result, groupTemplate);
        return result;
    }

    protected void setStrictDisableGrammars(GrammarCreator grammarCreator, GroupTemplate groupTemplate) {
        if (groupTemplate.getConf().isStrict()) {
            for (String disableGrammar : STRICT_DISABLE_GRAMMARS) {
                grammarCreator.addDisableGrammar(disableGrammar);
            }
        }
    }
}

