/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.base.NestedApplicationException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamUtil {
    private static final Log log = LogFactory.getLog(StreamUtil.class);

    public static byte[] getStreamAsByteArray(InputStream stream) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            byte[] bytes = new byte[256];
            int read = 0;
            while (0 <= (read = stream.read(bytes))) {
                byteStream.write(bytes, 0, read);
            }
            byteStream.flush();
        }
        catch (IOException exc) {
            log.error((Object)"Exception while reading from stream", (Throwable)exc);
        }
        return byteStream.toByteArray();
    }

    public static byte[] getStreamAsByteArray(InputStream stream, int length) {
        byte[] bytes = new byte[length];
        int read = 0;
        try {
            for (int offset = 0; offset < bytes.length && 0 <= (read = stream.read(bytes, offset, bytes.length - offset)); offset += read) {
            }
        }
        catch (IOException exc) {
            log.error((Object)"Exception while reading from stream", (Throwable)exc);
        }
        return bytes;
    }

    public static String getReaderAsString(Reader reader) {
        StringWriter writer = new StringWriter();
        try {
            char[] chars = new char[256];
            int read = 0;
            while (0 <= (read = reader.read(chars))) {
                writer.write(chars, 0, read);
            }
            writer.flush();
        }
        catch (IOException exc) {
            log.error((Object)"Exception while reading from reader", (Throwable)exc);
        }
        return writer.toString();
    }

    public static String getReaderAsString(Reader reader, int length) {
        char[] chars = new char[length];
        int read = 0;
        try {
            for (int offset = 0; offset < chars.length && 0 <= (read = reader.read(chars, offset, chars.length - offset)); offset += read) {
            }
        }
        catch (IOException exc) {
            log.error((Object)"Exception while reading from reader", (Throwable)exc);
        }
        return String.valueOf(chars);
    }

    public static InputStream copyStream(InputStream sourceStream) {
        try {
            if (sourceStream.markSupported()) {
                sourceStream.mark(sourceStream.available());
            }
            byte[] sourceData = StreamUtil.getStreamAsByteArray(sourceStream);
            if (sourceStream.markSupported()) {
                sourceStream.reset();
            }
            return new ByteArrayInputStream(sourceData);
        }
        catch (IOException exc) {
            log.error((Object)"Exception while copying stream", (Throwable)exc);
            return null;
        }
    }

    public static Reader copyReader(Reader sourceReader) {
        try {
            if (sourceReader.markSupported()) {
                sourceReader.mark(Integer.MAX_VALUE);
            }
            String sourceData = StreamUtil.getReaderAsString(sourceReader);
            if (sourceReader.markSupported()) {
                sourceReader.reset();
            }
            return new StringReader(sourceData);
        }
        catch (IOException exc) {
            log.error((Object)"Exception while copying reader", (Throwable)exc);
            return null;
        }
    }

    public static boolean compareStreams(InputStream sourceStream, InputStream targetStream) {
        try {
            if (sourceStream.markSupported()) {
                sourceStream.mark(sourceStream.available());
            }
            if (targetStream.markSupported()) {
                targetStream.mark(targetStream.available());
            }
            byte[] sourceArray = StreamUtil.getStreamAsByteArray(sourceStream);
            byte[] targetArray = StreamUtil.getStreamAsByteArray(targetStream);
            if (sourceStream.markSupported()) {
                sourceStream.reset();
            }
            if (targetStream.markSupported()) {
                targetStream.reset();
            }
            return Arrays.equals(sourceArray, targetArray);
        }
        catch (IOException exc) {
            log.error((Object)"Exception while comparing streams", (Throwable)exc);
            return false;
        }
    }

    public static boolean compareReaders(Reader sourceReader, Reader targetReader) {
        try {
            if (sourceReader.markSupported()) {
                sourceReader.mark(Integer.MAX_VALUE);
            }
            if (targetReader.markSupported()) {
                targetReader.mark(Integer.MAX_VALUE);
            }
            String sourceString = StreamUtil.getReaderAsString(sourceReader);
            String targetString = StreamUtil.getReaderAsString(targetReader);
            if (sourceReader.markSupported()) {
                sourceReader.reset();
            }
            if (targetReader.markSupported()) {
                targetReader.reset();
            }
            return sourceString.equals(targetString);
        }
        catch (IOException exc) {
            log.error((Object)"Exception while comparing readers", (Throwable)exc);
            return false;
        }
    }

    public static List<String> getLinesFromReader(Reader reader) {
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = bufferedReader.readLine();
            while (line != null) {
                resultList.add(line);
                line = bufferedReader.readLine();
            }
        }
        catch (IOException exc) {
            throw new NestedApplicationException(exc);
        }
        return resultList;
    }
}

