/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.util.regexp.PatternMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SQLStatementMatcher {
    private final PatternMatcher.Factory patternMatcherFactory;

    public SQLStatementMatcher(boolean caseSensitive, boolean exactMatch) {
        this(caseSensitive, exactMatch, false);
    }

    public SQLStatementMatcher(boolean caseSensitive, boolean exactMatch, boolean useRegularExpressions) {
        this(PatternMatcher.Factories.from((boolean)caseSensitive, (boolean)exactMatch, (boolean)useRegularExpressions));
    }

    public SQLStatementMatcher(PatternMatcher.Factory patternMatcherFactory) {
        this.patternMatcherFactory = patternMatcherFactory;
    }

    public <T> List<T> getMatchingObjects(Map<String, ? extends T> dataMap, String query, boolean queryContainsMapData) {
        if (null == query) {
            query = "";
        }
        ArrayList<T> resultList = new ArrayList<T>();
        for (Map.Entry<String, T> entry : dataMap.entrySet()) {
            String currentQuery;
            String source;
            if (queryContainsMapData) {
                source = query;
                currentQuery = entry.getKey();
            } else {
                source = entry.getKey();
                currentQuery = query;
            }
            if (!this.doStringsMatch(source, currentQuery)) continue;
            T matchingObject = entry.getValue();
            resultList.add(matchingObject);
        }
        return resultList;
    }

    public <T> List<T> getMatchingObjectsFromCollections(Map<String, ? extends Collection<? extends T>> dataMap, String query, boolean queryContainsMapData) {
        if (null == query) {
            query = "";
        }
        ArrayList<? extends T> resultList = new ArrayList<T>();
        for (Map.Entry<String, Collection<T>> entry : dataMap.entrySet()) {
            String currentQuery;
            String source;
            if (queryContainsMapData) {
                source = query;
                currentQuery = entry.getKey();
            } else {
                source = entry.getKey();
                currentQuery = query;
            }
            if (!this.doStringsMatch(source, currentQuery)) continue;
            Collection<? extends T> matchingObject = entry.getValue();
            resultList.addAll(matchingObject);
        }
        return resultList;
    }

    public boolean contains(Collection<String> col, String query, boolean queryContainsData) {
        for (String element : col) {
            String currentQuery;
            String source;
            if (queryContainsData) {
                source = query;
                currentQuery = element;
            } else {
                source = element;
                currentQuery = query;
            }
            if (!this.doStringsMatch(source, currentQuery)) continue;
            return true;
        }
        return false;
    }

    public boolean doStringsMatch(String source, String query) {
        if (null == source) {
            source = "";
        }
        if (null == query) {
            query = "";
        }
        PatternMatcher patternMatcher = this.patternMatcherFactory.create(query);
        return patternMatcher.matches(source);
    }
}

