/*
 * Decompiled with CFR 0.152.
 */
package com.ninjasquad.springmockk;

import com.ninjasquad.springmockk.AbstractMockkBeanOverrideHandler;
import com.ninjasquad.springmockk.MockkBean;
import com.ninjasquad.springmockk.MockkBeanOverrideHandler;
import com.ninjasquad.springmockk.MockkSpyBean;
import com.ninjasquad.springmockk.MockkSpyBeanOverrideHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ResolvableType;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/ninjasquad/springmockk/MockkBeanOverrideProcessor;", "Lorg/springframework/test/context/bean/override/BeanOverrideProcessor;", "<init>", "()V", "createHandler", "Lcom/ninjasquad/springmockk/AbstractMockkBeanOverrideHandler;", "overrideAnnotation", "", "testClass", "Ljava/lang/Class;", "field", "Ljava/lang/reflect/Field;", "createHandlers", "", "Lorg/springframework/test/context/bean/override/BeanOverrideHandler;", "springmockk"})
public final class MockkBeanOverrideProcessor
implements BeanOverrideProcessor {
    @NotNull
    public AbstractMockkBeanOverrideHandler createHandler(@NotNull Annotation overrideAnnotation, @NotNull Class<?> testClass, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)overrideAnnotation, (String)"overrideAnnotation");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (overrideAnnotation instanceof MockkBean) {
            if (!(Reflection.getOrCreateKotlinClasses((Class[])((MockkBean)overrideAnnotation).types()).length == 0)) {
                boolean $i$a$-check-MockkBeanOverrideProcessor$createHandler$32 = false;
                String $i$a$-check-MockkBeanOverrideProcessor$createHandler$32 = "The @MockkBean 'types' attribute must be omitted when declared on a field";
                throw new IllegalStateException($i$a$-check-MockkBeanOverrideProcessor$createHandler$32.toString());
            }
            ResolvableType resolvableType = ResolvableType.forField((Field)field, testClass);
            Intrinsics.checkNotNullExpressionValue((Object)resolvableType, (String)"forField(...)");
            return new MockkBeanOverrideHandler(field, resolvableType, (MockkBean)overrideAnnotation);
        }
        if (overrideAnnotation instanceof MockkSpyBean) {
            if (!(Reflection.getOrCreateKotlinClasses((Class[])((MockkSpyBean)overrideAnnotation).types()).length == 0)) {
                boolean bl = false;
                String string = "The @MockkSpyBean 'types' attribute must be omitted when declared on a field";
                throw new IllegalStateException(string.toString());
            }
            ResolvableType resolvableType = ResolvableType.forField((Field)field, testClass);
            Intrinsics.checkNotNullExpressionValue((Object)resolvableType, (String)"forField(...)");
            return new MockkSpyBeanOverrideHandler(field, resolvableType, (MockkSpyBean)overrideAnnotation);
        }
        String string = "Invalid annotation passed to MockkBeanOverrideProcessor: expected either @MockkBean or @MockkSpyBean on field %s.%s";
        Object[] objectArray = new Object[]{field.getDeclaringClass().getName(), field.getName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        throw new IllegalStateException(string2);
    }

    @NotNull
    public List<BeanOverrideHandler> createHandlers(@NotNull Annotation overrideAnnotation, @NotNull Class<?> testClass) {
        Intrinsics.checkNotNullParameter((Object)overrideAnnotation, (String)"overrideAnnotation");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        if (overrideAnnotation instanceof MockkBean) {
            KClass[] types = Reflection.getOrCreateKotlinClasses((Class[])((MockkBean)overrideAnnotation).types());
            if (!(types.length > 0)) {
                boolean $i$a$-check-MockkBeanOverrideProcessor$createHandlers$52 = false;
                String $i$a$-check-MockkBeanOverrideProcessor$createHandlers$52 = "The @MockkBean 'types' attribute must not be empty when declared on a class";
                throw new IllegalStateException($i$a$-check-MockkBeanOverrideProcessor$createHandlers$52.toString());
            }
            if (!(((CharSequence)((MockkBean)overrideAnnotation).name()).length() == 0 || types.length == 1)) {
                boolean $i$a$-check-MockkBeanOverrideProcessor$createHandlers$62 = false;
                String $i$a$-check-MockkBeanOverrideProcessor$createHandlers$62 = "The @MockkBean 'name' attribute cannot be used when mocking multiple types";
                throw new IllegalStateException($i$a$-check-MockkBeanOverrideProcessor$createHandlers$62.toString());
            }
            List handlers = new ArrayList();
            for (KClass type : types) {
                ResolvableType resolvableType = ResolvableType.forClass((Class)JvmClassMappingKt.getJavaClass((KClass)type));
                Intrinsics.checkNotNullExpressionValue((Object)resolvableType, (String)"forClass(...)");
                handlers.add(new MockkBeanOverrideHandler(resolvableType, (MockkBean)overrideAnnotation));
            }
            return handlers;
        }
        if (overrideAnnotation instanceof MockkSpyBean) {
            KClass[] types = Reflection.getOrCreateKotlinClasses((Class[])((MockkSpyBean)overrideAnnotation).types());
            if (!(types.length > 0)) {
                boolean $i$a$-check-MockkBeanOverrideProcessor$createHandlers$72 = false;
                String $i$a$-check-MockkBeanOverrideProcessor$createHandlers$72 = "The @MockkSpyBean 'types' attribute must not be empty when declared on a class";
                throw new IllegalStateException($i$a$-check-MockkBeanOverrideProcessor$createHandlers$72.toString());
            }
            if (!(((CharSequence)((MockkSpyBean)overrideAnnotation).name()).length() == 0 || types.length == 1)) {
                boolean bl = false;
                String string = "The @MockkSpyBean 'name' attribute cannot be used when mocking multiple types";
                throw new IllegalStateException(string.toString());
            }
            List handlers = new ArrayList();
            for (KClass type : types) {
                ResolvableType resolvableType = ResolvableType.forClass((Class)JvmClassMappingKt.getJavaClass((KClass)type));
                Intrinsics.checkNotNullExpressionValue((Object)resolvableType, (String)"forClass(...)");
                handlers.add(new MockkSpyBeanOverrideHandler(resolvableType, (MockkSpyBean)overrideAnnotation));
            }
            return handlers;
        }
        throw new IllegalStateException("Invalid annotation passed to MockkBeanOverrideProcessor: expected either @MockkBean or @MockkSpyBean on test class " + testClass.getName());
    }
}

