/*
 * Decompiled with CFR 0.152.
 */
package com.ninjasquad.springmockk;

import com.ninjasquad.springmockk.MockBeans;
import com.ninjasquad.springmockk.MockkClear;
import com.ninjasquad.springmockk.MockkFunctionsKt;
import io.mockk.MockKKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/ninjasquad/springmockk/MockkClearTestExecutionListener;", "Lorg/springframework/test/context/support/AbstractTestExecutionListener;", "<init>", "()V", "getOrder", "", "beforeTestMethod", "", "testContext", "Lorg/springframework/test/context/TestContext;", "afterTestMethod", "Companion", "springmockk"})
public final class MockkClearTestExecutionListener
extends AbstractTestExecutionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ORDER = 2147483547;
    @NotNull
    private static final Log logger;
    private static final boolean MOCKK_PRESENT;
    @Nullable
    private static volatile Boolean mockKInitialized;

    public int getOrder() {
        return 2147483547;
    }

    public void beforeTestMethod(@NotNull TestContext testContext) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        if (MockkClearTestExecutionListener.Companion.isEnabled()) {
            MockkClearTestExecutionListener.Companion.clearMocks(testContext.getApplicationContext(), MockkClear.BEFORE);
        }
    }

    public void afterTestMethod(@NotNull TestContext testContext) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        if (MockkClearTestExecutionListener.Companion.isEnabled()) {
            MockkClearTestExecutionListener.Companion.clearMocks(testContext.getApplicationContext(), MockkClear.AFTER);
        }
    }

    static {
        Log log = LogFactory.getLog(MockkClearTestExecutionListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)log, (String)"getLog(...)");
        logger = log;
        MOCKK_PRESENT = ClassUtils.isPresent((String)"io.mockk.MockK", (ClassLoader)MockkClearTestExecutionListener.class.getClassLoader());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\u001a\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/ninjasquad/springmockk/MockkClearTestExecutionListener$Companion;", "", "<init>", "()V", "ORDER", "", "logger", "Lorg/apache/commons/logging/Log;", "MOCKK_PRESENT", "", "mockKInitialized", "Ljava/lang/Boolean;", "clearMocks", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "clear", "Lcom/ninjasquad/springmockk/MockkClear;", "Lorg/springframework/context/ConfigurableApplicationContext;", "getBean", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableListableBeanFactory;", "beanName", "", "isStandardBeanOrSingletonFactoryBean", "Lorg/springframework/beans/factory/BeanFactory;", "isEnabled", "()Z", "springmockk"})
    public static final class Companion {
        private Companion() {
        }

        private final void clearMocks(ApplicationContext applicationContext, MockkClear clear) {
            if (applicationContext instanceof ConfigurableApplicationContext) {
                this.clearMocks((ConfigurableApplicationContext)applicationContext, clear);
            }
        }

        private final void clearMocks(ConfigurableApplicationContext applicationContext, MockkClear clear) {
            ConfigurableListableBeanFactory configurableListableBeanFactory = applicationContext.getBeanFactory();
            Intrinsics.checkNotNullExpressionValue((Object)configurableListableBeanFactory, (String)"getBeanFactory(...)");
            ConfigurableListableBeanFactory beanFactory = configurableListableBeanFactory;
            String[] stringArray = beanFactory.getBeanDefinitionNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getBeanDefinitionNames(...)");
            String[] beanNames = stringArray;
            String[] stringArray2 = beanFactory.getSingletonNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"getSingletonNames(...)");
            Set instantiatedSingletons = ArraysKt.toSet((Object[])stringArray2);
            for (String string : beanNames) {
                Object bean;
                BeanDefinition beanDefinition;
                Intrinsics.checkNotNull((Object)string);
                String beanName = string;
                Intrinsics.checkNotNullExpressionValue((Object)beanFactory.getBeanDefinition(beanName), (String)"getBeanDefinition(...)");
                if (!beanDefinition.isSingleton() || !instantiatedSingletons.contains(beanName) || (bean = this.getBean(beanFactory, beanName)) == null || clear != MockkClear.Companion.get(bean)) continue;
                MockKKt.clearMocks$default((Object)bean, (Object[])new Object[0], (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)124, null);
            }
            try {
                ((MockBeans)beanFactory.getBean(MockBeans.class)).clearAll$springmockk(clear);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            if (applicationContext.getParent() != null) {
                this.clearMocks(applicationContext.getParent(), clear);
            }
        }

        private final Object getBean(ConfigurableListableBeanFactory beanFactory, String beanName) {
            try {
                if (this.isStandardBeanOrSingletonFactoryBean((BeanFactory)beanFactory, beanName)) {
                    return beanFactory.getBean(beanName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return beanFactory.getSingleton(beanName);
        }

        private final boolean isStandardBeanOrSingletonFactoryBean(BeanFactory beanFactory, String beanName) {
            String factoryBeanName = "&" + beanName;
            if (beanFactory.containsBean(factoryBeanName)) {
                Object object = beanFactory.getBean(factoryBeanName);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.springframework.beans.factory.FactoryBean<*>");
                FactoryBean factoryBean = (FactoryBean)object;
                return factoryBean.isSingleton();
            }
            return true;
        }

        private final boolean isEnabled() {
            if (!MOCKK_PRESENT) {
                return false;
            }
            Boolean enabled = mockKInitialized;
            if (enabled == null) {
                block4: {
                    try {
                        MockkFunctionsKt.isMockOrSpy("a string is not a mock");
                        enabled = true;
                    }
                    catch (Throwable ex) {
                        enabled = false;
                        if (!logger.isDebugEnabled()) break block4;
                        logger.debug((Object)"MockkClearTestExecutionListener is disabled in the current environment. See exception for details.", ex);
                    }
                }
                mockKInitialized = enabled;
            }
            return enabled;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

