/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.simple.extend.form;

import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.simple.extend.XhtmlForm;
import com.openhtmltopdf.simple.extend.form.InputField;
import com.openhtmltopdf.simple.extend.form.SizeLimitedDocument;
import com.openhtmltopdf.util.GeneralUtil;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import org.w3c.dom.Element;

class PasswordField
extends InputField {
    public PasswordField(Element e, XhtmlForm form, LayoutContext context, BlockBox box) {
        super(e, form, context, box);
    }

    @Override
    public JComponent create() {
        JPasswordField password = new JPasswordField();
        if (this.hasAttribute("size")) {
            int size = GeneralUtil.parseIntRelaxed(this.getAttribute("size"));
            if (size == 0) {
                password.setColumns(15);
            } else {
                password.setColumns(size);
            }
        } else {
            password.setColumns(15);
        }
        if (this.hasAttribute("maxlength")) {
            password.setDocument(new SizeLimitedDocument(GeneralUtil.parseIntRelaxed(this.getAttribute("maxlength"))));
        }
        if (this.hasAttribute("readonly") && this.getAttribute("readonly").equalsIgnoreCase("readonly")) {
            password.setEditable(false);
        }
        return password;
    }

    @Override
    protected void applyOriginalState() {
        JPasswordField password = (JPasswordField)this.getComponent();
        password.setText(this.getOriginalState().getValue());
    }

    @Override
    protected String[] getFieldValues() {
        JPasswordField textfield = (JPasswordField)this.getComponent();
        return new String[]{new String(textfield.getPassword())};
    }
}

