/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.Month;
import java.time.format.DateTimeFormatter;

public class MonthAdapter
extends XmlAdapter<String, Month> {
    private static String MONT_FORMAT = "MM";
    private DateTimeFormatter dtf = DateTimeFormatter.ofPattern(MONT_FORMAT);

    public MonthAdapter(DateTimeFormatter ofPattern) {
        this.dtf = ofPattern;
    }

    public MonthAdapter() {
    }

    public Month unmarshal(String value) throws Exception {
        return Month.of(Integer.valueOf(value));
    }

    public String marshal(Month value) throws Exception {
        if (value != null) {
            return this.dtf.format(value);
        }
        return null;
    }

    public String toString() {
        return "MonthAdapter{ " + MONT_FORMAT + " }";
    }
}

