/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters.v9;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class V9DateTimeJsonAdapter
implements JsonSerializer<OffsetDateTime>,
JsonDeserializer<OffsetDateTime> {
    private static final Logger log = Logger.getLogger(V9DateTimeJsonAdapter.class.getName());
    private static final Gson GSON = new Gson();

    public JsonElement serialize(OffsetDateTime offsetDateTime, Type type, JsonSerializationContext jsonSerializationContext) {
        XMLGregorianCalendarDTO xMLGregorianCalendarDTO = new XMLGregorianCalendarDTO();
        xMLGregorianCalendarDTO.year = offsetDateTime.getYear();
        xMLGregorianCalendarDTO.month = offsetDateTime.getMonthValue();
        xMLGregorianCalendarDTO.day = offsetDateTime.getDayOfMonth();
        xMLGregorianCalendarDTO.hour = offsetDateTime.getHour();
        xMLGregorianCalendarDTO.minute = offsetDateTime.getMinute();
        xMLGregorianCalendarDTO.second = offsetDateTime.getSecond();
        if (offsetDateTime.getNano() != 0) {
            xMLGregorianCalendarDTO.fractionalSecond = BigDecimal.valueOf(offsetDateTime.getNano()).divide(BigDecimal.valueOf(1000000000L), 3, RoundingMode.DOWN);
        }
        if (offsetDateTime.getOffset() != null) {
            xMLGregorianCalendarDTO.timezone = offsetDateTime.getOffset().getTotalSeconds() / 60;
        }
        return GSON.toJsonTree((Object)xMLGregorianCalendarDTO, XMLGregorianCalendarDTO.class);
    }

    public OffsetDateTime deserialize(JsonElement xMLGregorianCalendarJsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        try {
            XMLGregorianCalendarDTO xMLGregorianCalendarDTO = (XMLGregorianCalendarDTO)GSON.fromJson(xMLGregorianCalendarJsonElement, XMLGregorianCalendarDTO.class);
            ZoneOffset zoneoffset = ZoneOffset.ofTotalSeconds(xMLGregorianCalendarDTO.timezone * 60);
            return OffsetDateTime.of(xMLGregorianCalendarDTO.year, xMLGregorianCalendarDTO.month, xMLGregorianCalendarDTO.day, xMLGregorianCalendarDTO.hour, xMLGregorianCalendarDTO.minute, xMLGregorianCalendarDTO.second, (int)(xMLGregorianCalendarDTO.fractionalSecond.doubleValue() * 1.0E9), zoneoffset);
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot parse JSON into OffsetDateTime: " + e.getMessage(), e);
            return null;
        }
    }

    static class XMLGregorianCalendarDTO {
        Integer year = 0;
        Integer month = 0;
        Integer day = 0;
        Integer timezone = 0;
        Integer hour = 0;
        Integer minute = 0;
        Integer second = 0;
        BigDecimal fractionalSecond = BigDecimal.ZERO;

        XMLGregorianCalendarDTO() {
        }
    }
}

