/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.crypto.cryptor;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.cryptor.Cryptor;
import com.pubnub.api.crypto.data.EncryptedData;
import com.pubnub.api.crypto.data.EncryptedStreamData;
import com.pubnub.internal.crypto.CryptoModuleImplKt;
import com.pubnub.internal.crypto.cryptor.LegacyCryptorKt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010#\u001a\u00020\u000fH\u0002J\b\u0010$\u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/pubnub/internal/crypto/cryptor/LegacyCryptor;", "Lcom/pubnub/api/crypto/cryptor/Cryptor;", "cipherKey", "", "useRandomIv", "", "<init>", "(Ljava/lang/String;Z)V", "getCipherKey", "()Ljava/lang/String;", "getUseRandomIv", "()Z", "newKey", "Ljavax/crypto/spec/SecretKeySpec;", "id", "", "encrypt", "Lcom/pubnub/api/crypto/data/EncryptedData;", "data", "decrypt", "encryptedData", "encryptStream", "Lcom/pubnub/api/crypto/data/EncryptedStreamData;", "stream", "Ljava/io/InputStream;", "decryptStream", "validateEncryptedInputStreamAndReturnBuffered", "Ljava/io/BufferedInputStream;", "validateStreamAndReturnBuffered", "createNewKey", "sha256", "input", "hexEncode", "validateData", "", "getIvBytesForEncryption", "createRandomIv", "getIvBytesForDecryption", "createInitializedCipher", "Ljavax/crypto/Cipher;", "iv", "mode", "", "getEncryptedDataForProcessing", "pubnub-kotlin-impl"})
public final class LegacyCryptor
implements Cryptor {
    @NotNull
    private final String cipherKey;
    private final boolean useRandomIv;
    @NotNull
    private final SecretKeySpec newKey;

    public LegacyCryptor(@NotNull String cipherKey, boolean useRandomIv) {
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        this.cipherKey = cipherKey;
        this.useRandomIv = useRandomIv;
        this.newKey = this.createNewKey();
    }

    public /* synthetic */ LegacyCryptor(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    @NotNull
    public final String getCipherKey() {
        return this.cipherKey;
    }

    public final boolean getUseRandomIv() {
        return this.useRandomIv;
    }

    @NotNull
    public byte[] id() {
        return LegacyCryptorKt.getLEGACY_CRYPTOR_ID();
    }

    @NotNull
    public EncryptedData encrypt(@NotNull byte[] data) {
        EncryptedData encryptedData;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.validateData(data);
        try {
            byte[] ivBytes = this.getIvBytesForEncryption();
            Cipher cipher = this.createInitializedCipher(ivBytes, 1);
            byte[] byArray = cipher.doFinal(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            byte[] encrypted = byArray;
            encryptedData = this.useRandomIv ? new EncryptedData(null, ArraysKt.plus((byte[])ivBytes, (byte[])encrypted), 1, null) : new EncryptedData(null, encrypted, 1, null);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return encryptedData;
    }

    @NotNull
    public byte[] decrypt(@NotNull EncryptedData encryptedData) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        this.validateData(encryptedData);
        try {
            byte[] decryptedData;
            byte[] ivBytes = this.getIvBytesForDecryption(encryptedData);
            Cipher cipher = this.createInitializedCipher(ivBytes, 2);
            byte[] encryptedDataForProcessing = this.getEncryptedDataForProcessing(encryptedData);
            byArray = decryptedData = cipher.doFinal(encryptedDataForProcessing);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return byArray;
    }

    @NotNull
    public EncryptedStreamData encryptStream(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BufferedInputStream bufferedInputStream = this.validateStreamAndReturnBuffered(stream);
        try {
            byte[] ivBytes = this.createRandomIv();
            Cipher cipher = this.createInitializedCipher(ivBytes, 1);
            CipherInputStream cipheredStream = new CipherInputStream(bufferedInputStream, cipher);
            return new EncryptedStreamData(null, (InputStream)new SequenceInputStream(new ByteArrayInputStream(ivBytes), cipheredStream), 1, null);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    @NotNull
    public InputStream decryptStream(@NotNull EncryptedStreamData encryptedData) {
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        BufferedInputStream bufferedInputStream = this.validateEncryptedInputStreamAndReturnBuffered(encryptedData.getStream());
        try {
            byte[] ivBytes = new byte[16];
            int numberOfReadBytes = bufferedInputStream.read(ivBytes);
            if (numberOfReadBytes != 16) {
                throw new PubNubException("Could not read IV from encrypted stream", PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
            }
            Cipher cipher = this.createInitializedCipher(ivBytes, 2);
            return new CipherInputStream(bufferedInputStream, cipher);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final BufferedInputStream validateEncryptedInputStreamAndReturnBuffered(InputStream stream) {
        InputStream inputStream = stream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        CryptoModuleImplKt.checkMinSize(bufferedInputStream, 32, (Function1<? super Integer, Unit>)((Function1)LegacyCryptor::validateEncryptedInputStreamAndReturnBuffered$lambda$0));
        return bufferedInputStream;
    }

    private final BufferedInputStream validateStreamAndReturnBuffered(InputStream stream) {
        InputStream inputStream = stream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        CryptoModuleImplKt.checkMinSize(bufferedInputStream, 1, (Function1<? super Integer, Unit>)((Function1)LegacyCryptor::validateStreamAndReturnBuffered$lambda$1));
        return bufferedInputStream;
    }

    private final SecretKeySpec createNewKey() {
        Object object = this.cipherKey;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        object = this.hexEncode(this.sha256(byArray));
        Charset charset = Charsets.UTF_8;
        object = new String((byte[])object, charset);
        int n = 0;
        int n2 = 32;
        String string = ((String)object).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        object = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        object = string2;
        byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] keyBytes = byArray2;
        return new SecretKeySpec(keyBytes, "AES");
    }

    private final byte[] sha256(byte[] input) {
        byte[] byArray;
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
            byArray = digest.digest(input);
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return byArray;
    }

    private final byte[] hexEncode(byte[] input) {
        StringBuilder result = new StringBuilder();
        for (byte byt : input) {
            String string;
            Intrinsics.checkNotNullExpressionValue((Object)Integer.toString((byt & 0xFF) + 256, 16), (String)"toString(...)");
            int n = 1;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            result.append(string2);
        }
        try {
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string3 = string;
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new PubNubException(e.getMessage(), PubNubError.CRYPTO_ERROR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final void validateData(byte[] data) {
        if (data.length == 0) {
            throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final byte[] getIvBytesForEncryption() {
        byte[] byArray;
        if (this.useRandomIv) {
            byArray = this.createRandomIv();
        } else {
            String string = "0123456789012345";
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        }
        return byArray;
    }

    private final byte[] createRandomIv() {
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        return ivBytes;
    }

    private final void validateData(EncryptedData encryptedData) {
        int encryptedDatSize = encryptedData.getData().length;
        if (this.useRandomIv ? encryptedDatSize <= 16 : encryptedDatSize == 0) {
            throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final byte[] getIvBytesForDecryption(EncryptedData encryptedData) {
        byte[] byArray;
        if (this.useRandomIv) {
            byArray = ArraysKt.sliceArray((byte[])encryptedData.getData(), (IntRange)new IntRange(0, 15));
        } else {
            String string = "0123456789012345";
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        }
        return byArray;
    }

    private final Cipher createInitializedCipher(byte[] iv, int mode) {
        Cipher cipher;
        Cipher it = cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        boolean bl = false;
        it.init(mode, (Key)this.newKey, new IvParameterSpec(iv));
        Cipher cipher2 = cipher;
        Intrinsics.checkNotNullExpressionValue((Object)cipher2, (String)"also(...)");
        return cipher2;
    }

    private final byte[] getEncryptedDataForProcessing(EncryptedData encryptedData) {
        byte[] encryptedDataForProcessing = this.useRandomIv ? ArraysKt.sliceArray((byte[])encryptedData.getData(), (IntRange)RangesKt.until((int)16, (int)encryptedData.getData().length)) : encryptedData.getData();
        return encryptedDataForProcessing;
    }

    private static final Unit validateEncryptedInputStreamAndReturnBuffered$lambda$0(int it) {
        throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
    }

    private static final Unit validateStreamAndReturnBuffered$lambda$1(int it) {
        throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
    }
}

