/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.endpoints.files.DownloadFile;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNDownloadFileResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\"\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0015H\u0014J\u0016\u0010\u0016\u001a\u00020\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH\u0014J\b\u0010!\u001a\u00020\u001fH\u0014J\b\u0010\"\u001a\u00020#H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/pubnub/internal/endpoints/files/DownloadFileEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lokhttp3/ResponseBody;", "Lcom/pubnub/api/models/consumer/files/PNDownloadFileResult;", "Lcom/pubnub/api/endpoints/files/DownloadFile;", "channel", "", "fileName", "fileId", "cryptoModule", "Lcom/pubnub/api/crypto/CryptoModule;", "pubNub", "Lcom/pubnub/internal/PubNubImpl;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/crypto/CryptoModule;Lcom/pubnub/internal/PubNubImpl;)V", "validateParams", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "getAffectedChannels", "", "getAffectedChannelGroups", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "isAuthRequired", "", "isSubKeyRequired", "isPubKeyRequired", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "pubnub-kotlin-impl"})
public final class DownloadFileEndpoint
extends EndpointCore<ResponseBody, PNDownloadFileResult>
implements DownloadFile {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;
    @NotNull
    private final String fileId;
    @Nullable
    private final CryptoModule cryptoModule;

    public DownloadFileEndpoint(@NotNull String channel, @NotNull String fileName, @NotNull String fileId, @Nullable CryptoModule cryptoModule, @NotNull PubNubImpl pubNub) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.channel = channel;
        this.fileName = fileName;
        this.fileId = fileId;
        this.cryptoModule = cryptoModule;
    }

    public /* synthetic */ DownloadFileEndpoint(String string, String string2, String string3, CryptoModule cryptoModule, PubNubImpl pubNubImpl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            cryptoModule = null;
        }
        this(string, string2, string3, cryptoModule, pubNubImpl);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected Call<ResponseBody> doWork(@NotNull HashMap<String, String> queryParams) throws PubNubException {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return this.getRetrofitManager().getFilesService$pubnub_kotlin_impl().downloadFile(this.getConfiguration().getSubscribeKey(), this.channel, this.fileId, this.fileName, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNDownloadFileResult createResponse(@NotNull Response<ResponseBody> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (!input.isSuccessful()) {
            throw new PubNubException(PubNubError.HTTP_ERROR, null, 2, null);
        }
        if (input.body() == null) {
            throw new PubNubException(PubNubError.INTERNAL_ERROR, null, 2, null);
        }
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        InputStream bodyStream = ((ResponseBody)object).byteStream();
        Object object2 = this.cryptoModule;
        if (object2 == null || (object2 = object2.decryptStream(bodyStream)) == null) {
            object2 = bodyStream;
        }
        Object byteStream = object2;
        return new PNDownloadFileResult(this.fileName, (InputStream)byteStream);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public PNOperationType operationType() {
        return (PNOperationType)PNOperationType.FileOperation.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.FILE_PERSISTENCE;
    }
}

