/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.v2.subscription;

import com.pubnub.api.callbacks.Listener;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.api.v2.callbacks.EventListener;
import com.pubnub.api.v2.subscriptions.EmptyOptions;
import com.pubnub.api.v2.subscriptions.FilterImpl;
import com.pubnub.api.v2.subscriptions.Subscription;
import com.pubnub.api.v2.subscriptions.SubscriptionCursor;
import com.pubnub.api.v2.subscriptions.SubscriptionOptions;
import com.pubnub.api.v2.subscriptions.SubscriptionSet;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.managers.AnnouncementCallback;
import com.pubnub.internal.managers.AnnouncementEnvelope;
import com.pubnub.internal.v2.callbacks.EventEmitterImpl;
import com.pubnub.internal.v2.entities.ChannelGroupName;
import com.pubnub.internal.v2.entities.ChannelName;
import com.pubnub.internal.v2.subscription.EmitterHelper;
import com.pubnub.internal.v2.subscription.SubscriptionInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010%\u001a\u00020\u00152\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0'J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020(H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\b\u00100\u001a\u00020,H\u0016J\b\u00101\u001a\u00020,H\u0016J\b\u00102\u001a\u00020,H\u0016J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020,H\u0016J\u0010\u00107\u001a\u00020,2\u0006\u00104\u001a\u000208H\u0016J\u0011\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0096\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u0010=\u001a\u0010\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020,\u0018\u00010\f2\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020,\u0018\u00010\f8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C*\u0004\b>\u0010?RG\u0010E\u001a\u0010\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020,\u0018\u00010\f2\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020,\u0018\u00010\f8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bG\u0010A\"\u0004\bH\u0010C*\u0004\bF\u0010?RG\u0010J\u001a\u0010\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020,\u0018\u00010\f2\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020,\u0018\u00010\f8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bL\u0010A\"\u0004\bM\u0010C*\u0004\bK\u0010?RG\u0010O\u001a\u0010\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020,\u0018\u00010\f2\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020,\u0018\u00010\f8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bQ\u0010A\"\u0004\bR\u0010C*\u0004\bP\u0010?RG\u0010T\u001a\u0010\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020,\u0018\u00010\f2\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020,\u0018\u00010\f8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bV\u0010A\"\u0004\bW\u0010C*\u0004\bU\u0010?RG\u0010Y\u001a\u0010\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020,\u0018\u00010\f2\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020,\u0018\u00010\f8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b[\u0010A\"\u0004\b\\\u0010C*\u0004\bZ\u0010?\u00a8\u0006a"}, d2={"Lcom/pubnub/internal/v2/subscription/SubscriptionImpl;", "Lcom/pubnub/internal/v2/subscription/SubscriptionInternal;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channels", "", "Lcom/pubnub/internal/v2/entities/ChannelName;", "channelGroups", "Lcom/pubnub/internal/v2/entities/ChannelGroupName;", "options", "Lcom/pubnub/api/v2/subscriptions/SubscriptionOptions;", "eventEmitterFactory", "Lkotlin/Function1;", "Lcom/pubnub/internal/v2/callbacks/EventEmitterImpl;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/util/Set;Ljava/util/Set;Lcom/pubnub/api/v2/subscriptions/SubscriptionOptions;Lkotlin/jvm/functions/Function1;)V", "getPubnub", "()Lcom/pubnub/internal/PubNubImpl;", "getOptions", "()Lcom/pubnub/api/v2/subscriptions/SubscriptionOptions;", "newValue", "", "isActive", "()Z", "setActive", "(Z)V", "getChannels", "()Ljava/util/Set;", "getChannelGroups", "filters", "", "Lcom/pubnub/api/v2/subscriptions/FilterImpl;", "lastTimetoken", "", "eventEmitter", "getEventEmitter", "()Lcom/pubnub/internal/v2/callbacks/EventEmitterImpl;", "accepts", "envelope", "Lcom/pubnub/internal/managers/AnnouncementEnvelope;", "Lcom/pubnub/api/models/consumer/pubsub/PNEvent;", "checkAndUpdateTimetoken", "result", "subscribe", "", "cursor", "Lcom/pubnub/api/v2/subscriptions/SubscriptionCursor;", "onSubscriptionActive", "unsubscribe", "onSubscriptionInactive", "close", "addListener", "listener", "Lcom/pubnub/api/v2/callbacks/EventListener;", "removeAllListeners", "removeListener", "Lcom/pubnub/api/callbacks/Listener;", "emitterHelper", "Lcom/pubnub/internal/v2/subscription/EmitterHelper;", "<set-?>", "Lcom/pubnub/api/models/consumer/pubsub/PNMessageResult;", "onMessage", "getOnMessage$delegate", "(Lcom/pubnub/internal/v2/subscription/SubscriptionImpl;)Ljava/lang/Object;", "getOnMessage", "()Lkotlin/jvm/functions/Function1;", "setOnMessage", "(Lkotlin/jvm/functions/Function1;)V", "Lcom/pubnub/api/models/consumer/pubsub/PNPresenceEventResult;", "onPresence", "getOnPresence$delegate", "getOnPresence", "setOnPresence", "Lcom/pubnub/api/models/consumer/pubsub/PNSignalResult;", "onSignal", "getOnSignal$delegate", "getOnSignal", "setOnSignal", "Lcom/pubnub/api/models/consumer/pubsub/message_actions/PNMessageActionResult;", "onMessageAction", "getOnMessageAction$delegate", "getOnMessageAction", "setOnMessageAction", "Lcom/pubnub/api/models/consumer/pubsub/objects/PNObjectEventResult;", "onObjects", "getOnObjects$delegate", "getOnObjects", "setOnObjects", "Lcom/pubnub/api/models/consumer/pubsub/files/PNFileEventResult;", "onFile", "getOnFile$delegate", "getOnFile", "setOnFile", "plus", "Lcom/pubnub/api/v2/subscriptions/SubscriptionSet;", "subscription", "Lcom/pubnub/api/v2/subscriptions/Subscription;", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nSubscriptionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionImpl.kt\ncom/pubnub/internal/v2/subscription/SubscriptionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n808#2,11:141\n1734#2,3:152\n*S KotlinDebug\n*F\n+ 1 SubscriptionImpl.kt\ncom/pubnub/internal/v2/subscription/SubscriptionImpl\n*L\n60#1:141,11\n74#1:152,3\n*E\n"})
public class SubscriptionImpl
implements SubscriptionInternal {
    @NotNull
    private final PubNubImpl pubnub;
    @NotNull
    private final SubscriptionOptions options;
    private volatile boolean isActive;
    @NotNull
    private final Set<ChannelName> channels;
    @NotNull
    private final Set<ChannelGroupName> channelGroups;
    @NotNull
    private final List<FilterImpl> filters;
    private long lastTimetoken;
    @NotNull
    private final EventEmitterImpl eventEmitter;
    @NotNull
    private final EmitterHelper emitterHelper;

    /*
     * WARNING - void declaration
     */
    public SubscriptionImpl(@NotNull PubNubImpl pubnub, @NotNull Set<ChannelName> channels, @NotNull Set<ChannelGroupName> channelGroups, @NotNull SubscriptionOptions options, @NotNull Function1<? super SubscriptionImpl, EventEmitterImpl> eventEmitterFactory) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(eventEmitterFactory, (String)"eventEmitterFactory");
        this.pubnub = pubnub;
        this.options = options;
        this.channels = CollectionsKt.toSet((Iterable)channels);
        this.channelGroups = CollectionsKt.toSet((Iterable)channelGroups);
        Iterable iterable = this.options.getAllOptions();
        SubscriptionImpl subscriptionImpl = this;
        boolean $i$f$filterIsInstance = false;
        void var8_9 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FilterImpl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        subscriptionImpl.filters = (List)destination$iv$iv;
        this.eventEmitter = (EventEmitterImpl)eventEmitterFactory.invoke((Object)this);
        this.emitterHelper = new EmitterHelper(this.eventEmitter);
    }

    public /* synthetic */ SubscriptionImpl(PubNubImpl pubNubImpl, Set set, Set set2, SubscriptionOptions subscriptionOptions, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 8) != 0) {
            subscriptionOptions = (SubscriptionOptions)EmptyOptions.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function1 = SubscriptionImpl::_init_$lambda$0;
        }
        this(pubNubImpl, set, set2, subscriptionOptions, (Function1<? super SubscriptionImpl, EventEmitterImpl>)function1);
    }

    @Override
    @NotNull
    public PubNubImpl getPubnub() {
        return this.pubnub;
    }

    @NotNull
    public final SubscriptionOptions getOptions() {
        return this.options;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final synchronized void setActive(boolean newValue) {
        if (!this.isActive && newValue) {
            this.getPubnub().getListenerManager().addAnnouncementCallback$pubnub_kotlin_impl(this.eventEmitter);
        } else if (this.isActive && !newValue) {
            this.getPubnub().getListenerManager().removeAnnouncementCallback$pubnub_kotlin_impl(this.eventEmitter);
        }
        this.isActive = newValue;
    }

    @Override
    @NotNull
    public Set<ChannelName> getChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    public Set<ChannelGroupName> getChannelGroups() {
        return this.channelGroups;
    }

    @NotNull
    protected final EventEmitterImpl getEventEmitter() {
        return this.eventEmitter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean accepts(@NotNull AnnouncementEnvelope<? extends PNEvent> envelope) {
        boolean bl;
        Intrinsics.checkNotNullParameter(envelope, (String)"envelope");
        PNEvent event = envelope.getEvent();
        if (!this.isActive) return false;
        Iterable $this$all$iv = this.filters;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                FilterImpl filter = (FilterImpl)element$iv;
                boolean bl2 = false;
                if (((Boolean)filter.getPredicate().invoke((Object)event)).booleanValue()) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (!this.checkAndUpdateTimetoken(event)) return false;
        boolean bl3 = true;
        boolean accepted = bl3;
        if (!accepted) return accepted;
        ((Collection)envelope.getAcceptedBy()).add(this);
        return accepted;
    }

    private final boolean checkAndUpdateTimetoken(PNEvent result) {
        Long l = result.getTimetoken();
        if (l != null) {
            long resultTimetoken = ((Number)l).longValue();
            boolean bl = false;
            if (resultTimetoken <= this.lastTimetoken) {
                return false;
            }
            this.lastTimetoken = resultTimetoken;
            return true;
        }
        return false;
    }

    public void subscribe(@NotNull SubscriptionCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        this.onSubscriptionActive(cursor);
        SubscriptionInternal[] subscriptionInternalArray = new SubscriptionInternal[]{this};
        this.getPubnub().subscribe$pubnub_kotlin_impl(subscriptionInternalArray, cursor);
    }

    @Override
    public void onSubscriptionActive(@NotNull SubscriptionCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        this.lastTimetoken = cursor.getTimetoken();
        this.setActive(true);
    }

    public void unsubscribe() {
        this.onSubscriptionInactive();
        SubscriptionInternal[] subscriptionInternalArray = new SubscriptionInternal[]{this};
        this.getPubnub().unsubscribe$pubnub_kotlin_impl(subscriptionInternalArray);
    }

    @Override
    public void onSubscriptionInactive() {
        this.lastTimetoken = 0L;
        this.setActive(false);
    }

    public void close() {
        this.unsubscribe();
    }

    public void addListener(@NotNull EventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventEmitter.addListener(listener);
    }

    public void removeAllListeners() {
        this.eventEmitter.removeAllListeners();
    }

    public void removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventEmitter.removeListener(listener);
    }

    @Nullable
    public Function1<PNMessageResult, Unit> getOnMessage() {
        return this.emitterHelper.getOnMessage();
    }

    public void setOnMessage(@Nullable Function1<? super PNMessageResult, Unit> function1) {
        this.emitterHelper.setOnMessage(function1);
    }

    private static Object getOnMessage$delegate(SubscriptionImpl subscriptionImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)subscriptionImpl.emitterHelper, EmitterHelper.class, "onMessage", "getOnMessage()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNPresenceEventResult, Unit> getOnPresence() {
        return this.emitterHelper.getOnPresence();
    }

    public void setOnPresence(@Nullable Function1<? super PNPresenceEventResult, Unit> function1) {
        this.emitterHelper.setOnPresence(function1);
    }

    private static Object getOnPresence$delegate(SubscriptionImpl subscriptionImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)subscriptionImpl.emitterHelper, EmitterHelper.class, "onPresence", "getOnPresence()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNSignalResult, Unit> getOnSignal() {
        return this.emitterHelper.getOnSignal();
    }

    public void setOnSignal(@Nullable Function1<? super PNSignalResult, Unit> function1) {
        this.emitterHelper.setOnSignal(function1);
    }

    private static Object getOnSignal$delegate(SubscriptionImpl subscriptionImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)subscriptionImpl.emitterHelper, EmitterHelper.class, "onSignal", "getOnSignal()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNMessageActionResult, Unit> getOnMessageAction() {
        return this.emitterHelper.getOnMessageAction();
    }

    public void setOnMessageAction(@Nullable Function1<? super PNMessageActionResult, Unit> function1) {
        this.emitterHelper.setOnMessageAction(function1);
    }

    private static Object getOnMessageAction$delegate(SubscriptionImpl subscriptionImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)subscriptionImpl.emitterHelper, EmitterHelper.class, "onMessageAction", "getOnMessageAction()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNObjectEventResult, Unit> getOnObjects() {
        return this.emitterHelper.getOnObjects();
    }

    public void setOnObjects(@Nullable Function1<? super PNObjectEventResult, Unit> function1) {
        this.emitterHelper.setOnObjects(function1);
    }

    private static Object getOnObjects$delegate(SubscriptionImpl subscriptionImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)subscriptionImpl.emitterHelper, EmitterHelper.class, "onObjects", "getOnObjects()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNFileEventResult, Unit> getOnFile() {
        return this.emitterHelper.getOnFile();
    }

    public void setOnFile(@Nullable Function1<? super PNFileEventResult, Unit> function1) {
        this.emitterHelper.setOnFile(function1);
    }

    private static Object getOnFile$delegate(SubscriptionImpl subscriptionImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)subscriptionImpl.emitterHelper, EmitterHelper.class, "onFile", "getOnFile()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @NotNull
    public SubscriptionSet plus(@NotNull Subscription subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        Object[] objectArray = new Subscription[]{this, subscription};
        return this.getPubnub().subscriptionSetOf(SetsKt.setOf((Object[])objectArray));
    }

    private static final EventEmitterImpl _init_$lambda$0(SubscriptionImpl subscriptionImpl) {
        Intrinsics.checkNotNullParameter((Object)subscriptionImpl, (String)"subscriptionImpl");
        return new EventEmitterImpl(AnnouncementCallback.Phase.SUBSCRIPTION, (Function1<? super AnnouncementEnvelope<? extends PNEvent>, Boolean>)((Function1)new Function1<AnnouncementEnvelope<? extends PNEvent>, Boolean>((Object)subscriptionImpl){

            public final Boolean invoke(AnnouncementEnvelope<? extends PNEvent> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((SubscriptionImpl)this.receiver).accepts(p0);
            }
        }));
    }
}

