/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.output.AggregateResultOutput;
import com.redis.lettucemod.search.AggregateResults;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;

public class AggregateOutput<K, V, R extends AggregateResults<K>>
extends CommandOutput<K, V, R> {
    private final AggregateResultOutput<K, V> nested;
    protected int mapCount = -1;

    public AggregateOutput(RedisCodec<K, V> codec, R results) {
        super(codec, results);
        this.nested = new AggregateResultOutput<K, V>(codec);
    }

    public void set(ByteBuffer bytes) {
        this.nested.set(bytes);
    }

    public void complete(int depth) {
        if (this.nested.isComplete()) {
            ((AggregateResults)this.output).add(this.nested.getAndClear());
        }
    }

    public void set(long integer) {
        ((AggregateResults)this.output).setCount(integer);
    }

    public void multi(int count) {
        if (this.mapCount == -1) {
            this.mapCount = count - 1;
        } else {
            this.nested.multi(count);
        }
    }
}

