/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.RedisModulesCommandBuilder;
import com.redis.lettucemod.output.GetOutput;
import com.redis.lettucemod.output.RangeOutput;
import com.redis.lettucemod.output.SampleListOutput;
import com.redis.lettucemod.output.SampleOutput;
import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.protocol.TimeSeriesCommandType;
import com.redis.lettucemod.timeseries.AddOptions;
import com.redis.lettucemod.timeseries.AlterOptions;
import com.redis.lettucemod.timeseries.CreateOptions;
import com.redis.lettucemod.timeseries.CreateRuleOptions;
import com.redis.lettucemod.timeseries.GetResult;
import com.redis.lettucemod.timeseries.IncrbyOptions;
import com.redis.lettucemod.timeseries.KeySample;
import com.redis.lettucemod.timeseries.MGetOptions;
import com.redis.lettucemod.timeseries.MRangeOptions;
import com.redis.lettucemod.timeseries.RangeOptions;
import com.redis.lettucemod.timeseries.RangeResult;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.lettucemod.timeseries.TimeRange;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerListOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.NestedMultiOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.List;

public class TimeSeriesCommandBuilder<K, V>
extends RedisModulesCommandBuilder<K, V> {
    private static final String AUTO_TIMESTAMP = "*";

    public TimeSeriesCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected <A, B, T> Command<A, B, T> createCommand(TimeSeriesCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    public Command<K, V, String> create(K key, CreateOptions<K, V> options) {
        CommandArgs args = this.args(key);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(TimeSeriesCommandType.CREATE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> alter(K key, AlterOptions<K, V> options) {
        CommandArgs args = this.args(key);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(TimeSeriesCommandType.ALTER, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> add(K key, Sample sample) {
        return this.add(key, sample, null);
    }

    public Command<K, V, Long> add(K key, Sample sample, AddOptions<K, V> options) {
        TimeSeriesCommandBuilder.notNull(sample, "Sample");
        CommandArgs args = this.args(key);
        this.add(args, sample.getTimestamp(), sample.getValue());
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(TimeSeriesCommandType.ADD, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    private void add(CommandArgs<K, V> args, long timestamp, double value) {
        TimeSeriesCommandBuilder.addTimestamp(args, timestamp);
        args.add(value);
    }

    public static <K, V> void addTimestamp(CommandArgs<K, V> args, long timestamp) {
        if (timestamp == 0L) {
            args.add(AUTO_TIMESTAMP);
        } else {
            args.add(timestamp);
        }
    }

    public Command<K, V, List<Long>> madd(KeySample<K> ... samples) {
        TimeSeriesCommandBuilder.notEmpty(samples, "Samples");
        CommandArgs args = new CommandArgs(this.codec);
        for (KeySample<K> sample : samples) {
            args.addKey(sample.getKey());
            this.add(args, sample.getTimestamp(), sample.getValue());
        }
        return this.createCommand(TimeSeriesCommandType.MADD, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> incrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.incrby(TimeSeriesCommandType.INCRBY, key, value, options);
    }

    public Command<K, V, Long> decrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.incrby(TimeSeriesCommandType.DECRBY, key, value, options);
    }

    private Command<K, V, Long> incrby(TimeSeriesCommandType commandType, K key, double value, IncrbyOptions<K, V> options) {
        CommandArgs args = this.args(key);
        args.add(value);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(commandType, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> createRule(K sourceKey, K destKey, CreateRuleOptions options) {
        TimeSeriesCommandBuilder.notNull(sourceKey, "Source key");
        TimeSeriesCommandBuilder.notNull(destKey, "Destination key");
        TimeSeriesCommandBuilder.notNull(options, "Options");
        CommandArgs args = this.args(sourceKey);
        args.addKey(destKey);
        options.build(args);
        return this.createCommand(TimeSeriesCommandType.CREATERULE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> deleteRule(K sourceKey, K destKey) {
        TimeSeriesCommandBuilder.notNull(sourceKey, "Source key");
        TimeSeriesCommandBuilder.notNull(destKey, "Destination key");
        CommandArgs args = this.args(sourceKey);
        args.addKey(destKey);
        return this.createCommand(TimeSeriesCommandType.DELETERULE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Sample>> range(K key, TimeRange range) {
        return this.range(key, range, null);
    }

    public Command<K, V, List<Sample>> range(K key, TimeRange range, RangeOptions options) {
        return this.range(TimeSeriesCommandType.RANGE, key, range, options);
    }

    public Command<K, V, List<Sample>> revrange(K key, TimeRange range) {
        return this.revrange(key, range, null);
    }

    public Command<K, V, List<Sample>> revrange(K key, TimeRange range, RangeOptions options) {
        return this.range(TimeSeriesCommandType.REVRANGE, key, range, options);
    }

    private Command<K, V, List<Sample>> range(TimeSeriesCommandType commandType, K key, TimeRange range, RangeOptions options) {
        TimeSeriesCommandBuilder.notNull(range, "Time range");
        CommandArgs args = this.args(key);
        range.build(args);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(commandType, new SampleListOutput(this.codec), args);
    }

    public Command<K, V, List<RangeResult<K, V>>> mrange(TimeRange range) {
        return this.mrange(range, null);
    }

    public Command<K, V, List<RangeResult<K, V>>> mrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.mrange(RangeDirection.FORWARD, range, options);
    }

    public Command<K, V, List<RangeResult<K, V>>> mrevrange(TimeRange range) {
        return this.mrevrange(range, null);
    }

    public Command<K, V, List<RangeResult<K, V>>> mrevrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.mrange(RangeDirection.REVERSE, range, options);
    }

    private Command<K, V, List<RangeResult<K, V>>> mrange(RangeDirection direction, TimeRange range, MRangeOptions<K, V> options) {
        TimeSeriesCommandBuilder.notNull(range, "Time range");
        CommandArgs args = new CommandArgs(this.codec);
        range.build(args);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(direction == RangeDirection.REVERSE ? TimeSeriesCommandType.MREVRANGE : TimeSeriesCommandType.MRANGE, new RangeOutput(this.codec), args);
    }

    public Command<K, V, Sample> get(K key) {
        return this.createCommand(TimeSeriesCommandType.GET, new SampleOutput(this.codec), this.args(key));
    }

    public Command<K, V, List<GetResult<K, V>>> mgetWithLabels(V ... filters) {
        return this.mget(MGetOptions.filters(filters).withLabels().build());
    }

    public Command<K, V, List<GetResult<K, V>>> mget(V ... filters) {
        return this.mget(MGetOptions.filters(filters).build());
    }

    public Command<K, V, List<GetResult<K, V>>> mget(MGetOptions<K, V> options) {
        CommandArgs args = new CommandArgs(this.codec);
        options.build(args);
        return this.createCommand(TimeSeriesCommandType.MGET, new GetOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> info(K key, boolean debug) {
        TimeSeriesCommandBuilder.notNullKey(key);
        CommandArgs args = this.args(key);
        if (debug) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.DEBUG);
        }
        return this.createCommand(TimeSeriesCommandType.INFO, (CommandOutput)new NestedMultiOutput(this.codec), (CommandArgs)args);
    }

    private static enum RangeDirection {
        FORWARD,
        REVERSE;

    }
}

