/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unfbx.chatgpt.entity.chat.Functions;
import com.unfbx.chatgpt.entity.chat.ResponseFormat;
import com.unfbx.chatgpt.entity.chat.tool.Tools;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BaseChatCompletion
implements Serializable {
    @NonNull
    private String model;
    @JsonProperty(value="response_format")
    private ResponseFormat responseFormat;
    @Deprecated
    private List<Functions> functions;
    @Deprecated
    @JsonProperty(value="function_call")
    private Object functionCall;
    private List<Tools> tools;
    @JsonProperty(value="tool_choice")
    private Object toolChoice;
    private double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    private Integer n;
    private boolean stream;
    private List<String> stop;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    private double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    private Map logitBias;
    private String user;
    private Integer seed;

    private static String $default$model() {
        return Model.GPT_3_5_TURBO.getName();
    }

    private static double $default$temperature() {
        return 0.2;
    }

    private static Double $default$topP() {
        return 1.0;
    }

    private static Integer $default$n() {
        return 1;
    }

    private static boolean $default$stream() {
        return false;
    }

    private static Integer $default$maxTokens() {
        return 2048;
    }

    private static double $default$presencePenalty() {
        return 0.0;
    }

    private static double $default$frequencyPenalty() {
        return 0.0;
    }

    protected BaseChatCompletion(BaseChatCompletionBuilder<?, ?> b) {
        this.model = ((BaseChatCompletionBuilder)b).model$set ? ((BaseChatCompletionBuilder)b).model$value : BaseChatCompletion.$default$model();
        if (this.model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.responseFormat = ((BaseChatCompletionBuilder)b).responseFormat;
        this.functions = ((BaseChatCompletionBuilder)b).functions;
        this.functionCall = ((BaseChatCompletionBuilder)b).functionCall;
        this.tools = ((BaseChatCompletionBuilder)b).tools;
        this.toolChoice = ((BaseChatCompletionBuilder)b).toolChoice;
        this.temperature = ((BaseChatCompletionBuilder)b).temperature$set ? ((BaseChatCompletionBuilder)b).temperature$value : BaseChatCompletion.$default$temperature();
        this.topP = ((BaseChatCompletionBuilder)b).topP$set ? ((BaseChatCompletionBuilder)b).topP$value : BaseChatCompletion.$default$topP();
        this.n = ((BaseChatCompletionBuilder)b).n$set ? ((BaseChatCompletionBuilder)b).n$value : BaseChatCompletion.$default$n();
        this.stream = ((BaseChatCompletionBuilder)b).stream$set ? ((BaseChatCompletionBuilder)b).stream$value : BaseChatCompletion.$default$stream();
        this.stop = ((BaseChatCompletionBuilder)b).stop;
        this.maxTokens = ((BaseChatCompletionBuilder)b).maxTokens$set ? ((BaseChatCompletionBuilder)b).maxTokens$value : BaseChatCompletion.$default$maxTokens();
        this.presencePenalty = ((BaseChatCompletionBuilder)b).presencePenalty$set ? ((BaseChatCompletionBuilder)b).presencePenalty$value : BaseChatCompletion.$default$presencePenalty();
        this.frequencyPenalty = ((BaseChatCompletionBuilder)b).frequencyPenalty$set ? ((BaseChatCompletionBuilder)b).frequencyPenalty$value : BaseChatCompletion.$default$frequencyPenalty();
        this.logitBias = ((BaseChatCompletionBuilder)b).logitBias;
        this.user = ((BaseChatCompletionBuilder)b).user;
        this.seed = ((BaseChatCompletionBuilder)b).seed;
    }

    public static BaseChatCompletionBuilder<?, ?> builder() {
        return new BaseChatCompletionBuilderImpl();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    @Deprecated
    public List<Functions> getFunctions() {
        return this.functions;
    }

    @Deprecated
    public Object getFunctionCall() {
        return this.functionCall;
    }

    public List<Tools> getTools() {
        return this.tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public boolean isStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @Deprecated
    public void setFunctions(List<Functions> functions) {
        this.functions = functions;
    }

    @Deprecated
    @JsonProperty(value="function_call")
    public void setFunctionCall(Object functionCall) {
        this.functionCall = functionCall;
    }

    public void setTools(List<Tools> tools) {
        this.tools = tools;
    }

    @JsonProperty(value="tool_choice")
    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseChatCompletion)) {
            return false;
        }
        BaseChatCompletion other = (BaseChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (Double.compare(this.getPresencePenalty(), other.getPresencePenalty()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrequencyPenalty(), other.getFrequencyPenalty()) != 0) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        ResponseFormat this$responseFormat = this.getResponseFormat();
        ResponseFormat other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !((Object)this$responseFormat).equals(other$responseFormat)) {
            return false;
        }
        List<Functions> this$functions = this.getFunctions();
        List<Functions> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        Object this$functionCall = this.getFunctionCall();
        Object other$functionCall = other.getFunctionCall();
        if (this$functionCall == null ? other$functionCall != null : !this$functionCall.equals(other$functionCall)) {
            return false;
        }
        List<Tools> this$tools = this.getTools();
        List<Tools> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        Object this$toolChoice = this.getToolChoice();
        Object other$toolChoice = other.getToolChoice();
        if (this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map this$logitBias = this.getLogitBias();
        Map other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseChatCompletion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        result = result * 59 + (this.isStream() ? 79 : 97);
        long $presencePenalty = Double.doubleToLongBits(this.getPresencePenalty());
        result = result * 59 + (int)($presencePenalty >>> 32 ^ $presencePenalty);
        long $frequencyPenalty = Double.doubleToLongBits(this.getFrequencyPenalty());
        result = result * 59 + (int)($frequencyPenalty >>> 32 ^ $frequencyPenalty);
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        ResponseFormat $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : ((Object)$responseFormat).hashCode());
        List<Functions> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        Object $functionCall = this.getFunctionCall();
        result = result * 59 + ($functionCall == null ? 43 : $functionCall.hashCode());
        List<Tools> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        Object $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "BaseChatCompletion(model=" + this.getModel() + ", responseFormat=" + this.getResponseFormat() + ", functions=" + this.getFunctions() + ", functionCall=" + this.getFunctionCall() + ", tools=" + this.getTools() + ", toolChoice=" + this.getToolChoice() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.isStream() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ", seed=" + this.getSeed() + ")";
    }

    public BaseChatCompletion() {
        this.model = BaseChatCompletion.$default$model();
        this.temperature = BaseChatCompletion.$default$temperature();
        this.topP = BaseChatCompletion.$default$topP();
        this.n = BaseChatCompletion.$default$n();
        this.stream = BaseChatCompletion.$default$stream();
        this.maxTokens = BaseChatCompletion.$default$maxTokens();
        this.presencePenalty = BaseChatCompletion.$default$presencePenalty();
        this.frequencyPenalty = BaseChatCompletion.$default$frequencyPenalty();
    }

    public BaseChatCompletion(@NonNull String model, ResponseFormat responseFormat, List<Functions> functions, Object functionCall, List<Tools> tools, Object toolChoice, double temperature, Double topP, Integer n, boolean stream, List<String> stop, Integer maxTokens, double presencePenalty, double frequencyPenalty, Map logitBias, String user, Integer seed) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
        this.responseFormat = responseFormat;
        this.functions = functions;
        this.functionCall = functionCall;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
        this.seed = seed;
    }

    private static final class BaseChatCompletionBuilderImpl
    extends BaseChatCompletionBuilder<BaseChatCompletion, BaseChatCompletionBuilderImpl> {
        private BaseChatCompletionBuilderImpl() {
        }

        @Override
        protected BaseChatCompletionBuilderImpl self() {
            return this;
        }

        @Override
        public BaseChatCompletion build() {
            return new BaseChatCompletion(this);
        }
    }

    public static abstract class BaseChatCompletionBuilder<C extends BaseChatCompletion, B extends BaseChatCompletionBuilder<C, B>> {
        private boolean model$set;
        private String model$value;
        private ResponseFormat responseFormat;
        private List<Functions> functions;
        private Object functionCall;
        private List<Tools> tools;
        private Object toolChoice;
        private boolean temperature$set;
        private double temperature$value;
        private boolean topP$set;
        private Double topP$value;
        private boolean n$set;
        private Integer n$value;
        private boolean stream$set;
        private boolean stream$value;
        private List<String> stop;
        private boolean maxTokens$set;
        private Integer maxTokens$value;
        private boolean presencePenalty$set;
        private double presencePenalty$value;
        private boolean frequencyPenalty$set;
        private double frequencyPenalty$value;
        private Map logitBias;
        private String user;
        private Integer seed;

        protected abstract B self();

        public abstract C build();

        public B model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this.self();
        }

        @JsonProperty(value="response_format")
        public B responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this.self();
        }

        @Deprecated
        public B functions(List<Functions> functions) {
            this.functions = functions;
            return this.self();
        }

        @Deprecated
        @JsonProperty(value="function_call")
        public B functionCall(Object functionCall) {
            this.functionCall = functionCall;
            return this.self();
        }

        public B tools(List<Tools> tools) {
            this.tools = tools;
            return this.self();
        }

        @JsonProperty(value="tool_choice")
        public B toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this.self();
        }

        public B temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this.self();
        }

        @JsonProperty(value="top_p")
        public B topP(Double topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this.self();
        }

        public B n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this.self();
        }

        public B stream(boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this.self();
        }

        public B stop(List<String> stop) {
            this.stop = stop;
            return this.self();
        }

        @JsonProperty(value="max_tokens")
        public B maxTokens(Integer maxTokens) {
            this.maxTokens$value = maxTokens;
            this.maxTokens$set = true;
            return this.self();
        }

        @JsonProperty(value="presence_penalty")
        public B presencePenalty(double presencePenalty) {
            this.presencePenalty$value = presencePenalty;
            this.presencePenalty$set = true;
            return this.self();
        }

        @JsonProperty(value="frequency_penalty")
        public B frequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty$value = frequencyPenalty;
            this.frequencyPenalty$set = true;
            return this.self();
        }

        @JsonProperty(value="logit_bias")
        public B logitBias(Map logitBias) {
            this.logitBias = logitBias;
            return this.self();
        }

        public B user(String user) {
            this.user = user;
            return this.self();
        }

        public B seed(Integer seed) {
            this.seed = seed;
            return this.self();
        }

        public String toString() {
            return "BaseChatCompletion.BaseChatCompletionBuilder(model$value=" + this.model$value + ", responseFormat=" + this.responseFormat + ", functions=" + this.functions + ", functionCall=" + this.functionCall + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", n$value=" + this.n$value + ", stream$value=" + this.stream$value + ", stop=" + this.stop + ", maxTokens$value=" + this.maxTokens$value + ", presencePenalty$value=" + this.presencePenalty$value + ", frequencyPenalty$value=" + this.frequencyPenalty$value + ", logitBias=" + this.logitBias + ", user=" + this.user + ", seed=" + this.seed + ")";
        }
    }

    public static enum Model {
        GPT_3_5_TURBO("gpt-3.5-turbo"),
        GPT_3_5_TURBO_0301("gpt-3.5-turbo-0301"),
        GPT_3_5_TURBO_0613("gpt-3.5-turbo-0613"),
        GPT_3_5_TURBO_16K("gpt-3.5-turbo-16k"),
        GPT_3_5_TURBO_16K_0613("gpt-3.5-turbo-16k-0613"),
        GPT_4("gpt-4"),
        GPT_4_0314("gpt-4-0314"),
        GPT_4_32K("gpt-4-32k"),
        GPT_4_32K_0314("gpt-4-32k-0314"),
        GPT_4_0613("gpt-4-0613"),
        GPT_4_32K_0613("gpt-4-32k-0613"),
        GPT_4_1106_PREVIEW("gpt-4-1106-preview"),
        GPT_4_VISION_PREVIEW("gpt-4-vision-preview");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

