/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.webauthn4j.WebAuthnAuthenticationManager;
import com.webauthn4j.WebAuthnRegistrationManager;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.verifier.AuthenticationDataVerifier;
import com.webauthn4j.verifier.CustomAuthenticationVerifier;
import com.webauthn4j.verifier.CustomRegistrationVerifier;
import com.webauthn4j.verifier.RegistrationDataVerifier;
import com.webauthn4j.verifier.attestation.statement.AttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.androidkey.NullAndroidKeyAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.androidsafetynet.NullAndroidSafetyNetAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.apple.NullAppleAnonymousAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.none.NoneAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.packed.NullPackedAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.tpm.NullTPMAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.statement.u2f.NullFIDOU2FAttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.NullCertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.VerificationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebAuthnManager {
    private final WebAuthnRegistrationManager webAuthnRegistrationManager;
    private final WebAuthnAuthenticationManager webAuthnAuthenticationManager;

    public WebAuthnManager(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier, @NotNull List<CustomRegistrationVerifier> customRegistrationVerifiers, @NotNull List<CustomAuthenticationVerifier> customAuthenticationVerifiers, @NotNull ObjectConverter objectConverter) {
        this.webAuthnRegistrationManager = new WebAuthnRegistrationManager(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier, customRegistrationVerifiers, objectConverter);
        this.webAuthnAuthenticationManager = new WebAuthnAuthenticationManager(customAuthenticationVerifiers, objectConverter);
    }

    public WebAuthnManager(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier, @NotNull List<CustomRegistrationVerifier> customRegistrationVerifiers, @NotNull List<CustomAuthenticationVerifier> customAuthenticationVerifiers) {
        this(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier, customRegistrationVerifiers, customAuthenticationVerifiers, new ObjectConverter());
    }

    public WebAuthnManager(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier, @NotNull ObjectConverter objectConverter) {
        this(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier, new ArrayList<CustomRegistrationVerifier>(), new ArrayList<CustomAuthenticationVerifier>(), objectConverter);
    }

    public WebAuthnManager(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier) {
        this(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier, new ArrayList<CustomRegistrationVerifier>(), new ArrayList<CustomAuthenticationVerifier>());
    }

    @NotNull
    public static WebAuthnManager createNonStrictWebAuthnManager() {
        ObjectConverter objectConverter = new ObjectConverter();
        return WebAuthnManager.createNonStrictWebAuthnManager(objectConverter);
    }

    @NotNull
    public static WebAuthnManager createNonStrictWebAuthnManager(@NotNull ObjectConverter objectConverter) {
        return new WebAuthnManager(Arrays.asList(new NoneAttestationStatementVerifier(), new NullFIDOU2FAttestationStatementVerifier(), new NullPackedAttestationStatementVerifier(), new NullTPMAttestationStatementVerifier(), new NullAndroidKeyAttestationStatementVerifier(), new NullAndroidSafetyNetAttestationStatementVerifier(), new NullAppleAnonymousAttestationStatementVerifier()), new NullCertPathTrustworthinessVerifier(), new NullSelfAttestationTrustworthinessVerifier(), objectConverter);
    }

    @NotNull
    public RegistrationData parseRegistrationResponseJSON(@NotNull String registrationResponseJSON) {
        return this.webAuthnRegistrationManager.parse(registrationResponseJSON);
    }

    @NotNull
    public RegistrationData parse(@NotNull RegistrationRequest registrationRequest) throws DataConversionException {
        return this.webAuthnRegistrationManager.parse(registrationRequest);
    }

    @NotNull
    public RegistrationData verifyRegistrationResponseJSON(@NotNull String registrationResponseJSON, @NotNull RegistrationParameters registrationParameters) throws DataConversionException, VerificationException {
        return this.webAuthnRegistrationManager.verify(registrationResponseJSON, registrationParameters);
    }

    @NotNull
    public RegistrationData verify(@NotNull RegistrationRequest registrationRequest, @NotNull RegistrationParameters registrationParameters) throws DataConversionException, VerificationException {
        return this.webAuthnRegistrationManager.verify(registrationRequest, registrationParameters);
    }

    @Deprecated
    @NotNull
    public RegistrationData validate(@NotNull RegistrationRequest registrationRequest, @NotNull RegistrationParameters registrationParameters) throws DataConversionException, VerificationException {
        return this.verify(registrationRequest, registrationParameters);
    }

    @NotNull
    public RegistrationData verify(@NotNull RegistrationData registrationData, @NotNull RegistrationParameters registrationParameters) throws VerificationException {
        return this.webAuthnRegistrationManager.verify(registrationData, registrationParameters);
    }

    @Deprecated
    @NotNull
    public RegistrationData validate(@NotNull RegistrationData registrationData, @NotNull RegistrationParameters registrationParameters) throws VerificationException {
        return this.verify(registrationData, registrationParameters);
    }

    @NotNull
    public AuthenticationData parseAuthenticationResponseJSON(@NotNull String authenticationResponseJSON) throws DataConversionException {
        return this.webAuthnAuthenticationManager.parse(authenticationResponseJSON);
    }

    @NotNull
    public AuthenticationData parse(@NotNull AuthenticationRequest authenticationRequest) throws DataConversionException {
        return this.webAuthnAuthenticationManager.parse(authenticationRequest);
    }

    @NotNull
    public AuthenticationData verifyAuthenticationResponseJSON(@NotNull String authenticationResponseJSON, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, VerificationException {
        return this.webAuthnAuthenticationManager.verify(authenticationResponseJSON, authenticationParameters);
    }

    @NotNull
    public AuthenticationData verify(@NotNull AuthenticationRequest authenticationRequest, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, VerificationException {
        return this.webAuthnAuthenticationManager.verify(authenticationRequest, authenticationParameters);
    }

    @Deprecated
    @NotNull
    public AuthenticationData validate(@NotNull AuthenticationRequest authenticationRequest, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, VerificationException {
        return this.verify(authenticationRequest, authenticationParameters);
    }

    @NotNull
    public AuthenticationData verify(@NotNull AuthenticationData authenticationData, @NotNull AuthenticationParameters authenticationParameters) throws VerificationException {
        return this.webAuthnAuthenticationManager.verify(authenticationData, authenticationParameters);
    }

    @Deprecated
    @NotNull
    public AuthenticationData validate(@NotNull AuthenticationData authenticationData, @NotNull AuthenticationParameters authenticationParameters) throws VerificationException {
        return this.verify(authenticationData, authenticationParameters);
    }

    @NotNull
    public RegistrationDataVerifier getRegistrationDataVerifier() {
        return this.webAuthnRegistrationManager.getRegistrationDataVerifier();
    }

    @NotNull
    public AuthenticationDataVerifier getAuthenticationDataVerifier() {
        return this.webAuthnAuthenticationManager.getAuthenticationDataVerifier();
    }
}

