/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.services.scheduler;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.avalon.cornerstone.services.scheduler.TimeTrigger;

public class CronTimeTrigger
implements TimeTrigger {
    protected final int m_minute;
    protected final int m_hour;
    protected final int m_dayOfMonth;
    protected final int m_month;
    protected final int m_dayOfWeek;
    protected final int m_year;

    public CronTimeTrigger(int minute, int hour, int day, int month, int year, boolean isDayOfWeek) {
        this.m_minute = minute;
        this.m_hour = hour;
        this.m_month = month;
        this.m_year = year;
        if (isDayOfWeek) {
            this.m_dayOfMonth = -1;
            this.m_dayOfWeek = day;
        } else {
            this.m_dayOfMonth = day;
            this.m_dayOfWeek = -1;
        }
    }

    public long getTimeAfter(long moment) {
        int dayOfMonth;
        Date timeMarker = new Date(moment);
        GregorianCalendar relativeTo = new GregorianCalendar();
        relativeTo.setTime(timeMarker);
        relativeTo.set(13, 0);
        GregorianCalendar next = (GregorianCalendar)((Calendar)relativeTo).clone();
        if (-1 != this.m_minute) {
            next.set(12, this.m_minute);
        } else if (-1 == this.m_hour && -1 == this.m_month && -1 == this.m_year) {
            next.add(12, 1);
        } else {
            next.set(12, 0);
        }
        if (-1 != this.m_hour) {
            next.set(11, this.m_hour);
            if (-1 == this.m_minute) {
                next.set(12, 0);
            }
        }
        if (-1 != this.m_month) {
            next.set(2, this.m_month);
            if (-1 == this.m_hour) {
                next.set(11, 0);
            }
            if (-1 == this.m_minute) {
                next.set(12, 0);
            }
        }
        if (-1 != this.m_year) {
            next.set(1, this.m_year);
            if (-1 == this.m_month) {
                next.set(2, 0);
            }
            if (-1 == this.m_hour) {
                next.set(11, 0);
            }
            if (-1 == this.m_minute) {
                next.set(12, 0);
            }
        }
        int minute = -1 != this.m_minute ? this.m_minute : 0;
        int rminute = relativeTo.get(12);
        if (-1 == this.m_year && -1 == this.m_month && -1 == this.m_hour && -1 != this.m_minute && rminute >= minute) {
            next.add(11, 1);
        }
        int hour = -1 != this.m_hour ? this.m_hour : 0;
        int rhour = relativeTo.get(11);
        if (-1 == this.m_dayOfMonth && -1 == this.m_dayOfWeek && (-1 != this.m_hour && rhour > hour || -1 == this.m_hour && rhour == 24 && rminute >= minute || -1 != this.m_hour && rhour == hour && rminute >= minute)) {
            next.add(6, 1);
        }
        int realDayOfMonth = this.m_dayOfMonth;
        GregorianCalendar targetMonth = (GregorianCalendar)((Calendar)next).clone();
        targetMonth.set(5, 1);
        targetMonth.set(2, this.m_month);
        int maxDayCount = ((Calendar)targetMonth).getActualMaximum(5);
        if (maxDayCount < realDayOfMonth) {
            realDayOfMonth = maxDayCount;
            next.add(2, -1);
        }
        int month = -1 != this.m_month ? this.m_month : 0;
        int n = dayOfMonth = -1 != this.m_dayOfMonth ? this.m_dayOfMonth : 0;
        if (-1 != this.m_month && -1 == this.m_year && (relativeTo.get(2) > month || relativeTo.get(2) == month && (relativeTo.get(5) > dayOfMonth || relativeTo.get(5) == dayOfMonth && (relativeTo.get(11) > hour || relativeTo.get(11) == hour && relativeTo.get(12) >= minute)))) {
            next.add(1, 1);
        }
        if (-1 != this.m_year && (relativeTo.get(1) > this.m_year || relativeTo.get(1) == this.m_year && (relativeTo.get(2) > month || relativeTo.get(2) == month && (relativeTo.get(5) > dayOfMonth || relativeTo.get(5) == dayOfMonth && (relativeTo.get(11) > hour || relativeTo.get(11) == hour && relativeTo.get(12) >= minute))))) {
            return -1L;
        }
        if (-1 != this.m_dayOfWeek) {
            int dayWait = (7 + this.m_dayOfWeek - relativeTo.get(7)) % 7;
            if (0 != dayWait) {
                next.add(6, dayWait);
            } else if (relativeTo.get(11) > hour || relativeTo.get(11) == hour && relativeTo.get(12) >= minute) {
                next.add(6, 7);
            }
        } else if (-1 != this.m_dayOfMonth) {
            next.set(5, realDayOfMonth);
            if (this.m_month == -1 && (relativeTo.get(5) > this.m_dayOfMonth || relativeTo.get(5) == this.m_dayOfMonth && (relativeTo.get(11) > hour || relativeTo.get(11) == hour && relativeTo.get(12) >= minute))) {
                next.roll(2, true);
            }
        }
        return next.getTime().getTime();
    }

    public void reset() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CronTimeTrigger[ ");
        if (-1 != this.m_minute) {
            sb.append("minute=");
            sb.append(this.m_minute);
            sb.append(" ");
        }
        if (-1 != this.m_hour) {
            sb.append("hour=");
            sb.append(this.m_hour);
            sb.append(" ");
        }
        if (-1 != this.m_month) {
            sb.append("month=");
            sb.append(this.m_month);
            sb.append(" ");
        }
        if (-1 != this.m_year) {
            sb.append("year=");
            sb.append(this.m_year);
            sb.append(" ");
        }
        if (-1 != this.m_dayOfMonth) {
            sb.append("dayOfMonth=");
            sb.append(this.m_dayOfMonth);
            sb.append(" ");
        }
        if (-1 != this.m_dayOfWeek) {
            sb.append("dayOfWeek=");
            sb.append(this.m_dayOfWeek);
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

