package de.flapdoodle.os.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AllOf}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAllOf.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAllOf.of()}.
 */
@Generated(from = "AllOf", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableAllOf extends AllOf {
  private final List<Peculiarity> pecularities;

  private ImmutableAllOf(Iterable<? extends Peculiarity> pecularities) {
    this.pecularities = createUnmodifiableList(false, createSafeList(pecularities, true, false));
  }

  private ImmutableAllOf(ImmutableAllOf original, List<Peculiarity> pecularities) {
    this.pecularities = pecularities;
  }

  /**
   * @return The value of the {@code pecularities} attribute
   */
  @Override
  public List<Peculiarity> pecularities() {
    return pecularities;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllOf#pecularities() pecularities}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllOf withPecularities(Peculiarity... elements) {
    List<Peculiarity> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableAllOf(this, newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllOf#pecularities() pecularities}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pecularities elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllOf withPecularities(Iterable<? extends Peculiarity> elements) {
    if (this.pecularities == elements) return this;
    List<Peculiarity> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableAllOf(this, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAllOf} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAllOf
        && equalTo(0, (ImmutableAllOf) another);
  }

  private boolean equalTo(int synthetic, ImmutableAllOf another) {
    return pecularities.equals(another.pecularities);
  }

  /**
   * Computes a hash code from attributes: {@code pecularities}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + pecularities.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AllOf} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AllOf{"
        + "pecularities=" + pecularities
        + "}";
  }

  /**
   * Construct a new immutable {@code AllOf} instance.
   * @param pecularities The value for the {@code pecularities} attribute
   * @return An immutable AllOf instance
   */
  public static ImmutableAllOf of(List<Peculiarity> pecularities) {
    return of((Iterable<? extends Peculiarity>) pecularities);
  }

  /**
   * Construct a new immutable {@code AllOf} instance.
   * @param pecularities The value for the {@code pecularities} attribute
   * @return An immutable AllOf instance
   */
  public static ImmutableAllOf of(Iterable<? extends Peculiarity> pecularities) {
    return validate(new ImmutableAllOf(pecularities));
  }

  private static ImmutableAllOf validate(ImmutableAllOf instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link AllOf} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AllOf instance
   */
  public static ImmutableAllOf copyOf(AllOf instance) {
    if (instance instanceof ImmutableAllOf) {
      return (ImmutableAllOf) instance;
    }
    return ImmutableAllOf.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAllOf ImmutableAllOf}.
   * <pre>
   * ImmutableAllOf.builder()
   *    .addPecularities|addAllPecularities(de.flapdoodle.os.common.Peculiarity) // {@link AllOf#pecularities() pecularities} elements
   *    .build();
   * </pre>
   * @return A new ImmutableAllOf builder
   */
  public static ImmutableAllOf.Builder builder() {
    return new ImmutableAllOf.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAllOf ImmutableAllOf}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AllOf", generator = "Immutables")
  public static final class Builder {
    private List<Peculiarity> pecularities = new ArrayList<Peculiarity>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AllOf} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AllOf instance) {
      Objects.requireNonNull(instance, "instance");
      addAllPecularities(instance.pecularities());
      return this;
    }

    /**
     * Adds one element to {@link AllOf#pecularities() pecularities} list.
     * @param element A pecularities element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPecularities(Peculiarity element) {
      this.pecularities.add(Objects.requireNonNull(element, "pecularities element"));
      return this;
    }

    /**
     * Adds elements to {@link AllOf#pecularities() pecularities} list.
     * @param elements An array of pecularities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPecularities(Peculiarity... elements) {
      for (Peculiarity element : elements) {
        this.pecularities.add(Objects.requireNonNull(element, "pecularities element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AllOf#pecularities() pecularities} list.
     * @param elements An iterable of pecularities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pecularities(Iterable<? extends Peculiarity> elements) {
      this.pecularities.clear();
      return addAllPecularities(elements);
    }

    /**
     * Adds elements to {@link AllOf#pecularities() pecularities} list.
     * @param elements An iterable of pecularities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPecularities(Iterable<? extends Peculiarity> elements) {
      for (Peculiarity element : elements) {
        this.pecularities.add(Objects.requireNonNull(element, "pecularities element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableAllOf ImmutableAllOf}.
     * @return An immutable instance of AllOf
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAllOf build() {
      return ImmutableAllOf.validate(new ImmutableAllOf(null, createUnmodifiableList(true, pecularities)));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
