/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.common.DistinctPeculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.Attributes;
import de.flapdoodle.os.common.matcher.Match;
import de.flapdoodle.os.common.matcher.Matchers;
import de.flapdoodle.os.common.types.LsbReleaseFile;
import de.flapdoodle.os.common.types.LsbReleaseFileConverter;
import java.util.function.Function;
import java.util.regex.Pattern;

public class LsbReleaseFiles {
    public static String RELEASE_FILE_NAME = "/etc/lsb-release";
    public static String NAME = "DISTRIB_ID";
    public static String VERSION_ID = "DISTRIB_RELEASE";
    public static String VERSION_CODENAME = "DISTRIB_CODENAME";

    static Attribute<LsbReleaseFile> lsbReleaseFile() {
        return LsbReleaseFiles.releaseFile(RELEASE_FILE_NAME);
    }

    static Attribute<LsbReleaseFile> releaseFile(String path) {
        return Attributes.mappedTextFile((String)path, (Function)LsbReleaseFileConverter.INSTANCE);
    }

    static DistinctPeculiarity<LsbReleaseFile> nameMatches(Attribute<LsbReleaseFile> osReleaseFile, String name) {
        return DistinctPeculiarity.of(osReleaseFile, (Match)Matchers.lsbReleaseFileEntry((String)NAME, (String)(".*" + name + ".*")));
    }

    static DistinctPeculiarity<LsbReleaseFile> versionMatches(Attribute<LsbReleaseFile> osReleaseFile, String version) {
        return DistinctPeculiarity.of(osReleaseFile, (Match)Matchers.lsbReleaseFileEntry((String)VERSION_ID, (String)(Pattern.quote(version) + ".*")));
    }

    static DistinctPeculiarity<LsbReleaseFile> versionIs(Attribute<LsbReleaseFile> osReleaseFile, String version) {
        return DistinctPeculiarity.of(osReleaseFile, (Match)Matchers.lsbReleaseFileEntry((String)VERSION_ID, (String)Pattern.quote(version)));
    }

    static DistinctPeculiarity<LsbReleaseFile> versionCodeNameIs(Attribute<LsbReleaseFile> osReleaseFile, String version) {
        return DistinctPeculiarity.of(osReleaseFile, (Match)Matchers.lsbReleaseFileEntry((String)VERSION_CODENAME, (String)Pattern.quote(version)));
    }

    static DistinctPeculiarity<LsbReleaseFile> lsbReleaseFileNameMatches(String name) {
        return LsbReleaseFiles.nameMatches(LsbReleaseFiles.lsbReleaseFile(), name);
    }

    static DistinctPeculiarity<LsbReleaseFile> lsbReleaseFileVersionMatches(String version) {
        return LsbReleaseFiles.versionMatches(LsbReleaseFiles.lsbReleaseFile(), version);
    }

    static DistinctPeculiarity<LsbReleaseFile> lsbReleaseFileVersionIs(String version) {
        return LsbReleaseFiles.versionIs(LsbReleaseFiles.lsbReleaseFile(), version);
    }

    static DistinctPeculiarity<LsbReleaseFile> lsbReleaseFileVersionCodeNameIs(String version) {
        return LsbReleaseFiles.versionCodeNameIs(LsbReleaseFiles.lsbReleaseFile(), version);
    }
}

