/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.Internal;
import dev.langchain4j.exception.AuthenticationException;
import dev.langchain4j.exception.HttpException;
import dev.langchain4j.exception.InternalServerException;
import dev.langchain4j.exception.InvalidRequestException;
import dev.langchain4j.exception.LangChain4jException;
import dev.langchain4j.exception.ModelNotFoundException;
import dev.langchain4j.exception.RateLimitException;
import dev.langchain4j.exception.TimeoutException;
import dev.langchain4j.exception.UnresolvedModelServerException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.Callable;

@FunctionalInterface
@Internal
public interface ExceptionMapper {
    public static final ExceptionMapper DEFAULT = new DefaultExceptionMapper();

    public static <T> T mappingException(Callable<T> action) {
        return DEFAULT.withExceptionMapper(action);
    }

    default public <T> T withExceptionMapper(Callable<T> action) {
        try {
            return action.call();
        }
        catch (Exception e) {
            throw this.mapException(e);
        }
    }

    public RuntimeException mapException(Exception var1);

    public static class DefaultExceptionMapper
    implements ExceptionMapper {
        @Override
        public RuntimeException mapException(Exception e) {
            RuntimeException runtimeException;
            Throwable rootCause = DefaultExceptionMapper.findRoot(e);
            if (rootCause instanceof HttpException) {
                HttpException httpException = (HttpException)rootCause;
                return this.mapHttpStatusCode(httpException, httpException.statusCode());
            }
            if (rootCause instanceof UnresolvedAddressException) {
                return new UnresolvedModelServerException(rootCause);
            }
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                runtimeException = re;
            } else {
                runtimeException = new LangChain4jException(e);
            }
            return runtimeException;
        }

        protected RuntimeException mapHttpStatusCode(Exception rootException, int httpStatusCode) {
            RuntimeException runtimeException;
            if (httpStatusCode >= 500 && httpStatusCode < 600) {
                return new InternalServerException(rootException);
            }
            if (httpStatusCode == 401 || httpStatusCode == 403) {
                return new AuthenticationException(rootException);
            }
            if (httpStatusCode == 404) {
                return new ModelNotFoundException(rootException);
            }
            if (httpStatusCode == 408) {
                return new TimeoutException(rootException);
            }
            if (httpStatusCode == 429) {
                return new RateLimitException(rootException);
            }
            if (httpStatusCode >= 400 && httpStatusCode < 500) {
                return new InvalidRequestException(rootException);
            }
            if (rootException instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)rootException;
                runtimeException = re;
            } else {
                runtimeException = new LangChain4jException(rootException);
            }
            return runtimeException;
        }

        private static Throwable findRoot(Throwable e) {
            Throwable cause = e.getCause();
            return cause == null || cause == e ? e : DefaultExceptionMapper.findRoot(cause);
        }
    }
}

