/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.observability.api.event;

import dev.langchain4j.guardrail.Guardrail;
import dev.langchain4j.guardrail.GuardrailRequest;
import dev.langchain4j.guardrail.GuardrailResult;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.observability.api.event.AiServiceEvent;

public interface GuardrailExecutedEvent<P extends GuardrailRequest<P>, R extends GuardrailResult<R>, G extends Guardrail<P, R>>
extends AiServiceEvent {
    public P request();

    public R result();

    public Class<G> guardrailClass();

    public static abstract class GuardrailExecutedEventBuilder<P extends GuardrailRequest<P>, R extends GuardrailResult<R>, G extends Guardrail<P, R>, T extends GuardrailExecutedEvent<P, R, G>>
    extends AiServiceEvent.Builder<T> {
        private P request;
        private R result;
        private Class<G> guardrailClass;

        protected GuardrailExecutedEventBuilder() {
        }

        protected GuardrailExecutedEventBuilder(T src) {
            super(src);
            this.request(src.request());
            this.result(src.result());
            this.guardrailClass(src.guardrailClass());
        }

        public Class<G> guardrailClass() {
            return this.guardrailClass;
        }

        public P request() {
            return this.request;
        }

        public R result() {
            return this.result;
        }

        public GuardrailExecutedEventBuilder<P, R, G, T> request(P request) {
            this.request = request;
            return this;
        }

        public GuardrailExecutedEventBuilder<P, R, G, T> result(R result) {
            this.result = result;
            return this;
        }

        public GuardrailExecutedEventBuilder<P, R, G, T> invocationContext(InvocationContext invocationContext) {
            return (GuardrailExecutedEventBuilder)super.invocationContext(invocationContext);
        }

        public <C extends G> GuardrailExecutedEventBuilder<P, R, G, T> guardrailClass(Class<C> guardrailClass) {
            this.guardrailClass = guardrailClass;
            return this;
        }
    }
}

