/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.TokenCountEstimator;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.googleai.BaseGeminiChatModel;
import dev.langchain4j.model.googleai.FinishReasonMapper;
import dev.langchain4j.model.googleai.GeminiCandidate;
import dev.langchain4j.model.googleai.GeminiFunctionCallingConfig;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GeminiHarmBlockThreshold;
import dev.langchain4j.model.googleai.GeminiHarmCategory;
import dev.langchain4j.model.googleai.GeminiMode;
import dev.langchain4j.model.googleai.GeminiSafetySetting;
import dev.langchain4j.model.googleai.GeminiUsageMetadata;
import dev.langchain4j.model.googleai.GoogleAiGeminiTokenizer;
import dev.langchain4j.model.googleai.PartsAndContentsMapper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class GoogleAiGeminiChatModel
extends BaseGeminiChatModel
implements ChatLanguageModel,
TokenCountEstimator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoogleAiGeminiChatModel.class);
    private final GoogleAiGeminiTokenizer geminiTokenizer;

    public GoogleAiGeminiChatModel(String apiKey, String modelName, Integer maxRetries, Double temperature, Integer topK, Double topP, Integer maxOutputTokens, Duration timeout, ResponseFormat responseFormat, List<String> stopSequences, GeminiFunctionCallingConfig toolConfig, Boolean allowCodeExecution, Boolean includeCodeExecutionOutput, Boolean logRequestsAndResponses, List<GeminiSafetySetting> safetySettings, List<ChatModelListener> listeners) {
        super(apiKey, modelName, temperature, topK, topP, maxOutputTokens, timeout, responseFormat, stopSequences, toolConfig, allowCodeExecution, includeCodeExecutionOutput, logRequestsAndResponses, safetySettings, listeners, maxRetries);
        this.geminiTokenizer = GoogleAiGeminiTokenizer.builder().modelName(this.modelName).apiKey(this.apiKey).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).maxRetries(this.maxRetries).logRequestsAndResponses((Boolean)Utils.getOrDefault((Object)logRequestsAndResponses, (Object)false)).build();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        ChatRequest request = ChatRequest.builder().messages(messages).build();
        ChatResponse response = this.chat(request);
        return Response.from((Object)response.aiMessage(), (TokenUsage)response.metadata().tokenUsage(), (FinishReason)response.metadata().finishReason());
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, Collections.singletonList(toolSpecification));
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        ChatRequest request = ChatRequest.builder().messages(messages).toolSpecifications(toolSpecifications).build();
        ChatResponse response = this.chat(request);
        return Response.from((Object)response.aiMessage(), (TokenUsage)response.metadata().tokenUsage(), (FinishReason)response.metadata().finishReason());
    }

    public ChatResponse chat(ChatRequest chatRequest) {
        ChatRequestParameters parameters = chatRequest.parameters();
        GoogleAiGeminiChatModel.validate(parameters);
        ChatLanguageModel.validate((ToolChoice)parameters.toolChoice());
        GeminiGenerateContentRequest request = this.createGenerateContentRequest(chatRequest.messages(), parameters.toolSpecifications(), (ResponseFormat)Utils.getOrDefault((Object)parameters.responseFormat(), (Object)this.responseFormat), chatRequest.parameters());
        ChatModelRequest chatModelRequest = this.createChatModelRequest(parameters.modelName(), chatRequest.messages(), parameters.toolSpecifications(), chatRequest.parameters());
        ConcurrentHashMap<Object, Object> listenerAttributes = new ConcurrentHashMap<Object, Object>();
        this.notifyListenersOnRequest(new ChatModelRequestContext(chatModelRequest, listenerAttributes));
        try {
            GeminiGenerateContentResponse geminiResponse = (GeminiGenerateContentResponse)RetryUtils.withRetry(() -> this.geminiService.generateContent(this.modelName, this.apiKey, request), (int)this.maxRetries);
            return this.processResponse(geminiResponse, chatModelRequest, listenerAttributes);
        }
        catch (RuntimeException e) {
            this.notifyListenersOnError(e, chatModelRequest, listenerAttributes);
            throw e;
        }
    }

    private static void validate(ChatRequestParameters parameters) {
        if (parameters.frequencyPenalty() != null) {
            throw new UnsupportedFeatureException("'frequencyPenalty' parameter is not supported by Google AI Gemini");
        }
        if (parameters.presencePenalty() != null) {
            throw new UnsupportedFeatureException("'presencePenalty' parameter is not supported by Google AI Gemini");
        }
    }

    private ChatResponse processResponse(GeminiGenerateContentResponse geminiResponse, ChatModelRequest chatModelRequest, ConcurrentHashMap<Object, Object> listenerAttributes) {
        if (geminiResponse == null) {
            throw new RuntimeException("Gemini response was null");
        }
        GeminiCandidate firstCandidate = geminiResponse.getCandidates().get(0);
        GeminiUsageMetadata tokenCounts = geminiResponse.getUsageMetadata();
        FinishReason finishReason = FinishReasonMapper.fromGFinishReasonToFinishReason(firstCandidate.getFinishReason());
        AiMessage aiMessage = this.createAiMessage(firstCandidate, finishReason);
        TokenUsage tokenUsage = this.createTokenUsage(tokenCounts);
        Response response = Response.from((Object)aiMessage, (TokenUsage)tokenUsage, (FinishReason)finishReason);
        this.notifyListenersOnResponse((Response<AiMessage>)response, chatModelRequest, listenerAttributes);
        return ChatResponse.builder().aiMessage(aiMessage).metadata(ChatResponseMetadata.builder().modelName(chatModelRequest.model()).finishReason(finishReason).tokenUsage(tokenUsage).build()).build();
    }

    private AiMessage createAiMessage(GeminiCandidate candidate, FinishReason finishReason) {
        if (candidate.getContent() == null) {
            return AiMessage.from((String)("No text was returned by the model. The model finished generating because of the following reason: " + String.valueOf(finishReason)));
        }
        return PartsAndContentsMapper.fromGPartsToAiMessage(candidate.getContent().getParts(), this.includeCodeExecutionOutput);
    }

    private TokenUsage createTokenUsage(GeminiUsageMetadata tokenCounts) {
        return new TokenUsage(tokenCounts.getPromptTokenCount(), tokenCounts.getCandidatesTokenCount(), tokenCounts.getTotalTokenCount());
    }

    public int estimateTokenCount(List<ChatMessage> messages) {
        return this.geminiTokenizer.estimateTokenCountInMessages(messages);
    }

    public Set<Capability> supportedCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        if (this.responseFormat != null && ResponseFormatType.JSON.equals((Object)this.responseFormat.type())) {
            capabilities.add(Capability.RESPONSE_FORMAT_JSON_SCHEMA);
        }
        return capabilities;
    }

    @Generated
    public static GoogleAiGeminiChatModelBuilder builder() {
        return new GoogleAiGeminiChatModelBuilder();
    }

    public static class GoogleAiGeminiChatModelBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String modelName;
        @Generated
        private Integer maxRetries;
        @Generated
        private Double temperature;
        @Generated
        private Integer topK;
        @Generated
        private Double topP;
        @Generated
        private Integer maxOutputTokens;
        @Generated
        private Duration timeout;
        @Generated
        private ResponseFormat responseFormat;
        @Generated
        private List<String> stopSequences;
        @Generated
        private GeminiFunctionCallingConfig toolConfig;
        @Generated
        private Boolean allowCodeExecution;
        @Generated
        private Boolean includeCodeExecutionOutput;
        @Generated
        private Boolean logRequestsAndResponses;
        @Generated
        private List<GeminiSafetySetting> safetySettings;
        @Generated
        private List<ChatModelListener> listeners;

        public GoogleAiGeminiChatModelBuilder toolConfig(GeminiMode mode, String ... allowedFunctionNames) {
            this.toolConfig = new GeminiFunctionCallingConfig(mode, Arrays.asList(allowedFunctionNames));
            return this;
        }

        public GoogleAiGeminiChatModelBuilder safetySettings(Map<GeminiHarmCategory, GeminiHarmBlockThreshold> safetySettingMap) {
            this.safetySettings = safetySettingMap.entrySet().stream().map(entry -> new GeminiSafetySetting((GeminiHarmCategory)((Object)((Object)entry.getKey())), (GeminiHarmBlockThreshold)((Object)((Object)entry.getValue())))).collect(Collectors.toList());
            return this;
        }

        @Generated
        GoogleAiGeminiChatModelBuilder() {
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder allowCodeExecution(Boolean allowCodeExecution) {
            this.allowCodeExecution = allowCodeExecution;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder includeCodeExecutionOutput(Boolean includeCodeExecutionOutput) {
            this.includeCodeExecutionOutput = includeCodeExecutionOutput;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        @Generated
        public GoogleAiGeminiChatModel build() {
            return new GoogleAiGeminiChatModel(this.apiKey, this.modelName, this.maxRetries, this.temperature, this.topK, this.topP, this.maxOutputTokens, this.timeout, this.responseFormat, this.stopSequences, this.toolConfig, this.allowCodeExecution, this.includeCodeExecutionOutput, this.logRequestsAndResponses, this.safetySettings, this.listeners);
        }

        @Generated
        public String toString() {
            return "GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder(apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", maxRetries=" + this.maxRetries + ", temperature=" + this.temperature + ", topK=" + this.topK + ", topP=" + this.topP + ", maxOutputTokens=" + this.maxOutputTokens + ", timeout=" + String.valueOf(this.timeout) + ", responseFormat=" + String.valueOf(this.responseFormat) + ", stopSequences=" + String.valueOf(this.stopSequences) + ", toolConfig=" + String.valueOf(this.toolConfig) + ", allowCodeExecution=" + this.allowCodeExecution + ", includeCodeExecutionOutput=" + this.includeCodeExecutionOutput + ", logRequestsAndResponses=" + this.logRequestsAndResponses + ", safetySettings=" + String.valueOf(this.safetySettings) + ", listeners=" + String.valueOf(this.listeners) + ")";
        }
    }
}

