/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.model.ollama.OllamaDateDeserializer;
import dev.langchain4j.model.ollama.OllamaModelDetails;
import java.time.OffsetDateTime;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class OllamaModelCard {
    private String license;
    private String modelfile;
    private String parameters;
    private String template;
    private OllamaModelDetails details;
    private Map<String, Object> modelInfo;
    @JsonDeserialize(using=OllamaDateDeserializer.class)
    private OffsetDateTime modifiedAt;

    OllamaModelCard() {
    }

    OllamaModelCard(String modelfile, String parameters, String template, OllamaModelDetails details) {
        this.modelfile = modelfile;
        this.parameters = parameters;
        this.template = template;
        this.details = details;
    }

    static Builder builder() {
        return new Builder();
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getModelfile() {
        return this.modelfile;
    }

    public void setModelfile(String modelfile) {
        this.modelfile = modelfile;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public OllamaModelDetails getDetails() {
        return this.details;
    }

    public void setDetails(OllamaModelDetails details) {
        this.details = details;
    }

    public Map<String, Object> getModelInfo() {
        return this.modelInfo;
    }

    public void setModelInfo(Map<String, Object> modelInfo) {
        this.modelInfo = modelInfo;
    }

    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    static class Builder {
        private String license;
        private String modelfile;
        private String parameters;
        private String template;
        private OllamaModelDetails details;
        private Map<String, Object> modelInfo;
        private OffsetDateTime modifiedAt;

        Builder() {
        }

        Builder license(String license) {
            this.license = license;
            return this;
        }

        Builder modelfile(String modelfile) {
            this.modelfile = modelfile;
            return this;
        }

        Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        Builder template(String template) {
            this.template = template;
            return this;
        }

        Builder details(OllamaModelDetails details) {
            this.details = details;
            return this;
        }

        Builder modelInfo(Map<String, Object> modelInfo) {
            this.modelInfo = modelInfo;
            return this;
        }

        Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        OllamaModelCard build() {
            return new OllamaModelCard(this.modelfile, this.parameters, this.template, this.details);
        }
    }
}

