/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.internal.ChatRequestValidationUtils;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.ollama.ChatRequest;
import dev.langchain4j.model.ollama.ChatResponse;
import dev.langchain4j.model.ollama.OllamaChatModelListenerUtils;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.OllamaMessagesUtils;
import dev.langchain4j.model.ollama.Options;
import dev.langchain4j.model.ollama.spi.OllamaChatModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OllamaChatModel
implements ChatModel {
    private final OllamaClient client;
    private final String modelName;
    private final Options options;
    private final ResponseFormat responseFormat;
    private final Integer maxRetries;
    private final List<ChatModelListener> listeners;
    private final Set<Capability> supportedCapabilities;

    public OllamaChatModel(HttpClientBuilder httpClientBuilder, String baseUrl, String modelName, Double temperature, Integer topK, Double topP, Double repeatPenalty, Integer seed, Integer numPredict, Integer numCtx, List<String> stop, String format, ResponseFormat responseFormat, Duration timeout, Integer maxRetries, Map<String, String> customHeaders, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners, Set<Capability> supportedCapabilities) {
        if (format != null && responseFormat != null) {
            throw new IllegalStateException("Cant use both 'format' and 'responseFormat' parameters");
        }
        this.client = OllamaClient.builder().httpClientBuilder(httpClientBuilder).baseUrl(baseUrl).timeout(timeout).customHeaders(customHeaders).logRequests(logRequests).logResponses(logResponses).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.options = Options.builder().temperature(temperature).topK(topK).topP(topP).repeatPenalty(repeatPenalty).seed(seed).numPredict(numPredict).numCtx(numCtx).stop(stop).build();
        this.responseFormat = "json".equals(format) ? ResponseFormat.JSON : responseFormat;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)2);
        this.listeners = new ArrayList<ChatModelListener>(Utils.getOrDefault(listeners, Collections.emptyList()));
        this.supportedCapabilities = new HashSet<Capability>((Collection)Utils.getOrDefault(supportedCapabilities, Collections.emptySet()));
    }

    public static OllamaChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OllamaChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OllamaChatModelBuilderFactory factory = (OllamaChatModelBuilderFactory)iterator.next();
            return (OllamaChatModelBuilder)factory.get();
        }
        return new OllamaChatModelBuilder();
    }

    public dev.langchain4j.model.chat.response.ChatResponse chat(dev.langchain4j.model.chat.request.ChatRequest request) {
        ChatRequestParameters parameters = request.parameters();
        ChatRequestValidationUtils.validateParameters((ChatRequestParameters)parameters);
        ChatRequestValidationUtils.validate((ToolChoice)parameters.toolChoice());
        Response<AiMessage> response = this.doGenerate(request.messages(), request.toolSpecifications(), (ResponseFormat)Utils.getOrDefault((Object)request.responseFormat(), (Object)this.responseFormat));
        return dev.langchain4j.model.chat.response.ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
    }

    public Set<Capability> supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.OLLAMA;
    }

    private Response<AiMessage> doGenerate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ResponseFormat responseFormat) {
        ChatRequest request = ChatRequest.builder().model(this.modelName).messages(OllamaMessagesUtils.toOllamaMessages(messages)).options(this.options).format(OllamaMessagesUtils.toOllamaResponseFormat(responseFormat)).stream(false).tools(OllamaMessagesUtils.toOllamaTools(toolSpecifications)).build();
        dev.langchain4j.model.chat.request.ChatRequest listenerRequest = OllamaChatModelListenerUtils.createListenerRequest(request, messages, toolSpecifications);
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        OllamaChatModelListenerUtils.onListenRequest(this.listeners, listenerRequest, this.provider(), attributes);
        try {
            ChatResponse chatResponse = (ChatResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.chat(request), (int)this.maxRetries);
            Response response = Response.from((Object)(chatResponse.getMessage().getToolCalls() != null ? AiMessage.from(OllamaMessagesUtils.toToolExecutionRequests(chatResponse.getMessage().getToolCalls())) : AiMessage.from((String)chatResponse.getMessage().getContent())), (TokenUsage)new TokenUsage(chatResponse.getPromptEvalCount(), chatResponse.getEvalCount()));
            OllamaChatModelListenerUtils.onListenResponse(this.listeners, (Response<AiMessage>)response, listenerRequest, this.provider(), attributes);
            return response;
        }
        catch (Exception e) {
            OllamaChatModelListenerUtils.onListenError(this.listeners, e, listenerRequest, this.provider(), attributes);
            throw e;
        }
    }

    public static class OllamaChatModelBuilder {
        private HttpClientBuilder httpClientBuilder;
        private String baseUrl;
        private String modelName;
        private Double temperature;
        private Integer topK;
        private Double topP;
        private Double repeatPenalty;
        private Integer seed;
        private Integer numPredict;
        private Integer numCtx;
        private List<String> stop;
        private String format;
        private ResponseFormat responseFormat;
        private Duration timeout;
        private Integer maxRetries;
        private Map<String, String> customHeaders;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;
        private Set<Capability> supportedCapabilities;

        public OllamaChatModelBuilder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        public OllamaChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OllamaChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OllamaChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public OllamaChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public OllamaChatModelBuilder repeatPenalty(Double repeatPenalty) {
            this.repeatPenalty = repeatPenalty;
            return this;
        }

        public OllamaChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public OllamaChatModelBuilder numPredict(Integer numPredict) {
            this.numPredict = numPredict;
            return this;
        }

        public OllamaChatModelBuilder numCtx(Integer numCtx) {
            this.numCtx = numCtx;
            return this;
        }

        public OllamaChatModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @Deprecated
        public OllamaChatModelBuilder format(String format) {
            this.format = format;
            return this;
        }

        public OllamaChatModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public OllamaChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OllamaChatModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OllamaChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OllamaChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OllamaChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public OllamaChatModelBuilder supportedCapabilities(Set<Capability> supportedCapabilities) {
            this.supportedCapabilities = supportedCapabilities;
            return this;
        }

        public OllamaChatModelBuilder supportedCapabilities(Capability ... supportedCapabilities) {
            return this.supportedCapabilities(new HashSet<Capability>(Arrays.asList(supportedCapabilities)));
        }

        public OllamaChatModel build() {
            return new OllamaChatModel(this.httpClientBuilder, this.baseUrl, this.modelName, this.temperature, this.topK, this.topP, this.repeatPenalty, this.seed, this.numPredict, this.numCtx, this.stop, this.format, this.responseFormat, this.timeout, this.maxRetries, this.customHeaders, this.logRequests, this.logResponses, this.listeners, this.supportedCapabilities);
        }
    }
}

