/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.qianfan;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.qianfan.InternalQianfanHelper;
import dev.langchain4j.model.qianfan.QianfanChatModelNameEnum;
import dev.langchain4j.model.qianfan.client.QianfanClient;
import dev.langchain4j.model.qianfan.client.QianfanStreamingResponseBuilder;
import dev.langchain4j.model.qianfan.client.SyncOrAsyncOrStreaming;
import dev.langchain4j.model.qianfan.client.chat.ChatCompletionRequest;
import dev.langchain4j.model.qianfan.client.chat.ChatCompletionResponse;
import dev.langchain4j.model.qianfan.spi.QianfanStreamingChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class QianfanStreamingChatModel
implements StreamingChatLanguageModel {
    private final QianfanClient client;
    private final String baseUrl;
    private final Double temperature;
    private final Double topP;
    private final String modelName;
    private final String endpoint;
    private final Double penaltyScore;
    private final String responseFormat;

    public QianfanStreamingChatModel(String baseUrl, String apiKey, String secretKey, Double temperature, Double topP, String modelName, String endpoint, String responseFormat, Double penaltyScore, Boolean logRequests, Boolean logResponses, Proxy proxy) {
        if (Utils.isNullOrBlank((String)apiKey) || Utils.isNullOrBlank((String)secretKey)) {
            throw new IllegalArgumentException(" api key and secret key must be defined. It can be generated here: https://console.bce.baidu.com/qianfan/ais/console/applicationConsole/application");
        }
        this.modelName = modelName;
        String string = this.endpoint = Utils.isNullOrBlank((String)endpoint) ? QianfanChatModelNameEnum.getEndpoint(modelName) : endpoint;
        if (Utils.isNullOrBlank((String)this.endpoint)) {
            throw new IllegalArgumentException("Qianfan is no such model name(or there is no model definition in the QianfanChatModelNameEnum class). You can see model name here: https://cloud.baidu.com/doc/WENXINWORKSHOP/s/Nlks5zkzu");
        }
        this.baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://aip.baidubce.com");
        this.client = QianfanClient.builder().baseUrl(this.baseUrl).apiKey(apiKey).secretKey(secretKey).logRequests(logRequests).logStreamingResponses(logResponses).proxy(proxy).build();
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.penaltyScore = penaltyScore;
        this.responseFormat = responseFormat;
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, null, null, handler);
    }

    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, toolSpecifications, null, handler);
    }

    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        throw new RuntimeException("Not supported");
    }

    private void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted, StreamingResponseHandler<AiMessage> handler) {
        ChatCompletionRequest.Builder builder = ChatCompletionRequest.builder().messages(InternalQianfanHelper.toOpenAiMessages(messages)).temperature(this.temperature).topP(this.topP).system(InternalQianfanHelper.getSystemMessage(messages)).responseFormat(this.responseFormat).penaltyScore(this.penaltyScore);
        if (toolSpecifications != null && !toolSpecifications.isEmpty()) {
            builder.functions(InternalQianfanHelper.toFunctions(toolSpecifications));
        }
        ChatCompletionRequest request = builder.build();
        QianfanStreamingResponseBuilder responseBuilder = new QianfanStreamingResponseBuilder(null);
        SyncOrAsyncOrStreaming<ChatCompletionResponse> response = this.client.chatCompletion(request, this.endpoint);
        response.onPartialResponse(partialResponse -> {
            responseBuilder.append((ChatCompletionResponse)partialResponse);
            QianfanStreamingChatModel.handle(partialResponse, handler);
        }).onComplete(() -> {
            Response<AiMessage> messageResponse = responseBuilder.build();
            handler.onComplete(messageResponse);
        }).onError(arg_0 -> handler.onError(arg_0)).execute();
    }

    private static void handle(ChatCompletionResponse partialResponse, StreamingResponseHandler<AiMessage> handler) {
        String result = partialResponse.getResult();
        if (Objects.isNull(result) || result.isEmpty()) {
            return;
        }
        handler.onNext(result);
    }

    public static QianfanStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QianfanStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QianfanStreamingChatModelBuilderFactory factory = (QianfanStreamingChatModelBuilderFactory)iterator.next();
            return (QianfanStreamingChatModelBuilder)factory.get();
        }
        return new QianfanStreamingChatModelBuilder();
    }

    public static class QianfanStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String secretKey;
        private Double temperature;
        private Double topP;
        private String modelName;
        private String endpoint;
        private String responseFormat;
        private Double penaltyScore;
        private Boolean logRequests;
        private Boolean logResponses;
        private Proxy proxy;

        public QianfanStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QianfanStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QianfanStreamingChatModelBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public QianfanStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public QianfanStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QianfanStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QianfanStreamingChatModelBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public QianfanStreamingChatModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public QianfanStreamingChatModelBuilder penaltyScore(Double penaltyScore) {
            this.penaltyScore = penaltyScore;
            return this;
        }

        public QianfanStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public QianfanStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public QianfanStreamingChatModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public QianfanStreamingChatModel build() {
            return new QianfanStreamingChatModel(this.baseUrl, this.apiKey, this.secretKey, this.temperature, this.topP, this.modelName, this.endpoint, this.responseFormat, this.penaltyScore, this.logRequests, this.logResponses, this.proxy);
        }

        public String toString() {
            return "QianfanStreamingChatModel.QianfanStreamingChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", secretKey=" + this.secretKey + ", temperature=" + this.temperature + ", topP=" + this.topP + ", modelName=" + this.modelName + ", endpoint=" + this.endpoint + ", responseFormat=" + this.responseFormat + ", penaltyScore=" + this.penaltyScore + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", proxy=" + this.proxy + ")";
        }
    }
}

