/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.message.server.ErrorMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import reactor.util.annotation.Nullable;

final class ExceptionFactory {
    private static final String CONSTRAINT_VIOLATION_PREFIX = "23";
    private static final String TRANSACTION_ROLLBACK_PREFIX = "40";
    private static final String SYNTAX_ERROR_PREFIX = "42";

    ExceptionFactory() {
    }

    static R2dbcException createException(ErrorMessage message, @Nullable String sql) {
        AssertUtils.requireNonNull(message, "error message must not be null");
        int errorCode = message.getErrorCode();
        String sqlState = message.getSqlState();
        String errorMessage = message.getErrorMessage();
        switch (errorCode) {
            case 1044: 
            case 1045: 
            case 1095: 
            case 1142: 
            case 1143: 
            case 1227: 
            case 1370: 
            case 1698: 
            case 1873: {
                return new R2dbcPermissionDeniedException(errorMessage, sqlState, errorCode);
            }
            case 1159: 
            case 1161: 
            case 1213: 
            case 1317: {
                return new R2dbcTransientResourceException(errorMessage, sqlState, errorCode);
            }
            case 1205: 
            case 1907: {
                return new R2dbcTimeoutException(errorMessage, sqlState, errorCode);
            }
            case 1613: {
                return new R2dbcRollbackException(errorMessage, sqlState, errorCode);
            }
            case 1050: 
            case 1051: 
            case 1054: 
            case 1064: 
            case 1146: 
            case 1247: 
            case 1304: 
            case 1305: 
            case 1630: {
                return new R2dbcBadGrammarException(errorMessage, sqlState, errorCode, sql);
            }
            case 1022: 
            case 1048: 
            case 1062: 
            case 1169: 
            case 1215: 
            case 1216: 
            case 1217: 
            case 1364: 
            case 1451: 
            case 1452: 
            case 1557: 
            case 1859: {
                return new R2dbcDataIntegrityViolationException(errorMessage, sqlState, errorCode);
            }
        }
        if (sqlState == null) {
            return new R2dbcNonTransientResourceException(errorMessage, null, errorCode);
        }
        return ExceptionFactory.mappingSqlState(errorMessage, sqlState, errorCode, sql);
    }

    private static R2dbcException mappingSqlState(String errorMessage, String sqlState, int errorCode, @Nullable String sql) {
        if (sqlState.startsWith(SYNTAX_ERROR_PREFIX)) {
            return new R2dbcBadGrammarException(errorMessage, sqlState, errorCode, sql);
        }
        if (sqlState.startsWith(CONSTRAINT_VIOLATION_PREFIX)) {
            return new R2dbcDataIntegrityViolationException(errorMessage, sqlState, errorCode);
        }
        if (sqlState.startsWith(TRANSACTION_ROLLBACK_PREFIX)) {
            return new R2dbcRollbackException(errorMessage, sqlState, errorCode);
        }
        return new R2dbcNonTransientResourceException(errorMessage, null, errorCode);
    }
}

