/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ColumnNameSet;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

final class InsertSyntheticRow
implements Row,
RowMetadata,
ColumnMetadata {
    private final Codecs codecs;
    private final String keyName;
    private final long lastInsertId;
    private final ColumnNameSet nameSet;

    InsertSyntheticRow(Codecs codecs, String keyName, long lastInsertId) {
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.keyName = AssertUtils.requireNonNull(keyName, "keyName must not be null");
        this.lastInsertId = lastInsertId;
        this.nameSet = new ColumnNameSet(keyName);
    }

    public <T> T get(int index, Class<T> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        InsertSyntheticRow.assertValidIndex(index);
        return this.get0(type);
    }

    public <T> T get(String name, Class<T> type) {
        AssertUtils.requireNonNull(name, "name must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        this.assertValidName(name);
        return this.get0(type);
    }

    public Number get(int index) {
        InsertSyntheticRow.assertValidIndex(index);
        return this.get0(this.getJavaType0());
    }

    public Number get(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        this.assertValidName(name);
        return this.get0(this.getJavaType0());
    }

    public ColumnMetadata getColumnMetadata(int index) {
        InsertSyntheticRow.assertValidIndex(index);
        return this;
    }

    public ColumnMetadata getColumnMetadata(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        this.assertValidName(name);
        return this;
    }

    public List<ColumnMetadata> getColumnMetadatas() {
        return Collections.singletonList(this);
    }

    public Set<String> getColumnNames() {
        return this.nameSet;
    }

    public Class<? extends Number> getJavaType() {
        return this.getJavaType0();
    }

    public String getName() {
        return this.keyName;
    }

    public Integer getNativeTypeMetadata() {
        return 8;
    }

    public Nullability getNullability() {
        return Nullability.NON_NULL;
    }

    public Integer getPrecision() {
        return 20;
    }

    public Integer getScale() {
        return null;
    }

    private void assertValidName(String name) {
        if (!this.nameSet.contains(name)) {
            throw new NoSuchElementException(String.format("column name '%s' does not exist in %s", name, this.nameSet));
        }
    }

    private <T> T get0(Class<T> type) {
        return this.codecs.decodeLastInsertId(this.lastInsertId, type);
    }

    private Class<? extends Number> getJavaType0() {
        if (this.lastInsertId < 0L) {
            return BigInteger.class;
        }
        return Long.TYPE;
    }

    private static void assertValidIndex(int index) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("column index %d is invalid, total 1", index));
        }
    }
}

