/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.BaseHandler;
import dev.miku.r2dbc.mysql.ExceptionFactory;
import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import dev.miku.r2dbc.mysql.message.client.SimpleQueryMessage;
import dev.miku.r2dbc.mysql.message.server.ErrorMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import java.util.Iterator;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.SynchronousSink;

final class MultiQueryHandler
extends BaseHandler {
    private final Iterator<String> statements;
    private String current;

    MultiQueryHandler(EmitterProcessor<ClientMessage> requests, Iterator<String> statements) {
        super(requests);
        String current = statements.next();
        requests.onNext((Object)new SimpleQueryMessage(current));
        this.current = current;
        this.statements = statements;
    }

    @Override
    public void accept(ServerMessage message, SynchronousSink<ServerMessage> sink) {
        if (message instanceof ErrorMessage) {
            sink.error((Throwable)ExceptionFactory.createException((ErrorMessage)message, this.current));
        } else {
            sink.next((Object)message);
        }
    }

    @Override
    protected boolean hasNext() {
        return this.statements.hasNext();
    }

    @Override
    protected ClientMessage nextMessage() {
        String sql;
        this.current = sql = this.statements.next();
        return new SimpleQueryMessage(sql);
    }

    void close() {
        this.requests.onComplete();
    }
}

