/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.MySqlStatement;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import reactor.util.annotation.Nullable;

abstract class MySqlStatementSupport
implements MySqlStatement {
    private static final String LAST_INSERT_ID = "LAST_INSERT_ID";
    @Nullable
    String generatedKeyName = null;

    MySqlStatementSupport() {
    }

    @Override
    public final MySqlStatement returnGeneratedValues(String ... columns) {
        AssertUtils.requireNonNull(columns, "columns must not be null");
        switch (columns.length) {
            case 0: {
                this.generatedKeyName = LAST_INSERT_ID;
                break;
            }
            case 1: {
                this.generatedKeyName = AssertUtils.requireValidName(columns[0], "id name must not be empty and not contain backticks");
                break;
            }
            default: {
                throw new IllegalArgumentException("MySQL only supports single generated value");
            }
        }
        return this;
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        return this;
    }
}

