/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.client;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.MySqlSslConfiguration;
import dev.miku.r2dbc.mysql.client.ReactorNettyClient;
import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.tcp.TcpClient;
import reactor.util.annotation.Nullable;

public interface Client {
    public Flux<ServerMessage> exchange(ClientMessage var1, Predicate<ServerMessage> var2);

    public Flux<ServerMessage> exchange(Flux<? extends ClientMessage> var1, Predicate<ServerMessage> var2);

    public Mono<Void> close();

    public Mono<Void> forceClose();

    public ByteBufAllocator getByteBufAllocator();

    public boolean isConnected();

    public void sslUnsupported();

    public void loginSuccess();

    public static Mono<Client> connect(MySqlSslConfiguration ssl, SocketAddress address, boolean tcpKeepAlive, boolean tcpNoDelay, ConnectionContext context, @Nullable Duration connectTimeout) {
        AssertUtils.requireNonNull(ssl, "ssl must not be null");
        AssertUtils.requireNonNull(address, "address must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        TcpClient tcpClient = TcpClient.newConnection();
        if (connectTimeout != null) {
            tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(connectTimeout.toMillis()));
        }
        if (address instanceof InetSocketAddress) {
            tcpClient = tcpClient.option(ChannelOption.SO_KEEPALIVE, (Object)tcpKeepAlive);
            tcpClient = tcpClient.option(ChannelOption.TCP_NODELAY, (Object)tcpNoDelay);
        }
        return tcpClient.remoteAddress(() -> address).connect().map(conn -> new ReactorNettyClient((Connection)conn, ssl, context));
    }
}

