/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.ByteArrayCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.util.BitSet;
import reactor.core.publisher.Mono;

final class BitSetCodec
extends AbstractClassedCodec<BitSet> {
    BitSetCodec(ByteBufAllocator allocator) {
        super(allocator, BitSet.class);
    }

    @Override
    public BitSet decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        if (!value.isReadable()) {
            return BitSet.valueOf(InternalArrays.EMPTY_BYTES);
        }
        return BitSet.valueOf(BitSetCodec.reverse(ByteBufUtil.getBytes((ByteBuf)value)));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BitSet;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new BitSetParameter(this.allocator, (BitSet)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        return 16 == info.getType();
    }

    private static byte[] reverse(byte[] bytes) {
        int maxIndex = bytes.length - 1;
        int half = bytes.length >>> 1;
        for (int i = 0; i < half; ++i) {
            byte b = bytes[i];
            bytes[i] = bytes[maxIndex - i];
            bytes[maxIndex - i] = b;
        }
        return bytes;
    }

    private static final class BitSetParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final BitSet set;

        private BitSetParameter(ByteBufAllocator allocator, BitSet set) {
            this.allocator = allocator;
            this.set = set;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> ByteArrayCodec.encodeBytes(this.allocator, BitSetCodec.reverse(this.set.toByteArray())));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> {
                if (this.set.isEmpty()) {
                    writer.writeBinary(false);
                } else {
                    writer.writeHex(BitSetCodec.reverse(this.set.toByteArray()));
                }
            });
        }

        @Override
        public short getType() {
            return 16;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BitSetParameter)) {
                return false;
            }
            BitSetParameter that = (BitSetParameter)o;
            return this.set.equals(that.set);
        }

        public int hashCode() {
            return this.set.hashCode();
        }
    }
}

