/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.collation;

import dev.miku.r2dbc.mysql.collation.CachedCharsetTarget;
import dev.miku.r2dbc.mysql.collation.CharsetTarget;
import dev.miku.r2dbc.mysql.collation.MixCharsetTarget;
import dev.miku.r2dbc.mysql.collation.NamedCharsetTarget;
import java.nio.charset.StandardCharsets;

final class CharsetTargets {
    static final CharsetTarget ASCII = new CachedCharsetTarget(1, StandardCharsets.US_ASCII);
    static final CharsetTarget LATIN1 = new MixCharsetTarget(1, StandardCharsets.ISO_8859_1, new NamedCharsetTarget(1, "Cp1252"));
    static final CharsetTarget UTF8 = new CachedCharsetTarget(3, StandardCharsets.UTF_8);
    static final CharsetTarget UTF8MB4 = new CachedCharsetTarget(4, StandardCharsets.UTF_8);
    static final CharsetTarget UTF16;
    static final CharsetTarget UCS2;
    static final CharsetTarget UTF16LE;
    static final CharsetTarget UTF32;
    static final CharsetTarget SWE7;
    static final CharsetTarget HP8;
    static final CharsetTarget DEC8;
    static final CharsetTarget ARMSCII8;
    static final CharsetTarget GEOSTD8;
    static final CharsetTarget BIG5;
    static final CharsetTarget EUC_KR;
    static final CharsetTarget EUC_JIS;
    static final CharsetTarget EUC_JPMS;
    static final CharsetTarget GB2312;
    static final CharsetTarget GB18030;
    static final CharsetTarget GBK;
    static final CharsetTarget CP850;
    static final CharsetTarget CP852;
    static final CharsetTarget CP866;
    static final CharsetTarget KEYBCS2;
    static final CharsetTarget CP932;
    static final CharsetTarget SHIFT_JIS;
    static final CharsetTarget CP1250;
    static final CharsetTarget CP1251;
    static final CharsetTarget CP1256;
    static final CharsetTarget CP1257;
    static final CharsetTarget TIS620;
    static final CharsetTarget KOI8_R;
    static final CharsetTarget KOI8_U;
    static final CharsetTarget LATIN2;
    static final CharsetTarget GREEK;
    static final CharsetTarget HEBREW;
    static final CharsetTarget LATIN5;
    static final CharsetTarget LATIN7;
    static final CharsetTarget MAC_ROMAN;
    static final CharsetTarget MAC_CE;

    private CharsetTargets() {
    }

    static {
        UCS2 = UTF16 = new CachedCharsetTarget(4, StandardCharsets.UTF_16);
        UTF16LE = new CachedCharsetTarget(4, StandardCharsets.UTF_16LE);
        UTF32 = new NamedCharsetTarget(4, "UTF-32");
        SWE7 = LATIN1;
        HP8 = LATIN1;
        DEC8 = LATIN1;
        ARMSCII8 = LATIN1;
        GEOSTD8 = LATIN1;
        BIG5 = new NamedCharsetTarget(2, "Big5");
        EUC_KR = new NamedCharsetTarget(2, "EUC-KR");
        EUC_JIS = new NamedCharsetTarget(3, "EUC-JP");
        EUC_JPMS = new NamedCharsetTarget(3, "eucJP-OPEN");
        GB2312 = new NamedCharsetTarget(2, "GB2312");
        GB18030 = new NamedCharsetTarget(4, "GB18030");
        GBK = new NamedCharsetTarget(2, "GBK");
        CP850 = new MixCharsetTarget(1, new NamedCharsetTarget(1, "Cp850"), new NamedCharsetTarget(1, "Cp437"));
        CP852 = new NamedCharsetTarget(1, "Cp852");
        CP866 = new NamedCharsetTarget(1, "Cp866");
        KEYBCS2 = CP852;
        CP932 = new NamedCharsetTarget(2, "WINDOWS-932");
        SHIFT_JIS = new MixCharsetTarget(2, new NamedCharsetTarget(2, "SHIFT-JIS"), new NamedCharsetTarget(2, "Cp943"), CP932);
        CP1250 = new NamedCharsetTarget(1, "Cp1250");
        CP1251 = new NamedCharsetTarget(1, "Cp1251");
        CP1256 = new NamedCharsetTarget(1, "Cp1256");
        CP1257 = new NamedCharsetTarget(1, "Cp1257");
        TIS620 = new NamedCharsetTarget(1, "TIS620");
        KOI8_U = KOI8_R = new NamedCharsetTarget(1, "KOI8-R");
        LATIN2 = new NamedCharsetTarget(1, "ISO-8859-2");
        GREEK = new NamedCharsetTarget(1, "ISO-8859-7");
        HEBREW = new NamedCharsetTarget(1, "ISO-8859-8");
        LATIN5 = new NamedCharsetTarget(1, "ISO-8859-9");
        LATIN7 = new NamedCharsetTarget(1, "ISO-8859-13");
        MAC_ROMAN = new NamedCharsetTarget(1, "MacRoman");
        MAC_CE = new NamedCharsetTarget(1, "MacCentralEurope");
    }
}

