/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.client;

import dev.miku.r2dbc.mysql.message.client.FixedSizeClientMessage;
import dev.miku.r2dbc.mysql.message.client.SslRequest;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;

final class SslRequest41
extends FixedSizeClientMessage
implements SslRequest {
    private static final int FILTER_SIZE = 23;
    private static final int BUF_SIZE = 32;
    private final int capabilities;
    private final int collationId;

    SslRequest41(int capabilities, int collationId) {
        AssertUtils.require(collationId > 0, "collationId must be a positive integer");
        this.capabilities = capabilities;
        this.collationId = collationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SslRequest41)) {
            return false;
        }
        SslRequest41 that = (SslRequest41)o;
        if (this.capabilities != that.capabilities) {
            return false;
        }
        return this.collationId == that.collationId;
    }

    public int hashCode() {
        int result = this.capabilities;
        result = 31 * result + this.collationId;
        return result;
    }

    public String toString() {
        return String.format("SslRequest41{capabilities=%x, collationId=%d}", this.capabilities, this.collationId);
    }

    @Override
    public int getCapabilities() {
        return this.capabilities;
    }

    @Override
    protected int size() {
        return 32;
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        buf.writeIntLE(this.capabilities).writeIntLE(0xFFFFFF).writeByte(this.collationId & 0xFF).writeZero(23);
    }

    int getCollationId() {
        return this.collationId;
    }
}

